/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;

public class ProviderMgr {
    static final int LOG_NONE = 0;
    static final int LOG_ERROR = 1;
    static final int LOG_WARNING = 2;
    static final int LOG_DEBUG = 3;
    static final boolean CHECK_NAMES = false;

    public static int writeName(String string, byte[] byArray, int n) throws DomainProtocolException {
        int n2 = n;
        if (string != null) {
            String string2;
            if (byArray == null) {
                throw new NullPointerException(Messages.getString("jndi.32"));
            }
            if (n > byArray.length || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && string2.length() != 0) {
                byte[] byArray2 = string2.getBytes();
                int n3 = byArray2.length;
                if (n3 > 63) {
                    throw new DomainProtocolException(Messages.getString("jndi.64", string2));
                }
                if (n2 + n3 + 1 > byArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                byArray[n2++] = (byte)n3;
                for (int i = 0; i < n3; ++i) {
                    byArray[n2++] = byArray2[i];
                }
                if (n2 - n + 1 <= 255) continue;
                throw new DomainProtocolException(Messages.getString("jndi.5A", 255, string));
            }
            byArray[n2++] = 0;
        }
        return n2;
    }

    public static int parseName(byte[] byArray, int n, StringBuffer stringBuffer) throws DomainProtocolException {
        int n2;
        int n3 = n;
        boolean bl = true;
        if (byArray == null) {
            throw new NullPointerException(Messages.getString("jndi.5B"));
        }
        if (stringBuffer == null) {
            throw new NullPointerException(Messages.getString("jndi.5C"));
        }
        while ((n2 = ProviderMgr.parse8Int(byArray, n3++)) != 0) {
            if ((n2 & 0xC0) == 192) {
                int n4 = ProviderMgr.parse16Int(byArray, --n3) & 0x3FFF;
                n3 += 2;
                if (!bl) {
                    stringBuffer.append('.');
                }
                ProviderMgr.parseName(byArray, n4, stringBuffer);
                break;
            }
            if (n2 > 63) {
                throw new DomainProtocolException(Messages.getString("jndi.59"));
            }
            if (n3 + n2 > byArray.length) {
                throw new DomainProtocolException(Messages.getString("jndi.5D"));
            }
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append('.');
            }
            stringBuffer.append(new String(byArray, n3, n2));
            n3 += n2;
        }
        return n3;
    }

    public static int getMatchingCount(String string, String string2) {
        int n = 0;
        if (string == null || string2 == null) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && stringTokenizer.nextToken().equalsIgnoreCase(stringTokenizer2.nextToken())) {
            ++n;
        }
        return n;
    }

    public static String getParentName(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().equals(".") || string.trim().length() == 0) {
            return ".";
        }
        int n = string.indexOf(46);
        if (n != -1 && string.length() > n + 1) {
            return string.substring(n + 1, string.length());
        }
        return ".";
    }

    public static int write16Int(int n, byte[] byArray, int n2) {
        int n3 = n2;
        byArray[n3++] = (byte)((n & 0xFF00) >> 8);
        byArray[n3++] = (byte)(n & 0xFF);
        return n3;
    }

    public static int write32Int(long l, byte[] byArray, int n) {
        int n2 = n;
        byArray[n2++] = (byte)((l & 0xFF000000L) >> 24);
        byArray[n2++] = (byte)((l & 0xFF0000L) >> 16);
        byArray[n2++] = (byte)((l & 0xFF00L) >> 8);
        byArray[n2++] = (byte)(l & 0xFFL);
        return n2;
    }

    public static int parse8Int(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static int parse16Int(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 8;
        int n3 = byArray[n + 1] & 0xFF;
        return n2 | n3;
    }

    public static long parse32Int(byte[] byArray, int n) {
        long l = ((long)byArray[n] & 0xFFL) << 24;
        long l2 = ((long)byArray[n + 1] & 0xFFL) << 16;
        long l3 = ((long)byArray[n + 2] & 0xFFL) << 8;
        long l4 = (long)byArray[n + 3] & 0xFFL;
        return l | l2 | l3 | l4;
    }

    public static int writeCharString(String string, byte[] byArray, int n) throws DomainProtocolException {
        int n2 = n;
        if (string == null || byArray == null) {
            throw new NullPointerException(Messages.getString("jndi.5E"));
        }
        if (string.length() > 255) {
            throw new DomainProtocolException(Messages.getString("jndi.5F"));
        }
        byte[] byArray2 = string.getBytes();
        byArray[n2++] = (byte)byArray2.length;
        for (byte by : byArray2) {
            byArray[n2++] = by;
        }
        return n2;
    }

    public static int parseCharString(byte[] byArray, int n, StringBuffer stringBuffer) {
        if (byArray == null || stringBuffer == null) {
            throw new NullPointerException(Messages.getString("jndi.60"));
        }
        byte by = byArray[n];
        stringBuffer.append(new String(byArray, n + 1, (int)by));
        return n + 1 + by;
    }

    public static int setBit(int n, int n2, boolean bl) {
        n = bl ? (n |= n2) : (n &= ~n2);
        return n;
    }

    public static boolean checkBit(int n, int n2) {
        return (n & n2) != 0;
    }

    public static boolean namesAreEqual(String string, String string2) {
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        if (!string2.endsWith(".")) {
            string2 = string2 + ".";
        }
        return string.equalsIgnoreCase(string2);
    }

    public static String normalizeName(String string) {
        if (string == null) {
            return string;
        }
        return string.endsWith(".") ? string.toLowerCase() : string.toLowerCase() + ".";
    }

    public static String getIpStr(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray == null || byArray.length < 4) {
            throw new IllegalArgumentException(Messages.getString("jndi.61"));
        }
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append("" + (byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    public static byte[] parseIpStr(String string) {
        byte[] byArray = new byte[4];
        String string2 = Messages.getString("jndi.62");
        if (string != null) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string3 = stringTokenizer.nextToken();
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(string2);
                }
                byArray[n++] = (byte)n2;
            }
            if (n != 4) {
                throw new IllegalArgumentException(string2);
            }
        } else {
            throw new NullPointerException(Messages.getString("jndi.63"));
        }
        return byArray;
    }

    public static int getRecordClassNumber(String string) {
        for (int i = 0; i < ProviderConstants.rrClassNames.length; ++i) {
            if (ProviderConstants.rrClassNames[i] == null || !string.equalsIgnoreCase(ProviderConstants.rrClassNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static int getRecordTypeNumber(String string) {
        for (int i = 0; i < ProviderConstants.rrTypeNames.length; ++i) {
            if (ProviderConstants.rrTypeNames[i] == null || !string.equalsIgnoreCase(ProviderConstants.rrTypeNames[i])) continue;
            return i;
        }
        return -1;
    }
}

