/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import javax.naming.InvalidNameException;
import org.apache.harmony.jndi.provider.dns.DNSName;
import org.apache.harmony.jndi.provider.dns.DNSNameParser;

public class ProviderConstants {
    public static final boolean QR_QUERY = false;
    public static final boolean QR_RESPONSE = true;
    public static final int QR_MASK = 32768;
    public static final int OPCODE_MASK = 30720;
    public static final int AA_MASK = 1024;
    public static final int TC_MASK = 512;
    public static final int RD_MASK = 256;
    public static final int RA_MASK = 128;
    public static final int Z_MASK = 112;
    public static final int RCODE_MASK = 15;
    public static final int OPCODE_SHIFT = 11;
    public static final int RCODE_SHIFT = 0;
    public static final int QUERY = 0;
    public static final int IQUERY = 1;
    public static final int STATUS = 2;
    public static final int NO_ERROR = 0;
    public static final int FORMAT_ERROR = 1;
    public static final int SERVER_FAILURE = 2;
    public static final int NAME_ERROR = 3;
    public static final int NOT_IMPLEMENTED = 4;
    public static final int REFUSED = 5;
    public static final int A_TYPE = 1;
    public static final int NS_TYPE = 2;
    public static final int MD_TYPE = 3;
    public static final int MF_TYPE = 4;
    public static final int CNAME_TYPE = 5;
    public static final int SOA_TYPE = 6;
    public static final int MB_TYPE = 7;
    public static final int MG_TYPE = 8;
    public static final int MR_TYPE = 9;
    public static final int NULL_TYPE = 10;
    public static final int WKS_TYPE = 11;
    public static final int PTR_TYPE = 12;
    public static final int HINFO_TYPE = 13;
    public static final int MINFO_TYPE = 14;
    public static final int MX_TYPE = 15;
    public static final int TXT_TYPE = 16;
    public static final int AAAA_TYPE = 28;
    public static final int SRV_TYPE = 33;
    public static final int AXFR_QTYPE = 252;
    public static final int MAILB_QTYPE = 253;
    public static final int MAILA_QTYPE = 254;
    public static final int ANY_QTYPE = 255;
    public static String[] rrTypeNames;
    public static String[] rrClassNames;
    public static final int IN_CLASS = 1;
    public static final int CS_CLASS = 2;
    public static final int CH_CLASS = 3;
    public static final int HS_CLASS = 4;
    public static final int ANY_QCLASS = 255;
    public static final int LABEL_MAX_CHARS = 63;
    public static final int NAME_MAX_CHARS = 255;
    public static final int DEFAULT_DNS_PORT = 53;
    public static final int DEFAULT_INITIAL_TIMEOUT = 1000;
    public static final int DEFAULT_TIMEOUT_RETRIES = 4;
    public static final boolean DEFAULT_AUTHORITATIVE = false;
    public static final boolean DEFAULT_RECURSION = true;
    public static final int DEFAULT_LOOKUP_ATTR_TYPE = 16;
    public static final int DEFAULT_LOOKUP_ATTR_CLASS = 1;
    public static final int DEFAULT_MAX_THREADS = 7;
    public static DNSName ROOT_ZONE_NAME_OBJ;

    static {
        int n;
        ROOT_ZONE_NAME_OBJ = null;
        rrTypeNames = new String[256];
        for (n = 0; n < 256; ++n) {
            ProviderConstants.rrTypeNames[n] = String.valueOf(n);
        }
        ProviderConstants.rrTypeNames[1] = "A";
        ProviderConstants.rrTypeNames[2] = "NS";
        ProviderConstants.rrTypeNames[5] = "CNAME";
        ProviderConstants.rrTypeNames[6] = "SOA";
        ProviderConstants.rrTypeNames[12] = "PTR";
        ProviderConstants.rrTypeNames[13] = "HINFO";
        ProviderConstants.rrTypeNames[15] = "MX";
        ProviderConstants.rrTypeNames[16] = "TXT";
        ProviderConstants.rrTypeNames[28] = "AAAA";
        ProviderConstants.rrTypeNames[33] = "SRV";
        ProviderConstants.rrTypeNames[255] = "*";
        rrClassNames = new String[256];
        for (n = 0; n < 256; ++n) {
            ProviderConstants.rrClassNames[n] = String.valueOf(n);
        }
        ProviderConstants.rrClassNames[1] = "IN";
        ProviderConstants.rrClassNames[4] = "HS";
        ProviderConstants.rrClassNames[255] = "*";
        try {
            ROOT_ZONE_NAME_OBJ = (DNSName)new DNSNameParser().parse(".");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }
}

