/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DNSName;

public class DNSNameParser
implements NameParser {
    @Override
    public Name parse(String string) throws InvalidNameException {
        boolean bl = false;
        DNSName dNSName = new DNSName();
        if (string == null) {
            throw new InvalidNameException(Messages.getString("jndi.2E"));
        }
        if (string.length() > 255) {
            throw new InvalidNameException(Messages.getString("jndi.54"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(".")) {
                if (bl) {
                    throw new InvalidNameException(Messages.getString("jndi.55"));
                }
                bl = true;
                if (dNSName.size() != 0 || !stringTokenizer.hasMoreTokens()) continue;
                throw new InvalidNameException(Messages.getString("jndi.56"));
            }
            if (string2.length() > 63) {
                throw new InvalidNameException(Messages.getString("jndi.57", string2));
            }
            dNSName.add(0, string2);
            bl = false;
        }
        if (bl) {
            dNSName.add(0, "");
        }
        return dNSName;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DNSNameParser;
    }
}

