/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.BasicNamingEnumerator;
import org.apache.harmony.jndi.provider.dns.DNSName;
import org.apache.harmony.jndi.provider.dns.DNSNameParser;
import org.apache.harmony.jndi.provider.dns.DNSPseudoURL;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.Resolver;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;

public class DNSContext
implements DirContext,
Cloneable {
    public static final String LOOKUP_ATTR = "org.apache.harmony.jndi.provider.dns.lookup.attr";
    public static final String RECURSION = "org.apache.harmony.jndi.provider.dns.recursion";
    public static final String TIMEOUT_INITIAL = "org.apache.harmony.jndi.provider.dns.timeout.initial";
    public static final String TIMEOUT_RETRIES = "org.apache.harmony.jndi.provider.dns.timeout.retries";
    public static final String THREADS_MAX = "org.apache.harmony.jndi.provider.dns.threads.max";
    private static final int NAME_CLASS_SWT = 1;
    private static final int BINDING_SWT = 2;
    private DNSNameParser nameParser;
    private Hashtable<Object, Object> environment;
    private Resolver resolver;
    private DNSName contextName;
    private boolean authoritative = false;
    private int lookupAttrType = 16;
    private int lookupAttrClass = 1;
    private boolean recursion = true;
    private int timeoutInitial = 1000;
    private int timeoutRetries = 4;
    private int maxThreads = 7;

    DNSContext(Hashtable<?, ?> hashtable) throws NamingException {
        this.nameParser = new DNSNameParser();
        if (hashtable == null) {
            throw new NullPointerException(Messages.getString("jndi.45"));
        }
        this.environment = (Hashtable)hashtable.clone();
        this.parseBoolProp("java.naming.authoritative");
        this.parseLookupProp();
        if (this.environment.containsKey(RECURSION)) {
            this.parseBoolProp(RECURSION);
        }
        if (this.environment.containsKey(TIMEOUT_INITIAL)) {
            this.parseIntProp(TIMEOUT_INITIAL);
        }
        if (this.environment.containsKey(TIMEOUT_RETRIES)) {
            this.parseIntProp(TIMEOUT_RETRIES);
        }
        this.parseIntProp(THREADS_MAX);
        this.resolver = new Resolver(this.timeoutInitial, this.timeoutRetries, this.maxThreads, this.authoritative, this.recursion);
        this.parseProviderUrlProp();
    }

    private void parseIntProp(String string) throws NumberFormatException {
        Object object = this.environment.get(string);
        if (object != null && object instanceof String) {
            int n = Integer.parseInt((String)object);
            if (string.equals(TIMEOUT_RETRIES)) {
                this.timeoutRetries = n;
            } else if (string.equals(TIMEOUT_INITIAL)) {
                this.timeoutInitial = n;
            } else if (string.equals(THREADS_MAX)) {
                this.maxThreads = n;
            }
        }
    }

    private void parseBoolProp(String string) {
        Object object = this.environment.get(string);
        boolean bl = false;
        if (object != null) {
            if (object instanceof String && object.equals("true")) {
                bl = true;
            }
            if (string.equals("java.naming.authoritative")) {
                this.authoritative = bl;
            } else if (string.equals(RECURSION)) {
                this.recursion = bl;
            }
        }
    }

    private void parseLookupProp() throws ConfigurationException {
        Object object;
        if (this.environment.containsKey(LOOKUP_ATTR) && (object = this.environment.get(LOOKUP_ATTR)) instanceof String) {
            String string;
            String string2 = (String)object;
            int n = string2.indexOf(" ");
            if (n > -1) {
                String string3 = string2.substring(0, n);
                this.lookupAttrClass = ProviderMgr.getRecordClassNumber(string3);
                if (this.lookupAttrClass == -1) {
                    throw new ConfigurationException(Messages.getString("jndi.46", string3));
                }
                string = string2.substring(n).trim();
            } else {
                this.lookupAttrClass = 1;
                string = string2.trim();
            }
            this.lookupAttrType = ProviderMgr.getRecordTypeNumber(string);
            if (this.lookupAttrType == -1) {
                throw new ConfigurationException(Messages.getString("jndi.47", string));
            }
        }
    }

    private void parseProviderUrlProp() throws NamingException {
        if (this.environment.containsKey("java.naming.provider.url")) {
            Object object = this.environment.get("java.naming.provider.url");
            if (object instanceof String) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    try {
                        DNSPseudoURL dNSPseudoURL = new DNSPseudoURL(string);
                        if (dNSPseudoURL.isHostIpGiven()) {
                            this.resolver.addInitialServer(null, dNSPseudoURL.getHost(), dNSPseudoURL.getPort(), dNSPseudoURL.getDomain());
                        } else {
                            this.resolver.addInitialServer(dNSPseudoURL.getHost(), null, dNSPseudoURL.getPort(), dNSPseudoURL.getDomain());
                        }
                        if (this.contextName == null) {
                            this.contextName = (DNSName)this.nameParser.parse(dNSPseudoURL.getDomain());
                            continue;
                        }
                        DNSName dNSName = (DNSName)this.nameParser.parse(dNSPseudoURL.getDomain());
                        if (dNSName.compareTo(this.contextName) == 0) continue;
                        throw new ConfigurationException(Messages.getString("jndi.48", this.contextName, dNSName));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ConfigurationException(Messages.getString("jndi.49", string, illegalArgumentException.getMessage()));
                    }
                }
            }
        } else {
            this.contextName = ProviderConstants.ROOT_ZONE_NAME_OBJ;
        }
    }

    DNSContext(DNSContext dNSContext, DNSName dNSName) {
        this.contextName = (DNSName)dNSName.clone();
        this.nameParser = dNSContext.nameParser;
        this.environment = (Hashtable)dNSContext.environment.clone();
        this.resolver = dNSContext.resolver;
        this.authoritative = dNSContext.authoritative;
        this.lookupAttrType = dNSContext.lookupAttrType;
        this.lookupAttrClass = dNSContext.lookupAttrClass;
        this.recursion = dNSContext.recursion;
        this.timeoutInitial = dNSContext.timeoutInitial;
        this.timeoutRetries = dNSContext.timeoutRetries;
        this.maxThreads = dNSContext.maxThreads;
    }

    @Override
    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes(this.convertNameFromStringForm(string), null);
    }

    @Override
    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(object instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)object).modifyAttributes("", n, attributes);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(object instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)object).modifyAttributes("", n, attributes);
    }

    @Override
    public DirContext getSchema(String string) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).getSchema("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).getSchemaClassDefinition("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).getSchema("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).getSchemaClassDefinition("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(object instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)object).modifyAttributes("", modificationItemArray);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(object instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)object).modifyAttributes("", modificationItemArray);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", attributes);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", attributes);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.bind(this.convertNameFromStringForm(string), object, attributes);
    }

    @Override
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.rebind(this.convertNameFromStringForm(string), object, attributes);
    }

    @Override
    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(contextNamePair.context instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)contextNamePair.context).bind(contextNamePair.name, object, attributes);
    }

    @Override
    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(contextNamePair.context instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)contextNamePair.context).rebind(contextNamePair.name, object, attributes);
    }

    @Override
    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        return this.getAttributes(this.convertNameFromStringForm(string), stringArray);
    }

    @Override
    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        Object object;
        DNSName dNSName = null;
        DNSName dNSName2 = null;
        CompositeName compositeName = null;
        Attributes attributes = null;
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (name.size() == 0) {
            dNSName = (DNSName)this.contextName.clone();
        } else if (name instanceof CompositeName) {
            object = name.get(0);
            dNSName2 = (DNSName)this.nameParser.parse((String)object);
            dNSName = (DNSName)this.composeName(dNSName2, this.contextName);
            if (name.size() > 1) {
                compositeName = (CompositeName)name.getSuffix(1);
            }
        } else if (name instanceof DNSName) {
            dNSName = (DNSName)this.composeName(name, this.contextName);
        } else {
            throw new InvalidNameException(Messages.getString("jndi.4B"));
        }
        if (compositeName != null) {
            object = this.constructCannotProceedException(dNSName2, compositeName);
            DirContext dirContext = DirectoryManager.getContinuationDirContext(object);
            attributes = dirContext.getAttributes(compositeName, stringArray);
        } else {
            Serializable serializable;
            int[] nArray;
            int[] nArray2;
            if (stringArray == null) {
                nArray2 = new int[1];
                nArray = new int[1];
                nArray2[0] = 255;
                nArray[0] = 255;
            } else {
                Object object2;
                object = new HashSet();
                serializable = new HashSet();
                for (String string : stringArray) {
                    int n = string.indexOf(32);
                    String string2 = null;
                    if (n > 0) {
                        String string3 = string.substring(0, n);
                        int n2 = ProviderMgr.getRecordClassNumber(string3);
                        if (n2 == -1) {
                            throw new InvalidAttributeIdentifierException(Messages.getString("jndi.4C", string3));
                        }
                        ((HashSet)object).add(new Integer(n2));
                        string2 = string.substring(n, string.length()).trim();
                    } else {
                        ((HashSet)object).add(new Integer(1));
                        string2 = string.trim();
                    }
                    int n3 = ProviderMgr.getRecordTypeNumber(string2);
                    if (n3 == -1) {
                        throw new InvalidAttributeIdentifierException(Messages.getString("jndi.4D", string2));
                    }
                    ((HashSet)serializable).add(new Integer(n3));
                }
                nArray = new int[((HashSet)object).size()];
                Iterator iterator = ((HashSet)object).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object2 = (Integer)iterator.next();
                    nArray[n++] = (Integer)object2;
                }
                nArray2 = new int[((HashSet)serializable).size()];
                iterator = ((HashSet)serializable).iterator();
                n = 0;
                while (iterator.hasNext()) {
                    object2 = (Integer)iterator.next();
                    nArray2[n++] = (Integer)object2;
                }
            }
            try {
                object = this.resolver.lookup(dNSName.toString(), nArray2, nArray);
                attributes = DNSContext.createAttributesFromRecords((Enumeration<ResourceRecord>)object);
            }
            catch (SecurityException securityException) {
                serializable = new NoPermissionException();
                ((NamingException)serializable).setRootCause(securityException);
                throw serializable;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                serializable = new NamingException();
                ((NamingException)serializable).setRootCause(exception);
                throw serializable;
            }
        }
        return attributes;
    }

    @Override
    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        return this.createSubcontext(this.convertNameFromStringForm(string), attributes);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (contextNamePair.context instanceof DirContext) {
            return ((DirContext)contextNamePair.context).createSubcontext(contextNamePair.name, attributes);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", attributes, stringArray);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", attributes, stringArray);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, SearchControls searchControls) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", string2, searchControls);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, SearchControls searchControls) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", string, searchControls);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", string2, objectArray, searchControls);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (object instanceof DirContext) {
            return ((DirContext)object).search("", string, objectArray, searchControls);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() {
        return this.contextName.toString();
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(this.convertNameFromStringForm(string));
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(this.convertNameFromStringForm(string));
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(contextNamePair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)contextNamePair.context).destroySubcontext(contextNamePair.name);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(contextNamePair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)contextNamePair.context).unbind(contextNamePair.name);
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(this.convertNameFromStringForm(string));
    }

    private Name convertNameFromStringForm(String string) throws InvalidNameException {
        Name name = null;
        if (string == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        name = new CompositeName(string);
        if (name.size() == 1) {
            name = this.nameParser.parse(string);
        } else if (name.size() == 0) {
            name = new DNSName();
        }
        return name;
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    @Override
    public Object removeFromEnvironment(String string) {
        return this.environment.remove(string);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(this.convertNameFromStringForm(string), object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(this.convertNameFromStringForm(string), object);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object object;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DNSName dNSName = null;
        DNSName dNSName2 = null;
        CompositeName compositeName = null;
        Object object2 = null;
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (name.size() == 0) {
            dNSName = (DNSName)this.contextName.clone();
        } else if (name instanceof CompositeName) {
            object = name.get(0);
            dNSName2 = (DNSName)this.nameParser.parse((String)object);
            dNSName = (DNSName)this.composeName(dNSName2, this.contextName);
            if (name.size() > 1) {
                compositeName = (CompositeName)name.getSuffix(1);
            }
        } else if (name instanceof DNSName) {
            dNSName = (DNSName)this.composeName(name, this.contextName);
        } else {
            throw new InvalidNameException(Messages.getString("jndi.4B"));
        }
        nArray[0] = this.lookupAttrType;
        nArray2[0] = this.lookupAttrClass;
        if (compositeName != null) {
            object = this.constructCannotProceedException(dNSName2, compositeName);
            Context context = DirectoryManager.getContinuationContext((CannotProceedException)object);
            object2 = context.lookup(compositeName);
        } else {
            try {
                object = new DNSContext(this, dNSName);
                Enumeration<ResourceRecord> enumeration = this.resolver.lookup(dNSName.toString(), nArray, nArray2);
                Attributes attributes = DNSContext.createAttributesFromRecords(enumeration);
                object2 = DirectoryManager.getObjectInstance(object, name, this, this.environment, attributes);
            }
            catch (SecurityException securityException) {
                NoPermissionException noPermissionException = new NoPermissionException(securityException.getMessage());
                noPermissionException.setRootCause(securityException);
                throw noPermissionException;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException(exception.getMessage());
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return object2;
    }

    private CannotProceedException constructCannotProceedException(DNSName dNSName, CompositeName compositeName) throws NamingException {
        DNSName dNSName2 = (DNSName)this.composeName(dNSName, this.contextName);
        final DNSContext dNSContext = new DNSContext(this, dNSName2);
        RefAddr refAddr = new RefAddr("nns"){
            private static final long serialVersionUID = 8654740210501193418L;
            DNSContext context;
            {
                super(string);
                this.context = (DNSContext)dNSContext.clone();
            }

            @Override
            public Object getContent() {
                return this.context;
            }
        };
        Reference reference = new Reference(this.getClass().getName(), refAddr);
        CannotProceedException cannotProceedException = null;
        CompositeName compositeName2 = null;
        if (this.environment.containsKey("java.naming.spi.CannotProceedException")) {
            cannotProceedException = (CannotProceedException)this.environment.get("java.naming.spi.CannotProceedException");
            compositeName2 = (CompositeName)cannotProceedException.getResolvedName();
            if (compositeName2 != null && compositeName2.get(compositeName2.size() - 1).equals("")) {
                compositeName2.remove(compositeName2.size() - 1);
            }
        } else {
            cannotProceedException = new CannotProceedException();
        }
        cannotProceedException.setEnvironment((Hashtable)this.environment.clone());
        cannotProceedException.setAltName(dNSName);
        cannotProceedException.setAltNameCtx((DNSContext)this.clone());
        cannotProceedException.setRemainingName(compositeName);
        if (compositeName2 == null) {
            compositeName2 = new CompositeName();
        }
        compositeName2.add(dNSName2.toString());
        compositeName2.add("");
        cannotProceedException.setResolvedName(compositeName2);
        cannotProceedException.setResolvedObj(reference);
        return cannotProceedException;
    }

    private static Attributes createAttributesFromRecords(Enumeration<ResourceRecord> enumeration) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        while (enumeration.hasMoreElements()) {
            ResourceRecord resourceRecord = enumeration.nextElement();
            String string = null;
            Attribute attribute = null;
            string = resourceRecord.getRRClass() == 1 ? ProviderConstants.rrTypeNames[resourceRecord.getRRType()] : ProviderConstants.rrClassNames[resourceRecord.getRRClass()] + " " + ProviderConstants.rrTypeNames[resourceRecord.getRRType()];
            attribute = basicAttributes.get(string);
            if (attribute != null) {
                attribute.add(attribute.size(), resourceRecord.getRData());
                continue;
            }
            BasicAttribute basicAttribute = new BasicAttribute(string, resourceRecord.getRData(), false);
            basicAttributes.put(basicAttribute);
        }
        return basicAttributes;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(contextNamePair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)contextNamePair.context).bind(contextNamePair.name, object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(contextNamePair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)contextNamePair.context).rebind(contextNamePair.name, object);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(this.convertNameFromStringForm(string), this.convertNameFromStringForm(string2));
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(this.convertNameFromStringForm(string));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        ContextNamePair contextNamePair;
        try {
            contextNamePair = this.getTargetNamespaceContextNamePair(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (contextNamePair.context instanceof Context) {
            return ((Context)contextNamePair.context).createSubcontext(contextNamePair.name);
        }
        throw new NotContextException(Messages.getString("jndi.4E"));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        ContextNamePair contextNamePair;
        ContextNamePair contextNamePair2;
        try {
            contextNamePair2 = this.getTargetNamespaceContextNamePair(name);
            contextNamePair = this.getTargetNamespaceContextNamePair(name2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(contextNamePair2.context instanceof Context && contextNamePair2.context.getClass().getName().equals(contextNamePair.context.getClass().getName()) && ((Context)contextNamePair2.context).getNameInNamespace().equals(((Context)contextNamePair.context).getNameInNamespace()))) {
            throw new NotContextException(Messages.getString("jndi.4F"));
        }
        ((Context)contextNamePair2.context).rename(contextNamePair2.name, contextNamePair.name);
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        Object object = this.lookup(string);
        if (object instanceof DNSContext) {
            return this.nameParser;
        }
        if (object instanceof Context) {
            return ((Context)object).getNameParser("");
        }
        throw new NotContextException(Messages.getString("jndi.4E"));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        Object object = this.lookup(name);
        if (object instanceof DNSContext) {
            return this.nameParser;
        }
        if (object instanceof Context) {
            return ((Context)object).getNameParser("");
        }
        throw new NotContextException(Messages.getString("jndi.4E"));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list_common(this.convertNameFromStringForm(string), 1);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.list_common(this.convertNameFromStringForm(string), 2);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list_common(name, 1);
    }

    private <T> NamingEnumeration<T> list_common(Name name, int n) throws NamingException {
        Enumeration<ResourceRecord> enumeration;
        DNSName dNSName = null;
        DNSName dNSName2 = null;
        CompositeName compositeName = null;
        NamingEnumeration<NameClassPair> namingEnumeration = null;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(Messages.getString("jndi.50"));
        }
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (name.size() == 0) {
            dNSName = (DNSName)this.contextName.clone();
        } else if (name instanceof CompositeName) {
            enumeration = name.get(0);
            dNSName2 = (DNSName)this.nameParser.parse((String)((Object)enumeration));
            dNSName = (DNSName)this.composeName(dNSName2, this.contextName);
            if (name.size() > 1) {
                compositeName = (CompositeName)name.getSuffix(1);
            }
        } else if (name instanceof DNSName) {
            dNSName = (DNSName)this.composeName(name, this.contextName);
        } else {
            throw new InvalidNameException(Messages.getString("jndi.4B"));
        }
        if (compositeName != null) {
            enumeration = this.constructCannotProceedException(dNSName2, compositeName);
            Context context = DirectoryManager.getContinuationContext((CannotProceedException)((Object)enumeration));
            namingEnumeration = context.list(compositeName);
        } else {
            try {
                enumeration = this.resolver.list(dNSName.toString());
                Hashtable<String, Binding> hashtable = new Hashtable<String, Binding>();
                DNSContext dNSContext = new DNSContext(this, dNSName);
                while (enumeration.hasMoreElements()) {
                    String string;
                    ResourceRecord resourceRecord = enumeration.nextElement();
                    Name name2 = this.nameParser.parse(resourceRecord.getName());
                    if (!name2.startsWith(dNSName) || name2.size() <= dNSName.size() || hashtable.containsKey(string = name2.get(dNSName.size()))) continue;
                    NameClassPair nameClassPair = null;
                    DNSName dNSName3 = null;
                    DNSName dNSName4 = null;
                    dNSName4 = new DNSName();
                    dNSName4.add(string);
                    dNSName3 = (DNSName)dNSName.clone();
                    dNSName3.add(string);
                    DNSContext dNSContext2 = new DNSContext(this, dNSName3);
                    Object object = DirectoryManager.getObjectInstance(dNSContext2, dNSName4, dNSContext, this.environment, null);
                    switch (n) {
                        case 1: {
                            nameClassPair = new NameClassPair(string, object.getClass().getName(), true);
                            break;
                        }
                        case 2: {
                            nameClassPair = new Binding(string, object, true);
                        }
                    }
                    hashtable.put(string, (Binding)nameClassPair);
                }
                namingEnumeration = new BasicNamingEnumerator(hashtable.elements());
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException(exception.getMessage());
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return namingEnumeration;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.list_common(name, 2);
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        Object object2 = this.environment.put(string, object);
        if (string.equals("java.naming.authoritative")) {
            this.parseBoolProp("java.naming.authoritative");
            this.resolver.setAuthoritativeAnswerDesired(this.authoritative);
        } else if (string.equals(RECURSION)) {
            this.parseBoolProp(RECURSION);
            this.resolver.setRecursionDesired(this.recursion);
        } else if (string.equals(TIMEOUT_INITIAL)) {
            this.parseIntProp(TIMEOUT_INITIAL);
            this.resolver.setInitialTimeout(this.timeoutInitial);
        } else if (string.equals(TIMEOUT_RETRIES)) {
            this.parseIntProp(TIMEOUT_RETRIES);
            this.resolver.setTimeoutRetries(this.timeoutRetries);
        } else if (string.equals(THREADS_MAX)) {
            this.parseIntProp(THREADS_MAX);
            this.resolver.setThreadNumberLimit(this.maxThreads);
        } else if (string.equals(LOOKUP_ATTR)) {
            this.parseLookupProp();
        } else if (string.equals("java.naming.provider.url")) {
            this.parseProviderUrlProp();
        }
        return object2;
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        Name name = null;
        Name name2 = null;
        if (string == null || string2 == null) {
            throw new NullPointerException(Messages.getString("jndi.51"));
        }
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        try {
            name = new CompositeName(string);
            name2 = new CompositeName(string2);
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (name == null || name.size() <= 1) {
            name = this.nameParser.parse(string);
        }
        if (name2 == null || name2.size() <= 1) {
            name2 = this.nameParser.parse(string2);
        }
        return this.composeName(name, name2).toString();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = null;
        if (name == null || name2 == null) {
            throw new NullPointerException(Messages.getString("jndi.51"));
        }
        if (name.size() == 0) {
            return name2;
        }
        if (name2.size() == 0) {
            return name;
        }
        if (name instanceof CompositeName && name2 instanceof CompositeName) {
            String string = name.get(0);
            String string2 = name2.get(name2.size() - 1);
            name3 = new CompositeName();
            if (name2.size() > 1) {
                name3.addAll(name2.getPrefix(name2.size() - 1));
            }
            try {
                name3.add(this.concatenateDNSNames(string, string2));
            }
            catch (InvalidNameException invalidNameException) {
                name3.add(string2);
                name3.add(string);
            }
            if (name.size() > 1) {
                name3.addAll(name.getSuffix(1));
            }
        } else if (name2 instanceof CompositeName && name instanceof DNSName) {
            String string = name.toString();
            String string3 = name2.get(name2.size() - 1);
            name3 = new CompositeName();
            if (name2.size() > 1) {
                name3.addAll(name2.getPrefix(name2.size() - 1));
            }
            try {
                name3.add(this.concatenateDNSNames(string, string3));
            }
            catch (InvalidNameException invalidNameException) {
                name3.add(string3);
                name3.add(string);
            }
        } else if (name2 instanceof DNSName && name instanceof CompositeName) {
            String string = name.get(0);
            String string4 = name2.toString();
            name3 = new CompositeName();
            try {
                name3.add(this.concatenateDNSNames(string, string4));
            }
            catch (InvalidNameException invalidNameException) {
                name3.add(string4);
                name3.add(string);
            }
            if (name.size() > 1) {
                name3.addAll(name.getSuffix(1));
            }
        } else if (name2 instanceof DNSName && name instanceof DNSName) {
            DNSName dNSName = ProviderConstants.ROOT_ZONE_NAME_OBJ;
            boolean bl = name2.compareTo(dNSName) == 0;
            boolean bl2 = name.compareTo(dNSName) == 0;
            boolean bl3 = name.get(0).equals("");
            if (bl3) {
                throw new NamingException(Messages.getString("jndi.52"));
            }
            if (bl && bl2) {
                name3 = (DNSName)dNSName.clone();
            } else {
                if (!bl && bl2) {
                    throw new NamingException(Messages.getString("jndi.53"));
                }
                name3 = new DNSName();
                name3.addAll(name2);
                name3.addAll(name);
            }
        } else {
            throw new NamingException(Messages.getString("jndi.4B"));
        }
        return name3;
    }

    private String concatenateDNSNames(String string, String string2) throws NamingException {
        boolean bl = string.equals(".");
        boolean bl2 = string2.equals(".");
        String string3 = null;
        this.nameParser.parse(string);
        this.nameParser.parse(string2);
        if (string.endsWith(".")) {
            throw new NamingException(Messages.getString("jndi.52"));
        }
        if (bl && bl2) {
            string3 = ".";
        } else if (!bl && bl2) {
            string3 = string + ".";
        } else {
            if (bl && !bl2) {
                throw new NamingException(Messages.getString("jndi.53"));
            }
            string3 = string + "." + string2;
        }
        return string3;
    }

    public Object clone() {
        return new DNSContext(this, this.contextName);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DNSContext && this.contextName.equals(((DNSContext)object).contextName);
    }

    private ContextNamePair getTargetNamespaceContextNamePair(Name name) throws NamingException {
        if (name == null || !(name instanceof CompositeName) || name.size() < 2) {
            throw new IllegalArgumentException();
        }
        String string = name.get(name.size() - 1);
        CompositeName compositeName = (CompositeName)name.getPrefix(name.size() - 1);
        compositeName.add("");
        Object object = this.lookup(compositeName);
        return new ContextNamePair(object, string);
    }

    static class ContextNamePair {
        Object context;
        String name;

        ContextNamePair(Object object, String string) {
            this.context = object;
            this.name = string;
        }
    }
}

