/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.parser.LdapParser;

public class LdapNameParser
implements NameParser,
LdapParser {
    private String s = null;

    public LdapNameParser(String string) {
        this.s = string;
    }

    @Override
    public Name parse(String string) throws NamingException {
        return new LdapName(string);
    }

    @Override
    public List getList() throws InvalidNameException {
        ArrayList<Rdn> arrayList = new ArrayList<Rdn>();
        int n = 0;
        char[] cArray = this.s.toCharArray();
        if (this.s.equals("")) {
            return arrayList;
        }
        if (this.s.startsWith(",") || this.s.startsWith(";")) {
            throw new InvalidNameException("Invalid name: " + this.s);
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != ',' && cArray[i] != ';' || cArray[i - 1] == '\\') continue;
            String string = this.s.substring(n, i);
            if (string.equals("")) {
                throw new InvalidNameException("Invalid name: " + this.s);
            }
            arrayList.add(new Rdn(string));
            n = i + 1;
        }
        arrayList.add(new Rdn(this.s.substring(n, this.s.length())));
        Collections.reverse(arrayList);
        return arrayList;
    }
}

