/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal;

import java.io.IOException;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;

public final class JndiBerInputStream
extends BerInputStream {
    public JndiBerInputStream(byte[] byArray) throws IOException {
        int n = 0;
        int n2 = byArray.length;
        this.buffer = byArray;
        this.offset = n;
        this.next();
        if (this.length != -1 && n + n2 != this.offset + this.length) {
            this.length = n + n2 - this.offset;
        }
    }

    public void readSequence(ASN1Sequence aSN1Sequence) throws IOException {
        int n;
        if (this.tag != 48) {
            throw new ASN1Exception(Messages.getString("security.12F", this.tagOffset, Integer.toHexString(this.tag)));
        }
        int n2 = this.offset;
        int n3 = n2 + this.length;
        ASN1Type[] aSN1TypeArray = aSN1Sequence.type;
        if (this.isVerify) {
            for (n = 0; this.offset < n3 && n < aSN1TypeArray.length; ++n) {
                this.next();
                while (!aSN1TypeArray[n].checkTag(this.tag)) {
                    if (!aSN1Sequence.OPTIONAL[n] || n == aSN1TypeArray.length - 1) {
                        throw new ASN1Exception(Messages.getString("security.130", this.tagOffset));
                    }
                    ++n;
                }
                aSN1TypeArray[n].decode((BerInputStream)this);
            }
            while (n < aSN1TypeArray.length) {
                if (!aSN1Sequence.OPTIONAL[n]) {
                    throw new ASN1Exception(Messages.getString("security.131", this.tagOffset));
                }
                ++n;
            }
        } else {
            int n4 = this.tagOffset;
            Object[] objectArray = new Object[aSN1TypeArray.length];
            while (this.offset < n3 && n < aSN1TypeArray.length) {
                this.next();
                while (n < aSN1TypeArray.length && !aSN1TypeArray[n].checkTag(this.tag)) {
                    if (!aSN1Sequence.OPTIONAL[n]) {
                        throw new ASN1Exception(Messages.getString("security.132", this.tagOffset));
                    }
                    if (aSN1Sequence.DEFAULT[n] != null) {
                        objectArray[n] = aSN1Sequence.DEFAULT[n];
                    }
                    ++n;
                }
                if (n == aSN1TypeArray.length) break;
                objectArray[n] = aSN1TypeArray[n].decode((BerInputStream)this);
                ++n;
            }
            while (n < aSN1TypeArray.length) {
                if (!aSN1Sequence.OPTIONAL[n]) {
                    throw new ASN1Exception(Messages.getString("security.133", this.tagOffset));
                }
                if (aSN1Sequence.DEFAULT[n] != null) {
                    objectArray[n] = aSN1Sequence.DEFAULT[n];
                }
                ++n;
            }
            this.content = objectArray;
            this.tagOffset = n4;
        }
    }
}

