/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal;

import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.harmony.jndi.internal.nls.Messages;

public final class EnvironmentReader {
    private static final String APPLICATION_RESOURCE_FILE = "jndi.properties";
    private static final String PROVIDER_RESOURCE_FILE = "jndiprovider.properties";

    private EnvironmentReader() {
    }

    public static void mergeEnvironment(Hashtable<?, ?> hashtable, Hashtable<Object, Object> hashtable2, boolean bl) {
        Object k = null;
        String string = null;
        Enumeration<?> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            if (!hashtable2.containsKey(k)) {
                hashtable2.put(k, hashtable.get(k));
                continue;
            }
            if (!bl || !"java.naming.factory.control".equals(k) && !"java.naming.factory.object".equals(k) && !"java.naming.factory.state".equals(k) && !"java.naming.factory.url.pkgs".equals(k)) continue;
            string = (String)hashtable2.get(k);
            string = string + ":" + hashtable.get(k);
            hashtable2.put(k, string);
        }
    }

    static Hashtable<Object, Object> filterProperties(JNDIPropertiesSource jNDIPropertiesSource) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        String string = null;
        string = jNDIPropertiesSource.getProperty("java.naming.factory.initial");
        if (null != string) {
            hashtable.put("java.naming.factory.initial", string);
        }
        if (null != (string = jNDIPropertiesSource.getProperty("java.naming.dns.url"))) {
            hashtable.put("java.naming.dns.url", string);
        }
        if (null != (string = jNDIPropertiesSource.getProperty("java.naming.provider.url"))) {
            hashtable.put("java.naming.provider.url", string);
        }
        if (null != (string = jNDIPropertiesSource.getProperty("java.naming.factory.object"))) {
            hashtable.put("java.naming.factory.object", string);
        }
        if (null != (string = jNDIPropertiesSource.getProperty("java.naming.factory.state"))) {
            hashtable.put("java.naming.factory.state", string);
        }
        if (null != (string = jNDIPropertiesSource.getProperty("java.naming.factory.url.pkgs"))) {
            hashtable.put("java.naming.factory.url.pkgs", string);
        }
        if (null != (string = jNDIPropertiesSource.getProperty("java.naming.factory.control"))) {
            hashtable.put("java.naming.factory.control", string);
        }
        return hashtable;
    }

    public static void readSystemProperties(Hashtable<Object, Object> hashtable) {
        Hashtable<Object, Object> hashtable2 = AccessController.doPrivileged(new PrivilegedAction<Hashtable<Object, Object>>(){

            @Override
            public Hashtable<Object, Object> run() {
                return EnvironmentReader.filterProperties(new SystemPropertiesSource());
            }
        });
        EnvironmentReader.mergeEnvironment(hashtable2, hashtable, false);
    }

    public static void readAppletParameters(Object object, Hashtable<Object, Object> hashtable) {
        if (null != object) {
            Hashtable<Object, Object> hashtable2 = EnvironmentReader.filterProperties(new AppletParametersSource((Applet)object));
            EnvironmentReader.mergeEnvironment(hashtable2, hashtable, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hashtable<Object, Object> readMultipleResourceFiles(String string, Hashtable<Object, Object> hashtable, ClassLoader classLoader) throws NamingException {
        if (null == classLoader) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            ConfigurationException configurationException = new ConfigurationException(Messages.getString("jndi.23"));
            configurationException.setRootCause(iOException);
            throw configurationException;
        }
        URL uRL = null;
        InputStream inputStream = null;
        Properties properties = new Properties();
        while (enumeration.hasMoreElements()) {
            uRL = enumeration.nextElement();
            try {
                inputStream = uRL.openStream();
                if (null == inputStream) continue;
                properties.load(inputStream);
                EnvironmentReader.mergeEnvironment(properties, hashtable, true);
                properties.clear();
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException(Messages.getString("jndi.24"));
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
            finally {
                try {
                    if (null == inputStream) continue;
                    inputStream.close();
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    inputStream = null;
                }
            }
        }
        return hashtable;
    }

    public static Hashtable<Object, Object> readApplicationResourceFiles(final Hashtable<Object, Object> hashtable) throws NamingException {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws NamingException {
                        EnvironmentReader.readMultipleResourceFiles(EnvironmentReader.APPLICATION_RESOURCE_FILE, hashtable, Thread.currentThread().getContextClassLoader());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof NamingException) {
                    throw (NamingException)exception;
                }
                if (!(exception instanceof RuntimeException)) break block3;
                throw (RuntimeException)exception;
            }
        }
        return hashtable;
    }

    public static Hashtable<Object, Object> readLibraryResourceFile(Hashtable<Object, Object> hashtable) throws NamingException {
        String string = System.getProperty("file.separator");
        String string2 = null;
        string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.home");
            }
        });
        if (!string2.endsWith(string)) {
            string2 = string2 + string;
        }
        string2 = string2 + "lib" + string + APPLICATION_RESOURCE_FILE;
        InputStream inputStream = null;
        final File file = new File(string2);
        final Properties properties = new Properties();
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
        if (bl) {
            try {
                inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws IOException {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        properties.load(fileInputStream);
                        return fileInputStream;
                    }
                });
                EnvironmentReader.mergeEnvironment(properties, hashtable, true);
            }
            catch (PrivilegedActionException privilegedActionException) {
                ConfigurationException configurationException = new ConfigurationException(Messages.getString("jndi.25"));
                configurationException.setRootCause(privilegedActionException.getException());
                throw configurationException;
            }
            finally {
                try {
                    if (null != inputStream) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return hashtable;
    }

    public static Hashtable<Object, Object> readProviderResourceFiles(final Context context, final Hashtable<Object, Object> hashtable) throws NamingException {
        String string = context.getClass().getName();
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (-1 == n) {
            string2 = PROVIDER_RESOURCE_FILE;
        } else {
            string2 = string.substring(0, n + 1);
            string2 = string2.replace('.', '/');
            string2 = string2 + PROVIDER_RESOURCE_FILE;
        }
        try {
            final String string3 = string2;
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws NamingException {
                    EnvironmentReader.readMultipleResourceFiles(string3, hashtable, context.getClass().getClassLoader());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
        return hashtable;
    }

    public static String[] getFactoryNamesFromEnvironmentAndProviderResource(Hashtable<?, ?> hashtable, Context context, String string) throws NamingException {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != hashtable && null != (object2 = (String)hashtable.get(string))) {
            object = new StringTokenizer((String)object2, ":");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (null != context) {
            object2 = new Hashtable();
            EnvironmentReader.readProviderResourceFiles(context, (Hashtable<Object, Object>)object2);
            object = (String)((Hashtable)object2).get(string);
            if (null != object) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if ("java.naming.factory.url.pkgs".equals(string)) {
            arrayList.add("com.sun.jndi.url");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static class AppletParametersSource
    implements JNDIPropertiesSource {
        private Applet applet;

        public AppletParametersSource(Applet applet) {
            this.applet = applet;
        }

        @Override
        public String getProperty(String string) {
            return this.applet.getParameter(string);
        }
    }

    private static class SystemPropertiesSource
    implements JNDIPropertiesSource {
        @Override
        public String getProperty(String string) {
            return System.getProperty(string);
        }
    }

    private static interface JNDIPropertiesSource {
        public String getProperty(String var1);
    }
}

