/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.io.Serializable;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class ResolveResult
implements Serializable {
    static final long serialVersionUID = -4552108072002407559L;
    protected Object resolvedObj;
    protected Name remainingName;

    protected ResolveResult() {
        this.resolvedObj = null;
        this.remainingName = null;
    }

    public ResolveResult(Object object, String string) {
        this.resolvedObj = object;
        try {
            this.remainingName = new CompositeName(string);
        }
        catch (InvalidNameException invalidNameException) {
            this.remainingName = null;
        }
    }

    public ResolveResult(Object object, Name name) {
        this.resolvedObj = object;
        this.remainingName = null == name ? null : (Name)name.clone();
    }

    public void appendRemainingComponent(String string) {
        if (null != string) {
            if (null == this.remainingName) {
                this.remainingName = new CompositeName();
            }
            try {
                this.remainingName.add(string);
            }
            catch (InvalidNameException invalidNameException) {
                throw new Error(invalidNameException.getMessage());
            }
        }
    }

    public void appendRemainingName(Name name) {
        if (null != name) {
            if (null == this.remainingName) {
                this.remainingName = (Name)name.clone();
            } else {
                try {
                    this.remainingName.addAll(name);
                }
                catch (InvalidNameException invalidNameException) {
                    throw new Error(invalidNameException.getMessage());
                }
            }
        }
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public void setRemainingName(Name name) {
        this.remainingName = null == name ? null : (Name)name.clone();
    }

    public void setResolvedObj(Object object) {
        this.resolvedObj = object;
    }
}

