/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;
import org.apache.harmony.jndi.internal.EnvironmentReader;
import org.apache.harmony.jndi.internal.UrlParser;
import org.apache.harmony.jndi.internal.nls.Messages;

public class NamingManager {
    public static final String CPE = "java.naming.spi.CannotProceedException";
    static InitialContextFactoryBuilder icfb;
    static ObjectFactoryBuilder ofb;
    private static final int DEFAULT_CAPACITY = 64;
    private static HashMap<CacheKey, Object> theCache;

    NamingManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder initialContextFactoryBuilder) throws IllegalStateException, SecurityException, NamingException {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkSetFactory();
        }
        Class<NamingManager> clazz = NamingManager.class;
        synchronized (NamingManager.class) {
            if (null != icfb) {
                throw new IllegalStateException(Messages.getString("jndi.1E"));
            }
            icfb = initialContextFactoryBuilder;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return null != icfb;
    }

    public static synchronized void setObjectFactoryBuilder(ObjectFactoryBuilder objectFactoryBuilder) throws IllegalStateException, SecurityException, NamingException {
        if (null != ofb) {
            throw new IllegalStateException(Messages.getString("jndi.1F"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkSetFactory();
        }
        ofb = objectFactoryBuilder;
    }

    public static Context getInitialContext(Hashtable<?, ?> hashtable) throws NoInitialContextException, NamingException {
        if (null != icfb) {
            return icfb.createInitialContextFactory(hashtable).getInitialContext(hashtable);
        }
        try {
            String string = (String)hashtable.get("java.naming.factory.initial");
            InitialContextFactory initialContextFactory = (InitialContextFactory)NamingManager.factoryForName(string);
            return initialContextFactory.getInitialContext(hashtable);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NoInitialContextException noInitialContextException = new NoInitialContextException(Messages.getString("jndi.20", hashtable));
            noInitialContextException.setRootCause(exception);
            throw noInitialContextException;
        }
    }

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException, Exception {
        Object object2;
        if (null != ofb) {
            ObjectFactory objectFactory = ofb.createObjectFactory(object, hashtable);
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        Reference reference = null;
        if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (object instanceof Reference) {
            reference = (Reference)object;
        }
        if (null != reference) {
            if (null != reference.getFactoryClassName()) {
                return NamingManager.getObjectInstanceByFactoryInReference(reference, object, name, context, hashtable);
            }
            object2 = NamingManager.getObjectInstanceByUrlRefAddr(name, context, hashtable, reference);
            if (null != object2) {
                return object2;
            }
        }
        if (null != (object2 = NamingManager.getObjectInstanceByObjectFactory(object, name, context, hashtable))) {
            return object2;
        }
        return object;
    }

    private static Object getObjectInstanceByObjectFactory(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException, Exception {
        String[] stringArray;
        for (String string : stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, context, "java.naming.factory.object")) {
            Object object2;
            ObjectFactory objectFactory = null;
            objectFactory = (ObjectFactory)NamingManager.factoryForName(string);
            if (null == objectFactory || null == (object2 = objectFactory.getObjectInstance(object, name, context, hashtable))) continue;
            return object2;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlRefAddr(Name name, Context context, Hashtable<?, ?> hashtable, Reference reference) throws NamingException {
        String[] stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, context, "java.naming.factory.url.pkgs");
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            String string;
            Object object;
            RefAddr refAddr = enumeration.nextElement();
            if (!(refAddr instanceof StringRefAddr) || !refAddr.getType().equalsIgnoreCase("URL") || null == (object = NamingManager.getObjectInstanceByUrlContextFactory(string = (String)((StringRefAddr)refAddr).getContent(), name, context, hashtable, stringArray, UrlParser.getScheme(string)))) continue;
            return object;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlContextFactory(String string, Name name, Context context, Hashtable<?, ?> hashtable, String[] stringArray, String string2) throws NamingException {
        if (null == string2 || 0 == string2.length()) {
            return null;
        }
        for (String string3 : stringArray) {
            ObjectFactory objectFactory = null;
            String string4 = string3 + "." + string2 + "." + string2 + "URLContextFactory";
            objectFactory = (ObjectFactory)NamingManager.factoryForName(string4);
            if (null == objectFactory) continue;
            try {
                Object object = objectFactory.getObjectInstance(string, name, context, hashtable);
                if (null == object) continue;
                return object;
            }
            catch (Exception exception) {
                if (exception instanceof NamingException) {
                    throw (NamingException)exception;
                }
                NamingException namingException = new NamingException(Messages.getString("jndi.21"));
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return null;
    }

    private static Object getObjectInstanceByFactoryInReference(Reference reference, Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        ObjectFactory objectFactory = null;
        objectFactory = (ObjectFactory)NamingManager.factoryForName(reference.getFactoryClassName());
        if (null == objectFactory && null != reference.getFactoryClassLocation()) {
            objectFactory = (ObjectFactory)NamingManager.loadFactoryFromLocation(reference.getFactoryClassName(), reference.getFactoryClassLocation());
        }
        if (null == objectFactory) {
            return object;
        }
        return objectFactory.getObjectInstance(reference, name, context, hashtable);
    }

    private static Object loadFactoryFromLocation(String string, String string2) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = new URL(stringTokenizer.nextToken());
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        try {
            return uRLClassLoader.loadClass(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Object getStateToBind(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        String[] stringArray;
        for (String string : stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, context, "java.naming.factory.state")) {
            Object object2;
            StateFactory stateFactory = null;
            stateFactory = (StateFactory)NamingManager.factoryForName(string);
            if (null == stateFactory || null == (object2 = stateFactory.getStateToBind(object, name, context, hashtable))) continue;
            return object2;
        }
        return object;
    }

    public static Context getURLContext(String string, Hashtable<?, ?> hashtable) throws NamingException {
        String[] stringArray;
        if (null == string || 0 == string.length() || null == hashtable) {
            return null;
        }
        for (String string2 : stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, null, "java.naming.factory.url.pkgs")) {
            String string3 = string2 + "." + string + "." + string + "URLContextFactory";
            ObjectFactory objectFactory = (ObjectFactory)NamingManager.factoryForName(string3);
            if (null == objectFactory) continue;
            try {
                return (Context)objectFactory.getObjectInstance(null, null, null, hashtable);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException(Messages.getString("jndi.22", exception.toString()));
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return null;
    }

    public static Context getContinuationContext(CannotProceedException cannotProceedException) throws NamingException {
        Context context = null;
        if (cannotProceedException.getEnvironment() == null) {
            cannotProceedException.setEnvironment(new Hashtable());
        }
        cannotProceedException.getEnvironment().put(CPE, cannotProceedException);
        if (null == cannotProceedException.getResolvedObj()) {
            cannotProceedException.fillInStackTrace();
            throw cannotProceedException;
        }
        if (cannotProceedException.getResolvedObj() instanceof Context) {
            context = (Context)cannotProceedException.getResolvedObj();
        } else {
            try {
                context = (Context)NamingManager.getObjectInstance(cannotProceedException.getResolvedObj(), cannotProceedException.getAltName(), cannotProceedException.getAltNameCtx(), cannotProceedException.getEnvironment());
            }
            catch (Exception exception) {
                throw cannotProceedException;
            }
            if (null == context) {
                cannotProceedException.fillInStackTrace();
                throw cannotProceedException;
            }
        }
        return context;
    }

    private static Object factoryForName(String string) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        CacheKey cacheKey = new CacheKey(string, classLoader2);
        if (theCache.containsKey(cacheKey)) {
            return theCache.get(cacheKey);
        }
        Object object = null;
        try {
            object = NamingManager.factoryForName(string, classLoader2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        theCache.put(cacheKey, object);
        if (null == object && !(classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        })).equals(classLoader2)) {
            try {
                object = NamingManager.factoryForName(string, classLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
            theCache.put(cacheKey, object);
        }
        return object;
    }

    private static Object factoryForName(final String string, final ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
        if (null == clazz) {
            throw new ClassNotFoundException(Messages.getString("jndi.1C", string));
        }
        return clazz.newInstance();
    }

    static {
        theCache = new HashMap(64);
    }

    private static class CacheKey {
        String clazzName;
        ClassLoader clazzLoader;

        public CacheKey(String string, ClassLoader classLoader) {
            this.clazzName = string;
            this.clazzLoader = classLoader;
        }

        public boolean equals(Object object) {
            if (object instanceof CacheKey) {
                boolean bl;
                CacheKey cacheKey = (CacheKey)object;
                boolean bl2 = this.clazzName == null ? cacheKey.clazzName == null : (bl = this.clazzName.equals(cacheKey.clazzName));
                boolean bl3 = this.clazzLoader == null ? cacheKey.clazzLoader == null : this.clazzLoader.equals(cacheKey.clazzLoader);
                return bl && bl3;
            }
            return false;
        }

        public int hashCode() {
            int n = this.clazzName == null ? 0 : this.clazzName.hashCode();
            int n2 = this.clazzLoader == null ? 0 : this.clazzLoader.hashCode();
            return n * 17 + n2;
        }
    }
}

