/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.SortKey;
import org.apache.harmony.security.asn1.ASN1Boolean;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;

public final class SortControl
extends BasicControl {
    static ASN1Sequence ASN1_SORTKEY = new ASN1Sequence(new ASN1Type[]{ASN1OctetString.getInstance(), new ASN1Implicit(0, (ASN1Type)ASN1StringType.UTF8STRING), new ASN1Implicit(1, (ASN1Type)ASN1Boolean.getInstance())}){
        {
            this.setOptional(1);
            this.setDefault(Boolean.FALSE, 2);
        }

        public void getValues(Object object, Object[] objectArray) {
            SortKey sortKey = (SortKey)object;
            try {
                objectArray[0] = sortKey.getAttributeID().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                objectArray[0] = sortKey.getAttributeID().getBytes();
            }
            objectArray[1] = sortKey.getMatchingRuleID();
            objectArray[2] = !sortKey.isAscending();
        }
    };
    static ASN1SequenceOf ASN1_SORTKEYLIST = new ASN1SequenceOf((ASN1Type)ASN1_SORTKEY);
    private static final long serialVersionUID = -1965961680233330744L;
    public static final String OID = "1.2.840.113556.1.4.473";

    public SortControl(String string, boolean bl) throws IOException {
        super(OID, bl, null);
        ArrayList<SortKey> arrayList = new ArrayList<SortKey>();
        if (string != null) {
            arrayList.add(new SortKey(string, true, null));
        } else {
            arrayList.add(new SortKey("", true, null));
        }
        this.value = ASN1_SORTKEYLIST.encode(arrayList);
    }

    public SortControl(String[] stringArray, boolean bl) throws IOException {
        super(OID, bl, null);
        ArrayList<SortKey> arrayList = new ArrayList<SortKey>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) {
                arrayList.add(new SortKey(stringArray[i], true, null));
                continue;
            }
            arrayList.add(new SortKey("", true, null));
        }
        this.value = ASN1_SORTKEYLIST.encode(arrayList);
    }

    public SortControl(SortKey[] sortKeyArray, boolean bl) throws IOException {
        super(OID, bl, null);
        ArrayList<SortKey> arrayList = new ArrayList<SortKey>();
        for (int i = 0; i < sortKeyArray.length; ++i) {
            arrayList.add(sortKeyArray[i]);
        }
        this.value = ASN1_SORTKEYLIST.encode(arrayList);
    }
}

