/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.LdapRdnParser;
import org.apache.harmony.jndi.internal.parser.LdapTypeAndValueList;

public class Rdn
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = -5994465067210009656L;
    private transient List<Attribute> list;
    private transient LdapRdnParser parser;

    public static String escapeValue(Object object) {
        if (object == null) {
            throw new NullPointerException("val " + Messages.getString("ldap.00"));
        }
        return LdapRdnParser.escapeValue(object);
    }

    public static Object unescapeValue(String string) {
        if (string == null) {
            throw new NullPointerException("val " + Messages.getString("ldap.00"));
        }
        return LdapRdnParser.unescapeValue(string);
    }

    public Rdn(Attributes attributes) throws InvalidNameException {
        if (attributes == null) {
            throw new NullPointerException("attrSet " + Messages.getString("ldap.00"));
        }
        if (attributes.size() == 0) {
            throw new InvalidNameException("atrrSet " + Messages.getString("ldap.03"));
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            try {
                attribute.get();
            }
            catch (NamingException namingException) {}
        }
        this.list = this.convertToAttributeArrayList(attributes);
    }

    public Rdn(Rdn rdn) {
        if (rdn == null) {
            throw new NullPointerException("rdn " + Messages.getString("ldap.00"));
        }
        this.list = this.convertToAttributeArrayList(rdn.toAttributes());
    }

    public Rdn(String string) throws InvalidNameException {
        if (string == null) {
            throw new NullPointerException("rdnString " + Messages.getString("ldap.00"));
        }
        if (string.length() != 0) {
            this.parser = new LdapRdnParser(string);
            this.list = this.parser.getList();
        } else {
            this.list = new ArrayList<Attribute>();
        }
    }

    public Rdn(String string, Object object) throws InvalidNameException {
        if (string == null) {
            throw new NullPointerException("type " + Messages.getString("ldap.00"));
        }
        if (object == null) {
            throw new NullPointerException("value " + Messages.getString("ldap.00"));
        }
        if (string.length() == 0) {
            throw new InvalidNameException("type " + Messages.getString("ldap.04"));
        }
        if (object instanceof String && ((String)object).length() == 0) {
            throw new InvalidNameException("value " + Messages.getString("ldap.04"));
        }
        this.list = this.convertToAttributeArrayList(new BasicAttributes(string, object, true));
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof Rdn)) {
            throw new ClassCastException(Messages.getString("ldap.06"));
        }
        Rdn rdn = (Rdn)object;
        String string = "";
        String string2 = "";
        NamingEnumeration<? extends Attribute> namingEnumeration = this.toAttributes().getAll();
        while (namingEnumeration.hasMoreElements()) {
            string = string + Rdn.escapeValue(namingEnumeration.nextElement().toString());
        }
        namingEnumeration = rdn.toAttributes().getAll();
        while (namingEnumeration.hasMoreElements()) {
            string2 = string2 + Rdn.escapeValue(namingEnumeration.nextElement().toString());
        }
        return string.toLowerCase().compareTo(string2.toLowerCase());
    }

    private List<Attribute> convertToAttributeArrayList(Attributes attributes) {
        LdapTypeAndValueList ldapTypeAndValueList = new LdapTypeAndValueList();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        try {
            while (namingEnumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)namingEnumeration.nextElement();
                ldapTypeAndValueList.put(attribute.getID(), attribute.get());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return ldapTypeAndValueList.toAttributeList();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rdn) || this.size() != ((Rdn)object).size()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = this.toAttributes().getAll();
        NamingEnumeration<? extends Attribute> namingEnumeration2 = ((Rdn)object).toAttributes().getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            Attribute attribute2 = (Attribute)namingEnumeration2.nextElement();
            if (!attribute.getID().toLowerCase().equals(attribute2.getID().toLowerCase()) || attribute.size() != attribute2.size()) {
                return false;
            }
            NamingEnumeration<?> namingEnumeration3 = null;
            NamingEnumeration<?> namingEnumeration4 = null;
            try {
                namingEnumeration3 = attribute.getAll();
                namingEnumeration4 = attribute2.getAll();
            }
            catch (NamingException namingException) {
                return false;
            }
            while (namingEnumeration3.hasMoreElements()) {
                String string;
                Object e = namingEnumeration3.nextElement();
                String string2 = e instanceof String ? (String)e : Rdn.escapeValue(e);
                Object e2 = namingEnumeration4.nextElement();
                String string3 = string = e2 instanceof String ? (String)e2 : Rdn.escapeValue(e2);
                if (string2.toLowerCase().equals(string.toLowerCase())) continue;
                return false;
            }
        }
        return true;
    }

    public String getType() {
        return this.list.get(0).getID();
    }

    public Object getValue() {
        Object object = null;
        try {
            object = this.list.get(0).get();
        }
        catch (NamingException namingException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return object;
    }

    public int hashCode() {
        int n = 0;
        for (Attribute attribute : this.list) {
            NamingEnumeration<?> namingEnumeration = null;
            n += attribute.getID().toLowerCase().hashCode();
            try {
                namingEnumeration = attribute.getAll();
            }
            catch (NamingException namingException) {
                continue;
            }
            while (namingEnumeration.hasMoreElements()) {
                Object object = namingEnumeration.nextElement();
                if (object instanceof byte[]) {
                    object = new String((byte[])object);
                }
                try {
                    String string = (String)object;
                    n += Rdn.escapeValue(string.toLowerCase()).hashCode();
                }
                catch (ClassCastException classCastException) {
                    n += object.hashCode();
                }
            }
        }
        return n;
    }

    public int size() {
        int n = 0;
        Iterator<Attribute> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().size();
        }
        return n;
    }

    public Attributes toAttributes() {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        for (Attribute attribute : this.list) {
            BasicAttribute basicAttribute = new BasicAttribute(attribute.getID(), false);
            try {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    basicAttribute.add(namingEnumeration.next());
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            basicAttributes.put(basicAttribute);
        }
        return basicAttributes;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Attribute> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            NamingEnumeration<?> namingEnumeration = null;
            try {
                namingEnumeration = attribute.getAll();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            while (namingEnumeration.hasMoreElements()) {
                stringBuffer.append(attribute.getID());
                stringBuffer.append('=');
                stringBuffer.append(Rdn.escapeValue(namingEnumeration.nextElement()));
                if (!namingEnumeration.hasMoreElements()) continue;
                stringBuffer.append('+');
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append('+');
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InvalidNameException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        if (string == null) {
            throw new NullPointerException("rdnString " + Messages.getString("ldap.00"));
        }
        if (string.length() != 0) {
            this.parser = new LdapRdnParser(string);
            this.list = this.parser.getList();
        } else {
            this.list = new ArrayList<Attribute>();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.toString());
    }
}

