/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicNamingEnumeration;
import org.apache.harmony.jndi.internal.nls.Messages;

public class BasicAttributes
implements Attributes {
    static final long serialVersionUID = 4980164073184639448L;
    private boolean ignoreCase;
    private transient Hashtable<String, Attribute> attrMap = new Hashtable();

    public BasicAttributes() {
        this(false);
    }

    public BasicAttributes(boolean bl) {
        this.ignoreCase = bl;
    }

    public BasicAttributes(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttributes(String string, Object object, boolean bl) {
        this.ignoreCase = bl;
        this.attrMap.put(this.convertId(string), new BasicAttribute(string, object));
    }

    private String convertId(String string) {
        return this.ignoreCase ? string.toLowerCase() : string;
    }

    @Override
    public Attribute get(String string) {
        return this.attrMap.get(this.convertId(string));
    }

    public NamingEnumeration<Attribute> getAll() {
        return new BasicNamingEnumeration<Attribute>(this.attrMap.elements());
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        if (this.ignoreCase) {
            Enumeration<Attribute> enumeration = this.attrMap.elements();
            Vector<String> vector = new Vector<String>(this.attrMap.size());
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement().getID());
            }
            return new BasicNamingEnumeration<String>(vector.elements());
        }
        return new BasicNamingEnumeration<String>(this.attrMap.keys());
    }

    @Override
    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @Override
    public Attribute put(Attribute attribute) {
        String string = this.convertId(attribute.getID());
        return this.attrMap.put(string, attribute);
    }

    @Override
    public Attribute put(String string, Object object) {
        return this.put(new BasicAttribute(string, object));
    }

    @Override
    public Attribute remove(String string) {
        return this.attrMap.remove(this.convertId(string));
    }

    @Override
    public int size() {
        return this.attrMap.size();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.attrMap = new Hashtable();
        for (int i = 0; i < n; ++i) {
            BasicAttribute basicAttribute = (BasicAttribute)objectInputStream.readObject();
            this.attrMap.put(this.convertId(basicAttribute.getID()), basicAttribute);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.attrMap.size());
        Enumeration<Attribute> enumeration = this.attrMap.elements();
        while (enumeration.hasMoreElements()) {
            objectOutputStream.writeObject(enumeration.nextElement());
        }
    }

    @Override
    public Object clone() {
        try {
            BasicAttributes basicAttributes = (BasicAttributes)super.clone();
            basicAttributes.attrMap = (Hashtable)this.attrMap.clone();
            return basicAttributes;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)Messages.getString("jndi.15"));
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attributes)) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        if (this.isCaseIgnored() != attributes.isCaseIgnored() || this.size() != attributes.size()) {
            return false;
        }
        for (Map.Entry<String, Attribute> entry : this.attrMap.entrySet()) {
            if (entry.getValue().equals(attributes.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        Enumeration<Attribute> enumeration = this.attrMap.elements();
        int n2 = n = this.ignoreCase ? 1 : 0;
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().hashCode();
        }
        return n;
    }

    public String toString() {
        String string = null;
        Iterator<Map.Entry<String, Attribute>> iterator = this.attrMap.entrySet().iterator();
        Map.Entry<String, Attribute> entry = null;
        if (iterator.hasNext()) {
            entry = iterator.next();
            string = "{\n";
            string = string + entry.getKey();
            string = string + "=" + entry.getValue().toString();
            while (iterator.hasNext()) {
                entry = iterator.next();
                string = string + "; ";
                string = string + entry.getKey();
                string = string + "=" + entry.getValue().toString();
            }
            string = string + "}\n";
        } else {
            string = "This Attributes does not have any attributes.\n";
        }
        return string;
    }
}

