/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicNamingEnumeration;
import javax.naming.directory.DirContext;
import org.apache.harmony.jndi.internal.nls.Messages;

public class BasicAttribute
implements Attribute {
    static final long serialVersionUID = 6743528196119291326L;
    protected String attrID;
    protected boolean ordered;
    protected transient Vector<Object> values = new Vector();

    public BasicAttribute(String string) {
        this(string, false);
    }

    public BasicAttribute(String string, boolean bl) {
        this.attrID = string;
        this.ordered = bl;
    }

    public BasicAttribute(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttribute(String string, Object object, boolean bl) {
        this(string, bl);
        this.values.add(object);
    }

    private boolean compareValueClasses(Class<? extends Object> clazz, Class<? extends Object> clazz2) {
        if ((clazz.getName().startsWith("[L") || clazz.getName().startsWith("[[")) && (clazz2.getName().startsWith("[L") || clazz2.getName().startsWith("[["))) {
            return true;
        }
        return clazz.getName().equals(clazz2.getName());
    }

    private boolean compareValues(Object object, Object object2) {
        if (null == object && null == object2) {
            return true;
        }
        if (null != object && null != object2) {
            if (object.getClass().isArray() && object2.getClass().isArray()) {
                if (this.compareValueClasses(object.getClass(), object2.getClass())) {
                    int n = Array.getLength(object);
                    if (Array.getLength(object2) == n) {
                        --n;
                        while (n >= 0) {
                            Object object3 = Array.get(object, n);
                            Object object4 = Array.get(object2, n);
                            if (null == object3 ? null != object4 : !object3.equals(object4)) {
                                return false;
                            }
                            --n;
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return object.equals(object2);
        }
        return false;
    }

    private int hashCodeOfValue(Object object) {
        int n = 0;
        if (null != object) {
            if (object.getClass().isArray()) {
                Object object2 = null;
                for (int i = Array.getLength(object) - 1; i >= 0; --i) {
                    object2 = Array.get(object, i);
                    if (null == object2) continue;
                    n += object2.hashCode();
                }
            } else {
                n = object.hashCode();
            }
        }
        return n;
    }

    @Override
    public void add(int n, Object object) {
        if (this.ordered) {
            this.values.add(n, object);
        } else {
            if (this.contains(object)) {
                throw new IllegalStateException(Messages.getString("jndi.16"));
            }
            this.values.add(n, object);
        }
    }

    @Override
    public boolean add(Object object) {
        if (this.ordered) {
            return this.values.add(object);
        }
        if (this.contains(object)) {
            return false;
        }
        return this.values.add(object);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Object clone() {
        try {
            BasicAttribute basicAttribute = (BasicAttribute)super.clone();
            basicAttribute.values = (Vector)this.values.clone();
            return basicAttribute;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)Messages.getString("jndi.17"));
        }
    }

    @Override
    public boolean contains(Object object) {
        Enumeration<Object> enumeration = this.values.elements();
        while (enumeration.hasMoreElements()) {
            if (!this.compareValues(enumeration.nextElement(), object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get() throws NamingException {
        if (0 == this.values.size()) {
            throw new NoSuchElementException(Messages.getString("jndi.18"));
        }
        return this.values.get(0);
    }

    @Override
    public Object get(int n) throws NamingException {
        return this.values.get(n);
    }

    @Override
    public NamingEnumeration<?> getAll() throws NamingException {
        return new BasicNamingEnumeration<Object>(this.values.elements());
    }

    @Override
    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException(Messages.getString("jndi.19"));
    }

    @Override
    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException(Messages.getString("jndi.19"));
    }

    @Override
    public String getID() {
        return this.attrID;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Object remove(int n) {
        return this.values.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            if (!this.compareValues(this.values.get(i), object)) continue;
            this.values.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public Object set(int n, Object object) {
        if (!this.ordered && this.contains(object)) {
            throw new IllegalStateException(Messages.getString("jndi.16"));
        }
        return this.values.set(n, object);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.values = new Vector();
        for (int i = 0; i < n; ++i) {
            this.values.add(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.values.size());
        for (Object object : this.values) {
            objectOutputStream.writeObject(object);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BasicAttribute) {
            BasicAttribute basicAttribute = (BasicAttribute)object;
            if (!this.attrID.equals(basicAttribute.attrID)) {
                return false;
            }
            if (this.ordered != basicAttribute.ordered) {
                return false;
            }
            if (this.values.size() != basicAttribute.values.size()) {
                return false;
            }
            if (this.ordered) {
                Enumeration<Object> enumeration = this.values.elements();
                Enumeration<Object> enumeration2 = basicAttribute.values.elements();
                while (enumeration.hasMoreElements()) {
                    if (this.compareValues(enumeration.nextElement(), enumeration2.nextElement())) continue;
                    return false;
                }
                return true;
            }
            Enumeration<Object> enumeration = this.values.elements();
            while (enumeration.hasMoreElements()) {
                if (basicAttribute.contains(enumeration.nextElement())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.attrID.hashCode();
        Enumeration<Object> enumeration = this.values.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (null == object) continue;
            n += this.hashCodeOfValue(object);
        }
        return n;
    }

    public String toString() {
        Enumeration<Object> enumeration = this.values.elements();
        String string = "Attribute ID: " + this.attrID;
        string = string + "\nAttribute values: ";
        if (!enumeration.hasMoreElements()) {
            string = string + "This Attribute does not have any values.";
        } else {
            string = string + enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                string = string + "," + enumeration.nextElement();
            }
        }
        return string + "\n";
    }
}

