/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.NamingManager;
import org.apache.harmony.jndi.internal.EnvironmentReader;
import org.apache.harmony.jndi.internal.UrlParser;
import org.apache.harmony.jndi.internal.nls.Messages;

public class InitialContext
implements Context {
    protected Context defaultInitCtx;
    protected boolean gotDefault;
    protected Hashtable<Object, Object> myProps;
    private static WeakHashMap<ClassLoader, Hashtable<Object, Object>> propsCache = new WeakHashMap();
    private static Hashtable<Object, Object> libProperties = null;

    public static <T> T doLookup(Name name) throws NamingException {
        return (T)new InitialContext().lookup(name);
    }

    public static <T> T doLookup(String string) throws NamingException {
        return (T)new InitialContext().lookup(string);
    }

    public InitialContext() throws NamingException {
        this(null);
    }

    public InitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        this.internalInit(hashtable);
    }

    protected InitialContext(boolean bl) throws NamingException {
        if (!bl) {
            this.internalInit(null);
        }
    }

    private void internalInit(Hashtable<?, ?> hashtable) throws NamingException {
        this.myProps = null == hashtable ? new Hashtable() : (Hashtable)hashtable.clone();
        EnvironmentReader.readAppletParameters(this.myProps.get("java.naming.applet"), this.myProps);
        EnvironmentReader.readSystemProperties(this.myProps);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (propsCache.containsKey(classLoader)) {
            EnvironmentReader.mergeEnvironment(propsCache.get(classLoader), this.myProps, true);
        } else {
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            EnvironmentReader.readApplicationResourceFiles(hashtable2);
            propsCache.put(classLoader, hashtable2);
            EnvironmentReader.mergeEnvironment(hashtable2, this.myProps, true);
        }
        if (libProperties == null) {
            libProperties = new Hashtable();
            EnvironmentReader.readLibraryResourceFile(libProperties);
        }
        EnvironmentReader.mergeEnvironment(libProperties, this.myProps, true);
        if (this.myProps.containsKey("java.naming.factory.initial")) {
            this.getDefaultInitCtx();
        }
    }

    protected void init(Hashtable<?, ?> hashtable) throws NamingException {
        this.internalInit(hashtable);
    }

    private void initializeDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            if (null == this.defaultInitCtx) {
                throw new NoInitialContextException("Failed to create an initial context.");
            }
            this.gotDefault = true;
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        this.initializeDefaultInitCtx();
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (0 < name.size()) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(String string) throws NamingException {
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        if (null == string) {
            throw new NullPointerException(Messages.getString("jndi.00"));
        }
        String string2 = UrlParser.getScheme(string);
        Context context = null;
        if (null != string2) {
            context = NamingManager.getURLContext(string2, this.myProps);
            if (null == context) {
                context = this.getDefaultInitCtx();
            }
            return context;
        }
        return this.getDefaultInitCtx();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookup(string);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, object);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).bind(string, object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rebind(string, object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).unbind(string);
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rename(name, name2);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rename(string, string2);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).list(string);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).listBindings(string);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).destroySubcontext(string);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).createSubcontext(string);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookupLink(string);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).getNameParser(string);
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        if (null == name) {
            throw new NullPointerException();
        }
        return (Name)name.clone();
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return string;
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.myProps.put(string, object);
        return this.getDefaultInitCtx().addToEnvironment(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        this.myProps.remove(string);
        return this.getDefaultInitCtx().removeFromEnvironment(string);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.getDefaultInitCtx().getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        if (this.gotDefault) {
            this.getDefaultInitCtx().close();
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.getDefaultInitCtx().getNameInNamespace();
    }
}

