/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.harmony.jndi.internal.nls.Messages;

public class CompositeName
implements Name {
    private static final long serialVersionUID = 1667768148915813118L;
    private static final int OUT_OF_QUOTE = 0;
    private static final int IN_SINGLE_QUOTE = 1;
    private static final int IN_DOUBLE_QUOTE = 2;
    private static final int QUOTE_ENDED = 3;
    private transient Vector<String> elems;

    private CompositeName(List<String> list) {
        this.elems = new Vector<String>(list);
    }

    protected CompositeName(Enumeration<String> enumeration) {
        this.elems = new Vector();
        while (enumeration.hasMoreElements()) {
            this.elems.add(enumeration.nextElement());
        }
    }

    public CompositeName() {
        this.elems = new Vector();
    }

    public CompositeName(String string) throws InvalidNameException {
        this.elems = CompositeName.parseName(string);
    }

    private static Vector<String> parseName(String string) throws InvalidNameException {
        Vector<String> vector = new Vector<String>();
        if (CompositeName.isAllSlash(string)) {
            for (int i = 0; i < string.length(); ++i) {
                vector.add("");
            }
            return vector;
        }
        if (string.indexOf(34) < 0 && string.indexOf(39) < 0 && string.indexOf(92) < 0) {
            int n = 0;
            int n2 = 0;
            while ((n2 = string.indexOf(47, n)) >= 0) {
                vector.add(string.substring(n, n2));
                n = n2 + 1;
            }
            vector.add(string.substring(n));
            return vector;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (n == 3) {
                if (c == '/') {
                    vector.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n = 0;
                    continue;
                }
                throw new InvalidNameException(Messages.getString("jndi.0C"));
            }
            if (c == '\\') {
                try {
                    char c2 = cArray[++i];
                    if (c2 == '\\' || c2 == '\'' || c2 == '\"' || c2 == '/') {
                        stringBuilder.append(c2);
                        continue;
                    }
                    stringBuilder.append(c);
                    stringBuilder.append(c2);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new InvalidNameException(Messages.getString("jndi.0D"));
                }
            }
            if (c != '/' && c != '\"' && c != '\'') {
                stringBuilder.append(c);
                continue;
            }
            if (n == 0 && c == '/') {
                vector.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            if (n == 0 && c == '\'' && stringBuilder.length() == 0) {
                n = 1;
                continue;
            }
            if (n == 0 && c == '\"' && stringBuilder.length() == 0) {
                n = 2;
                continue;
            }
            if (n == 1 && c == '\'') {
                n = 3;
                continue;
            }
            if (n == 2 && c == '\"') {
                n = 3;
                continue;
            }
            stringBuilder.append(c);
        }
        vector.add(stringBuilder.toString());
        if (n != 0 && n != 3) {
            throw new InvalidNameException(Messages.getString("jndi.0E"));
        }
        return vector;
    }

    private static boolean isAllSlash(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '/') continue;
            return false;
        }
        return true;
    }

    private static String formatName(Vector<String> vector) {
        if (CompositeName.isAllEmptyElements(vector)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuilder.append("/");
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < vector.size(); ++i) {
            char[] cArray;
            String string = vector.get(i);
            if (i > 0) {
                stringBuilder.append("/");
            }
            if (string.indexOf(47) < 0 && string.indexOf(92) < 0 && string.indexOf(39) < 0 && string.indexOf(34) < 0) {
                stringBuilder.append(string);
                continue;
            }
            for (char c : cArray = string.toCharArray()) {
                if (c == '/' || c == '\\' || c == '\'' || c == '\"') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    private static boolean isAllEmptyElements(Vector<String> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.get(i);
            if (string.length() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Enumeration<String> getAll() {
        return this.elems.elements();
    }

    @Override
    public String get(int n) {
        return this.elems.get(n);
    }

    @Override
    public Name getPrefix(int n) {
        if (n < 0 || n > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CompositeName(this.elems.subList(0, n));
    }

    @Override
    public Name getSuffix(int n) {
        if (n < 0 || n > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CompositeName(this.elems.subList(n, this.elems.size()));
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        if (null == name) {
            throw new NullPointerException();
        }
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.0F"));
        }
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            this.elems.add(enumeration.nextElement());
        }
        return this;
    }

    @Override
    public Name addAll(int n, Name name) throws InvalidNameException {
        if (null == name) {
            throw new NullPointerException();
        }
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.0F"));
        }
        if (n < 0 || n > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            this.elems.add(n++, enumeration.nextElement());
        }
        return this;
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        this.elems.add(string);
        return this;
    }

    @Override
    public Name add(int n, String string) throws InvalidNameException {
        if (n < 0 || n > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elems.add(n, string);
        return this;
    }

    @Override
    public Object remove(int n) throws InvalidNameException {
        if (n < 0 || n >= this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elems.remove(n);
    }

    @Override
    public int size() {
        return this.elems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elems.isEmpty();
    }

    @Override
    public boolean startsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        if (name.size() > this.elems.size()) {
            return false;
        }
        Enumeration<String> enumeration = name.getAll();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = this.elems.get(n);
            String string2 = enumeration.nextElement();
            if (!(null != string ? string.equals(string2) : null == string2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean endsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        if (name.size() > this.elems.size()) {
            return false;
        }
        Enumeration<String> enumeration = name.getAll();
        int n = this.elems.size() - name.size();
        while (enumeration.hasMoreElements()) {
            String string = this.elems.get(n);
            String string2 = enumeration.nextElement();
            if (!(null != string ? string.equals(string2) : null == string2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof CompositeName) {
            CompositeName compositeName = (CompositeName)object;
            for (int i = 0; i < this.elems.size() && i < compositeName.elems.size(); ++i) {
                int n = this.elems.get(i).compareTo(compositeName.elems.get(i));
                if (n == 0) continue;
                return n;
            }
            if (this.elems.size() == compositeName.elems.size()) {
                return 0;
            }
            if (this.elems.size() < compositeName.elems.size()) {
                return -1;
            }
            return 1;
        }
        throw new ClassCastException();
    }

    @Override
    public Object clone() {
        return new CompositeName(this.elems);
    }

    public String toString() {
        return CompositeName.formatName(this.elems);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompositeName)) {
            return false;
        }
        return this.elems.equals(((CompositeName)object).elems);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.elems.size(); ++i) {
            n += this.elems.get(i).hashCode();
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elems.size());
        for (String string : this.elems) {
            objectOutputStream.writeObject(string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws OptionalDataException, ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elems = new Vector();
        for (int i = 0; i < n; ++i) {
            this.elems.add((String)objectInputStream.readObject());
        }
    }
}

