/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Arrays;
import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private static final long serialVersionUID = -3415254970957330361L;
    private byte[] buf;

    public BinaryRefAddr(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    public BinaryRefAddr(String string, byte[] byArray, int n, int n2) {
        super(string);
        this.buf = new byte[n2];
        System.arraycopy(byArray, n, this.buf, 0, n2);
    }

    @Override
    public Object getContent() {
        return this.buf;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BinaryRefAddr) {
            BinaryRefAddr binaryRefAddr = (BinaryRefAddr)object;
            return this.addrType.equals(binaryRefAddr.addrType) && Arrays.equals(this.buf, binaryRefAddr.buf);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.addrType.hashCode();
        for (byte by : this.buf) {
            n += by;
        }
        return n;
    }

    @Override
    public String toString() {
        String string = "The type of the address is: " + this.addrType + "\nThe content of the address is: ";
        int n = this.buf.length > 128 ? 128 : this.buf.length;
        for (int i = 0; i < n; ++i) {
            string = string + Integer.toHexString(this.buf[i]) + " ";
        }
        string = string.substring(0, string.length() - 1) + "\n";
        return string;
    }
}

