/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDIdentityConstraintCategory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XSDConcreteComponentImpl
extends EObjectImpl
implements XSDConcreteComponent {
    protected static final Element ELEMENT_EDEFAULT = null;
    protected Element element = ELEMENT_EDEFAULT;
    protected EList diagnostics = null;
    protected static final int FATAL = 0;
    protected static final int ERROR = 1;
    protected static final int WARNING = 2;
    protected static final int INFORMATION = 3;
    protected boolean updatingDOM;
    protected boolean isReconciling;
    protected boolean forceResolve;
    protected EList xsdContents;
    protected final int UNANALYZED = 0;
    protected final int ANALYZING = 1;
    protected final int ANALYZED = 2;
    protected final int CIRCULAR = 3;
    static /* synthetic */ Class class$0;

    protected XSDConcreteComponentImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_CONCRETE_COMPONENT;
    }

    protected XSDFactory getXSDFactory() {
        return this.getXSDPackage().getXSDFactory();
    }

    protected XSDPackage getXSDPackage() {
        return (XSDPackage)this.eClass().getEPackage();
    }

    public EList getXSDContents() {
        if (this.xsdContents == null) {
            this.xsdContents = new XSDContentsEList((EObject)this, (EStructuralFeature[])((BasicEList)this.eClass().getEAllContainments()).data());
        }
        return this.xsdContents;
    }

    public void reset() {
        Iterator contents = this.getXSDContents().iterator();
        while (contents.hasNext()) {
            XSDConcreteComponentImpl content = (XSDConcreteComponentImpl)contents.next();
            content.reset();
        }
    }

    protected final Element createElement(int nodeType) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema == null) {
            return null;
        }
        Document document = null;
        Element element = null;
        XSDConcreteComponent container2 = this.getContainer();
        block0: while (container2 != null) {
            element = container2.getElement();
            if (element != null) {
                Node root = element.getParentNode();
                while (root != null) {
                    if (root.getNodeType() == 9) {
                        document = (Document)root;
                        break block0;
                    }
                    root = root.getParentNode();
                }
            }
            container2 = container2.getContainer();
        }
        if (document == null && (document = xsdSchema.getDocument()) == null) {
            document = xsdSchema.updateDocument();
        }
        String qualifier = xsdSchema.getSchemaForSchemaQNamePrefix();
        String schemaForSchemaNamespace = xsdSchema.getSchemaForSchemaNamespace();
        Element newElement = document.createElementNS(schemaForSchemaNamespace, String.valueOf(qualifier == null ? "" : String.valueOf(qualifier) + ":") + XSDConstants.ELEMENT_TAGS[nodeType]);
        if (document.getDocumentElement() == null) {
            document.appendChild(newElement);
        }
        if (nodeType == 33) {
            Iterator entries = xsdSchema.getQNamePrefixToNamespaceMap().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = (String)entry.getKey();
                newElement.setAttributeNS("http://www.w3.org/2000/xmlns/", key == null ? "xmlns" : "xmlns:" + key, (String)entry.getValue());
            }
            String xmlnsAttribute = "xmlns";
            if (qualifier != null) {
                xmlnsAttribute = String.valueOf(xmlnsAttribute) + ":" + qualifier;
            }
            newElement.setAttributeNS("http://www.w3.org/2000/xmlns/", xmlnsAttribute, schemaForSchemaNamespace);
        }
        return newElement;
    }

    public Element createElement() {
        return null;
    }

    public void updateElement(boolean deep) {
        if (deep || this.getElement() == null) {
            this.updateElement();
        } else {
            this.changeAttribute(null);
            this.changeReference(null);
        }
    }

    public void updateElement() {
        if (this.getElement() == null) {
            XSDConcreteComponent container2 = this.getContainer();
            if (container2 == null) {
                if (!(this instanceof XSDSchema)) {
                    return;
                }
            } else if (container2.getElement() == null) {
                container2.updateElement();
                return;
            }
            this.isReconciling = true;
            this.createElement();
            this.isReconciling = false;
        }
        this.changeAttribute(null);
        this.changeReference(null);
        Iterator containments = this.eClass().getEAllContainments().iterator();
        while (containments.hasNext()) {
            EReference eReference = (EReference)containments.next();
            if (eReference.isTransient()) continue;
            if (eReference.isMany()) {
                Iterator objects = ((Collection)this.eGet(eReference)).iterator();
                while (objects.hasNext()) {
                    XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)objects.next();
                    this.handleElementForAdopt(eReference, xsdConcreteComponent);
                    xsdConcreteComponent.updateElement();
                }
                continue;
            }
            XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)this.eGet(eReference);
            if (xsdConcreteComponent == null) continue;
            this.handleElementForAdopt(eReference, xsdConcreteComponent);
            xsdConcreteComponent.updateElement();
        }
    }

    protected void updatePrefix(Node node, String namespace, String oldPrefix, String newPrefix) {
        if ((namespace == null ? node.getNamespaceURI() == null : namespace.equals(node.getNamespaceURI())) && (oldPrefix == null ? node.getPrefix() == null : oldPrefix.equals(node.getPrefix()))) {
            node.setPrefix(newPrefix);
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.updatePrefix(child, namespace, oldPrefix, newPrefix);
            child = child.getNextSibling();
        }
    }

    protected boolean isUpdatingDOM() {
        return this.updatingDOM;
    }

    public void elementChanged(Element changedElement) {
        if (!this.isUpdatingDOM() && !this.isReconciling) {
            this.isReconciling = true;
            this.reconcile(changedElement);
            XSDConcreteComponent theContainer = this.getContainer();
            if (theContainer != null && theContainer.getElement() == changedElement) {
                theContainer.elementChanged(changedElement);
            }
            this.isReconciling = false;
            this.traverseToRootForPatching();
        }
    }

    public void elementAttributesChanged(Element changedElement) {
        if (!this.isUpdatingDOM() && !this.isReconciling) {
            this.isReconciling = true;
            this.reconcileAttributes(changedElement);
            XSDConcreteComponent theContainer = this.getContainer();
            if (theContainer != null && theContainer.getElement() == changedElement) {
                theContainer.elementAttributesChanged(changedElement);
            }
            this.isReconciling = false;
            this.traverseToRootForPatching();
        }
    }

    public void elementContentsChanged(Element changedElement) {
        if (!this.isUpdatingDOM() && !this.isReconciling) {
            this.isReconciling = true;
            this.reconcileContents(changedElement);
            XSDConcreteComponent theContainer = this.getContainer();
            if (theContainer != null && theContainer.getElement() == changedElement) {
                theContainer.elementContentsChanged(changedElement);
            }
            this.isReconciling = false;
            this.traverseToRootForPatching();
        }
    }

    protected void traverseToRootForPatching() {
        XSDConcreteComponentImpl container2;
        if (!this.isReconciling && (container2 = (XSDConcreteComponentImpl)this.getContainer()) != null) {
            container2.traverseToRootForPatching();
        }
    }

    protected void traverseToRootForAnalysis() {
        XSDConcreteComponentImpl container2;
        if (!this.isReconciling && (container2 = (XSDConcreteComponentImpl)this.getContainer()) != null) {
            container2.traverseToRootForAnalysis();
        }
    }

    protected void patch() {
        Iterator contents = this.getXSDContents().iterator();
        while (contents.hasNext()) {
            XSDConcreteComponentImpl content = (XSDConcreteComponentImpl)contents.next();
            content.forceResolve = this.forceResolve;
            content.isReconciling = true;
            content.patch();
            content.isReconciling = false;
            content.forceResolve = false;
        }
    }

    protected boolean analyze() {
        boolean result = true;
        Iterator contents = this.getXSDContents().iterator();
        while (contents.hasNext()) {
            XSDConcreteComponentImpl content = (XSDConcreteComponentImpl)contents.next();
            content.isReconciling = true;
            if (!content.analyze()) {
                result = false;
            }
            content.isReconciling = false;
        }
        return result;
    }

    public void validate() {
        Iterator contents = this.getXSDContents().iterator();
        while (contents.hasNext()) {
            XSDConcreteComponent content = (XSDConcreteComponent)contents.next();
            content.validate();
        }
    }

    public void clearDiagnostics() {
        EList theDiagnostics = this.getDiagnostics();
        if (!theDiagnostics.isEmpty()) {
            theDiagnostics.clear();
        }
        Iterator contents = this.getXSDContents().iterator();
        while (contents.hasNext()) {
            XSDConcreteComponent content = (XSDConcreteComponent)contents.next();
            content.clearDiagnostics();
        }
    }

    protected XSDDiagnostic reportConstraintViolation(String part, String anchor, Element element, String attributeName, Object[] substitutions) {
        Attr attr;
        XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, anchor, substitutions)}));
        xsdDiagnostic.setPrimaryComponent(this);
        Node node = element;
        if (attributeName != null && (attr = element.getAttributeNodeNS(null, attributeName)) != null) {
            node = attr;
        }
        xsdDiagnostic.setNode(node);
        this.getDiagnostics().add(xsdDiagnostic);
        return xsdDiagnostic;
    }

    protected XSDDiagnostic checkElementComplexContent(String elementName, String part, String anchor, Element element) {
        XSDElementDeclaration xsdElementDeclaration = this.getSchema().getSchemaForSchema().resolveElementDeclaration(elementName);
        return this.checkComplexContent((XSDComplexTypeDefinition)xsdElementDeclaration.getTypeDefinition(), part, anchor, element);
    }

    protected void printDFA(XSDParticle.DFA dfa) {
        ((XSDParticleImpl.XSDNFA)dfa).dump(System.err);
    }

    protected XSDDiagnostic checkComplexContent(String builtInTypeName, String part, String anchor, Element element) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = this.getSchema().getSchemaForSchema().resolveComplexTypeDefinition(builtInTypeName);
        return this.checkComplexContent(xsdComplexTypeDefinition, part, anchor, element);
    }

    protected XSDDiagnostic checkComplexContent(XSDComplexTypeDefinition xsdComplexTypeDefinition, String part, String anchor, Element element) {
        XSDParticle complexType = xsdComplexTypeDefinition.getComplexType();
        XSDParticle.DFA dfa = complexType.getDFA();
        XSDParticle.DFA.State state = dfa.getInitialState();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                XSDParticle.DFA.Transition transition = state.accept(child.getNamespaceURI(), child.getLocalName());
                if (transition != null) {
                    state = transition.getState();
                } else {
                    XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
                    xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
                    xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, "content-valid.1", new Object[]{XSDConstants.uri(child), xsdComplexTypeDefinition.getURI(), XSDConcreteComponentImpl.getExpected(state)})}));
                    xsdDiagnostic.setAnnotationURI(String.valueOf(part) + "#" + anchor);
                    xsdDiagnostic.setPrimaryComponent(this);
                    xsdDiagnostic.setNode(child);
                    this.getDiagnostics().add(xsdDiagnostic);
                    return xsdDiagnostic;
                }
            }
            child = child.getNextSibling();
        }
        if (!state.isAccepting()) {
            XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
            xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
            xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, "content-valid.2", new Object[]{xsdComplexTypeDefinition.getURI(), XSDConcreteComponentImpl.getExpected(state)})}));
            xsdDiagnostic.setAnnotationURI(String.valueOf(part) + "#" + anchor);
            xsdDiagnostic.setPrimaryComponent(this);
            xsdDiagnostic.setNode(element);
            this.getDiagnostics().add(xsdDiagnostic);
            return xsdDiagnostic;
        }
        return null;
    }

    private static String getExpected(XSDParticle.DFA.State state) {
        StringBuffer result = new StringBuffer();
        Iterator i = state.getTransitions().iterator();
        while (i.hasNext()) {
            XSDParticle.DFA.Transition transition = (XSDParticle.DFA.Transition)i.next();
            XSDParticle xsdParticle = transition.getParticle();
            XSDTerm xsdTerm = xsdParticle.getTerm();
            if (xsdTerm instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                if (result.length() != 0) {
                    result.append(" | ");
                }
                result.append(xsdElementDeclaration.getName());
                continue;
            }
            boolean cfr_ignored_0 = xsdTerm instanceof XSDWildcard;
        }
        if (state.isAccepting()) {
            if (result.length() != 0) {
                result.append(" | ");
            }
            result.append(XSDPlugin.INSTANCE.getString("expecting_nothing"));
        }
        return result.length() == 0 ? XSDPlugin.INSTANCE.getString("expecting_nothing") : result.toString();
    }

    protected XSDDiagnostic checkAttributeTypeConstraint(String builtInTypeName, String builtInAttributeName, String value, String part, String anchor, Element element, String attributeName, boolean isRequired) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = this.getSchema().getSchemaForSchema().resolveComplexTypeDefinition(builtInTypeName);
        return this.checkAttributeTypeConstraint(xsdComplexTypeDefinition, builtInAttributeName, value, part, anchor, element, attributeName, isRequired);
    }

    protected XSDDiagnostic checkAttributeTypeConstraint(XSDComplexTypeDefinition xsdComplexTypeDefinition, String builtInAttributeName, String value, String part, String anchor, Element element, String attributeName, boolean isRequired) {
        Iterator i = xsdComplexTypeDefinition.getAttributeUses().iterator();
        while (i.hasNext()) {
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i.next();
            XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
            if (!builtInAttributeName.equals(xsdAttributeDeclaration.getName())) continue;
            XSDDiagnostic result = this.checkSimpleTypeConstraint(xsdAttributeDeclaration.getTypeDefinition(), value, part, anchor, element, attributeName, isRequired);
            return result;
        }
        return null;
    }

    protected XSDDiagnostic checkBuiltInTypeConstraint(String builtInTypeName, String value, String part, String anchor, Element element, String attributeName, boolean isRequired) {
        XSDSimpleTypeDefinition builtInType = this.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition(builtInTypeName);
        return this.checkSimpleTypeConstraint(builtInType, value, part, anchor, element, attributeName, isRequired);
    }

    protected XSDDiagnostic checkSimpleTypeConstraint(XSDSimpleTypeDefinition xsdTypeDefinition, String value, String part, String anchor, Element element, String attributeName, boolean isRequired) {
        XSDDiagnostic result = null;
        if (element != null && value == null && element.hasAttributeNS(null, attributeName)) {
            value = element.getAttributeNS(null, attributeName);
        }
        if (value == null) {
            if (isRequired) {
                result = this.createRequiredAttributeDiagnostic(part, anchor, element, attributeName);
            }
        } else {
            XSDSimpleTypeDefinition.Assessment assessment = xsdTypeDefinition.assess(value);
            Collection allDiagnostics = assessment.getDiagnostics();
            if (!allDiagnostics.isEmpty()) {
                ((XSDSimpleTypeDefinitionImpl.AssessmentImpl)assessment).assignDiagnostics(this, element, attributeName);
                this.getDiagnostics().addAll(allDiagnostics);
                result = (XSDDiagnostic)allDiagnostics.iterator().next();
                result.setAnnotationURI(String.valueOf(part) + "#" + anchor);
            }
        }
        return result;
    }

    protected Collection checkAttributes(String part, String anchor, Element element, String[] allowedAttributeNames) {
        ArrayList<XSDDiagnostic> result = null;
        if (element != null) {
            NamedNodeMap attributes = element.getAttributes();
            int i = 0;
            int length = attributes.getLength();
            while (i < length) {
                block6: {
                    Attr attr = (Attr)attributes.item(i);
                    if (attr.getNamespaceURI() == null) {
                        String localName = attr.getLocalName();
                        int j = 0;
                        while (j < allowedAttributeNames.length) {
                            if (!allowedAttributeNames[j].equals(localName)) {
                                ++j;
                                continue;
                            }
                            break block6;
                        }
                        XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
                        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
                        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, "cvc-complex-type.3", new Object[]{localName})}));
                        xsdDiagnostic.setAnnotationURI(String.valueOf(part) + "#" + anchor);
                        xsdDiagnostic.setPrimaryComponent(this);
                        xsdDiagnostic.setNode(attr);
                        this.getDiagnostics().add(xsdDiagnostic);
                        if (result == null) {
                            result = new ArrayList<XSDDiagnostic>();
                        }
                        result.add(xsdDiagnostic);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    protected XSDDiagnostic createRequiredAttributeDiagnostic(String part, String anchor, Element element, String attributeName) {
        XSDDiagnostic result = this.getXSDFactory().createXSDDiagnostic();
        result.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        result.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(result, "cvc-complex-type.4", new Object[]{attributeName})}));
        result.setAnnotationURI(String.valueOf(part) + "#" + anchor);
        result.setPrimaryComponent(this);
        result.setNode(element);
        this.getDiagnostics().add(result);
        return result;
    }

    protected XSDConcreteComponentImpl getDiagnosticTarget(XSDConcreteComponent xsdConcreteComponent) {
        return EcoreUtil.isAncestor(this, (EObject)xsdConcreteComponent) && !xsdConcreteComponent.eContainmentFeature().isTransient() ? (XSDConcreteComponentImpl)xsdConcreteComponent : this;
    }

    protected XSDDiagnostic createDiagnostic(XSDDiagnosticSeverity severity, String key) {
        XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
        xsdDiagnostic.setSeverity(severity);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, key, null)}));
        xsdDiagnostic.setPrimaryComponent(this);
        xsdDiagnostic.setNode(this.getElement());
        Element theElement = this.getElement();
        xsdDiagnostic.setNode(theElement);
        this.getDiagnostics().add(xsdDiagnostic);
        return xsdDiagnostic;
    }

    protected XSDDiagnostic createDiagnostic(XSDDiagnosticSeverity severity, String key, Object s1) {
        XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
        xsdDiagnostic.setSeverity(severity);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, key, new Object[]{s1})}));
        xsdDiagnostic.setPrimaryComponent(this);
        xsdDiagnostic.setNode(this.getElement());
        Element theElement = this.getElement();
        xsdDiagnostic.setNode(theElement);
        this.getDiagnostics().add(xsdDiagnostic);
        return xsdDiagnostic;
    }

    protected XSDDiagnostic createDiagnostic(XSDDiagnosticSeverity severity, String key, Object s1, Object s2) {
        XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
        xsdDiagnostic.setSeverity(severity);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, key, new Object[]{s1, s2})}));
        xsdDiagnostic.setPrimaryComponent(this);
        xsdDiagnostic.setNode(this.getElement());
        Element theElement = this.getElement();
        xsdDiagnostic.setNode(theElement);
        this.getDiagnostics().add(xsdDiagnostic);
        return xsdDiagnostic;
    }

    protected XSDDiagnostic createDiagnostic(XSDDiagnosticSeverity severity, String key, Object s1, Object s2, Object s3) {
        XSDDiagnostic xsdDiagnostic = this.getXSDFactory().createXSDDiagnostic();
        xsdDiagnostic.setSeverity(severity);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDConcreteComponentImpl.populateDiagnostic(xsdDiagnostic, key, new Object[]{s1, s2, s3})}));
        xsdDiagnostic.setPrimaryComponent(this);
        xsdDiagnostic.setNode(this.getElement());
        Element theElement = this.getElement();
        xsdDiagnostic.setNode(theElement);
        this.getDiagnostics().add(xsdDiagnostic);
        return xsdDiagnostic;
    }

    protected static String populateDiagnostic(XSDDiagnostic xsdDiagnostic, String key, Object[] substitutions) {
        xsdDiagnostic.setKey(key);
        if (substitutions != null) {
            EList values = xsdDiagnostic.getSubstitutions();
            int i = 0;
            while (i < substitutions.length) {
                Object value = substitutions[i];
                values.add(value == null ? null : value.toString());
                ++i;
            }
            return XSDPlugin.INSTANCE.getString(key, substitutions);
        }
        return XSDPlugin.INSTANCE.getString(key);
    }

    protected void reconcile(Element changedElement) {
        this.reconcileAttributes(changedElement);
        this.reconcileContents(changedElement);
    }

    protected void reconcileAttributes(Element changedElement) {
    }

    protected Collection getContentNodes(Element changedElement) {
        ArrayList<Node> result = new ArrayList<Node>();
        Node child = this.getElement().getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                result.add(child);
            }
            child = child.getNextSibling();
        }
        return result;
    }

    protected void reconcileContents(Element changedElement) {
        XSDSchemaImpl xsdSchema = (XSDSchemaImpl)this.getSchema();
        ArrayList<XSDConcreteComponent> newContents = new ArrayList<XSDConcreteComponent>();
        ArrayList remainingContents = new ArrayList(this.getXSDContents());
        Collection contentNodes = this.getContentNodes(changedElement);
        Iterator i = contentNodes.iterator();
        block0: while (i.hasNext()) {
            XSDConcreteComponent potentialReplacement;
            Element potentialReplacedElement;
            Node child = (Node)i.next();
            if (child.getNodeType() != 1 || xsdSchema != null && child == xsdSchema.getDeletionNode()) continue;
            Iterator contents = remainingContents.iterator();
            while (contents.hasNext()) {
                XSDConcreteComponent remainingConcreteComponent = (XSDConcreteComponent)contents.next();
                if (remainingConcreteComponent.getElement() != child) continue;
                newContents.add(remainingConcreteComponent);
                contents.remove();
                continue block0;
            }
            if (!remainingContents.isEmpty() && (potentialReplacedElement = (potentialReplacement = (XSDConcreteComponent)remainingContents.get(0)).getElement()) != null && potentialReplacedElement.getParentNode() != changedElement && potentialReplacedElement.getLocalName().equals(child.getLocalName())) {
                remainingContents.remove(0);
                potentialReplacement.setElement((Element)child);
                newContents.add(potentialReplacement);
                continue;
            }
            this.handleUnreconciledElement((Element)child, newContents, remainingContents);
        }
        this.handleReconciliation(newContents, remainingContents);
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
    }

    protected void handleAnnotationReconciliation(EReference eReference, List newContents, List remainingContents) {
        XSDConcreteComponent xsdConcreteComponent;
        XSDAnnotation newAnnotation = null;
        XSDAnnotation oldAnnotation = (XSDAnnotation)this.eGet(eReference);
        if (!newContents.isEmpty() && (xsdConcreteComponent = (XSDConcreteComponent)newContents.get(0)) instanceof XSDAnnotation) {
            newAnnotation = (XSDAnnotation)xsdConcreteComponent;
            newContents.remove(0);
        }
        if (newAnnotation != oldAnnotation) {
            this.eSet(eReference, newAnnotation);
        }
        if (oldAnnotation != null) {
            remainingContents.remove(oldAnnotation);
        }
    }

    public void eNotify(Notification msg) {
        block39: {
            Object feature;
            int eventType;
            block37: {
                EReference eReference;
                block40: {
                    Object newValue;
                    Object oldValue;
                    block38: {
                        eventType = msg.getEventType();
                        feature = msg.getFeature();
                        oldValue = msg.getOldValue();
                        newValue = msg.getNewValue();
                        if (!this.eClass().getEAllReferences().contains(feature)) break block37;
                        eReference = (EReference)feature;
                        if (feature != XSDPackage.Literals.XSD_CONCRETE_COMPONENT__DIAGNOSTICS) break block38;
                        switch (eventType) {
                            case 3: {
                                this.adoptDiagnostic((XSDDiagnostic)newValue);
                                break;
                            }
                            case 5: {
                                Iterator newValues = ((Collection)newValue).iterator();
                                while (newValues.hasNext()) {
                                    XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)newValues.next();
                                    this.adoptDiagnostic(xsdDiagnostic);
                                }
                                break block39;
                            }
                            case 4: {
                                if (oldValue != null) {
                                    this.orphanDiagnostic((XSDDiagnostic)oldValue);
                                    break;
                                }
                                break block39;
                            }
                            case 6: {
                                Iterator oldValues = ((Collection)oldValue).iterator();
                                while (oldValues.hasNext()) {
                                    XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)oldValues.next();
                                    this.orphanDiagnostic(xsdDiagnostic);
                                }
                                break block39;
                            }
                            case 7: {
                                break;
                            }
                            case 1: 
                            case 2: {
                                if (oldValue != null) {
                                    this.orphanDiagnostic((XSDDiagnostic)oldValue);
                                }
                                if (newValue == null) break block39;
                                this.adoptDiagnostic((XSDDiagnostic)newValue);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block39;
                    }
                    if (!eReference.isContainment() || eReference.isTransient()) break block40;
                    switch (eventType) {
                        case 3: {
                            this.adoptContent(eReference, (XSDConcreteComponent)newValue);
                            break;
                        }
                        case 5: {
                            Iterator newValues = ((Collection)newValue).iterator();
                            while (newValues.hasNext()) {
                                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)newValues.next();
                                this.adoptContent(eReference, xsdConcreteComponent);
                            }
                            break block39;
                        }
                        case 4: {
                            if (oldValue != null) {
                                this.orphanContent(eReference, (XSDConcreteComponent)oldValue);
                                break;
                            }
                            break block39;
                        }
                        case 6: {
                            Iterator oldValues = ((Collection)oldValue).iterator();
                            while (oldValues.hasNext()) {
                                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)oldValues.next();
                                this.orphanContent(eReference, xsdConcreteComponent);
                            }
                            break block39;
                        }
                        case 7: {
                            this.moveContent(eReference, (XSDConcreteComponent)newValue);
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (oldValue != null) {
                                this.orphanContent(eReference, (XSDConcreteComponent)oldValue);
                            }
                            if (newValue == null) break block39;
                            this.adoptContent(eReference, (XSDConcreteComponent)newValue);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block39;
                }
                switch (eventType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.changeReference(eReference);
                    }
                }
                break block39;
            }
            if (this.eClass().getEAllAttributes().contains(feature)) {
                EAttribute eAttribute = (EAttribute)feature;
                switch (eventType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.changeAttribute(eAttribute);
                    }
                }
            }
        }
        super.eNotify(msg);
    }

    protected void changeAttribute(EAttribute eAttribute) {
        Element theElement;
        if (eAttribute == XSDPackage.Literals.XSD_CONCRETE_COMPONENT__ELEMENT && (theElement = this.getElement()) != null && !this.isReconciling) {
            Node rootDocument = theElement.getParentNode();
            while (rootDocument != null) {
                if (rootDocument.getNodeType() == 9) {
                    this.isReconciling = true;
                    if (this.getSchema() == null) {
                        this.reconcileAttributes(this.getElement());
                        this.isReconciling = false;
                        break;
                    }
                    this.reconcile(this.getElement());
                    this.isReconciling = false;
                    this.traverseToRootForPatching();
                    break;
                }
                rootDocument = rootDocument.getParentNode();
            }
        }
    }

    protected void changeReference(EReference eReference) {
    }

    protected Node getAdoptionParentNode(EReference eReference) {
        return this.getElement();
    }

    protected void handleElementForAdopt(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        Node adoptionParent = this.getAdoptionParentNode(eReference);
        Element childElement = xsdConcreteComponent.getElement();
        Element referencedElement = null;
        Iterator contents = this.getXSDContents().iterator();
        block0: while (contents.hasNext()) {
            if (contents.next() != xsdConcreteComponent) continue;
            if (!contents.hasNext()) break;
            referencedElement = ((XSDConcreteComponent)contents.next()).getElement();
            while (referencedElement != null) {
                Node parent = referencedElement.getParentNode();
                if (parent == null) {
                    referencedElement = null;
                    break block0;
                }
                if (parent == adoptionParent || parent.getNodeType() != 1) break block0;
                referencedElement = (Element)parent;
            }
            break block0;
        }
        if (childElement == null) {
            ((XSDConcreteComponentImpl)xsdConcreteComponent).isReconciling = true;
            childElement = ((XSDConcreteComponentImpl)xsdConcreteComponent).createElement();
            ((XSDConcreteComponentImpl)xsdConcreteComponent).isReconciling = false;
            if (childElement == null) {
                System.out.println("not created! " + xsdConcreteComponent);
            }
        }
        boolean isAttached = false;
        Node rootDocument = childElement;
        while (rootDocument != null) {
            if (XSDConstants.nodeType(rootDocument) == 33) {
                isAttached = true;
                break;
            }
            rootDocument = rootDocument.getParentNode();
        }
        if (!isAttached) {
            if (referencedElement == null && XSDConstants.nodeType(childElement) == 1 && !eReference.isMany()) {
                Node child = adoptionParent.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        referencedElement = (Element)child;
                        break;
                    }
                    child = child.getNextSibling();
                }
            }
            this.niceInsertBefore(adoptionParent, childElement, referencedElement);
        }
    }

    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        XSDSchema xsdSchema;
        if (this.isReconciling) {
            if (xsdConcreteComponent.getElement() != null) {
                xsdConcreteComponent.elementChanged(xsdConcreteComponent.getElement());
            }
        } else {
            Element childElement = xsdConcreteComponent.getElement();
            if (this.getElement() != null && (childElement == null || childElement.getParentNode() == null)) {
                if (childElement != null && childElement.getOwnerDocument() != this.getElement().getOwnerDocument()) {
                    xsdConcreteComponent.setElement(null);
                    childElement = null;
                }
                this.handleElementForAdopt(eReference, xsdConcreteComponent);
                xsdConcreteComponent.updateElement();
            }
        }
        if ((xsdSchema = this.getSchema()) != null) {
            ((XSDConcreteComponentImpl)xsdConcreteComponent).adoptBy(xsdSchema);
        }
    }

    protected void adoptBy(XSDSchema xsdSchema) {
        EList theDiagnostics = this.getDiagnostics();
        if (!theDiagnostics.isEmpty()) {
            xsdSchema.getDiagnostics().addAll(theDiagnostics);
        }
        Iterator components = this.getXSDContents().iterator();
        while (components.hasNext()) {
            XSDConcreteComponentImpl childXSDConcreteComponent = (XSDConcreteComponentImpl)components.next();
            childXSDConcreteComponent.adoptBy(xsdSchema);
        }
    }

    protected void adoptDiagnostic(XSDDiagnostic xsdDiagnostic) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            xsdSchema.getAllDiagnostics().add(xsdDiagnostic);
        }
    }

    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        XSDSchema xsdSchema;
        Element contentElement;
        Element parent;
        if (!this.isReconciling && (parent = this.getElement()) != null && (contentElement = xsdConcreteComponent.getElement()) != null) {
            this.niceRemoveChild(contentElement.getParentNode(), contentElement);
        }
        if ((xsdSchema = this.getSchema()) != null) {
            ((XSDConcreteComponentImpl)xsdConcreteComponent).orphanBy(xsdSchema);
        }
    }

    protected void orphanBy(XSDSchema xsdSchema) {
        EList theDiagnostics = this.getDiagnostics();
        if (!theDiagnostics.isEmpty()) {
            xsdSchema.getDiagnostics().removeAll(theDiagnostics);
        }
        Iterator components = this.getXSDContents().iterator();
        while (components.hasNext()) {
            XSDConcreteComponentImpl childXSDConcreteComponent = (XSDConcreteComponentImpl)components.next();
            childXSDConcreteComponent.orphanBy(xsdSchema);
        }
    }

    protected void orphanDiagnostic(XSDDiagnostic xsdDiagnostic) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            xsdSchema.getAllDiagnostics().remove(xsdDiagnostic);
        }
    }

    public void moveContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        Element child;
        if (this.isReconciling) {
            return;
        }
        Node parent = this.getAdoptionParentNode(eReference);
        if (parent != null && (child = xsdConcreteComponent.getElement()) != null) {
            EList contents = this.getXSDContents();
            int index = contents.indexOf(xsdConcreteComponent);
            this.niceRemoveChild(parent, child);
            this.niceInsertBefore(parent, child, ++index == contents.size() ? null : ((XSDConcreteComponent)contents.get(index)).getElement());
        }
    }

    public void niceInsertBefore(Node parent, Node newChild, Node referenceChild) {
        if (this.isReconciling) {
            return;
        }
        this.forceNiceInsertBefore(parent, newChild, referenceChild);
    }

    /*
     * Unable to fully structure code
     */
    public void forceNiceInsertBefore(Node parent, Node newChild, Node referenceChild) {
        this.updatingDOM = true;
        child = referenceChild == null ? parent.getLastChild() : referenceChild.getPreviousSibling();
        block4: while (child != null) {
            switch (child.getNodeType()) {
                case 3: {
                    text = (Text)child;
                    data = text.getData();
                    index = data.lastIndexOf(10);
                    if (index != -1) {
                        indent = new StringBuffer();
                        ancestor = parent.getParentNode();
                        while (ancestor != null && ancestor.getNodeType() != 9) {
                            indent.append("    ");
                            ancestor = ancestor.getParentNode();
                        }
                        if (index + 1 < data.length() && data.charAt(index + 1) == '\r') {
                            ++index;
                        }
                        if (index + 1 == data.length()) {
                            text.appendData(indent + "    ");
                        } else {
                            text.replaceData(index + 1, data.length() - index - 1, indent + "    ");
                        }
                        if (referenceChild != null) {
                            indent.append("    ");
                        }
                        newText = parent.getOwnerDocument().createTextNode("\n" + indent);
                        parent.insertBefore(newText, referenceChild);
                        referenceChild = newText;
                        break block4;
                    }
                    ** GOTO lbl34
                }
                case 1: {
                    break block4;
                }
lbl34:
                // 2 sources

                default: {
                    child = child.getPreviousSibling();
                }
            }
        }
        parent.insertBefore(newChild, referenceChild);
        this.updatingDOM = false;
    }

    public void niceRemoveChild(Node parent, Node child) {
        if (this.isReconciling) {
            return;
        }
        this.forceNiceRemoveChild(parent, child);
    }

    public void forceNiceRemoveChild(Node parent, Node child) {
        Text text;
        String data;
        int index;
        this.updatingDOM = true;
        boolean done = false;
        Node previous = child.getPreviousSibling();
        if (previous != null && previous.getNodeType() == 3 && (index = (data = (text = (Text)previous).getData()).lastIndexOf(10)) != -1) {
            if (index - 1 > 0 && data.charAt(index - 1) == '\r') {
                text.deleteData(index - 1, data.length() - index + 1);
            } else {
                text.deleteData(index, data.length() - index);
            }
            done = true;
        }
        if (!done) {
            Node next = child.getNextSibling();
            while (next != null) {
                if (next.getNodeType() == 3) {
                    Text text2 = (Text)next;
                    String data2 = text2.getData();
                    int index2 = data2.indexOf(10);
                    if (index2 != -1) {
                        if (index2 + 1 < data2.length() && data2.charAt(index2 + 1) == '\r') {
                            text2.deleteData(0, index2 + 2);
                            break;
                        }
                        text2.deleteData(0, index2 + 1);
                        break;
                    }
                } else if (next.getNodeType() == 1) break;
                next = next.getNextSibling();
            }
        }
        parent.removeChild(child);
        this.updatingDOM = false;
    }

    public void forceReplace(Element replacementElement, Element referenceElement) {
        XSDConcreteComponentImpl containerOfContainer;
        this.isReconciling = true;
        this.updatingDOM = true;
        XSDConcreteComponentImpl container2 = (XSDConcreteComponentImpl)this.getContainer();
        container2.isReconciling = true;
        container2.updatingDOM = true;
        Node parent = referenceElement.getParentNode();
        XSDConcreteComponentImpl xSDConcreteComponentImpl = containerOfContainer = parent != container2.getElement() ? (XSDConcreteComponentImpl)container2.getContainer() : null;
        if (containerOfContainer != null) {
            containerOfContainer.isReconciling = true;
            containerOfContainer.updatingDOM = true;
        }
        Node child = referenceElement.getFirstChild();
        while (child != null) {
            Node node = child;
            child = child.getNextSibling();
            referenceElement.removeChild(node);
            replacementElement.appendChild(node);
        }
        NamedNodeMap attributes = referenceElement.getAttributes();
        int i = 0;
        int length = attributes.getLength();
        while (i < length) {
            replacementElement.setAttributeNode((Attr)attributes.item(i).cloneNode(true));
            ++i;
        }
        this.forceNiceInsertBefore(parent, replacementElement, referenceElement);
        this.forceNiceRemoveChild(parent, referenceElement);
        this.updatingDOM = false;
        this.isReconciling = false;
        container2.updatingDOM = false;
        container2.isReconciling = false;
        if (containerOfContainer != null) {
            containerOfContainer.updatingDOM = false;
            containerOfContainer.isReconciling = false;
        }
    }

    public void forceEngulf(Element newElement, Element engulfingElement, Element referenceElement, Node referenceChild) {
        this.isReconciling = true;
        this.updatingDOM = true;
        this.forceNiceInsertBefore(referenceElement, newElement, referenceChild);
        Node child = referenceChild;
        while (child != null) {
            Node node = child;
            child = child.getNextSibling();
            this.forceNiceRemoveChild(referenceElement, node);
            this.forceNiceInsertBefore(engulfingElement, node, null);
        }
        this.updatingDOM = false;
        this.isReconciling = false;
    }

    public void forceEngulf(Node firstAdoptee, Element engulfingElement, Node referenceChild) {
        this.isReconciling = true;
        this.updatingDOM = true;
        Node parent = firstAdoptee.getParentNode();
        Node child = firstAdoptee;
        while (child != null) {
            Node node = child;
            child = child.getNextSibling();
            this.forceNiceRemoveChild(parent, node);
            this.forceNiceInsertBefore(engulfingElement, node, referenceChild);
        }
        this.updatingDOM = false;
        this.isReconciling = false;
    }

    protected void niceSetAttribute(Element element, String attribute, String value) {
        if (this.isReconciling) {
            return;
        }
        if (value == null) {
            if (element.hasAttributeNS(null, attribute)) {
                this.updatingDOM = true;
                element.removeAttribute(attribute);
                this.updatingDOM = false;
            }
        } else if (!element.hasAttributeNS(null, attribute) || !element.getAttributeNS(null, attribute).equals(value)) {
            this.updatingDOM = true;
            element.setAttributeNS(null, attribute, value);
            this.updatingDOM = false;
        }
    }

    protected String niceCreateNamespaceAttribute(String namespace) {
        XSDSchema xsdSchema = this.getSchema();
        if (namespace == null) {
            namespace = "";
        }
        if (xsdSchema != null && xsdSchema.getElement() != null) {
            Element schemaElement = xsdSchema.getElement();
            if (XSDConstants.isSchemaForSchemaNamespace(namespace) && !schemaElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", "xsd")) {
                schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", namespace);
                return "xsd";
            }
            String qualifier = "Q";
            int count = 1;
            while (schemaElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", String.valueOf(qualifier) + count)) {
                ++count;
            }
            schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + qualifier + count, namespace);
            return String.valueOf(qualifier) + count;
        }
        return null;
    }

    protected void niceSetAttributeURIValue(Element element, String attribute, String uriList) {
        if (this.isReconciling) {
            return;
        }
        if (uriList == null) {
            this.updatingDOM = true;
            element.removeAttribute(attribute);
            this.updatingDOM = false;
        } else {
            StringBuffer value = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(uriList, " ");
            while (stringTokenizer.hasMoreElements()) {
                String qName;
                String qualifier;
                String uri = stringTokenizer.nextToken();
                String namespace = null;
                String localName = uri;
                int index = uri.lastIndexOf("#");
                if (index != -1) {
                    if (index > 0) {
                        namespace = uri.substring(0, index);
                    }
                    localName = uri.substring(index + 1);
                }
                if ((qualifier = XSDConstants.lookupQualifier(element, namespace)) == null) {
                    qualifier = this.niceCreateNamespaceAttribute(namespace);
                }
                String string = qName = qualifier == null || qualifier.length() == 0 ? localName : String.valueOf(qualifier) + ":" + localName;
                if (value.length() != 0) {
                    value.append(' ');
                }
                value.append(qName);
            }
            if (!element.hasAttributeNS(null, attribute) || !element.getAttributeNS(null, attribute).equals(value.toString())) {
                this.updatingDOM = true;
                element.setAttributeNS(null, attribute, value.toString());
                this.updatingDOM = false;
            }
        }
    }

    public XSDConcreteComponent getContainer() {
        return this.eContainer instanceof XSDConcreteComponent ? (XSDConcreteComponent)((Object)this.eContainer) : null;
    }

    public XSDConcreteComponent getRootContainer() {
        XSDConcreteComponent root = this;
        XSDConcreteComponent parent;
        while ((parent = root.getContainer()) != null) {
            root = parent;
        }
        return root;
    }

    public boolean contains(XSDConcreteComponent xsdConcreteComponent) {
        while (xsdConcreteComponent != null) {
            if (xsdConcreteComponent == this) {
                return true;
            }
            xsdConcreteComponent = xsdConcreteComponent.getContainer();
        }
        return false;
    }

    public XSDSchema getSchema() {
        XSDConcreteComponent container2 = this;
        while (container2 != null) {
            if (container2 instanceof XSDSchema) {
                return (XSDSchema)container2;
            }
            container2 = container2.getContainer();
        }
        return null;
    }

    public EList getDiagnostics() {
        if (this.diagnostics == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.xsd.XSDDiagnostic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.diagnostics = new EObjectContainmentEList(clazz, this, 4);
        }
        return this.diagnostics;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (element: ");
        result.append(this.element);
        result.append(')');
        return result.toString();
    }

    public XSDConcreteComponent getBestConcreteComponent(List elementPath) {
        XSDConcreteComponent result = this;
        Iterator components = this.getXSDContents().iterator();
        while (components.hasNext()) {
            XSDConcreteComponentImpl childXSDConcreteComponent = (XSDConcreteComponentImpl)components.next();
            if (!elementPath.contains(childXSDConcreteComponent.getElement())) continue;
            result = childXSDConcreteComponent;
            XSDConcreteComponent betterXSDConcreteComponent = childXSDConcreteComponent.getBestConcreteComponent(elementPath);
            if (betterXSDConcreteComponent != null) {
                result = betterXSDConcreteComponent;
            }
            if (!this.considerAllContainsForBestConcreteComponent()) break;
        }
        return result;
    }

    protected boolean considerAllContainsForBestConcreteComponent() {
        return false;
    }

    public static void setListContentAndOrder(EList targetList, List prototypeList) {
        int index = 0;
        int size = prototypeList.size();
        while (index < size) {
            Object prototypeObject = prototypeList.get(index);
            if (targetList.size() <= index) {
                targetList.add(prototypeObject);
            } else {
                Object targetObject = targetList.get(index);
                if (targetObject == null ? prototypeObject != null : !targetObject.equals(prototypeObject)) {
                    if (targetList.contains(prototypeObject)) {
                        targetList.move(index, prototypeObject);
                    } else {
                        targetList.add(index, prototypeObject);
                    }
                }
            }
            ++index;
        }
    }

    protected String getURIReferenceLabel() {
        return null;
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        StringBuffer result = new StringBuffer();
        XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)eObject;
        String sort = xsdConcreteComponent.eClass().getName();
        int sortCount = 0;
        int labelCount = 0;
        String uriReferenceLabel = ((XSDConcreteComponentImpl)xsdConcreteComponent).getURIReferenceLabel();
        Iterator contents = this.eContents().iterator();
        while (contents.hasNext()) {
            XSDConcreteComponentImpl sibling = (XSDConcreteComponentImpl)contents.next();
            if (sibling == eObject) break;
            if (!sibling.eClass().getName().equals(sort)) continue;
            ++sortCount;
            if (uriReferenceLabel == null || !uriReferenceLabel.equals(sibling.getURIReferenceLabel())) continue;
            ++labelCount;
        }
        if (uriReferenceLabel != null) {
            result.append(uriReferenceLabel);
            if (labelCount != 0) {
                result.append("=");
                result.append(labelCount);
            }
            result.append(";");
        }
        result.append(sort);
        if (sortCount != 0) {
            result.append("=");
            result.append(sortCount);
        }
        return result.toString();
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        EObject result = null;
        if (uriFragmentSegment.startsWith("@")) {
            result = super.eObjectForURIFragmentSegment(uriFragmentSegment);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(uriFragmentSegment, ";=,", true);
            String uriReferenceLabel = null;
            String sort = stringTokenizer.nextToken();
            if (Character.isDigit(sort.charAt(0))) {
                int diagnosticIndex = 0;
                try {
                    diagnosticIndex = Integer.parseInt(sort);
                }
                catch (NumberFormatException numberFormatException) {}
                EList theDiagnostics = ((XSDConcreteComponent)result).getDiagnostics();
                if (theDiagnostics.size() > diagnosticIndex) {
                    result = (XSDDiagnostic)theDiagnostics.get(diagnosticIndex);
                }
            } else {
                String sortCountString;
                String prefix;
                EReference eReference = null;
                int labelCount = 0;
                int sortCount = 0;
                String string = prefix = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                if (prefix.equals(",")) {
                    String relationName = sort;
                    eReference = (EReference)result.eClass().getEStructuralFeature(relationName);
                    sort = stringTokenizer.nextToken();
                    prefix = stringTokenizer.nextToken();
                }
                if (prefix.equals("=")) {
                    sortCountString = stringTokenizer.nextToken();
                    try {
                        sortCount = Integer.parseInt(sortCountString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    String string2 = prefix = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                }
                if (prefix.equals(";")) {
                    uriReferenceLabel = sort;
                    labelCount = sortCount;
                    sort = stringTokenizer.nextToken();
                    sortCount = 0;
                    if (stringTokenizer.hasMoreTokens() && (prefix = stringTokenizer.nextToken()).equals("=")) {
                        sortCountString = stringTokenizer.nextToken();
                        try {
                            sortCount = Integer.parseInt(sortCountString);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                EList collection = eReference == null ? this.eContents() : (eReference.isMany() ? (Collection)this.eGet(eReference) : Collections.singleton(this.eGet(eReference)));
                XSDConcreteComponentImpl candidate = null;
                Iterator contents = collection.iterator();
                while (contents.hasNext()) {
                    XSDConcreteComponentImpl child = (XSDConcreteComponentImpl)contents.next();
                    if (sortCount >= 0 && child.eClass().getName().equals(sort)) {
                        candidate = child;
                        if (--sortCount == -1 && uriReferenceLabel == null) break;
                    }
                    if (uriReferenceLabel == null || !uriReferenceLabel.equals(child.getURIReferenceLabel()) || !child.eClass().getName().equals(sort) || labelCount-- != 0) continue;
                    candidate = child;
                    break;
                }
                result = candidate;
            }
        }
        return result;
    }

    public XSDTypeDefinition resolveTypeDefinitionURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveTypeDefinition(null, uri);
        }
        return this.resolveTypeDefinition(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDTypeDefinition resolveTypeDefinition(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveTypeDefinition(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedTypeDefinition(null, localName);
    }

    public XSDTypeDefinition resolveTypeDefinition(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveTypeDefinition(namespace, localName);
        }
        return this.createUnresolvedTypeDefinition(namespace, localName);
    }

    protected XSDTypeDefinition createUnresolvedTypeDefinition(String namespace, String localName) {
        return this.createUnresolvedSimpleTypeDefinition(namespace, localName);
    }

    public XSDSimpleTypeDefinition resolveSimpleTypeDefinitionURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveSimpleTypeDefinition(null, uri);
        }
        return this.resolveSimpleTypeDefinition(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDSimpleTypeDefinition resolveSimpleTypeDefinition(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveSimpleTypeDefinition(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedSimpleTypeDefinition(null, localName);
    }

    public XSDSimpleTypeDefinition resolveSimpleTypeDefinition(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveSimpleTypeDefinition(namespace, localName);
        }
        return this.createUnresolvedSimpleTypeDefinition(namespace, localName);
    }

    protected XSDSimpleTypeDefinition createUnresolvedSimpleTypeDefinition(String namespace, String localName) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        if (localName != null) {
            xsdSimpleTypeDefinition.setName(localName);
        }
        if (namespace != null) {
            xsdSimpleTypeDefinition.setTargetNamespace(namespace);
        }
        xsdSimpleTypeDefinition.setVariety(XSDVariety.ATOMIC_LITERAL);
        return xsdSimpleTypeDefinition;
    }

    public XSDComplexTypeDefinition resolveComplexTypeDefinitionURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveComplexTypeDefinition(null, uri);
        }
        return this.resolveComplexTypeDefinition(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDComplexTypeDefinition resolveComplexTypeDefinition(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveComplexTypeDefinition(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedComplexTypeDefinition(null, localName);
    }

    public XSDComplexTypeDefinition resolveComplexTypeDefinition(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveComplexTypeDefinition(namespace, localName);
        }
        return this.createUnresolvedComplexTypeDefinition(namespace, localName);
    }

    protected XSDComplexTypeDefinition createUnresolvedComplexTypeDefinition(String namespace, String localName) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        if (localName != null) {
            xsdComplexTypeDefinition.setName(localName);
        }
        if (namespace != null) {
            xsdComplexTypeDefinition.setTargetNamespace(namespace);
        }
        return xsdComplexTypeDefinition;
    }

    public XSDAttributeDeclaration resolveAttributeDeclarationURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveAttributeDeclaration(null, uri);
        }
        return this.resolveAttributeDeclaration(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDAttributeDeclaration resolveAttributeDeclaration(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveAttributeDeclaration(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedAttributeDeclaration(null, localName);
    }

    public XSDAttributeDeclaration resolveAttributeDeclaration(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveAttributeDeclaration(namespace, localName);
        }
        return this.createUnresolvedAttributeDeclaration(namespace, localName);
    }

    protected XSDAttributeDeclaration createUnresolvedAttributeDeclaration(String namespace, String localName) {
        XSDAttributeDeclaration xsdAttributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        if (localName != null) {
            xsdAttributeDeclaration.setName(localName);
        }
        if (namespace != null) {
            xsdAttributeDeclaration.setTargetNamespace(namespace);
        }
        xsdAttributeDeclaration.setResolvedAttributeDeclaration(xsdAttributeDeclaration);
        return xsdAttributeDeclaration;
    }

    public XSDElementDeclaration resolveElementDeclarationURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveElementDeclaration(null, uri);
        }
        return this.resolveElementDeclaration(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDElementDeclaration resolveElementDeclaration(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveElementDeclaration(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedElementDeclaration(null, localName);
    }

    public XSDElementDeclaration resolveElementDeclaration(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveElementDeclaration(namespace, localName);
        }
        return this.createUnresolvedElementDeclaration(namespace, localName);
    }

    protected XSDElementDeclaration createUnresolvedElementDeclaration(String namespace, String localName) {
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        if (localName != null) {
            xsdElementDeclaration.setName(localName);
        }
        if (namespace != null) {
            xsdElementDeclaration.setTargetNamespace(namespace);
        }
        xsdElementDeclaration.setResolvedElementDeclaration(xsdElementDeclaration);
        return xsdElementDeclaration;
    }

    public XSDAttributeGroupDefinition resolveAttributeGroupDefinitionURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveAttributeGroupDefinition(null, uri);
        }
        return this.resolveAttributeGroupDefinition(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDAttributeGroupDefinition resolveAttributeGroupDefinition(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveAttributeGroupDefinition(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedAttributeGroupDefinition(null, localName);
    }

    public XSDAttributeGroupDefinition resolveAttributeGroupDefinition(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveAttributeGroupDefinition(namespace, localName);
        }
        return this.createUnresolvedAttributeGroupDefinition(namespace, localName);
    }

    protected XSDAttributeGroupDefinition createUnresolvedAttributeGroupDefinition(String namespace, String localName) {
        XSDAttributeGroupDefinition xsdAttributeGroupDefinition = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
        if (localName != null) {
            xsdAttributeGroupDefinition.setName(localName);
        }
        if (namespace != null) {
            xsdAttributeGroupDefinition.setTargetNamespace(namespace);
        }
        xsdAttributeGroupDefinition.setResolvedAttributeGroupDefinition(xsdAttributeGroupDefinition);
        return xsdAttributeGroupDefinition;
    }

    public XSDModelGroupDefinition resolveModelGroupDefinitionURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveModelGroupDefinition(null, uri);
        }
        return this.resolveModelGroupDefinition(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDModelGroupDefinition resolveModelGroupDefinition(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveModelGroupDefinition(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedModelGroupDefinition(null, localName);
    }

    public XSDModelGroupDefinition resolveModelGroupDefinition(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveModelGroupDefinition(namespace, localName);
        }
        return this.createUnresolvedModelGroupDefinition(namespace, localName);
    }

    protected XSDModelGroupDefinition createUnresolvedModelGroupDefinition(String namespace, String localName) {
        XSDModelGroupDefinition xsdModelGroupDefinition = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
        if (localName != null) {
            xsdModelGroupDefinition.setName(localName);
        }
        if (namespace != null) {
            xsdModelGroupDefinition.setTargetNamespace(namespace);
        }
        xsdModelGroupDefinition.setResolvedModelGroupDefinition(xsdModelGroupDefinition);
        XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        xsdModelGroupDefinition.setModelGroup(xsdModelGroup);
        return xsdModelGroupDefinition;
    }

    public XSDIdentityConstraintDefinition resolveIdentityConstraintDefinitionURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveIdentityConstraintDefinition(null, uri);
        }
        return this.resolveIdentityConstraintDefinition(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDIdentityConstraintDefinition resolveIdentityConstraintDefinition(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveIdentityConstraintDefinition(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedIdentityConstraintDefinition(null, localName);
    }

    public XSDIdentityConstraintDefinition resolveIdentityConstraintDefinition(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveIdentityConstraintDefinition(namespace, localName);
        }
        return this.createUnresolvedIdentityConstraintDefinition(namespace, localName);
    }

    protected XSDIdentityConstraintDefinition createUnresolvedIdentityConstraintDefinition(String namespace, String localName) {
        XSDIdentityConstraintDefinition xsdIdentityConstraintDefinition = XSDFactory.eINSTANCE.createXSDIdentityConstraintDefinition();
        xsdIdentityConstraintDefinition.setIdentityConstraintCategory(XSDIdentityConstraintCategory.KEY_LITERAL);
        if (localName != null) {
            xsdIdentityConstraintDefinition.setName(localName);
        }
        if (namespace != null) {
            xsdIdentityConstraintDefinition.setTargetNamespace(namespace);
        }
        return xsdIdentityConstraintDefinition;
    }

    public XSDNotationDeclaration resolveNotationDeclarationURI(String uri) {
        int index = uri.lastIndexOf("#");
        if (index == -1) {
            return this.resolveNotationDeclaration(null, uri);
        }
        return this.resolveNotationDeclaration(uri.substring(0, index), uri.substring(index + 1));
    }

    public XSDNotationDeclaration resolveNotationDeclaration(String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveNotationDeclaration(xsdSchema.getTargetNamespace(), localName);
        }
        return this.createUnresolvedNotationDeclaration(null, localName);
    }

    public XSDNotationDeclaration resolveNotationDeclaration(String namespace, String localName) {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            return xsdSchema.resolveNotationDeclaration(namespace, localName);
        }
        return this.createUnresolvedNotationDeclaration(namespace, localName);
    }

    protected XSDNotationDeclaration createUnresolvedNotationDeclaration(String namespace, String localName) {
        XSDNotationDeclaration xsdNotationDeclaration = XSDFactory.eINSTANCE.createXSDNotationDeclaration();
        if (localName != null) {
            xsdNotationDeclaration.setName(localName);
        }
        if (namespace != null) {
            xsdNotationDeclaration.setTargetNamespace(namespace);
        }
        return xsdNotationDeclaration;
    }

    public Collection getComponentsWithApplicationInformation(String sourceURI) {
        HashSet result = new HashSet();
        this.getComponentsWithInformation(result, 4, sourceURI);
        return result;
    }

    public Collection getComponentsWithUserInformation(String sourceURI) {
        HashSet result = new HashSet();
        this.getComponentsWithInformation(result, 10, sourceURI);
        return result;
    }

    protected void getComponentsWithInformation(Collection result, int nodeType, String sourceURI) {
        Iterator contents = this.getXSDContents().iterator();
        while (contents.hasNext()) {
            XSDConcreteComponentImpl xsdConcreteComponent = (XSDConcreteComponentImpl)contents.next();
            xsdConcreteComponent.getComponentsWithInformation(result, nodeType, sourceURI);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void setElementGen(Element newElement) {
        Element oldElement = this.element;
        this.element = newElement;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldElement, (Object)this.element));
        }
    }

    public void setElement(Element element) {
        if (element == null) {
            this.isReconciling = true;
            this.setElementGen(null);
            Iterator contents = this.getXSDContents().iterator();
            while (contents.hasNext()) {
                XSDConcreteComponentImpl content = (XSDConcreteComponentImpl)contents.next();
                content.setElement(null);
            }
            this.isReconciling = false;
        } else {
            this.setElementGen(element);
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        throw new RuntimeException("Unimplemented: XSDConcreteComponent.cloneConcreteComponent(boolean deep, boolean shareDOM)");
    }

    protected static List cloneConcreteComponents(List xsdConcreteComponents, boolean deep, boolean shareDOM) {
        ArrayList<XSDConcreteComponent> result = new ArrayList<XSDConcreteComponent>(xsdConcreteComponents.size());
        Iterator components = xsdConcreteComponents.iterator();
        while (components.hasNext()) {
            XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)components.next();
            try {
                XSDConcreteComponent clonedConcreteComponent = xsdConcreteComponent.cloneConcreteComponent(deep, shareDOM);
                result.add(clonedConcreteComponent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return result;
    }

    public boolean eNotificationRequired() {
        return true;
    }

    public static class XSDContentsEList
    extends EContentsEList {
        XSDContentsEList(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        protected ListIterator newListIterator() {
            return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            EReference eReference = (EReference)eStructuralFeature;
            return !eReference.isTransient();
        }

        public List basicList() {
            return new XSDContentsEList(this.eObject, this.eStructuralFeatures);
        }

        public Iterator basicIterator() {
            return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
        }

        public static class FeatureIteratorImpl
        extends EContentsEList.FeatureIteratorImpl {
            public FeatureIteratorImpl(EObject eObject) {
                super(eObject, (EStructuralFeature[])((BasicEList)eObject.eClass().getEAllReferences()).data());
            }

            public FeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
                super(eObject, eStructuralFeatures);
            }

            protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                EReference eReference = (EReference)eStructuralFeature;
                return !eReference.isTransient();
            }
        }
    }
}

