/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactoryDefaultHandler;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.RendererFactoryDefaultHandler;

public abstract class RendererFactory {
    private static RendererFactory defaultRendererFactory;
    private static RendererFactoryDefaultHandler defaultHandler;
    private boolean validating = true;
    public static final Notifier NotificationEngine;

    static {
        NotificationEngine = Notifier.INSTANCE;
    }

    public abstract Renderer createRenderer();

    public static RendererFactory getDefaultRendererFactory() {
        if (defaultRendererFactory == null) {
            defaultRendererFactory = RendererFactory.getDefaultHandler().getDefaultRendererFactory();
        }
        return defaultRendererFactory;
    }

    public static void setDefaultRendererFactory(RendererFactory factory) {
        NotificationEngine.notifyListeners(factory);
        defaultRendererFactory = factory;
    }

    public String toString() {
        return "RendererFactory instance: " + this.getClass().getName();
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean b) {
        this.validating = b;
    }

    public static RendererFactoryDefaultHandler getDefaultHandler() {
        if (defaultHandler == null) {
            defaultHandler = EMF2DOMRendererFactoryDefaultHandler.INSTANCE;
        }
        return defaultHandler;
    }

    public static void setDefaultHandler(RendererFactoryDefaultHandler handler) {
        defaultHandler = handler;
    }

    public static interface Listener {
        public void updateRendererFactory(RendererFactory var1);
    }

    public static class Notifier {
        private static final Notifier INSTANCE = new Notifier();
        private final Collection resourceFactoryListeners = new ArrayList();

        private Notifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyListeners(RendererFactory rendererFactory) {
            int length = this.resourceFactoryListeners.size();
            if (length > 0 && rendererFactory != RendererFactory.getDefaultRendererFactory()) {
                WeakReference wref = null;
                Listener listener = null;
                Collection collection = this.resourceFactoryListeners;
                synchronized (collection) {
                    Iterator i = this.resourceFactoryListeners.iterator();
                    while (i.hasNext()) {
                        wref = (WeakReference)i.next();
                        listener = (Listener)wref.get();
                        if (listener != null) {
                            listener.updateRendererFactory(rendererFactory);
                            continue;
                        }
                        i.remove();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(Listener l) {
            Collection collection = this.resourceFactoryListeners;
            synchronized (collection) {
                this.resourceFactoryListeners.add(new WeakReference<Listener>(l));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(Listener listenerToRemove) {
            int length = this.resourceFactoryListeners.size();
            if (length > 0) {
                WeakReference wref = null;
                Listener listener = null;
                Collection collection = this.resourceFactoryListeners;
                synchronized (collection) {
                    Iterator i = this.resourceFactoryListeners.iterator();
                    while (i.hasNext()) {
                        wref = (WeakReference)i.next();
                        listener = (Listener)wref.get();
                        if (listener != null) {
                            if (listener != listenerToRemove) continue;
                            i.remove();
                            break;
                        }
                        i.remove();
                    }
                }
            }
        }
    }
}

