/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class J2EESchemaUtility {
    public static final String[][] TEST_DATA = new String[][]{{"Test WebModule that already has complete information", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with incomplete information", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with a possible comment match, and with incomplete information.", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with a possible comment match, and with complete information.", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with a possible comment match, with complex comment structure, and with incomplete information.", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app <!-- --> id=\"WebApp_ID\" <!-- --> version=\"2.4\" <!-- --> xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n<!-- -->\n>\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app <!-- --> id=\"WebApp_ID\" <!-- --> version=\"2.4\" <!-- --> xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n<!-- -->\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}};
    public static final String TEST_COMMENTS = "<!-- --> <!-- <!-- --> <!--";
    public static int[][] TEST_COMMENT_REGIONS;
    public static final int BUFFER_SIZE = 16384;
    public static final String UTF_8 = "UTF-8";
    public static final String BEGIN_COMMENT_TEXT = "<!--";
    public static final byte[] BEGIN_COMMENT_BYTES;
    public static final String END_COMMENT_TEXT = "-->";
    public static final byte[] END_COMMENT_BYTES;
    public static final String CLOSE_TEXT = ">";
    public static final byte[] CLOSE_BYTES;
    public static final String NS_TEXT = "xmlns=\"http://java.sun.com/xml/ns/j2ee\"";
    public static final byte[] NS_BYTES;
    public static final String XSI_TEXT = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    public static final byte[] XSI_BYTES;
    public static final String SCHEMA_PREFIX = "xsi:schemaLocation=\"";
    public static final byte[] WEB_BYTES;
    public static final String VERSION_2_4_TEXT = "version=\"2.4\"";
    public static final byte[] VERSION_2_4_BYTES;
    public static final byte[] WEB_2_4_BYTES;
    public static final byte[] EJB_JAR_BYTES;
    public static final String VERSION_2_1_TEXT = "version=\"2.1\"";
    public static final byte[] VERSION_2_1_BYTES;
    public static final byte[] EJB_JAR_2_1_BYTES;
    public static final byte[] RAR_BYTES;
    public static final String VERSION_1_5_TEXT = "version=\"1.5\"";
    public static final byte[] VERSION_1_5_BYTES;
    public static final byte[] RAR_1_5_BYTES;
    public static final byte[] APP_BYTES;
    public static final String VERSION_1_4_TEXT = "version=\"1.4\"";
    public static final byte[] VERSION_1_4_BYTES;
    public static final byte[] APP_1_4_BYTES;
    public static final byte[] SPACE_BYTES;

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[2];
        nArray[1] = 8;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{9, 22};
        nArrayArray[2] = new int[]{23, 27};
        TEST_COMMENT_REGIONS = nArrayArray;
        BEGIN_COMMENT_BYTES = J2EESchemaUtility.getBytes(BEGIN_COMMENT_TEXT);
        END_COMMENT_BYTES = J2EESchemaUtility.getBytes(END_COMMENT_TEXT);
        CLOSE_BYTES = J2EESchemaUtility.getBytes(CLOSE_TEXT);
        NS_BYTES = J2EESchemaUtility.getBytes(NS_TEXT);
        XSI_BYTES = J2EESchemaUtility.getBytes(XSI_TEXT);
        WEB_BYTES = J2EESchemaUtility.getBytes("<web-app");
        VERSION_2_4_BYTES = J2EESchemaUtility.getBytes(VERSION_2_4_TEXT);
        WEB_2_4_BYTES = J2EESchemaUtility.getBytes("xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\"");
        EJB_JAR_BYTES = J2EESchemaUtility.getBytes("<ejb-jar");
        VERSION_2_1_BYTES = J2EESchemaUtility.getBytes(VERSION_2_1_TEXT);
        EJB_JAR_2_1_BYTES = J2EESchemaUtility.getBytes("xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd\"");
        RAR_BYTES = J2EESchemaUtility.getBytes("<connector");
        VERSION_1_5_BYTES = J2EESchemaUtility.getBytes(VERSION_1_5_TEXT);
        RAR_1_5_BYTES = J2EESchemaUtility.getBytes("xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd\"");
        APP_BYTES = J2EESchemaUtility.getBytes("<application");
        VERSION_1_4_BYTES = J2EESchemaUtility.getBytes(VERSION_1_4_TEXT);
        APP_1_4_BYTES = J2EESchemaUtility.getBytes("xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd\"");
        SPACE_BYTES = J2EESchemaUtility.getBytes(" ");
    }

    public static void main(String[] args) {
        J2EESchemaUtility.testComments(TEST_COMMENTS, TEST_COMMENT_REGIONS);
        try {
            int testNo = 0;
            while (testNo < TEST_DATA.length) {
                String testDescription = TEST_DATA[testNo][0];
                String testLocation = TEST_DATA[testNo][1];
                String testText = TEST_DATA[testNo][2];
                String testOutput = TEST_DATA[testNo][3];
                J2EESchemaUtility.testConvert(testText, testLocation, testDescription, testOutput);
                ++testNo;
            }
        }
        catch (IOException e) {
            System.out.println("Unexpected test exception [ " + e + " ]");
            e.printStackTrace(System.out);
        }
    }

    public static String testConvert(String testText, String testLocation, String description, String expectedOutput) throws IOException {
        System.out.println("========================================");
        System.out.println(description);
        System.out.println("Input [ " + testText + " ]");
        System.out.println("Location [ " + testLocation + " ]");
        byte[] testBytes = J2EESchemaUtility.getBytes(testText);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testBytes);
        ByteArrayInputStream convertedStream = J2EESchemaUtility.forceSchema(inputStream, testLocation);
        byte[] convertedBytes = J2EESchemaUtility.load(convertedStream);
        String convertedText = new String(convertedBytes, UTF_8);
        System.out.println("Output [ " + convertedText + " ]");
        if (convertedText.equals(expectedOutput)) {
            System.out.println("PASSED");
        } else {
            System.out.println("Expected [ " + expectedOutput + " ]");
            System.out.println("FAILED");
        }
        System.out.println("========================================");
        return convertedText;
    }

    public static int[][] testComments(String commentText, int[][] expectedRegions) {
        System.out.println("Input [ " + commentText + " ]");
        int[][] actualRegions = J2EESchemaUtility.locateComments(J2EESchemaUtility.getBytes(commentText));
        int numRegions = actualRegions.length;
        System.out.println("Expected Regions: [ " + expectedRegions.length + " ] actual [ " + numRegions + " ]");
        int regionMax = numRegions > expectedRegions.length ? numRegions : expectedRegions.length;
        int regionNo = 0;
        while (regionNo < regionMax) {
            int expectedEnd;
            int expectedStart;
            int actualEnd;
            int actualStart;
            if (regionNo < numRegions) {
                actualStart = actualRegions[regionNo][0];
                actualEnd = actualRegions[regionNo][1];
            } else {
                actualStart = -1;
                actualEnd = -1;
            }
            if (regionNo < expectedRegions.length) {
                expectedStart = expectedRegions[regionNo][0];
                expectedEnd = expectedRegions[regionNo][1];
            } else {
                expectedStart = -1;
                expectedEnd = -1;
            }
            System.out.println("  Actual [ " + actualStart + ", " + actualEnd + " ] expected [ " + expectedStart + ", " + expectedEnd + " ]");
            ++regionNo;
        }
        return actualRegions;
    }

    public static ByteArrayInputStream forceSchema(InputStream initialStream, String inputLocation) throws IOException {
        byte[] inputBytes = J2EESchemaUtility.load(initialStream);
        byte[] convertedBytes = J2EESchemaUtility.convert(inputBytes, inputLocation);
        return new ByteArrayInputStream(convertedBytes);
    }

    public static byte[] load(InputStream initialStream) throws IOException {
        int nextRead;
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        int totalRead = 0;
        byte[] currentBuffer = null;
        int currentUsage = 0;
        int currentAvail = 16384;
        do {
            if (currentBuffer == null) {
                currentBuffer = new byte[16384];
            }
            if ((nextRead = initialStream.read(currentBuffer, currentUsage, currentAvail)) <= 0) continue;
            currentUsage += nextRead;
            if ((currentAvail -= nextRead) != 0) continue;
            buffers.add(currentBuffer);
            totalRead += 16384;
            currentBuffer = null;
            currentUsage = 0;
            currentAvail = 16384;
        } while (nextRead >= 0);
        if (currentUsage > 0) {
            buffers.add(currentBuffer);
            totalRead += currentUsage;
            currentBuffer = null;
            currentUsage = 0;
        }
        byte[] allBytes = new byte[totalRead];
        int remainingFill = totalRead;
        int currentFill = 0;
        int numBuffers = buffers.size();
        int bufferNo = 0;
        while (bufferNo < numBuffers) {
            byte[] nextBuffer = (byte[])buffers.get(bufferNo);
            int nextChunk = remainingFill >= 16384 ? 16384 : remainingFill;
            System.arraycopy(nextBuffer, 0, allBytes, currentFill, nextChunk);
            remainingFill -= nextChunk;
            currentFill += nextChunk;
            ++bufferNo;
        }
        return allBytes;
    }

    public static byte[] getBytes(String text) {
        try {
            return text.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("WARNING: Unexpected exception: " + e);
            e.printStackTrace(System.out);
            return J2EESchemaUtility.getBytes(text);
        }
    }

    public static byte[] convert(byte[] inputBytes, String inputLocation) {
        if (inputLocation.endsWith("web.xml")) {
            return J2EESchemaUtility.convert(inputBytes, WEB_BYTES, VERSION_2_4_BYTES, WEB_2_4_BYTES);
        }
        if (inputLocation.endsWith("ejb-jar.xml")) {
            return J2EESchemaUtility.convert(inputBytes, EJB_JAR_BYTES, VERSION_2_1_BYTES, EJB_JAR_2_1_BYTES);
        }
        if (inputLocation.endsWith("ra.xml")) {
            return J2EESchemaUtility.convert(inputBytes, RAR_BYTES, VERSION_1_5_BYTES, RAR_1_5_BYTES);
        }
        if (inputLocation.endsWith("application.xml")) {
            return J2EESchemaUtility.convert(inputBytes, APP_BYTES, VERSION_1_4_BYTES, APP_1_4_BYTES);
        }
        return inputBytes;
    }

    public static int[][] locateComments(byte[] inputBytes) {
        int commentStart;
        ArrayList<int[]> commentLocations = new ArrayList<int[]>();
        int nextSearchOffset = 0;
        int remainingBytes = inputBytes.length;
        while (remainingBytes > 0 && (commentStart = J2EESchemaUtility.find(inputBytes, nextSearchOffset, remainingBytes, BEGIN_COMMENT_BYTES)) != -1) {
            int absoluteStart = nextSearchOffset + commentStart;
            int commentEnd = J2EESchemaUtility.find(inputBytes, nextSearchOffset += commentStart + BEGIN_COMMENT_BYTES.length, remainingBytes -= commentStart + BEGIN_COMMENT_BYTES.length, END_COMMENT_BYTES);
            commentEnd = commentEnd == -1 ? remainingBytes : (commentEnd += END_COMMENT_BYTES.length);
            int absoluteEnd = nextSearchOffset + commentEnd;
            nextSearchOffset += commentEnd;
            remainingBytes -= commentEnd;
            int[] nextCommentRegion = new int[]{absoluteStart, absoluteEnd};
            commentLocations.add(nextCommentRegion);
        }
        return (int[][])commentLocations.toArray((T[])new int[0][]);
    }

    public static byte[] convert(byte[] inputBytes, byte[] elementBytes, byte[] versionBytes, byte[] schemaBytes) {
        boolean addSchemaBytes;
        int[][] commentRegions = J2EESchemaUtility.locateComments(inputBytes);
        int elementOffset = J2EESchemaUtility.find(inputBytes, 0, inputBytes.length, elementBytes, commentRegions);
        if (elementOffset == -1) {
            return inputBytes;
        }
        int usableStart = elementOffset + elementBytes.length;
        int closeOffset = J2EESchemaUtility.find(inputBytes, usableStart, inputBytes.length - usableStart, CLOSE_BYTES, commentRegions);
        if (closeOffset == -1) {
            return inputBytes;
        }
        int versionOffset = J2EESchemaUtility.find(inputBytes, usableStart, closeOffset, versionBytes, commentRegions);
        if (versionOffset == -1) {
            return inputBytes;
        }
        int nsOffset = J2EESchemaUtility.find(inputBytes, usableStart, closeOffset, NS_BYTES, commentRegions);
        boolean addNSBytes = nsOffset == -1;
        int xsiOffset = J2EESchemaUtility.find(inputBytes, usableStart, closeOffset, XSI_BYTES, commentRegions);
        boolean addXSIBytes = xsiOffset == -1;
        int schemaOffset = J2EESchemaUtility.find(inputBytes, usableStart, closeOffset, schemaBytes, commentRegions);
        boolean bl = addSchemaBytes = schemaOffset == -1;
        if (!(addNSBytes || addXSIBytes || addSchemaBytes)) {
            return inputBytes;
        }
        int nsAddition = addNSBytes ? NS_BYTES.length + 1 : 0;
        int xsiAddition = addXSIBytes ? XSI_BYTES.length + 1 : 0;
        int schemaAddition = addSchemaBytes ? schemaBytes.length + 1 : 0;
        byte[] convertedBytes = new byte[inputBytes.length + nsAddition + xsiAddition + schemaAddition];
        int headerLength = usableStart + closeOffset;
        System.arraycopy(inputBytes, 0, convertedBytes, 0, headerLength);
        if (addNSBytes) {
            System.arraycopy(SPACE_BYTES, 0, convertedBytes, headerLength, SPACE_BYTES.length);
            System.arraycopy(NS_BYTES, 0, convertedBytes, headerLength += SPACE_BYTES.length, NS_BYTES.length);
            headerLength += NS_BYTES.length;
        }
        if (addXSIBytes) {
            System.arraycopy(SPACE_BYTES, 0, convertedBytes, headerLength, SPACE_BYTES.length);
            System.arraycopy(XSI_BYTES, 0, convertedBytes, headerLength += SPACE_BYTES.length, XSI_BYTES.length);
            headerLength += XSI_BYTES.length;
        }
        if (addSchemaBytes) {
            System.arraycopy(SPACE_BYTES, 0, convertedBytes, headerLength, SPACE_BYTES.length);
            System.arraycopy(schemaBytes, 0, convertedBytes, headerLength += SPACE_BYTES.length, schemaBytes.length);
            headerLength += schemaBytes.length;
        }
        int tailOffset = usableStart + closeOffset;
        System.arraycopy(inputBytes, tailOffset, convertedBytes, headerLength, inputBytes.length - tailOffset);
        return convertedBytes;
    }

    public static int find(byte[] target, int targetOffset, int targetLen, byte[] key, int[][] ignoredRegions) {
        if (ignoredRegions.length == 0) {
            return J2EESchemaUtility.find(target, targetOffset, targetLen, key);
        }
        int targetEnd = targetOffset + targetLen;
        int result = -1;
        int useableStart = -1;
        int useableEnd = 0;
        boolean pastTarget = false;
        int regionNo = 0;
        while (!pastTarget && result == -1 && regionNo < ignoredRegions.length) {
            useableStart = useableEnd;
            useableEnd = ignoredRegions[regionNo][0];
            if (targetOffset < useableEnd && targetEnd > useableStart) {
                if (useableStart < targetOffset) {
                    useableStart = targetOffset;
                }
                if (useableEnd > targetEnd) {
                    useableEnd = targetEnd;
                    pastTarget = true;
                }
                if ((result = J2EESchemaUtility.find(target, useableStart, useableEnd - useableStart, key)) != -1) {
                    result += useableStart - targetOffset;
                }
            }
            useableEnd = ignoredRegions[regionNo][1];
            ++regionNo;
        }
        if (result == -1 && !pastTarget && (result = J2EESchemaUtility.find(target, useableStart = useableEnd, (useableEnd = targetEnd) - useableStart, key)) != -1) {
            result += useableStart - targetOffset;
        }
        return result;
    }

    public static int find(byte[] target, int targetOffset, int targetLen, byte[] key) {
        if (key.length > targetLen) {
            return -1;
        }
        int matchOffset = -1;
        int targetMax = targetLen - key.length + 1;
        int searchOffset = 0;
        while (matchOffset == -1 && searchOffset < targetMax) {
            boolean foundMismatch = false;
            int keyOffset = 0;
            while (!foundMismatch && keyOffset < key.length) {
                if (target[targetOffset + searchOffset + keyOffset] != key[keyOffset]) {
                    foundMismatch = true;
                }
                ++keyOffset;
            }
            if (!foundMismatch) {
                matchOffset = searchOffset;
            }
            ++searchOffset;
        }
        return matchOffset;
    }
}

