/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.functions;

import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.functions.FuncSubstring;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.objects.XString;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.functions.EFunction3Args;

public class EFuncSubstring
extends EFunction3Args {
    public IExpression instance(Expression e) {
        return new EFuncSubstring((FuncSubstring)e);
    }

    public EFuncSubstring(FuncSubstring fs) {
        super((Function3Args)fs);
    }

    public Object[] execute(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        String string = this.getArg0AsString(context).str();
        int from = (int)this.getArg1AsNumber(context);
        int to = (int)this.getArg2AsNumber(context);
        String subString = to > 0 ? string.substring(from, to) : string.substring(from);
        return new Object[]{new XString(subString)};
    }

    public void compile(ICompilerContext compilationContext) throws CodeGenerationError {
        compilationContext.in(this);
        IExpression a0 = this.getEArg0();
        IExpression a1 = this.getEArg1();
        IExpression a2 = this.getEArg2();
        compilationContext.append(" ( ");
        a0.compile(compilationContext);
        compilationContext.append(".substring(((int)");
        a1.compile(compilationContext);
        if (a2 != null) {
            compilationContext.append(")-1, ((int)");
            a2.compile(compilationContext);
            compilationContext.append(") + ((int)");
            a1.compile(compilationContext);
            compilationContext.append(") ) )");
            compilationContext.out();
        } else {
            compilationContext.append(")-1) )");
            compilationContext.out();
        }
    }
}

