/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath.emf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.tptp.platform.provisional.fastxpath.NameType;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.BindingMetaData;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.ClassMapping;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.ReflectionHelper;
import org.eclipse.tptp.platform.provisional.fastxpath.emf.EMFReflectionHelper;

public class EMFBindingMetaData
implements BindingMetaData {
    public static final EMFBindingMetaData INSTANCE = new EMFBindingMetaData();
    private HashMap classMappings = new HashMap();
    private HashMap recursiveElements = new HashMap();
    private HashMap nameToTypeMap = new HashMap();
    private HashMap abstractInnerClasses = new HashMap();
    private ExtendedMetaData metaData = new BasicExtendedMetaData(){

        public List getAttributes(EClass eClass) {
            return eClass.getEAllAttributes();
        }

        public List getElements(EClass eClass) {
            return eClass.getEReferences();
        }
    };
    private boolean processedThisClassAlready = false;

    private EMFBindingMetaData() {
    }

    public synchronized void preProcessClass(Object object) {
        EClass clazz = ((EObject)object).eClass();
        this.preProcessClass(clazz, clazz.getName());
        EPackage pkg = clazz.getEPackage();
        Iterator iter = this.abstractInnerClasses.keySet().iterator();
        while (iter.hasNext()) {
            EClass abstractClass = (EClass)this.abstractInnerClasses.get(iter.next());
            Iterator iterator = pkg.getEClassifiers().iterator();
            while (iterator.hasNext()) {
                Object classifier = iterator.next();
                if (!(classifier instanceof EClass)) continue;
                EClass pkgClass = (EClass)classifier;
                Iterator superIter = pkgClass.getEAllSuperTypes().iterator();
                while (superIter.hasNext()) {
                    EClass superClass = (EClass)superIter.next();
                    if (!superClass.equals(abstractClass)) continue;
                    this.preProcessClass(pkgClass, abstractClass.getName());
                }
            }
        }
    }

    private List getConcreteClasses(EClass abstractClass) {
        LinkedList<EClass> concreteClassList = new LinkedList<EClass>();
        EPackage pkg = abstractClass.getEPackage();
        Iterator iterator = pkg.getEClassifiers().iterator();
        while (iterator.hasNext()) {
            Object classifier = iterator.next();
            if (!(classifier instanceof EClass)) continue;
            EClass pkgClass = (EClass)classifier;
            Iterator superIter = pkgClass.getEAllSuperTypes().iterator();
            while (superIter.hasNext()) {
                EClass superClass = (EClass)superIter.next();
                if (!superClass.equals(abstractClass)) continue;
                concreteClassList.add(pkgClass);
            }
        }
        return concreteClassList;
    }

    private void preProcessClass(EClass clazz, String name) {
        EStructuralFeature eStructuralFeature;
        EList list = clazz.getEAllReferences();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            eStructuralFeature = (EStructuralFeature)iter.next();
            this.fillRecursiveMap(name, eStructuralFeature.getName());
            this.fillNameToTypeMap(eStructuralFeature);
        }
        list = clazz.getEAllAttributes();
        iter = list.iterator();
        while (iter.hasNext()) {
            eStructuralFeature = (EStructuralFeature)iter.next();
            this.fillRecursiveMap(name, eStructuralFeature.getName());
            this.fillNameToTypeMap(eStructuralFeature);
        }
        iter = clazz.getEAllReferences().iterator();
        while (iter.hasNext()) {
            EReference reference = (EReference)iter.next();
            EClass cl = (EClass)reference.getEType();
            if (cl.equals(clazz)) {
                if (this.processedThisClassAlready) {
                    this.processedThisClassAlready = false;
                    continue;
                }
                this.processedThisClassAlready = true;
            }
            this.preProcessClass(reference.getEReferenceType(), reference.getName());
            if (!cl.isAbstract()) continue;
            List concreteClassList = this.getConcreteClasses(cl);
            Iterator iterator = concreteClassList.iterator();
            while (iterator.hasNext()) {
                EClass concreteClass = (EClass)iterator.next();
                this.preProcessClass(concreteClass, reference.getName());
            }
            this.abstractInnerClasses.put(name, clazz);
        }
    }

    private void fillNameToTypeMap(EStructuralFeature structuralFeature) {
        String name = structuralFeature.getName();
        String className = structuralFeature.getEType().getInstanceClassName();
        int upperBound = structuralFeature.getUpperBound();
        boolean isList = upperBound > 1 || upperBound == -1;
        this.nameToTypeMap.put(name, new NameType(className, isList));
    }

    private void fillRecursiveMap(String className, String name) {
        HashSet<String> containers = (HashSet<String>)this.recursiveElements.get(name);
        if (containers == null) {
            containers = new HashSet<String>();
            this.recursiveElements.put(name, containers);
        }
        containers.add(className);
    }

    public synchronized String[] getElements(Object object) {
        if (!(object instanceof EObject)) {
            return new String[0];
        }
        EObject obj = (EObject)object;
        ClassMapping classMapping = this.getClassMapping(obj);
        return this.resolveNamesList(classMapping.getElements());
    }

    public synchronized String[] getAttributes(Object object) {
        if (!(object instanceof EObject)) {
            return new String[0];
        }
        EObject obj = (EObject)object;
        ClassMapping classMapping = this.getClassMapping(obj);
        return this.resolveNamesList(classMapping.getAttributes());
    }

    public synchronized ClassMapping getClassMapping(EClass eClass) {
        EStructuralFeature eStructuralFeature;
        ClassMapping map = new ClassMapping();
        Set attributes = map.getAttributes();
        Set elements = map.getElements();
        Iterator i = this.metaData.getAllAttributes(eClass).iterator();
        while (i.hasNext()) {
            eStructuralFeature = (EStructuralFeature)i.next();
            map.put(eStructuralFeature.getName(), eStructuralFeature);
            this.fillAccordingToAnnotations(attributes, elements, attributes, eStructuralFeature);
        }
        i = this.metaData.getAllElements(eClass).iterator();
        while (i.hasNext()) {
            eStructuralFeature = (EStructuralFeature)i.next();
            map.put(eStructuralFeature.getName(), eStructuralFeature);
            this.fillAccordingToAnnotations(attributes, elements, elements, eStructuralFeature);
        }
        return map;
    }

    private void fillAccordingToAnnotations(Set attributes, Set elements, Set defaultGroup, EStructuralFeature eStructuralFeature) {
        EList annotations = eStructuralFeature.getEAnnotations();
        if (annotations == null || annotations.size() == 0) {
            defaultGroup.add(eStructuralFeature.getName());
        } else {
            EAnnotation annotation = (EAnnotation)annotations.get(0);
            String kind = (String)annotation.getDetails().get("kind");
            if (kind.equals("element")) {
                elements.add(eStructuralFeature.getName());
            } else {
                attributes.add(eStructuralFeature.getName());
            }
        }
    }

    private String[] resolveNamesList(Set nameList) {
        Object[] objArr = nameList.toArray();
        String[] nameArr = new String[objArr.length];
        System.arraycopy(objArr, 0, nameArr, 0, objArr.length);
        return nameArr;
    }

    public ClassMapping getClassMapping(Object obj) {
        if (!(obj instanceof EObject)) {
            return new ClassMapping();
        }
        EClass eClass = ((EObject)obj).eClass();
        ClassMapping classMapping = (ClassMapping)this.classMappings.get(eClass);
        if (classMapping == null) {
            this.preProcessClass(obj);
            classMapping = this.getClassMapping(((EObject)obj).eClass());
            this.classMappings.put(eClass, classMapping);
        }
        return classMapping;
    }

    public Set getRecursiveElements(String name) {
        return (Set)this.recursiveElements.get(name);
    }

    public NameType getClassNameForElementName(String elementName) {
        return (NameType)this.nameToTypeMap.get(elementName);
    }

    public ReflectionHelper getReflectionHelper(Object object) throws Exception {
        return new EMFReflectionHelper(this.getClassMapping(object));
    }
}

