/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.hyades.models.hierarchy.util.internal.IdentityHashSet;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.FastXPathClassGenerator;

public class EclipseCompiler
implements FastXPathClassGenerator {
    private boolean verboseOutput = false;
    private byte[] bytes;
    private char[] sourcecode;
    private Set classLoaders;
    private MyClassLoader classLoader = null;

    public byte[] getBytes() {
        return this.bytes;
    }

    public Class generateClass(byte[] bArr) throws ClassNotFoundException, CodeGenerationError {
        return this.getClassLoader().defineClass(bArr);
    }

    public Class generateClass(char[] source, String targetClassName) throws ClassNotFoundException, CodeGenerationError {
        final MyClassLoader classLoader = this.getClassLoader();
        final ArrayList problemList = new ArrayList();
        MyNameEnvironment env = new MyNameEnvironment(targetClassName, this.getClass().getClassLoader(), source);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap settings = new HashMap();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                int i;
                if (result.hasProblems()) {
                    CategorizedProblem[] problems = result.getProblems();
                    i = 0;
                    while (i < problems.length) {
                        CategorizedProblem problem = problems[i];
                        if (problem.isError()) {
                            problemList.add(problem.getSourceStart() + "," + problem.getSourceEnd() + ":" + problem.getMessage());
                        }
                        ++i;
                    }
                }
                if (problemList.isEmpty()) {
                    ClassFile[] classFiles = result.getClassFiles();
                    i = 0;
                    while (i < classFiles.length) {
                        ClassFile classFile = classFiles[i];
                        char[][] compoundName = classFile.getCompoundName();
                        String className = "";
                        String sep = "";
                        int j = 0;
                        while (j < compoundName.length) {
                            className = String.valueOf(className) + sep;
                            className = String.valueOf(className) + new String(compoundName[j]);
                            sep = ".";
                            ++j;
                        }
                        byte[] bArr = classFile.getBytes();
                        classLoader.defineClass(bArr);
                        ++i;
                    }
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[]{new MyCompilationUnit(source, targetClassName)};
        Compiler compiler = new Compiler((INameEnvironment)env, policy, settings, requestor, (IProblemFactory)problemFactory, true);
        compiler.compile(compilationUnits);
        if (!problemList.isEmpty()) {
            throw new CodeGenerationError((String)problemList.get(0));
        }
        Class<?> c = classLoader.loadClass(targetClassName);
        this.bytes = classLoader.getBytes();
        this.sourcecode = source;
        return c;
    }

    public void setVerbose(boolean verboseOutput) {
        this.verboseOutput = verboseOutput;
    }

    public char[] getSourcecode() {
        return this.sourcecode;
    }

    public void addClassLoader(ClassLoader cl) {
        if (this.classLoaders == null) {
            this.classLoaders = new IdentityHashSet();
        }
        this.classLoaders.add(cl);
    }

    protected InputStream getClassInputStream(ClassLoader classLoader, String resourceName) {
        InputStream is = classLoader.getResourceAsStream(resourceName);
        if (is == null) {
            Iterator iter = this.classLoaders.iterator();
            while (iter.hasNext()) {
                ClassLoader element = (ClassLoader)iter.next();
                is = element.getResourceAsStream(resourceName);
                if (is == null) continue;
                return is;
            }
        }
        return is;
    }

    protected MyClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new MyClassLoader(this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    class MyClassLoader
    extends ClassLoader {
        byte[] bArr;

        MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(byte[] arr) {
            this.bArr = arr;
            return super.defineClass(null, arr, 0, arr.length);
        }

        public byte[] getBytes() {
            return this.bArr;
        }
    }

    class MyCompilationUnit
    implements ICompilationUnit {
        String className;
        char[] source;

        MyCompilationUnit(char[] source, String className) {
            this.className = className;
            this.source = source;
        }

        public char[] getFileName() {
            return this.className.toCharArray();
        }

        public char[] getContents() {
            return this.source;
        }

        public char[] getMainTypeName() {
            return this.className.toCharArray();
        }

        public char[][] getPackageName() {
            return null;
        }
    }

    public class MyNameEnvironment
    implements INameEnvironment {
        private String targetClassName;
        private ClassLoader classLoader;
        private char[] source;

        public MyNameEnvironment(String targetClassName, ClassLoader classLoader, char[] source) {
            this.targetClassName = targetClassName;
            this.classLoader = classLoader;
            this.source = source;
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            String type = "";
            int i = 0;
            while (i < compoundTypeName.length) {
                if (i > 0) {
                    type = String.valueOf(type) + ".";
                }
                type = String.valueOf(type) + new String(compoundTypeName[i]);
                ++i;
            }
            return this.findType(type);
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            String type = "";
            String dot = "";
            int i = 0;
            while (i < packageName.length) {
                type = String.valueOf(type) + dot;
                type = String.valueOf(type) + new String(packageName[i]);
                dot = ".";
                ++i;
            }
            type = String.valueOf(type) + dot;
            type = String.valueOf(type) + new String(typeName);
            return this.findType(type);
        }

        private NameEnvironmentAnswer findType(String className) {
            try {
                if (className.equals(this.targetClassName)) {
                    MyCompilationUnit compilationUnit = new MyCompilationUnit(this.source, className);
                    return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                }
                String resourceName = String.valueOf(className.replace('.', '/')) + ".class";
                InputStream is = EclipseCompiler.this.getClassInputStream(this.classLoader, resourceName);
                if (is != null) {
                    int count;
                    byte[] buf = new byte[8192];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                    while ((count = is.read(buf, 0, buf.length)) > 0) {
                        baos.write(buf, 0, count);
                    }
                    baos.flush();
                    byte[] classBytes = baos.toByteArray();
                    char[] fileName = className.toCharArray();
                    ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                    return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                }
            }
            catch (IOException exc) {
                System.out.println("Compilation error");
                exc.printStackTrace();
            }
            catch (ClassFormatException exc) {
                System.out.println("Compilation error");
                exc.printStackTrace();
            }
            return null;
        }

        private boolean isPackage(String result) {
            if (result.equals(this.targetClassName)) {
                return false;
            }
            String resourceName = String.valueOf(result.replace('.', '/')) + ".class";
            InputStream is = EclipseCompiler.this.getClassInputStream(this.classLoader, resourceName);
            return is == null;
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            String str;
            String result = "";
            String dot = "";
            if (parentPackageName != null) {
                int i = 0;
                while (i < parentPackageName.length) {
                    result = String.valueOf(result) + dot;
                    String str2 = new String(parentPackageName[i]);
                    result = String.valueOf(result) + str2;
                    dot = ".";
                    ++i;
                }
            }
            if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                return false;
            }
            result = String.valueOf(result) + dot;
            result = String.valueOf(result) + str;
            return this.isPackage(result);
        }

        public void cleanup() {
        }
    }
}

