/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.NameType;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;

public class CompilerPostProcessor {
    protected StringBuffer sb;
    protected int numLoops;
    protected HashSet matches = new HashSet();
    protected FastXPathContext fastXPathContext;
    protected String toBool = "org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator.toBool";
    protected String returnMatch = "element";
    static final String[] OPERATORS = new String[]{" == ", " != ", " <= ", " < ", " >= ", " > ", " - ", " * ", " + ", " / "};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public CompilerPostProcessor(StringBuffer sb, FastXPathContext fastXPathContext) {
        this.sb = sb;
        this.fastXPathContext = fastXPathContext;
    }

    public CompilerPostProcessor(String string) {
        this.sb = new StringBuffer(string);
    }

    public String postCompileProcess() {
        String finalOutputString;
        this.matches.clear();
        int index = -1;
        while ((index = this.sb.indexOf(" .get")) != -1) {
            this.sb.replace(index, index + 5, " obj.get");
        }
        index = this.sb.indexOf(" (");
        StringBuffer finalOutput = new StringBuffer("if");
        this.sb = new StringBuffer(this.sb.substring(Math.max(index, 0), this.sb.length()));
        this.addToBool(this.sb, 0);
        this.fixStringEquals(this.sb);
        this.numLoops = 0;
        String loopsInside = this.processLoops(this.sb, 0);
        if (loopsInside != null && !loopsInside.equals(this.sb.toString())) {
            StringBuffer fixme = new StringBuffer(loopsInside);
            this.balanceParenthesis(fixme);
            finalOutputString = fixme.toString();
        } else {
            int lastPredicateMarker = this.sb.indexOf("$*$*$*$* ");
            finalOutput.append(String.valueOf(this.sb.substring(0, lastPredicateMarker)) + "\n");
            String whatToReturn = this.sb.substring(lastPredicateMarker + "$*$*$*$* ".length());
            if (whatToReturn.trim().length() == 0) {
                whatToReturn = "obj";
            }
            this.addReturnMatch(finalOutput, whatToReturn);
            this.addReturnNotMatch(finalOutput);
            this.balanceParenthesis(finalOutput);
            finalOutputString = finalOutput.toString();
        }
        return finalOutputString;
    }

    protected String addNullCheckWorkaround(String finalOutputString) {
        StringBuffer s = new StringBuffer();
        this.addReturnNotMatch(s);
        return "\ntry {\n" + finalOutputString + "\n} catch(java.lang.NullPointerException npe1) {\n" + s.toString() + "\n}";
    }

    protected void addReturnNotMatch(StringBuffer buffer) {
        buffer.append("return null;");
    }

    protected void addReturnMatch(StringBuffer buffer, String whatToReturn) {
        buffer.append("\treturn " + whatToReturn + ";\n");
    }

    public char[] fixCompileError(CodeGenerationError error) {
        String errorMsg = error.getMessage();
        if (errorMsg.indexOf("Cannot invoke equals") != -1) {
            return this.fixEqualsNoGoHere(errorMsg);
        }
        if (errorMsg.indexOf("Incompatible operand types String and boolean") != -1 || errorMsg.indexOf("Incompatible operand types boolean and String") != -1) {
            return this.fixStringAndBooleanDontMix(errorMsg);
        }
        if (errorMsg.indexOf("Incompatible operand types String and ") != -1 || errorMsg.indexOf("Incompatible operand types ") != -1 && errorMsg.indexOf("and String") != -1) {
            return this.fixStringAndPrimitiveDontMix(errorMsg);
        }
        if (errorMsg.indexOf("Incompatible operand types ") != -1 && errorMsg.indexOf(" boolean") != -1) {
            return this.fixSomeClassAndBooleanDontMix(errorMsg);
        }
        if (errorMsg.indexOf("The method equals(Object) in the type ") != -1 && errorMsg.indexOf("is not applicable for the arguments (boolean)") != -1) {
            return this.fixEqualsNoGoHere(errorMsg);
        }
        if (errorMsg.indexOf("The method equals(Object) in the type ") != -1 && errorMsg.indexOf("is not applicable for the arguments (double)") != -1) {
            return this.fixEqualsNoGoHere(errorMsg);
        }
        if (errorMsg.indexOf("The operator ") != -1 && errorMsg.indexOf("is undefined for the argument type(s) String, double") != -1) {
            return this.fixBadOperatorForStrings(errorMsg);
        }
        if (errorMsg.indexOf("Type mismatch: cannot convert from ") != -1 && errorMsg.indexOf("boolean") != -1) {
            return this.fixMissingToBool(errorMsg);
        }
        if (errorMsg.indexOf(" is undefined for the argument type(s) ") != -1 && errorMsg.indexOf("The operator ") != -1 && errorMsg.indexOf("boolean") != -1) {
            return this.fixMissingToBool2(errorMsg);
        }
        if (errorMsg.indexOf("Cannot cast from String to ") != -1) {
            return this.fixCast(errorMsg);
        }
        if (errorMsg.indexOf("Type mismatch: cannot convert from ") != -1 && errorMsg.indexOf("to Object") != -1) {
            return this.convertToObject(errorMsg);
        }
        if (errorMsg.indexOf("The method ") != -1 && errorMsg.indexOf("is undefined for the type") != -1) {
            return this.fixBadMethod(errorMsg);
        }
        if (errorMsg.indexOf("The operator ") != -1 && errorMsg.indexOf("is undefined for the argument type(s) java.lang.String, java.lang.String") != -1) {
            return this.fixBadOperatorForStrings2(errorMsg);
        }
        return null;
    }

    protected char[] convertToObject(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        this.sb.insert(bounds.from, "\"\" + ");
        return this.sb.toString().toCharArray();
    }

    protected char[] fixCast(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String header = "Cannot cast from String to ";
        int idx = errorMsg.indexOf(header);
        if (idx == -1) {
            return null;
        }
        String className = errorMsg.substring(idx + header.length());
        if (className.equals(Short.TYPE.getName())) {
            this.replaceCasting("short", "Short", bounds);
        } else if (className.equals(Long.TYPE.getName())) {
            this.replaceCasting("long", "Long", bounds);
        } else if (className.equals(Integer.TYPE.getName())) {
            this.replaceCasting("int", "Integer", bounds);
        } else if (className.equals(Float.TYPE.getName())) {
            this.replaceCasting("float", "Float", bounds);
        } else if (className.equals(Double.TYPE.getName())) {
            this.replaceCasting("double", "Double", bounds);
        } else if (className.equals(Character.TYPE.getName())) {
            this.replaceCasting("short", "Short", bounds);
        } else if (className.equals(Boolean.TYPE.getName())) {
            this.replaceCasting("boolean", "Boolean", bounds);
        } else if (className.equals(Byte.TYPE.getName())) {
            this.replaceCasting("byte", "Byte", bounds);
        } else {
            return null;
        }
        return this.sb.toString().toCharArray();
    }

    protected void replaceCasting(String primitive, String className, ErrorBounds bounds) {
        if (this.sb.indexOf("(" + primitive + ")", bounds.from) == bounds.from) {
            this.sb.insert(bounds.to + 1, "." + primitive + "Value()");
            this.sb.delete(bounds.from, bounds.from + primitive.length() + 2);
            this.sb.insert(bounds.from, String.valueOf(className) + ".valueOf");
        } else {
            this.sb.insert(bounds.to + 1, ")." + primitive + "Value()");
            this.sb.insert(bounds.from, String.valueOf(className) + ".valueOf(");
        }
    }

    protected char[] fixMissingToBool2(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String subString = this.sb.substring(bounds.from - 1, bounds.to + 1);
        String[] sArr = subString.split(" && ");
        if (sArr.length == 1 && (sArr = subString.split(" || ")).length == 1) {
            return null;
        }
        if (sArr[0].indexOf(this.toBool) == -1) {
            this.sb.insert(bounds.from + sArr[0].length(), ")");
            this.sb.insert(bounds.from, String.valueOf(this.toBool) + "(");
        } else {
            this.sb.insert(bounds.to, ")");
            this.sb.insert(bounds.to - sArr[1].length(), String.valueOf(this.toBool) + "(");
        }
        this.balanceParenthesis(this.sb);
        return this.sb.toString().toCharArray();
    }

    protected char[] fixMissingToBool(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String subString = this.sb.substring(bounds.from, bounds.to + 1);
        this.sb.insert(bounds.from + subString.length(), ")");
        this.sb.insert(bounds.from, String.valueOf(this.toBool) + "(");
        this.balanceParenthesis(this.sb);
        return this.sb.toString().toCharArray();
    }

    protected char[] fixBadOperatorForStrings(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String subString = this.sb.substring(bounds.from, bounds.to + 1);
        int idxOfOperator = -1;
        int i = 0;
        while (i < OPERATORS.length) {
            idxOfOperator = subString.indexOf(OPERATORS[i]);
            if (idxOfOperator != -1) {
                idxOfOperator += bounds.from;
                StringTokenizer tokenizer = new StringTokenizer(subString, "() ");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    try {
                        Double.parseDouble(token);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (token.equals(OPERATORS[i])) continue;
                        int idx = this.sb.indexOf(token, bounds.from);
                        if (idx < idxOfOperator) {
                            this.sb.insert(idxOfOperator, ")");
                            this.sb.insert(idx, "Double.parseDouble(");
                        }
                        this.addNumberFormatExceptionTryCatch();
                        return this.sb.toString().toCharArray();
                    }
                }
            }
            ++i;
        }
        return null;
    }

    protected void addNumberFormatExceptionTryCatch() {
        int ifIdx = this.sb.indexOf("if ");
        int returnIdx = this.sb.indexOf("return ");
        int endOfReturnExpression = this.sb.indexOf(";", returnIdx) + 1;
        this.sb.insert(endOfReturnExpression, "\n}catch(NumberFormatException nfe){}");
        this.sb.insert(ifIdx, "try{\n\t");
    }

    protected char[] fixStringAndPrimitiveDontMix(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String range = this.sb.substring(bounds.from, bounds.to + 1);
        String[] sArr = range.split("\"");
        if (sArr != null && sArr.length == 3) {
            try {
                Double.parseDouble(sArr[1]);
                this.sb.deleteCharAt(this.sb.indexOf("\"", bounds.from));
                this.sb.deleteCharAt(this.sb.indexOf("\"", bounds.from));
                return this.sb.toString().toCharArray();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (sArr.length == 1) {
            return this.fixBadOperatorForStrings(errorMsg);
        }
        return this.fixBadOperatorForStrings(errorMsg);
    }

    protected char[] fixSomeClassAndBooleanDontMix(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String subString = this.sb.substring(bounds.from, bounds.to + 1);
        String[] sArr = subString.split("==");
        if (sArr.length == 1 && (sArr = subString.split("!=")).length == 1) {
            return null;
        }
        if (sArr[0].indexOf("true") != -1 || sArr[0].indexOf("false") != -1) {
            this.sb.insert(bounds.to, ")");
            this.sb.insert(bounds.from + sArr[0].length() + "==".length(), String.valueOf(this.toBool) + "(");
        } else if (sArr[1].indexOf("true") != -1 || sArr[1].indexOf("false") != -1) {
            this.sb.insert(bounds.from + sArr[0].length(), ")");
            this.sb.insert(bounds.from, String.valueOf(this.toBool) + "(");
        } else {
            return null;
        }
        this.balanceParenthesis(this.sb);
        return this.sb.toString().toCharArray();
    }

    protected char[] fixStringAndBooleanDontMix(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        int toBoolIdx = this.sb.indexOf(String.valueOf(this.toBool) + "(", bounds.from);
        if (toBoolIdx == -1 || toBoolIdx > bounds.to) {
            return this.fixSomeClassAndBooleanDontMix(errorMsg);
        }
        this.sb.replace(toBoolIdx, toBoolIdx + (String.valueOf(this.toBool) + "(").length(), "");
        this.balanceParenthesis(this.sb);
        return this.sb.toString().toCharArray();
    }

    protected char[] fixEqualsNoGoHere(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        int equalsIdx = this.sb.indexOf(".equals", bounds.from - 1);
        if (equalsIdx == -1 || equalsIdx > bounds.to) {
            return null;
        }
        this.sb.replace(equalsIdx, equalsIdx + ".equals".length(), " == ");
        return this.sb.toString().toCharArray();
    }

    protected String processLoops(StringBuffer predicate, int start) {
        int middleIdx;
        int tmpIdx = 0;
        this.numLoops = 0;
        while ((tmpIdx = predicate.indexOf("for (java.", tmpIdx)) != -1) {
            ++this.numLoops;
            tmpIdx += 10;
        }
        int leftIdx = predicate.indexOf("obj.get", start);
        if (leftIdx == -1) {
            leftIdx = predicate.indexOf("element" + (this.numLoops - 1) + ".");
            if (leftIdx == -1) {
                return this.addCasting(predicate, start);
            }
            middleIdx = leftIdx + 6;
        } else {
            middleIdx = leftIdx + 1;
        }
        int rightIdx = leftIdx;
        while ((rightIdx = predicate.indexOf("()", rightIdx + 1)) != -1) {
            String name = predicate.substring(middleIdx + 6, rightIdx);
            if (name.split("\\S").length > 1) {
                tmpIdx = predicate.indexOf("obj.get", middleIdx);
                if (tmpIdx == -1) {
                    String[] sArr = name.split("element[0-9]*\\.");
                    if (sArr.length == 1) {
                        return predicate.toString();
                    }
                    name = sArr[1].substring(3);
                } else {
                    middleIdx = tmpIdx + 7;
                    name = predicate.substring(middleIdx, rightIdx);
                }
            }
            NameType type = null;
            type = this.isList(name);
            if (type != null) {
                return this.createLoop(predicate, leftIdx, rightIdx, type);
            }
            tmpIdx = predicate.indexOf("(\"", rightIdx + 1);
            if (tmpIdx != -1 && (tmpIdx = predicate.indexOf("\")", tmpIdx + 1)) != -1) {
                rightIdx = tmpIdx + 2;
            }
            middleIdx = rightIdx;
        }
        if (this.numLoops == 0) {
            return null;
        }
        return predicate.toString();
    }

    protected String createLoop(StringBuffer predicate, int leftIdx, int rightIdx, NameType type) {
        int whereToReplace;
        int closingBraket;
        if (this.hasAnIndexAlready(predicate, rightIdx)) {
            return this.processLoops(predicate, rightIdx);
        }
        if (this.followedByAnIndex(predicate, rightIdx) && (closingBraket = this.getIndexOfClosingBrakcet(predicate, rightIdx + 7)) != -1) {
            predicate.insert(closingBraket, ")");
            String castingWithBrakets = "((" + type.getClassName() + ")";
            predicate.insert(leftIdx, castingWithBrakets);
            return this.processLoops(predicate, rightIdx + castingWithBrakets.length());
        }
        if (this.followedByGetSizeFunction(predicate, rightIdx)) {
            return this.processLoops(predicate, rightIdx);
        }
        int j = rightIdx;
        while (j >= leftIdx - 1) {
            if (predicate.charAt(j) == ' ') {
                leftIdx = j + 1;
                break;
            }
            --j;
        }
        if (predicate.substring(rightIdx, Math.min(rightIdx + 7, predicate.length())).equals("().get(")) {
            predicate.insert(predicate.indexOf(")", rightIdx + 7), ")");
            String castingWithBrakets = "((" + type.getClassName() + ")";
            predicate.insert(leftIdx, castingWithBrakets);
            return this.processLoops(predicate, rightIdx + castingWithBrakets.length());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("for (java.util.Iterator iter" + this.numLoops + " = " + predicate.substring(leftIdx, rightIdx + 2) + ".iterator(); iter" + this.numLoops + ".hasNext();)\n{\n\t");
        buffer.append(String.valueOf(type.getClassName()) + " element" + this.numLoops + " = (" + type.getClassName() + ")iter" + this.numLoops + ".next();\n");
        String whatToReplace = predicate.substring(leftIdx, rightIdx + 2);
        if (whatToReplace.endsWith(".")) {
            whatToReplace = whatToReplace.substring(0, whatToReplace.length() - 1);
        }
        while ((whereToReplace = predicate.indexOf(whatToReplace)) != -1) {
            predicate.replace(whereToReplace, whereToReplace + whatToReplace.length(), "element" + this.numLoops);
        }
        if (this.numLoops == 0) {
            int lastPredicateMarker = predicate.indexOf("$*$*$*$* ");
            String whatToReturn = predicate.substring(lastPredicateMarker + "$*$*$*$* ".length());
            buffer.append("        if " + predicate.substring(0, lastPredicateMarker) + "\n");
            this.addReturnMatch(buffer, whatToReturn);
            buffer.append("}\n");
            this.addReturnNotMatch(buffer);
        } else {
            String delim = "iter0.next();\n";
            int index = predicate.lastIndexOf(".next();\n");
            if (index > -1) {
                delim = predicate.substring(index - 5, index + 10);
            }
            int whereToPut = predicate.indexOf(delim);
            predicate.insert(whereToPut + delim.length(), buffer.toString());
            predicate.insert(predicate.length() - 14, "}");
            buffer = new StringBuffer(predicate.toString());
        }
        return this.processLoops(buffer, this.getReturnMatchStringIndex(buffer));
    }

    protected int getReturnMatchStringIndex(StringBuffer b) {
        int startIndex = b.indexOf("if  ");
        return b.indexOf(String.valueOf(this.returnMatch) + this.numLoops, startIndex);
    }

    protected String addCasting(StringBuffer predicate, int start) {
        String match;
        String patternStr = "\\.get\\w+\\(\\)";
        Pattern pattern = Pattern.compile(patternStr);
        String inputStr = predicate.substring(start);
        Matcher matcher = pattern.matcher(inputStr);
        String result = predicate.toString();
        if (matcher.find() && !this.matches.contains(match = matcher.group())) {
            this.matches.add(match);
            NameType type = null;
            type = this.isList(match.substring(4, match.length() - 2));
            if (type != null) {
                int end = matcher.end();
                int begin = this.getIndexOfOpeningBrakcet(predicate, end + start);
                result = this.createLoop(predicate, begin, end + start - 1, type);
            }
        }
        return result;
    }

    protected int getIndexOfOpeningBrakcet(StringBuffer predicate, int start) {
        int cnt = 0;
        int i = start;
        while (i > 0) {
            if (predicate.charAt(i) == '(') {
                --cnt;
            }
            if (predicate.charAt(i) == ')') {
                ++cnt;
            }
            if (cnt == -1) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected int getIndexOfClosingBrakcet(StringBuffer predicate, int start) {
        int cnt = 0;
        int i = start;
        while (i < predicate.length()) {
            if (predicate.charAt(i) == '(') {
                ++cnt;
            }
            if (predicate.charAt(i) == ')') {
                --cnt;
            }
            if (cnt == -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean followedByGetSizeFunction(StringBuffer predicate, int rightIdx) {
        String whatFollows = predicate.substring(rightIdx, Math.min(rightIdx + 7, predicate.length()));
        return whatFollows.equals("().size");
    }

    protected boolean followedByAnIndex(StringBuffer predicate, int rightIdx) {
        String whatFollows = predicate.substring(rightIdx, Math.min(rightIdx + 7, predicate.length()));
        return whatFollows.equals("().get(");
    }

    protected void balanceParenthesis(StringBuffer predicate) {
        int idx;
        ArrayList<Object> stack = new ArrayList<Object>();
        String emptyBraket = "(  )";
        while ((idx = predicate.indexOf(emptyBraket)) != -1) {
            predicate.delete(idx, idx + emptyBraket.length());
        }
        int i = 0;
        while (i < predicate.length()) {
            if (predicate.charAt(i) == '(') {
                if (predicate.indexOf("(\"", i) == i) {
                    i = predicate.indexOf("\")", i + 2) + 2;
                } else {
                    stack.add(new Object());
                }
            } else if (predicate.charAt(i) == ')') {
                if (stack.size() == 0) {
                    predicate.deleteCharAt(i--);
                } else {
                    stack.remove(0);
                }
            }
            ++i;
        }
    }

    protected boolean hasAnIndexAlready(StringBuffer predicate, int rightIdx) {
        String s = predicate.substring(rightIdx += 2, predicate.length());
        int closingPar = s.indexOf(")");
        if (closingPar == -1) {
            return false;
        }
        String possibleCasting = predicate.substring(rightIdx, rightIdx + closingPar);
        return possibleCasting.equals("(int");
    }

    protected NameType isList(String name) {
        NameType type = this.getType(name);
        if (type == null || !type.isList()) {
            return null;
        }
        return type;
    }

    protected NameType getType(String name) {
        name = this.LowerCaseFirstLetter(name);
        NameType type = this.fastXPathContext.getBindingMetaData().getClassNameForElementName(name);
        return type;
    }

    protected String LowerCaseFirstLetter(String name) {
        return name.substring(0, 1).toLowerCase().concat(name.substring(1, name.length()));
    }

    protected ErrorBounds getBounds(String errorMsg) {
        String[] sArr = errorMsg.split(",");
        int from = 0;
        int to = 0;
        if (sArr != null && sArr.length >= 2) {
            from = new Integer(sArr[0]);
            to = new Integer(sArr[1].substring(0, sArr[1].indexOf(":")));
        }
        return new ErrorBounds(from, to);
    }

    protected int getFirstClosingParenthesis(StringBuffer predicate, int start) {
        String s;
        int cnt = 0;
        boolean changed = false;
        int i = start;
        while (i < predicate.length()) {
            if (predicate.charAt(i) == '(') {
                ++cnt;
                changed = true;
            }
            if (predicate.charAt(i) == ')') {
                --cnt;
                changed = true;
            }
            if (cnt == -1) break;
            if (predicate.charAt(i) == ' ' && cnt == 0 && changed) {
                boolean notSpaceMet = false;
                int j = i + 1;
                while (j < predicate.length()) {
                    if (predicate.charAt(j) == ' ') {
                        if (notSpaceMet) {
                            break;
                        }
                    } else {
                        notSpaceMet = true;
                    }
                    ++j;
                }
                if (j != -1) {
                    String s2 = predicate.substring(i, j);
                    if (s2.indexOf("&&") != -1) {
                        return i;
                    }
                    if (s2.indexOf("||") != -1) {
                        return i;
                    }
                    if (s2.indexOf("==") != -1) {
                        return -1;
                    }
                    if (s2.indexOf(".equals") != -1) {
                        return -1;
                    }
                    if (s2.indexOf("!=") != -1) {
                        return -1;
                    }
                    if (s2.indexOf("<") != -1) {
                        return -1;
                    }
                    if (s2.indexOf(">") != -1) {
                        return -1;
                    }
                    if (s2.indexOf("+") != -1) {
                        return -1;
                    }
                    if (s2.indexOf("-") != -1) {
                        return -1;
                    }
                    if (s2.indexOf("*") != -1) {
                        return -1;
                    }
                    if (s2.indexOf("/") != -1) {
                        return -1;
                    }
                    if (s2.indexOf("%") != -1) {
                        return -1;
                    }
                    return i;
                }
            }
            ++i;
        }
        if ((s = predicate.substring(start, i)).indexOf("==") != -1) {
            return -1;
        }
        if (s.indexOf(".equals") != -1) {
            return -1;
        }
        return i;
    }

    protected boolean toBoolCandidate(StringBuffer predicate, int start, int end) {
        String s = predicate.substring(start, end);
        if (s.indexOf("&&") != -1) {
            return true;
        }
        if (s.indexOf("||") != -1) {
            return true;
        }
        return start > 1 && predicate.charAt(start - 1) == '!';
    }

    protected boolean surroundedByToEquals(StringBuffer predicate, int start) {
        if (start >= 8) {
            return predicate.substring(start - 8, start).indexOf("equals") != -1;
        }
        return false;
    }

    protected boolean surroundedByToBool(StringBuffer predicate, int start) {
        if (start >= 8) {
            return predicate.substring(start - 8, start).indexOf(this.toBool) != -1;
        }
        return false;
    }

    protected boolean isWhiteSpace(String s) {
        return s.trim().length() == 0;
    }

    protected int getFirstOpenParenthesis(StringBuffer predicate, int idx) {
        int i = idx;
        while (i >= 0) {
            if (predicate.charAt(i) == '(') {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected void fixStringEquals(StringBuffer predicate) {
        this.fixStringEquals(predicate, 0, 0);
    }

    protected void fixStringEquals(StringBuffer predicate, int start, int firstOp) {
        int lastMethodCallBeginIdx;
        int opIndex = -1;
        int op = firstOp;
        while (op < OPERATORS.length) {
            opIndex = predicate.indexOf(OPERATORS[op], start);
            if (opIndex != -1) break;
            start = 0;
            ++op;
        }
        if (opIndex == -1) {
            return;
        }
        int leftOfEquals = opIndex - 1;
        int rightOfEquals = opIndex + OPERATORS[op].length();
        while (leftOfEquals > -1 && predicate.charAt(leftOfEquals--) == ' ') {
        }
        if (predicate.charAt(++leftOfEquals) == ')' && predicate.charAt(leftOfEquals - 1) == '(' && (lastMethodCallBeginIdx = predicate.substring(0, leftOfEquals - 1).lastIndexOf(".get")) != -1) {
            String getterName = predicate.substring(lastMethodCallBeginIdx + 4, leftOfEquals - 1);
            getterName = this.LowerCaseFirstLetter(getterName);
            this.fixCasting(predicate, op, leftOfEquals, getterName);
        }
        if (predicate.charAt(++leftOfEquals) == ')') {
            while (rightOfEquals < predicate.length() && predicate.charAt(rightOfEquals++) == ' ') {
            }
            if (predicate.charAt(--rightOfEquals) == '\"') {
                int closingQuoteIndx = rightOfEquals + 1;
                while (closingQuoteIndx < predicate.length() && predicate.charAt(closingQuoteIndx++) != '\"') {
                }
                predicate.insert(closingQuoteIndx, ")");
                predicate.replace(leftOfEquals + 1, rightOfEquals, ".equals(");
            }
        } else if (predicate.charAt(leftOfEquals) == '\"') {
            while (rightOfEquals < predicate.length() && predicate.charAt(rightOfEquals++) == ' ') {
            }
            if (predicate.charAt(--rightOfEquals) == 'o') {
                int closingQuoteIndx = rightOfEquals + 1;
                while (closingQuoteIndx < predicate.length() && predicate.charAt(closingQuoteIndx++) != ' ') {
                }
                predicate.insert(--closingQuoteIndx, ")");
                predicate.replace(leftOfEquals + 1, rightOfEquals, ".equals(");
            }
        }
        this.fixStringEquals(predicate, rightOfEquals, op);
    }

    protected char[] fixBadOperatorForStrings2(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String subString = this.sb.substring(bounds.from, bounds.to + 1);
        int idxOfOperator = -1;
        int i = 0;
        while (i < OPERATORS.length) {
            idxOfOperator = subString.indexOf(OPERATORS[i]);
            if (idxOfOperator != -1) {
                idxOfOperator += bounds.from;
                StringTokenizer tokenizer = new StringTokenizer(subString, "() ");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (OPERATORS[i].trim().equals("<")) {
                        String toADD = "-1 == " + token + "()" + ".compareTo" + subString.substring(idxOfOperator - bounds.from + 2).trim();
                        String toReturn = String.valueOf(this.sb.substring(0, bounds.from)) + toADD + this.sb.substring(bounds.to + 1);
                        return toReturn.toCharArray();
                    }
                    if (OPERATORS[i].trim().equals("<=")) {
                        String toADD = "1 > " + token + "()" + ".compareTo" + subString.substring(idxOfOperator - bounds.from + 2).trim();
                        String toReturn = String.valueOf(this.sb.substring(0, bounds.from)) + toADD + this.sb.substring(bounds.to + 1);
                        return toReturn.toCharArray();
                    }
                    if (OPERATORS[i].trim().equals(">")) {
                        String toADD = "1 == " + token + "()" + ".compareTo" + subString.substring(idxOfOperator - bounds.from + 2).trim();
                        String toReturn = String.valueOf(this.sb.substring(0, bounds.from)) + toADD + this.sb.substring(bounds.to + 1);
                        return toReturn.toCharArray();
                    }
                    if (!OPERATORS[i].trim().equals(">=")) continue;
                    String toADD = "-1 < " + token + "()" + ".compareTo" + subString.substring(idxOfOperator - bounds.from + 2).trim();
                    String toReturn = String.valueOf(this.sb.substring(0, bounds.from)) + toADD + this.sb.substring(bounds.to + 1);
                    return toReturn.toCharArray();
                }
            }
            ++i;
        }
        return null;
    }

    protected char[] fixBadMethod(String errorMsg) {
        ErrorBounds bounds = this.getBounds(errorMsg);
        String subString = this.sb.substring(bounds.from, bounds.to + 1);
        String start = "The method";
        String end = "is undefined";
        String method = errorMsg.substring(errorMsg.indexOf(start) + start.length(), errorMsg.indexOf(end)).trim();
        subString = subString.replaceAll(method, "is" + method.substring(3));
        String toReturn = String.valueOf(this.sb.substring(0, bounds.from)) + subString + this.sb.substring(bounds.to + 3);
        return toReturn.toCharArray();
    }

    protected void fixCasting(StringBuffer predicate, int op, int leftOfEquals, String getterName) {
        if (this.isShort(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(short)");
        } else if (this.isInteger(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(int)");
        } else if (this.isFloat(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(float)");
        } else if (this.isDouble(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(double)");
        } else if (this.isLong(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(long)");
        } else if (this.isByte(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(byte)");
        } else if (this.isBoolean(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(boolean)");
        } else if (this.isChar(getterName)) {
            this.addCast(predicate, op, leftOfEquals, "(char)");
        }
    }

    protected void addCast(StringBuffer predicate, int op, int leftOfEquals, String type) {
        int idx = leftOfEquals + 1 + OPERATORS[op].length();
        predicate.insert(idx, type);
        idx += type.length();
        block0: while (++idx < predicate.length()) {
            if (predicate.charAt(idx) == '\"') {
                predicate.deleteCharAt(idx);
                while (++idx < predicate.length()) {
                    if (predicate.charAt(idx) != '\"') continue;
                    predicate.deleteCharAt(idx);
                    break block0;
                }
                break;
            }
            if (predicate.charAt(idx) != ' ') break;
        }
    }

    protected boolean isShort(String getterName) {
        return this.isOfType(getterName, Short.TYPE.getName());
    }

    protected boolean isInteger(String getterName) {
        return this.isOfType(getterName, Integer.TYPE.getName());
    }

    protected boolean isFloat(String getterName) {
        return this.isOfType(getterName, Float.TYPE.getName());
    }

    protected boolean isDouble(String getterName) {
        return this.isOfType(getterName, Double.TYPE.getName());
    }

    protected boolean isLong(String getterName) {
        return this.isOfType(getterName, Long.TYPE.getName());
    }

    protected boolean isByte(String getterName) {
        return this.isOfType(getterName, Byte.TYPE.getName());
    }

    protected boolean isBoolean(String getterName) {
        return this.isOfType(getterName, Boolean.TYPE.getName());
    }

    protected boolean isChar(String getterName) {
        return this.isOfType(getterName, Character.TYPE.getName());
    }

    protected boolean isOfType(String getterName, String className) {
        NameType type = this.getType(getterName);
        if (type == null) {
            return false;
        }
        return type.getClassName().equals(className);
    }

    protected void addToBool(StringBuffer predicate, int i) {
        int openParenthesis;
        int idx = predicate.indexOf("obj.", i);
        if (idx == -1) {
            if (i == 0) {
                idx = predicate.toString().lastIndexOf("(") + 1;
            } else {
                return;
            }
        }
        if ((openParenthesis = this.getFirstOpenParenthesis(predicate, idx)) == -1) {
            int lastPredicateIdx = this.sb.indexOf("$*$*$*$* ");
            if (lastPredicateIdx <= 2) {
                this.sb.insert(0, " (true)");
            } else {
                this.sb.insert(0, "(" + this.toBool + " (");
                this.sb.insert(lastPredicateIdx, ")) ");
            }
            return;
        }
        if (this.toBoolCandidate(predicate, openParenthesis + 1, idx)) {
            int closingParenthesis = this.getFirstClosingParenthesis(predicate, idx);
            if (closingParenthesis == -1) {
                return;
            }
            predicate.insert(closingParenthesis, ")");
            predicate.insert(openParenthesis + 1, String.valueOf(this.toBool) + "(");
            this.addToBool(predicate, closingParenthesis + (String.valueOf(this.toBool) + "(").length());
        }
    }

    public StringBuffer getSb() {
        return this.sb;
    }

    public CompilerPostProcessor setSb(StringBuffer sb) {
        this.sb = sb;
        return this;
    }

    public FastXPathContext getFastXPathContext() {
        return this.fastXPathContext;
    }

    public CompilerPostProcessor setFastXPathContext(FastXPathContext fastXPathContext) {
        this.fastXPathContext = fastXPathContext;
        return this;
    }

    public String getReturnMatch() {
        return this.returnMatch;
    }

    public void setReturnMatch(String returnMatch) {
        this.returnMatch = returnMatch;
    }

    protected class ErrorBounds {
        int from;
        int to;

        ErrorBounds(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }
}

