/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FXPObject;
import org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.BindingMetaData;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.ClassMapping;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.ReflectionHelper;

public class FastXPathContext {
    public static final int ELEMENTS_AND_ATTRIBUTES = 0;
    public static final int ELEMENTS_ONLY = 1;
    public static final int ELEMENTS_ONLY_RECURSIVE = 2;
    public static final int ATTRIBUTES_ONLY = 3;
    public static final int ATTRIBUTES_ONLY_RECURSIVE = 4;
    protected Object object = null;
    protected Object rootObject = null;
    protected String lastQueriedElement = null;
    protected BindingMetaData metaData;
    public static final boolean FOLLOWING_DIRECTION = true;
    public static final boolean PRECEDING_DIRECTION = false;
    protected String m_id = null;
    protected IFastXPathEngine eApi;
    protected HashMap ancestorTree = new HashMap();
    protected LinkedList stack;
    protected static Object stub = new Object();

    public FastXPathContext(Object object, IFastXPathEngine api) {
        this.object = object;
        this.rootObject = object;
        this.eApi = api;
        this.stack = new LinkedList();
    }

    public FastXPathContext() {
    }

    public FastXPathContext createContext(Object obj) {
        FastXPathContext newContext = new FastXPathContext(obj, this.eApi);
        if (this.rootObject == null) {
            newContext.setRootObject(obj);
        } else {
            newContext.setRootObject(this.rootObject);
        }
        newContext.stack = this.stack;
        newContext.metaData = this.metaData;
        newContext.ancestorTree = this.ancestorTree;
        return newContext;
    }

    public FastXPathContext createFreshContext() {
        FastXPathContext context = this.createContext(this.rootObject);
        context.stack.clear();
        return context;
    }

    public Object[] get(String name, int queryType) throws ExpressionEvaluationException {
        return this.get(this.object, name, queryType);
    }

    public Object[] get(String name) throws ExpressionEvaluationException {
        return this.get(this.object, name, 0);
    }

    public Object[] getAll(String name, int queryType, boolean addObj) throws ExpressionEvaluationException {
        return this.optimizedGetAll(this.object, name, queryType, addObj);
    }

    public String getId() throws ExpressionEvaluationException {
        return this.getId(this.object);
    }

    public Object[] getAttribute(String name, int queryType) throws ExpressionEvaluationException {
        if (queryType == 3) {
            return this.get(name, 3);
        }
        Object[] allElements = this.getDescendantOrSelf("*", 2);
        ArrayList<FXPObject> list = new ArrayList<FXPObject>();
        int i = 0;
        while (i < allElements.length) {
            Object[] tmpArr = this.get(allElements[i], name, 3);
            int j = 0;
            while (j < tmpArr.length) {
                list.add(new FXPObject(tmpArr[j], allElements[i], j + 1, name));
                ++j;
            }
            ++i;
        }
        return list.toArray();
    }

    public Object[] getFollowing(String name, int queryType) throws ExpressionEvaluationException {
        return this.getSibling(this.object, name, queryType, true);
    }

    public Object[] getFollowingSibling(String name) throws ExpressionEvaluationException {
        return this.getSibling(this.object, name, 2, true);
    }

    public Object[] getPreceding(String name) throws ExpressionEvaluationException {
        return this.getSibling(this.object, name, 2, false);
    }

    public Object[] getPrecedingSibling(String name, int queryType) throws ExpressionEvaluationException {
        return this.getSibling(this.object, name, queryType, false);
    }

    public Object[] getDescendant(String name, int queryType) throws ExpressionEvaluationException {
        return this.optimizedGetAll(this.object, name, queryType, false);
    }

    public Object[] getDescendantOrSelf(String name, int queryType) throws ExpressionEvaluationException {
        return this.optimizedGetAll(this.object, name, queryType, true);
    }

    public Object[] getAncestor(String name, int queryType, boolean includeSelf) throws ExpressionEvaluationException {
        boolean checkName = !name.equals("*");
        HashSet<Object> set = new HashSet<Object>();
        if (queryType == 2) {
            Object[] allElements = this.getDescendantOrSelf(name, queryType);
            int i = 0;
            while (i < allElements.length) {
                set.add(allElements[i]);
                ++i;
            }
        }
        HashSet<Object> resultSet = new HashSet<Object>();
        if (includeSelf && queryType != 2) {
            if (!checkName || name.equals(this.getId(this.object))) {
                set.add(this.object);
            }
            resultSet.add(this.object);
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            Object parent = null;
            while (child instanceof FXPObject && (parent = ((FXPObject)child).parent) != null) {
                if (!checkName || name.equals(this.getId(child))) {
                    resultSet.add(parent);
                }
                child = parent;
            }
        }
        return set.toArray();
    }

    public Object[] getAncestor(String name, int queryType) throws ExpressionEvaluationException {
        return this.getAncestor(name, queryType, false);
    }

    public Object[] getAncestorOrSelf(String name, int queryType) throws ExpressionEvaluationException {
        return this.getAncestor(name, queryType, true);
    }

    public Object[] getSelf(String name) throws ExpressionEvaluationException {
        if (name.equals("*") || name.equals(this.getId()) || this.object == this.rootObject) {
            return new Object[]{this.object};
        }
        return new Object[0];
    }

    public Object[] getSelf() {
        return new Object[]{this.object};
    }

    public Object[] getParent() {
        return this.getParent(this.object);
    }

    public Object[] getParent(Object obj) {
        Object[] objectArray;
        Object parent = this.ancestorTree.get(obj);
        if (parent == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = parent;
        }
        return objectArray;
    }

    public Object[] getChild(String name, int queryType) throws ExpressionEvaluationException {
        return this.getChild(this.object, name, queryType);
    }

    private Object[] get(Object obj, String name) throws ExpressionEvaluationException {
        return this.get(obj, name, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] get(Object obj, String name, int queryType) throws ExpressionEvaluationException {
        Object history = obj;
        while (obj instanceof FXPObject) {
            obj = ((FXPObject)obj).getVal();
        }
        ClassMapping classMapping = this.metaData.getClassMapping(obj);
        Object[] result = null;
        if (name.equals("*")) {
            if (queryType == 3) {
                result = this.multipleGetter(obj, classMapping, this.metaData.getAttributes(obj));
            } else if (this.stack.size() != 0) {
                result = this.multipleGetter(obj, classMapping, this.metaData.getElements(obj));
            } else if (obj == this.rootObject) {
                result = new Object[]{obj};
            }
        } else {
            ReflectionHelper helper = null;
            try {
                helper = this.metaData.getReflectionHelper(obj);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException(e);
            }
            switch (queryType) {
                case 1: 
                case 2: {
                    result = helper.getElement(obj, name);
                    if (result != null && result.length != 0 || obj == this.rootObject) break;
                    result = helper.getAttribute(obj, name);
                    break;
                }
                case 3: {
                    result = helper.getAttribute(obj, name);
                    break;
                }
                default: {
                    result = helper.get(obj, name);
                }
            }
            if (result == null) {
                if (obj == this.rootObject && obj.getClass().getName().endsWith(String.valueOf(name) + "Impl")) {
                    result = new Object[]{new FXPObject(obj, null, 1, name)};
                } else {
                    if (queryType != 2 && queryType != 4) throw new ExpressionEvaluationException();
                    result = new Object[]{};
                }
            } else {
                if (!helper.isSet(obj, name)) {
                    result = new Object[]{};
                }
                Object[] fxObjectArray = new Object[result.length];
                int i = 0;
                while (i < result.length) {
                    fxObjectArray[i] = new FXPObject(result[i], obj, i + 1, name);
                    this.ancestorTree.put(fxObjectArray[i], history);
                    ++i;
                }
                result = fxObjectArray;
            }
        }
        this.stack.addFirst(stub);
        return result;
    }

    private Object[] multipleGetter(Object obj, ClassMapping classMapping, String[] elements) throws ExpressionEvaluationException {
        ArrayList<FXPObject> list = new ArrayList<FXPObject>();
        int validCnt = 1;
        int i = 0;
        while (i < elements.length) {
            ReflectionHelper helper = null;
            try {
                helper = this.metaData.getReflectionHelper(obj);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException(e);
            }
            Object[] objArr = helper.get(obj, elements[i]);
            int j = 0;
            while (j < objArr.length) {
                if (helper.isSet(obj, elements[i])) {
                    this.ancestorTree.put(objArr[j], obj);
                    list.add(new FXPObject(objArr[j], obj, validCnt++, elements[i]));
                }
                ++j;
            }
            ++i;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element != null) continue;
            iter.remove();
        }
        return list.toArray();
    }

    private String getId(Object obj) throws ExpressionEvaluationException {
        if (obj instanceof FXPObject) {
            return ((FXPObject)this.object).getRefId();
        }
        if (obj == this.object) {
            if (this.m_id == null) {
                this.m_id = this.obtainId(this.object);
            }
            return this.m_id;
        }
        return this.obtainId(obj);
    }

    private String obtainId(Object obj) throws ExpressionEvaluationException {
        Object[] oArr;
        Object container2 = this.ancestorTree.get(obj);
        if (container2 == null) {
            String name = obj.getClass().getName();
            int indexOfDot = name.lastIndexOf(".");
            return indexOfDot == -1 ? name : name.substring(name.indexOf(".") + 1);
        }
        if (this.lastQueriedElement != null && (oArr = this.get(container2, this.lastQueriedElement)).length > 0 && oArr[0] == obj) {
            return this.lastQueriedElement;
        }
        String[] elements = this.metaData.getElements(container2);
        String isElement = this.isInContainer(obj, container2, elements);
        return isElement.equals("") ? this.isInContainer(obj, container2, this.metaData.getAttributes(container2)) : isElement;
    }

    private String isInContainer(Object obj, Object container2, String[] elements) throws ExpressionEvaluationException {
        int i = 0;
        while (i < elements.length) {
            Object[] arr = this.get(container2, elements[i]);
            int j = 0;
            while (j < arr.length) {
                if (arr[j] == obj) {
                    this.lastQueriedElement = elements[i];
                    return this.lastQueriedElement;
                }
                ++j;
            }
            ++i;
        }
        return "";
    }

    private Object[] optimizedGetAll(Object obj, String name, int queryType, boolean addSelf) throws ExpressionEvaluationException {
        HashSet<Object> list = new HashSet<Object>();
        Object[] thisLevelArr = this.get(obj, name, queryType);
        int i = 0;
        while (i < thisLevelArr.length) {
            if (thisLevelArr[i] != obj || addSelf) {
                ((AbstractCollection)list).add(new FXPObject(thisLevelArr[i], obj, i + 1, name));
            }
            ++i;
        }
        if (name.equals("*")) {
            String[] elementNames = this.metaData.getElements(obj);
            int elemCnt = 1;
            int i2 = 0;
            while (i2 < elementNames.length) {
                Object[] oArr = this.get(obj, elementNames[i2], 1);
                int cfr_ignored_0 = oArr.length;
                int j = 0;
                while (j < oArr.length) {
                    if (oArr[j] != null) {
                        ((FXPObject)oArr[j]).setPosition(elemCnt++);
                        ((AbstractCollection)list).add(oArr[j]);
                        Object[] tmpArr = this.optimizedGetAll(oArr[j], name, queryType, false);
                        int k = 0;
                        while (k < tmpArr.length) {
                            ((FXPObject)tmpArr[k]).setPosition(k + 1);
                            ((AbstractCollection)list).add(tmpArr[k]);
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            return ((AbstractCollection)list).toArray();
        }
        Set recursiveElementNames = this.metaData.getRecursiveElements(name);
        if (recursiveElementNames == null) {
            return ((AbstractCollection)list).toArray();
        }
        ArrayList rElementNames = new ArrayList();
        rElementNames.addAll(recursiveElementNames);
        int i3 = 0;
        while (i3 < rElementNames.size()) {
            String s = (String)rElementNames.get(i3);
            Object[] oArr = this.get(obj, s, 2);
            if (oArr.length == 0 && !s.equals(name)) {
                oArr = this.optimizedGetAll(obj, s, queryType, false);
            }
            int j = 0;
            while (j < oArr.length) {
                if (oArr[j] != obj) {
                    Object[] tmpArr = this.optimizedGetAll(oArr[j], name, queryType, false);
                    int k = 0;
                    while (k < tmpArr.length) {
                        ((AbstractCollection)list).add(tmpArr[k]);
                        ++k;
                    }
                }
                ++j;
            }
            ++i3;
        }
        return ((AbstractCollection)list).toArray();
    }

    private Object[] getChild(Object obj, String name, int queryType) throws ExpressionEvaluationException {
        return queryType == 2 ? this.optimizedGetAll(this.object, name, queryType, false) : this.get(obj, name, queryType);
    }

    private Object[] getSibling(Object obj, String name, int queryType, boolean direction) throws ExpressionEvaluationException {
        Object[] parentArr;
        Object parent = null;
        ArrayList resultVec = new ArrayList();
        while ((parentArr = this.getParent(obj)) != null && parentArr.length > 0 && (parent = parentArr[0]) != null) {
            String[] elements;
            int i;
            if (parent == null) {
                return new Object[0];
            }
            Object parentVal = parent;
            if (parent instanceof FXPObject) {
                parentVal = ((FXPObject)parent).val;
            }
            if ((i = this.getPositionInElements(obj, elements = this.metaData.getElements(parentVal))) == -1) {
                return new Object[0];
            }
            Object[] tmpArr = this.getChild(parent, elements[i], 1);
            if (direction) {
                this.fillSiblingVector(this.getPositionInElements(obj, tmpArr) + 1, tmpArr.length, tmpArr, name, queryType, resultVec);
            } else {
                this.fillSiblingVector(-1, this.getPositionInElements(obj, tmpArr), tmpArr, name, queryType, resultVec);
            }
            if (direction) {
                this.fillSiblingVector(i + 1, elements.length, elements, name, queryType, parent, resultVec);
            } else {
                this.fillSiblingVector(i - 1, -1, elements, name, queryType, parent, resultVec);
            }
            if (queryType == 2) {
                obj = parent;
                continue;
            }
            return resultVec.toArray();
        }
        return resultVec.toArray();
    }

    private void fillSiblingVector(int start, int finish, Object[] tmpArr, String name, int queryType, ArrayList resultVec) throws ExpressionEvaluationException {
        boolean checkName;
        int inc = 1;
        boolean bl = checkName = !name.equals("*");
        if (start > finish) {
            inc = -1;
            --finish;
        }
        for (int i = start; i != finish && i >= 0; i += inc) {
            if (!checkName || name.equals(this.getId(tmpArr[i]))) {
                resultVec.add(tmpArr[i]);
            }
            if (queryType != 2) continue;
            Object[] tmpArr2 = this.optimizedGetAll(tmpArr[i], name, 2, false);
            int j = 0;
            while (j < tmpArr2.length) {
                if (!checkName || name.equals(this.getId(tmpArr2[j]))) {
                    resultVec.add(tmpArr2[j]);
                }
                ++j;
            }
        }
    }

    private void fillSiblingVector(int start, int finish, String[] elements, String name, int queryType, Object parent, ArrayList resultVec) throws ExpressionEvaluationException {
        boolean checkName;
        if (start < 0 || start > elements.length) {
            return;
        }
        int inc = 1;
        boolean bl = checkName = !name.equals("*");
        if (start > finish) {
            inc = -1;
            --finish;
        }
        for (int i = start; i != finish && i >= 0; i += inc) {
            Object[] tmpArr = this.getChild(parent, elements[i], 1);
            int j = 0;
            while (j < tmpArr.length) {
                if (!checkName || name.equals(this.getId(tmpArr[j]))) {
                    resultVec.add(tmpArr[j]);
                }
                if (queryType == 2) {
                    Object[] tmpArr2 = this.optimizedGetAll(tmpArr[j], name, 2, false);
                    int k = 0;
                    while (k < tmpArr2.length) {
                        if (!checkName || name.equals(this.getId(tmpArr2[k]))) {
                            resultVec.add(tmpArr2[k]);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
    }

    private int getPositionInElements(Object obj, String[] elements) throws ExpressionEvaluationException {
        String myName = this.getId(obj);
        int i = 0;
        while (i < elements.length) {
            if (myName.equals(elements[i])) {
                return i;
            }
            ++i;
        }
        if (i == elements.length) {
            return -1;
        }
        return -1;
    }

    private int getPositionInElements(Object obj, Object[] objArr) {
        int i = 0;
        while (i < objArr.length) {
            if (obj == objArr[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getObject() {
        return this.object;
    }

    public Object getRootObject() {
        return this.rootObject;
    }

    public IFastXPathEngine getEngine() {
        return this.eApi;
    }

    public void setEngine(IFastXPathEngine api) {
        this.eApi = api;
    }

    private void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
    }

    public BindingMetaData getBindingMetaData() {
        return this.metaData;
    }

    public void setBindingMetaData(BindingMetaData metaData) {
        this.metaData = metaData;
    }

    public void resetState() {
        this.m_id = null;
        this.ancestorTree.clear();
        this.lastQueriedElement = null;
        this.stack.clear();
    }
}

