/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.eclipse.hyades.models.hierarchy.util.ModelDebugger;
import org.eclipse.tptp.platform.provisional.fastxpath.ByteCodeInfo;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContextFactory;
import org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerNotAvailableException;

public class FastXPathAPI {
    public static final String FXP_BINDING_FACTORY = "FXP_BINDING_FACTORY";
    public static final String FXP_BINDING_FACTORY_DEFAULT = "org.eclipse.tptp.platform.provisional.fastxpath.emf.EMFFastXPathContextFactory";
    public static String bindingFactory = "org.eclipse.tptp.platform.provisional.fastxpath.emf.EMFFastXPathContextFactory";
    public static final CompiledExpressionEvaluator FAILED_COMPILATION_STUB = new CompiledExpressionEvaluator(){

        public Object eval(Object object, IFastXPathEngine fastXPathEngine) {
            return null;
        }
    };
    protected IFastXPathEngine fastXPathEngine = null;
    protected Map compiledXpathExpressions = new HashMap();
    protected Map xPathByteCodeIndex = new HashMap();
    protected boolean compileExpressions = true;
    protected boolean useSerializedByteCodeCache = true;
    protected File serializedCache = null;
    protected FileChannel serializedCacheChannel = null;
    protected ByteBuffer writeByteBuffer = null;
    protected byte[] writeBuffer = null;
    protected byte[] readBuffer = null;
    protected ByteBuffer readByteBuffer = null;
    protected long currentSerializedCacheOffset = 0L;
    private boolean isSerializedCacheDirty = false;

    static {
        bindingFactory = System.getProperty(FXP_BINDING_FACTORY);
        if (bindingFactory == null) {
            bindingFactory = FXP_BINDING_FACTORY_DEFAULT;
        }
    }

    public FastXPathAPI(FastXPathContextFactory factory) throws InstantiationException {
        if (factory == null) {
            try {
                factory = (FastXPathContextFactory)this.getClass().getClassLoader().loadClass(bindingFactory).newInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException("Error initializing " + bindingFactory);
            }
        }
        Class<?> c = null;
        int mode = 0;
        try {
            c = this.getClass().getClassLoader().loadClass("org.apache.xpath.XPathAPI");
            c.newInstance();
            mode = 1;
        }
        catch (Throwable throwable) {
            try {
                c = this.getClass().getClassLoader().loadClass("com.sun.org.apache.xpath.internal.XPathAPI");
                c.newInstance();
                mode = 2;
            }
            catch (Throwable e1) {
                throw new InstantiationException("Error initializing FastXPathEngine: " + e1.getCause());
            }
        }
        if (mode == 1) {
            try {
                c = this.getClass().getClassLoader().loadClass("org.eclipse.tptp.platform.provisional.jre14.fastxpath.FastXPathEngine");
                this.fastXPathEngine = (IFastXPathEngine)c.newInstance();
            }
            catch (Throwable e1) {
                throw new InstantiationException("Error initializing FastXPathEngine: " + e1.getCause());
            }
        }
        if (mode == 2) {
            try {
                c = this.getClass().getClassLoader().loadClass("org.eclipse.tptp.platform.provisional.sun50.fastxpath.FastXPathEngine");
                this.fastXPathEngine = (IFastXPathEngine)c.newInstance();
            }
            catch (Throwable e1) {
                throw new InstantiationException("Error initializing FastXPathEngine: " + e1.getCause());
            }
        }
        if (this.fastXPathEngine != null) {
            this.fastXPathEngine.setFastXPathContextFactory(factory);
        }
    }

    public boolean match(Object obj, String xpathExpr) throws TransformerException, ExpressionEvaluationException {
        return this.eval(obj, xpathExpr) == obj;
    }

    public Object eval(Object obj, String xpathExpr) throws TransformerException, ExpressionEvaluationException {
        if (this.compileExpressions) {
            CompiledExpressionEvaluator compiledEvaluator = this.getCompiledExpressionEvaluator(obj, xpathExpr);
            if (compiledEvaluator != null && FAILED_COMPILATION_STUB != compiledEvaluator) {
                try {
                    return this.fastXPathEngine.evalCompiled(compiledEvaluator, obj);
                }
                catch (NullPointerException nullPointerException) {
                    if (ModelDebugger.INSTANCE.debug) {
                        System.out.println("NPE in the compiled expression: " + xpathExpr);
                    }
                }
            } else if (ModelDebugger.INSTANCE.debug) {
                System.out.println("Failed to compile expression: " + xpathExpr);
            }
        }
        return this.fastXPathEngine.eval(xpathExpr, obj);
    }

    public Object[] selectNodes(Object obj, String xpathExpr) throws TransformerException, ExpressionEvaluationException {
        return this.fastXPathEngine.selectNodes(xpathExpr, obj);
    }

    public boolean setCompile(boolean compileExpressions) {
        boolean oldMode = this.compileExpressions;
        this.compileExpressions = compileExpressions;
        return oldMode;
    }

    public CompiledExpressionEvaluator getCompiledExpressionEvaluator(Object obj, String queryExpr) {
        CompiledExpressionEvaluator compiledEvaluator = (CompiledExpressionEvaluator)this.compiledXpathExpressions.get(queryExpr);
        if (compiledEvaluator == null) {
            try {
                if (this.useSerializedByteCodeCache && this.writeByteBuffer != null) {
                    ByteCodeInfo info = (ByteCodeInfo)this.xPathByteCodeIndex.get(queryExpr);
                    if (info != null) {
                        this.readByteBuffer = ByteBuffer.allocate(info.getLenght());
                        this.serializedCacheChannel.read(this.readByteBuffer, info.getOffset());
                        compiledEvaluator = this.createCompiledExpressionEvaluator(this.readByteBuffer.array(), queryExpr);
                    } else {
                        compiledEvaluator = this.fastXPathEngine.compile(queryExpr, obj, null);
                        if (compiledEvaluator == null) {
                            compiledEvaluator = FAILED_COMPILATION_STUB;
                        }
                        byte[] byteCode = (byte[])this.fastXPathEngine.getClassesAsByteArrays().get(queryExpr);
                        info = new ByteCodeInfo();
                        info.setLenght(byteCode.length);
                        info.setOffset(this.currentSerializedCacheOffset);
                        this.writeByteBuffer.clear();
                        this.writeByteBuffer.put(byteCode, 0, byteCode.length);
                        this.writeByteBuffer.limit(byteCode.length);
                        this.writeByteBuffer.flip();
                        this.serializedCacheChannel.write(this.writeByteBuffer);
                        this.isSerializedCacheDirty = true;
                        this.xPathByteCodeIndex.put(queryExpr, info);
                        this.fastXPathEngine.getClassesAsByteArrays().remove(queryExpr);
                        this.currentSerializedCacheOffset += (long)byteCode.length;
                    }
                } else {
                    compiledEvaluator = this.fastXPathEngine.compile(queryExpr, obj, null);
                    if (compiledEvaluator == null) {
                        compiledEvaluator = FAILED_COMPILATION_STUB;
                    }
                }
            }
            catch (Exception exception) {
                compiledEvaluator = FAILED_COMPILATION_STUB;
            }
            this.compiledXpathExpressions.put(queryExpr, compiledEvaluator);
        }
        return compiledEvaluator;
    }

    public IFastXPathEngine getFastXPathEngine() {
        return this.fastXPathEngine;
    }

    public void storeCompiledExpressions(File file) throws FileNotFoundException, IOException, CodeGenerationError {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        if (!this.useSerializedByteCodeCache) {
            HashMap expressionsToClassBytes = new HashMap();
            Map classesAsBytes = this.fastXPathEngine.getClassesAsByteArrays();
            Iterator iter = classesAsBytes.keySet().iterator();
            while (iter.hasNext()) {
                String xpath = (String)iter.next();
                expressionsToClassBytes.put(xpath, classesAsBytes.get(xpath));
            }
            objectOutputStream.writeObject(expressionsToClassBytes);
        } else {
            objectOutputStream.writeObject(this.xPathByteCodeIndex);
            if (this.isSerializedCacheDirty) {
                this.writeByteBuffer.flip();
                this.serializedCacheChannel.write(this.writeByteBuffer);
                this.isSerializedCacheDirty = false;
                this.serializedCacheChannel.close();
            }
        }
        objectOutputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadCompiledExpressions(File file) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, CodeGenerationError, CompilerNotAvailableException {
        ObjectInputStream inputStream;
        block15: {
            StringBuffer serializedCachePath2;
            inputStream = null;
            try {
                try {
                    inputStream = new ObjectInputStream(new FileInputStream(file));
                    if (this.useSerializedByteCodeCache) {
                        this.xPathByteCodeIndex = (HashMap)inputStream.readObject();
                    } else {
                        HashMap expressionsToClassBytes = (HashMap)inputStream.readObject();
                        Iterator iter = expressionsToClassBytes.keySet().iterator();
                        while (iter.hasNext()) {
                            String xpath = (String)iter.next();
                            CompiledExpressionEvaluator evaluator = this.createCompiledExpressionEvaluator(expressionsToClassBytes, xpath);
                            this.compiledXpathExpressions.put(xpath, evaluator);
                        }
                    }
                }
                catch (EOFException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (this.useSerializedByteCodeCache) {
                    StringBuffer serializedCachePath2 = new StringBuffer();
                    serializedCachePath2.append(file.getParent());
                    serializedCachePath2.append(File.separator);
                    int idx = file.getName().lastIndexOf(".");
                    if (idx >= 0) {
                        serializedCachePath2.append(file.getName().substring(0, idx));
                    } else {
                        serializedCachePath2.append(file.getName());
                    }
                    serializedCachePath2.append("_");
                    serializedCachePath2.append("byteCode");
                    serializedCachePath2.append(".dat");
                    File serializedCache = new File(serializedCachePath2.toString());
                    if (!serializedCache.exists()) {
                        serializedCache.createNewFile();
                    }
                    this.serializedCacheChannel = new RandomAccessFile(serializedCache, "rw").getChannel();
                    this.writeByteBuffer = ByteBuffer.allocate(65536);
                    this.currentSerializedCacheOffset = serializedCache.length();
                    this.serializedCacheChannel.position(this.currentSerializedCacheOffset);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (!this.useSerializedByteCodeCache) break block15;
                serializedCachePath2 = new StringBuffer();
                serializedCachePath2.append(file.getParent());
            }
            serializedCachePath2.append(File.separator);
            int idx = file.getName().lastIndexOf(".");
            if (idx >= 0) {
                serializedCachePath2.append(file.getName().substring(0, idx));
            } else {
                serializedCachePath2.append(file.getName());
            }
            serializedCachePath2.append("_");
            serializedCachePath2.append("byteCode");
            serializedCachePath2.append(".dat");
            File serializedCache = new File(serializedCachePath2.toString());
            if (!serializedCache.exists()) {
                serializedCache.createNewFile();
            }
            this.serializedCacheChannel = new RandomAccessFile(serializedCache, "rw").getChannel();
            this.writeByteBuffer = ByteBuffer.allocate(65536);
            this.currentSerializedCacheOffset = serializedCache.length();
            this.serializedCacheChannel.position(this.currentSerializedCacheOffset);
        }
        if (inputStream == null) return;
        inputStream.close();
    }

    private CompiledExpressionEvaluator createCompiledExpressionEvaluator(Map expressionsToClassBytes, String xpath) throws ClassNotFoundException, CodeGenerationError, CompilerNotAvailableException, InstantiationException, IllegalAccessException {
        Class evaluatorClass = this.fastXPathEngine.getClassGenerator().generateClass((byte[])expressionsToClassBytes.get(xpath));
        CompiledExpressionEvaluator evaluator = (CompiledExpressionEvaluator)evaluatorClass.newInstance();
        return evaluator;
    }

    private CompiledExpressionEvaluator createCompiledExpressionEvaluator(byte[] byteCode, String xpath) throws ClassNotFoundException, CodeGenerationError, CompilerNotAvailableException, InstantiationException, IllegalAccessException {
        Class evaluatorClass = this.fastXPathEngine.getClassGenerator().generateClass(byteCode);
        CompiledExpressionEvaluator evaluator = (CompiledExpressionEvaluator)evaluatorClass.newInstance();
        return evaluator;
    }

    public void setUseSerializedByteCode(boolean newVal) {
        this.useSerializedByteCodeCache = newVal;
    }

    public boolean useSerializedByteCode() {
        return this.useSerializedByteCodeCache;
    }
}

