/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.test;

import java.io.IOException;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.NamedPipeInputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.NamedPipeOutputStream;

public class TestNamedPipe {
    private String _ns = "TPTP_NS";
    private String _npName = "PIPE_TEST";
    private NamedPipeOutputStream _npOut;
    private NamedPipeInputStream _npIn;
    private boolean _done = false;
    private int _iterations = 100000;

    public static void main(String[] args) {
        TestNamedPipe t = new TestNamedPipe();
        t.test01();
    }

    public void test01() {
        TestInputThread tin = new TestInputThread();
        TestOutputThread tout = new TestOutputThread();
        tin.start();
        tout.start();
        try {
            tout.join();
            this._done = true;
            tin.interrupt();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    class TestInputThread
    extends Thread {
        private byte[] buffer = new byte[1024];

        public TestInputThread() {
            this.setName("Input Thread");
            TestNamedPipe.this._npIn = new NamedPipeInputStream(TestNamedPipe.this._ns, TestNamedPipe.this._npName);
        }

        public void interrupt() {
            super.interrupt();
            try {
                TestNamedPipe.this._npIn.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void run() {
            int totalByteReceived = 0;
            while (!TestNamedPipe.this._done) {
                try {
                    TestNamedPipe.this._npIn.connect();
                    int byteReceived = TestNamedPipe.this._npIn.read(this.buffer);
                    TestNamedPipe.this._npIn.disconnect();
                    totalByteReceived += byteReceived;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Total byte received = " + totalByteReceived);
            try {
                TestNamedPipe.this._npIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class TestOutputThread
    extends Thread {
        public TestOutputThread() {
            this.setName("Output Thread ");
            TestNamedPipe.this._npOut = new NamedPipeOutputStream(TestNamedPipe.this._ns, TestNamedPipe.this._npName);
        }

        public void run() {
            int totalByteSent = 0;
            int i = 0;
            while (i < TestNamedPipe.this._iterations) {
                String str = new String("iteration " + i);
                try {
                    byte[] b = str.getBytes();
                    TestNamedPipe.this._npOut.open();
                    TestNamedPipe.this._npOut.write(b);
                    TestNamedPipe.this._npOut.close();
                    totalByteSent += b.length;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            System.out.println("Total byte sent = " + totalByteSent);
        }
    }
}

