/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.hyades.collection.framework.channel.DataChannelHelper;
import org.eclipse.hyades.collection.framework.channel.DataChannelImpl;
import org.eclipse.hyades.execution.core.DataChannelConnectionException;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class SharedMemoryOutputStream
extends OutputStream {
    private static boolean _nativeAvailable = false;
    private String _shmName;
    private DataChannelImpl _dataChannel = null;

    static {
        try {
            System.loadLibrary("tptpShm");
            _nativeAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            TPTPLoggerImpl.log(0, "Cannot load native library: tptpNP");
        }
        catch (SecurityException securityException) {
            TPTPLoggerImpl.log(0, "Not allowed to load native library: tptpNP");
        }
    }

    public SharedMemoryOutputStream(String name) {
        this._shmName = name;
        if (_nativeAvailable) {
            DataChannelHelper helper = new DataChannelHelper();
            try {
                this._dataChannel = helper.connectToDataChannel(this._shmName);
                this._dataChannel.setFillable();
            }
            catch (DataChannelConnectionException dataChannelConnectionException) {
                TPTPLoggerImpl.log(0, "Cannot connect to shared memory: " + name);
            }
            catch (InvalidDataChannelAccessException invalidDataChannelAccessException) {
                TPTPLoggerImpl.log(0, "Cannot change shared memory access to fillable: " + name);
            }
        }
    }

    public void close() throws IOException {
        if (!_nativeAvailable) {
            throw new IOException();
        }
        this._dataChannel.disconnect();
        this._dataChannel = null;
    }

    public void flush() throws IOException {
    }

    public void write(byte[] b) throws IOException {
        if (_nativeAvailable && this._dataChannel != null) {
            try {
                this._dataChannel.write(b);
            }
            catch (InvalidDataChannelAccessException e) {
                e.printStackTrace();
            }
        } else {
            throw new IOException();
        }
    }

    public void write(int arg0) throws IOException {
        byte[] b = new byte[]{(byte)arg0};
        this.write(b);
    }
}

