/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.hyades.collection.framework.channel.DataChannelHelper;
import org.eclipse.hyades.collection.framework.channel.DataChannelImpl;
import org.eclipse.hyades.execution.core.DataChannelCreationException;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class SharedMemoryInputStream
extends InputStream {
    protected static final int WAIT_TIME = 1000;
    private byte[] inBuf;
    private boolean closed = false;
    private int inCount;
    private long inTotalLength;
    private int inPos;
    private static boolean _nativeAvailable = false;
    private DataChannelImpl _dataChannel = null;

    static {
        try {
            System.loadLibrary("tptpShm");
            _nativeAvailable = true;
        }
        catch (UnsatisfiedLinkError e1) {
            TPTPLoggerImpl.log(0, "Cannot load native library: " + e1.getMessage());
        }
        catch (SecurityException e2) {
            TPTPLoggerImpl.log(0, "Not allowed to load native library: " + e2.getMessage());
        }
    }

    public SharedMemoryInputStream(String name) {
        int dataChannelSize = ExecutionPlugin.getInstance().getInt(ACStrings.PREF_SHARED_MEMORY_SIZE);
        this.inCount = 0;
        this.inPos = 0;
        if (_nativeAvailable) {
            DataChannelHelper helper = new DataChannelHelper();
            try {
                this._dataChannel = helper.createDataChannel(name, dataChannelSize * 1024 * 1024);
                this._dataChannel.setFlushable();
                this._dataChannel.startFlushingToStream(new OutputStream(){

                    public void write(int b) throws IOException {
                        System.out.println(".write() - not supported");
                    }

                    public void write(byte[] b) throws IOException {
                        SharedMemoryInputStream.this.writeBuf(b, 0, b.length);
                    }

                    public void write(byte[] b, int off, int len) throws IOException {
                        SharedMemoryInputStream.this.writeBuf(b, off, len);
                    }

                    public void close() throws IOException {
                        super.close();
                    }

                    public void flush() throws IOException {
                        super.flush();
                    }
                });
                TPTPLoggerImpl.log(3, "Created shared memory buffer: " + name + " of size: " + dataChannelSize + " MB");
            }
            catch (DataChannelCreationException e) {
                TPTPLoggerImpl.log(0, "Cannot create shared memory: " + name + ", " + e.getMessage());
            }
            catch (InvalidDataChannelAccessException e) {
                TPTPLoggerImpl.log(0, "Cannot change shared memory access to flushable: " + name + ", " + e.getMessage());
            }
        }
    }

    protected synchronized void makeOpened() {
        this.inBuf = null;
        this.inCount = 0;
        this.inPos = 0;
        this.closed = false;
        this.notifyAll();
    }

    public synchronized int available() throws IOException {
        this.waitForNewData();
        return this.inCount;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public synchronized boolean hasEmptyBuffer() {
        return this.inCount == 0;
    }

    public synchronized void mark(int arg0) {
        super.mark(arg0);
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        --this.inCount;
        return this.inBuf[this.inPos++];
    }

    public synchronized int read(byte[] outBuf, int offset, int length) throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        int readBytes = Math.min(this.inCount, length);
        System.arraycopy(this.inBuf, this.inPos, outBuf, offset, readBytes);
        this.inPos += readBytes;
        this.inCount -= readBytes;
        TPTPLoggerImpl.logData(outBuf, offset + 10, readBytes - 10);
        return readBytes;
    }

    public int read(byte[] arg0) throws IOException {
        return this.read(arg0, 0, arg0.length);
    }

    public synchronized void reset() throws IOException {
        super.reset();
    }

    public synchronized long skip(long arg0) throws IOException {
        if ((arg0 += (long)this.inPos) < this.inTotalLength) {
            this.inPos = (int)arg0;
            return arg0;
        }
        return -1L;
    }

    public synchronized void writeBuf(byte[] buf, int offset, int length) {
        if (buf == null || length == 0) {
            return;
        }
        this.inBuf = buf;
        this.inPos = offset;
        this.inTotalLength += (long)length;
        this.inCount = length;
        this.notifyAll();
        this.waitForEmptyBuffer();
    }

    protected synchronized void makeClosed() {
        this.inBuf = null;
        this.inCount = 0;
        this.inPos = 0;
        this.closed = true;
        this.notifyAll();
    }

    private void waitForEmptyBuffer() {
        while (!this.hasEmptyBuffer() && !this.closed) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                if (!this.hasEmptyBuffer() && !this.closed) continue;
                return;
            }
        }
    }

    private synchronized void waitForNewData() {
        boolean notify = true;
        while (this.hasEmptyBuffer()) {
            if (notify) {
                this.notifyAll();
                notify = false;
            }
            if (this.closed) {
                return;
            }
            if (!this._dataChannel.isFlushing()) {
                return;
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                if (!this.closed) continue;
                return;
            }
        }
    }
}

