/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.stream;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.NamedPipeOutputStream;

public class NamedPipeInputStream
extends InputStream {
    private static boolean _nativeAvailable = false;
    private String _pipeNameSpace;
    private String _pipeName;
    private int _handle = -1;
    private boolean _closing = false;
    private boolean _isConnected = false;

    static {
        try {
            System.loadLibrary("tptpCommon");
            System.loadLibrary("tptpNP");
            _nativeAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            TPTPLoggerImpl.log(0, "Cannot load native library: tptpNP");
        }
        catch (SecurityException securityException) {
            TPTPLoggerImpl.log(0, "Not allowed to load native library: tptpNP");
        }
    }

    public NamedPipeInputStream(String pipeNameSpace, String pipeName) {
        this._pipeNameSpace = pipeNameSpace;
        this._pipeName = pipeName;
        if (_nativeAvailable) {
            this._handle = this.create0(this._pipeNameSpace, this._pipeName);
        }
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this._closing = true;
        if (!_nativeAvailable) {
            throw new IOException();
        }
        NamedPipeOutputStream out = new NamedPipeOutputStream(this._pipeNameSpace, this._pipeName);
        out.open();
        out.close();
        this.destroy0(this._handle, this._pipeNameSpace, this._pipeName);
        TPTPLoggerImpl.log(this, 3, "Named pipe destroyed: " + this._pipeName);
        this._handle = -1;
    }

    public void connect() throws IOException {
        if (_nativeAvailable) {
            this._handle = this.connect0(this._handle, this._pipeNameSpace, this._pipeName);
            this._isConnected = true;
            if (this._closing) {
                throw new IOException();
            }
        } else {
            throw new IOException();
        }
    }

    public void disconnect() throws IOException {
        if (!_nativeAvailable) {
            throw new IOException();
        }
        this.disconnect0(this._handle);
        this._isConnected = false;
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        this.read(b);
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        int byteRead = -1;
        if (_nativeAvailable && this._handle != -1) {
            if (this._handle > 0) {
                if (!this._isConnected) {
                    this.connect();
                }
                if ((byteRead = this.read0(this._handle, b)) <= 0 || byteRead < b.length) {
                    this.disconnect();
                }
            }
        } else {
            this.disconnect();
            throw new IOException();
        }
        return byteRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int byteRead = -1;
        byte[] buffer = new byte[len];
        if (_nativeAvailable && this._handle != -1) {
            if (!this._isConnected) {
                this.connect();
            }
            if ((byteRead = this.read0(this._handle, buffer)) <= 0 || byteRead < buffer.length) {
                this.disconnect();
            }
        } else {
            this.disconnect();
            throw new IOException();
        }
        int i = 0;
        while (i < byteRead) {
            b[off + i] = buffer[i];
            ++i;
        }
        return byteRead;
    }

    public void reset() throws IOException {
    }

    private native int create0(String var1, String var2);

    private native void destroy0(int var1, String var2, String var3);

    private native int connect0(int var1, String var2, String var3);

    private native void disconnect0(int var1);

    private native int read0(int var1, byte[] var2);
}

