/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;

public class TPTPLoggerImpl {
    public static final int SEVERE = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int NUM_LEVELS = 4;
    private static FileOutputStream _logger;
    private static FileOutputStream _dataLog;
    private static String _logDir;
    private static boolean _enabled;
    private static boolean _dataLogEnabled;
    private static int _level;

    static {
        ExecutionPlugin execPlugin;
        _logger = null;
        _dataLog = null;
        _logDir = null;
        _enabled = false;
        _dataLogEnabled = false;
        _level = 0;
        try {
            execPlugin = ExecutionPlugin.getInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            execPlugin = null;
        }
        if (execPlugin != null) {
            TPTPLoggerImpl.setLoggingDirectory(execPlugin.getString(ACStrings.PREF_LOGGING_DIRECTORY));
            String prop = System.getProperty("TPTP_AC_TRACE_DATA");
            if (prop != null && prop.equals("true")) {
                _dataLogEnabled = true;
            }
            TPTPLoggerImpl.init();
        }
    }

    private static void close() {
        if (_logger != null) {
            try {
                _logger.flush();
                _logger.close();
                _logger = null;
            }
            catch (IOException iOException) {}
        }
    }

    private static void init() {
        if (_enabled) {
            if (_logger != null) {
                TPTPLoggerImpl.close();
            }
            if (_logDir != null) {
                try {
                    _logger = new FileOutputStream(String.valueOf(_logDir) + File.separator + "tptp_iac.log", true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Logging directory is invalid");
                    _logger = null;
                }
                if (_dataLogEnabled) {
                    try {
                        _dataLog = new FileOutputStream(String.valueOf(_logDir) + File.separator + "tptp_iac_data.log", true);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println("Cannot create data log file");
                    }
                }
            } else {
                System.out.println("Cannot determine logging directory");
                _logger = null;
            }
        } else {
            TPTPLoggerImpl.close();
        }
    }

    public static void logData(byte[] data) {
        TPTPLoggerImpl.logData(data, 0, data.length);
    }

    public static synchronized void logData(byte[] data, int offset, int len) {
        if (_dataLog != null && _dataLogEnabled) {
            try {
                _dataLog.write(data, offset, len);
                _dataLog.write(new String("\n").getBytes());
                _dataLog.flush();
            }
            catch (Exception exception) {}
        }
    }

    public static void log(int type, String message) {
        TPTPLoggerImpl.log(null, type, message);
    }

    public static synchronized void log(Object obj, int type, String message) {
        byte[] b;
        String level;
        if (!_enabled || type > _level) {
            return;
        }
        long current = System.currentTimeMillis();
        String time = new String("[" + DateFormat.getDateInstance().format(new Date(current)) + " " + DateFormat.getTimeInstance().format(new Date(current)) + "] ");
        switch (type) {
            case 3: {
                level = ACStrings.PREF_LOGGING_LEVEL_DEBUG;
                break;
            }
            case 0: {
                level = ACStrings.PREF_LOGGING_LEVEL_SEVERE;
                break;
            }
            case 1: {
                level = ACStrings.PREF_LOGGING_LEVEL_WARNING;
                break;
            }
            case 2: {
                level = ACStrings.PREF_LOGGING_LEVEL_INFO;
                break;
            }
            default: {
                level = ACStrings.PREF_LOGGING_LEVEL_UKNOWN;
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(time);
        buffer.append("[" + level + "] ");
        buffer.append(message);
        if (obj != null) {
            buffer.append(" - " + obj.getClass().getName());
        }
        buffer.append("\n");
        try {
            b = buffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            b = buffer.toString().getBytes();
        }
        if (_logger == null) {
            System.out.print(b);
        } else {
            try {
                _logger.write(b);
                _logger.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void finalize() {
        TPTPLoggerImpl.close();
    }

    public static void setEnabled(boolean enabled) {
        _enabled = enabled;
        TPTPLoggerImpl.init();
    }

    public static void setLoggingDirectory(String dir) {
        File logDirFile;
        String logDir = dir;
        if (dir.equals(_logDir)) {
            return;
        }
        if (logDir != null && logDir.endsWith(File.separator)) {
            logDir = logDir.substring(0, logDir.length() - 1);
        }
        if ((logDirFile = new File(logDir)) != null && logDirFile.exists() && logDirFile.isDirectory()) {
            _logDir = dir;
        }
        TPTPLoggerImpl.init();
    }

    public static void setLoggingLevel(int level) {
        _level = level;
    }
}

