/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.tptp.platform.agentcontroller.internal.DataConnection;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class SocketDataConnectionImpl
implements DataConnection {
    private InputStream _inputStream = null;
    private InetSocketAddress _addr = null;
    private ServerSocket _serverSocket = null;
    private Socket _socket = null;
    private int _port = 0;

    public SocketDataConnectionImpl() {
        this(0);
    }

    public SocketDataConnectionImpl(int port) {
        try {
            this._serverSocket = new ServerSocket();
            this._addr = new InetSocketAddress(port);
            this._serverSocket.bind(this._addr);
            this._port = this._serverSocket.getLocalPort();
            TPTPLoggerImpl.log(this, 3, "Initializing socket data channel on port: " + this._port);
        }
        catch (IOException iOException) {
            TPTPLoggerImpl.log(this, 0, "Error during socket data channel initialization");
        }
    }

    public void create() {
        if (this._serverSocket != null) {
            try {
                this._socket = this._serverSocket.accept();
                this._inputStream = this._socket.getInputStream();
                this._socket.setSoTimeout(0);
                TPTPLoggerImpl.log(this, 3, "Socket data channel created");
            }
            catch (SocketException socketException) {
                TPTPLoggerImpl.log(this, 0, "Error during socket data channel creation");
            }
            catch (IOException iOException) {
                TPTPLoggerImpl.log(this, 0, "Error during socket data channel creation");
            }
        }
    }

    public void destroyConnection() {
        if (this._serverSocket != null) {
            try {
                this._serverSocket.close();
                this._serverSocket = null;
                this._inputStream = null;
                TPTPLoggerImpl.log(this, 3, "Socket data channel destroyed");
            }
            catch (IOException iOException) {
                TPTPLoggerImpl.log(this, 1, "Error during socket data channel destruction");
            }
        }
    }

    public InetAddress getAddress() {
        if (this._socket != null) {
            return this._socket.getInetAddress();
        }
        return null;
    }

    public String getConnectionName() {
        return String.valueOf(this._port);
    }

    public String getConnectionType() {
        return "TPTP_SOCKET_DATA_CONNECTION";
    }

    public String getConnectionId() {
        return String.valueOf(this.getConnectionType()) + ":" + this.getConnectionName();
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public int getPort() {
        return this._serverSocket.getLocalPort();
    }

    public void objectReceived(Object object) throws IOException {
    }

    public void run() {
    }

    public void setInputStream(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
    }
}

