/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.util.Enumeration;
import org.eclipse.tptp.platform.agentcontroller.internal.SystemShutdownListener;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.AgentProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.NodeProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.ProcessProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.ProcessProxyListener;

public class ProcessPollingThreadImpl
extends Thread {
    private NodeProxy _node;
    private ProcessProxyListener _listener;
    private SystemShutdownListener _shutdownListener;
    private boolean _stop = false;

    public ProcessPollingThreadImpl(NodeProxy node, ProcessProxyListener listener) {
        this._node = node;
        this._listener = listener;
        this.setName("Agent Controller Process Polling");
    }

    public void setSystemShutdownListener(SystemShutdownListener listener) {
        this._shutdownListener = listener;
    }

    public void interrupt() {
        this._stop = true;
    }

    public void run() {
        while (!this._stop) {
            int numAttachedAgents = 0;
            try {
                ProcessProxy[] processes = this._node.getProcesses();
                int i = 0;
                while (processes != null && i < processes.length) {
                    if (!processes[i].isAlive()) {
                        this._listener.processExited(processes[i].getPid());
                    } else {
                        Enumeration agents = processes[i].getAgents();
                        while (agents.hasMoreElements()) {
                            AgentProxy agent = (AgentProxy)agents.nextElement();
                            if (!agent.isAttached()) continue;
                            ++numAttachedAgents;
                        }
                    }
                    ++i;
                }
                ProcessPollingThreadImpl.sleep(5000L);
                if (numAttachedAgents > 0) continue;
                this._shutdownListener.shutdown();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

