/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.AcknowledgementMessage;
import org.eclipse.hyades.internal.execution.local.common.ActiveAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentActiveCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentAttachedCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentConfigurationCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetachedCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentInactiveCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentQueryStateCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentScopingInformationCommand;
import org.eclipse.hyades.internal.execution.local.common.AttachToAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ConsoleInfoCommand;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DetachFromAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.GetPropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.KillProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.LaunchProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.ManageFileCommand;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.ProcessExitedCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessLaunchedCommand;
import org.eclipse.hyades.internal.execution.local.common.PropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.common.RegisterAgentInterestCommand;
import org.eclipse.hyades.internal.execution.local.common.RegisteredProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.ResourceLocation;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.common.SimpleAgentInfoCommand;
import org.eclipse.hyades.internal.execution.local.common.StartMonitoringLocalAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.StartMonitoringRemoteAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.StopMonitorCommand;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.tptp.platform.agentcontroller.config.PlatformObject;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.AgentController;
import org.eclipse.tptp.platform.agentcontroller.internal.BufferConstant;
import org.eclipse.tptp.platform.agentcontroller.internal.Connection;
import org.eclipse.tptp.platform.agentcontroller.internal.MessageProcessor;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.TPTPMessage;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Configuration;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Option;
import org.eclipse.tptp.platform.agentcontroller.internal.exception.QueueFullException;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConfigurationImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConnectionFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.PlatformUtility;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPMessageImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.AgentProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.AgentProxyListener;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.NodeProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.ProcessProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.ProcessProxyListener;

public class HyadesMessageProcessorImpl
extends Thread
implements AgentProxyListener,
MessageProcessor,
ProcessProxyListener {
    private Queue _inputQueue = null;
    private Queue _outputQueue = null;
    private Configuration _config = ConfigurationImpl.getInstance();
    private NodeProxy _node;
    private Object _launcherLock = new Object();
    private Object _requeueLock = new Object();
    private int _numShmBuffers = 0;
    private boolean _stop = false;
    private MemoryManagerThread _mmThread = null;

    public HyadesMessageProcessorImpl() {
        super("Agent Controller Message Processor");
        this._node = new NodeProxy("Local Direct Connection");
    }

    public void agentActive(long pid, String agentName) {
        TPTPLoggerImpl.log(this, 3, "Active agent " + agentName + ":" + pid);
    }

    public void agentAttached(long pid, String agentName) {
        TPTPLoggerImpl.log(this, 3, "Attached to agent: " + agentName + " in process: " + pid);
    }

    public void agentDetached(long pid, String agentName) {
        AgentProxy agent;
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null) {
            Connection dataConnection;
            String dataConnectionName;
            String client = agent.getAttachedClient();
            if (client != null) {
                AgentDetachedCommand command = new AgentDetachedCommand();
                command.setContext(0L);
                command.setProcessId(pid);
                command.setAgentName(agentName);
                this.sendCommand(client, command);
            }
            if ((dataConnectionName = agent.getAttachedDataConnection()) != null && (dataConnection = ConnectionFactoryImpl.getConnection(dataConnectionName)) != null) {
                dataConnection.destroyConnection();
                ConnectionFactoryImpl.removeConnection(dataConnectionName);
                agent.setAttachedDataConnection(null);
            }
        }
        AgentControllerFactoryImpl.getAgentController().triggered();
        TPTPLoggerImpl.log(this, 3, "Detached from agent: " + agentName + " in process: " + pid);
    }

    public void agentInactive(long pid, String agentName) {
        AgentProxy agent;
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null) {
            agent.setAttached(false);
            String client = agent.getAttachedClient();
            if (client != null) {
                AgentInactiveCommand command = new AgentInactiveCommand();
                command.setContext(0L);
                command.setProcessId(pid);
                command.setAgentName(agentName);
                command.setAgentType(agent.getType());
                command.setAgentUUID(agent.getUuid());
                this.sendCommand(client, command);
            }
        }
        TPTPLoggerImpl.log(this, 3, "Inactive agent: " + agentName + " in process: " + pid);
    }

    public void agentStartMonitored(long pid, String agentName) {
    }

    public void agentStopMonitored(long pid, String agentName) {
    }

    public NodeProxy getNode() {
        return this._node;
    }

    private void handleAgentActive(String source, String destination, CommandElement command) {
        AgentProxy agent;
        AgentActiveCommand aaCmd = (AgentActiveCommand)command;
        long pid = aaCmd.getProcessId();
        String agentName = aaCmd.getAgentName();
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null) {
            TPTPLoggerImpl.log(this, 3, "Agent " + agentName + " in process " + pid + " is now active");
            agent.setActive(true);
            if (agent.getAttachedClient() != null) {
                TPTPLoggerImpl.log(this, 3, "Notifying attached client");
                this.sendCommand(agent.getAttachedClient(), aaCmd);
            }
        }
    }

    private void handleAgentInactive(String source, String destination, CommandElement command) {
        AgentProxy agent;
        AgentInactiveCommand aiCmd = (AgentInactiveCommand)command;
        long pid = aiCmd.getProcessId();
        String agentName = aiCmd.getAgentName();
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null) {
            TPTPLoggerImpl.log(this, 3, "Agent " + agentName + " in process " + pid + " is now inactive");
            agent.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAgentScopingInformation(String source, String destination, CommandElement command) {
        String agentName = "unknown";
        String agentType = "unknown";
        String agentUUID = "unknown";
        ProcessProxy process = null;
        AgentProxy agent = null;
        AgentScopingInformationCommand cmd = (AgentScopingInformationCommand)command;
        if (cmd.getAgentName() != null) {
            agentName = cmd.getAgentName().getData();
        }
        if (cmd.getAgentType() != null) {
            agentType = cmd.getAgentType().getData();
        }
        if (cmd.getAgentUUID() != null) {
            agentUUID = cmd.getAgentUUID().getData();
        }
        long pid = cmd.getProcessId();
        TPTPLoggerImpl.log(this, 2, "Incomming agent registration request from agent " + agentName + " in process " + pid);
        process = this._node.getProcess(pid);
        if (process == null) {
            process = new ProcessProxy(pid);
            process.addProcessListener(this);
            process.setProcess(null);
            this._node.addProcess(process);
        }
        Object object = this._node;
        synchronized (object) {
            this._node.notifyAll();
        }
        agent = process.getAgent(agentName);
        if (agent == null) {
            agent = new AgentProxy(agentName, agentType, agentUUID);
            agent.setProcess(process);
            agent.addAgentListener(this);
            process.addAgent(agent);
        }
        object = process;
        synchronized (object) {
            process.notifyAll();
        }
        agent.setActive(true);
        if (agent.getType() == null) {
            agent.setType(agentType);
        }
        if (agent.getUuid() == null) {
            agent.setUuid(agentUUID);
        }
        if (agent.getAttachedClient() != null) {
            agent.setAttached(true);
        }
        AgentConfiguration agentConfig = this._config.getAgentConfiguration(agentName, agentType);
        AgentConfigurationCommand cfgCmd = new AgentConfigurationCommand();
        cfgCmd.setAgentName(cmd.getAgentName());
        cfgCmd.setAgentType(cmd.getAgentType());
        cfgCmd.setAgentUUID(cmd.getAgentType());
        cfgCmd.setContext(command.getContext());
        cfgCmd.setNodeUUID(cmd.getNodeUUID());
        cfgCmd.setProcessId(cmd.getProcessId());
        cfgCmd.setProcessUUID(cmd.getProcessUUID());
        if (agentConfig != null) {
            int i = 0;
            while (i < agentConfig.size()) {
                TPTPLoggerImpl.log(this, 3, "Sending agent option, name=" + agentConfig.getEntryAt(i).getName() + ", type=" + agentConfig.getEntryAt(i).getType() + ", value=" + agentConfig.getEntryAt(i).getValue() + " to agent: " + agentName);
                cfgCmd.addEntry(agentConfig.getEntryAt(i));
                ++i;
            }
        }
        this.sendCommand(agent.getAttachedControlConnection(), cfgCmd);
        if (agent.getAttachedClient() != null) {
            AgentActiveCommand aaCmd = new AgentActiveCommand();
            aaCmd.setContext(command.getContext());
            aaCmd.setProcessId(pid);
            aaCmd.setAgentName(agentName);
            aaCmd.setAgentType(agentType);
            aaCmd.setAgentUUID(agentUUID);
            TPTPLoggerImpl.log(this, 3, "Notifying attached client that agent is active: " + agentName);
            this.sendCommand(agent.getAttachedClient(), aaCmd);
        }
        Object object2 = this._requeueLock;
        synchronized (object2) {
            this._requeueLock.notifyAll();
        }
    }

    private void handleAttachToAgent(String source, String destination, CommandElement command, boolean isRequeued) {
        AttachToAgentCommand cmd = (AttachToAgentCommand)command;
        String agentName = cmd.getAgentName();
        long pid = cmd.getProcessId();
        ProcessProxy process = null;
        AgentProxy agent = null;
        TPTPLoggerImpl.log(this, 2, "Attaching agent: " + agentName + " in process: " + pid);
        process = this._node.getProcess(pid);
        if (process == null) {
            if (isRequeued) {
                TPTPLoggerImpl.log(this, 1, "Cannot find process: " + pid);
                ErrorCommand error = new ErrorCommand();
                error.setContext(command.getContext());
                error.setAgentName("Agent Controller");
                error.setProcessId(0L);
                error.setErrorId("RAC007");
                error.setErrorString("No such agent");
                error.setSeverity(0L);
                this.sendCommand(source, error);
                return;
            }
            TPTPLoggerImpl.log(this, 2, "Cannot find process: " + pid + ", requeueing message");
            this.requeueCommand(source, destination, cmd);
            return;
        }
        TPTPLoggerImpl.log(this, 2, "Found process: " + pid);
        agent = process.getAgent(agentName);
        if (agent == null) {
            if (isRequeued) {
                TPTPLoggerImpl.log(this, 1, "Cannot find agent: " + agentName);
                return;
            }
            TPTPLoggerImpl.log(this, 2, "Cannot find agent: " + agentName + ", requeueing message");
            this.requeueCommand(source, destination, cmd);
            return;
        }
        TPTPLoggerImpl.log(this, 2, "Found agent: " + agentName);
        if (agent.isAttached()) {
            TPTPLoggerImpl.log(this, 1, "Agent is currently attached to client");
        } else if (agent.getType() == null || agent.getUuid() == null) {
            TPTPLoggerImpl.log(this, 1, "Agent " + agent.getName() + " does not register properly. Missing TYPE and/or UUID information");
        } else {
            agent.setAttached(true);
            agent.setAttachedClient(source);
            this.sendAgentActiveCommand(command, pid, agent);
        }
        this.sendCommand(agent.getAttachedControlConnection(), cmd);
        TPTPLoggerImpl.log(this, 2, "Agent is attached successfully");
    }

    private void handleCustomCommand(String source, String destination, CommandElement command) {
        AgentProxy agent;
        ProcessProxy process;
        SimpleAgentInfoCommand cmd;
        String agentName = null;
        long pid = 0L;
        ControlMessage msg = new ControlMessage();
        if (command.getTag() == 26L) {
            cmd = (CustomCommand)command;
            cmd.setContext(command.getContext());
            pid = cmd.getProcessId();
            agentName = cmd.getAgentName();
            msg.appendCommand(cmd);
            TPTPLoggerImpl.log(this, 3, "Custom command data = (" + ((CustomCommand)cmd).getData() + ")");
        } else if (command.getTag() == 29L) {
            cmd = (BinaryCustomCommand)command;
            cmd.setContext(command.getContext());
            pid = cmd.getProcessId();
            agentName = cmd.getAgentName();
            msg.appendCommand(cmd);
            StringBuffer strbuf = new StringBuffer();
            int i = 0;
            while (i < ((CustomCommand)cmd).getDataBinary().length) {
                strbuf.append(String.valueOf(((CustomCommand)cmd).getDataBinary()[i]) + " ");
                ++i;
            }
            TPTPLoggerImpl.log(this, 3, "Binary custom command data = (" + strbuf.toString() + ")");
        } else if (command.getTag() == 25L) {
            cmd = (SetNVPairCommand)command;
            cmd.setContext(command.getContext());
            pid = cmd.getProcessId();
            agentName = cmd.getAgentName();
            msg.appendCommand(cmd);
            TPTPLoggerImpl.log(this, 3, "Name/Type/Value data = (" + ((SetNVPairCommand)cmd).getName() + "/" + ((SetNVPairCommand)cmd).getType() + "/" + ((SetNVPairCommand)cmd).getValue() + ")");
        }
        if (agentName != null && (process = this._node.getProcess(pid)) != null && (agent = process.getAgent(agentName)) != null) {
            if (source.startsWith("TPTP_NAMED_PIPE_CONTROL_CONNECTION")) {
                String attachedClient = agent.getAttachedClient();
                if (attachedClient != null) {
                    TPTPLoggerImpl.log(this, 3, "Trying to send custom command to client, from agent " + agentName + " in process " + pid);
                    this.sendMessage(attachedClient, msg);
                }
            } else {
                String attachedControlStream = agent.getAttachedControlConnection();
                if (attachedControlStream != null) {
                    TPTPLoggerImpl.log(this, 3, "Trying to send custom command to agent " + agentName + " in process " + pid + ", from client");
                    this.sendMessage(attachedControlStream, msg);
                }
            }
        }
    }

    private void handleDetachFromAgent(String source, String destination, CommandElement command) {
        DetachFromAgentCommand cmd = (DetachFromAgentCommand)command;
        String agentName = cmd.getAgentName();
        long pid = cmd.getProcessId();
        TPTPLoggerImpl.log(this, 2, "Detaching agent: " + agentName + " in process: " + pid);
        ProcessProxy process = this._node.getProcess(pid);
        if (process == null) {
            TPTPLoggerImpl.log(this, 1, "Cannot find process: " + pid);
        } else {
            AgentProxy agent = process.getAgent(agentName);
            if (agent == null) {
                TPTPLoggerImpl.log(this, 1, "Cannot find agnet: " + agentName + " in process " + pid);
            } else {
                if (agent.isMonitoring()) {
                    StopMonitorCommand stopCmd = new StopMonitorCommand();
                    stopCmd.setContext(command.getContext());
                    stopCmd.setProcessId(pid);
                    stopCmd.setAgentName(agentName);
                    this.handleStopMonitoringAgent(source, destination, stopCmd);
                }
                if (!agent.isAttached()) {
                    TPTPLoggerImpl.log(this, 1, "Agent " + agentName + " in process " + pid + " is already detached");
                } else {
                    String attachedControlStream = agent.getAttachedControlConnection();
                    if (attachedControlStream != null) {
                        this.sendCommand(attachedControlStream, cmd);
                        TPTPLoggerImpl.log(this, 2, "Agent " + agentName + " in process " + pid + " is detached successfully");
                    }
                    agent.setAttached(false);
                    agent.setAttachedDataConnection(null);
                }
            }
        }
    }

    private void handleErrorString(String source, String destination, CommandElement command) {
        String attachedClient;
        ProcessProxy process = null;
        AgentProxy agent = null;
        ErrorCommand eCmd = (ErrorCommand)command;
        long pid = eCmd.getProcessId();
        String agentName = eCmd.getAgentName();
        process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null && (attachedClient = agent.getAttachedClient()) != null) {
            this.sendCommand(attachedClient, command);
        }
    }

    private void handleGetPropertyList(String source, String destination, CommandElement command) {
        GetPropertyListCommand gpCmd = (GetPropertyListCommand)command;
        RAString name = gpCmd.getName();
        RAString type = gpCmd.getType();
        TPTPLoggerImpl.log(this, 2, "Trying to get property list for name=" + name.getData() + ", type=" + type.getData());
        if (name != null && type != null) {
            Enumeration options = this._config.resolveOptions(name.getData(), type.getData());
            PropertyListCommand plCmd = new PropertyListCommand();
            plCmd.setContext(command.getContext());
            while (options.hasMoreElements()) {
                Option opt = (Option)options.nextElement();
                plCmd.addPropertyListValue(opt.getName(), opt.getType(), opt.getValue());
                TPTPLoggerImpl.log(this, 2, "Returning property name=" + opt.getName() + ", type=" + opt.getType() + ", value=" + opt.getValue());
            }
            this.sendCommand(source, plCmd);
        }
    }

    private void handleKillProcess(String source, String destination, CommandElement command) {
        KillProcessCommand kpCmd = (KillProcessCommand)command;
        long pid = kpCmd.getProcessId();
        TPTPLoggerImpl.log(this, 2, "Trying to kill process: " + pid);
        PlatformUtility.killProcess(pid);
        this.processExited(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLaunchProcess(String source, String destination, CommandElement command) {
        Object object = this._launcherLock;
        synchronized (object) {
            LaunchProcessCommand lpCmd = (LaunchProcessCommand)command;
            long pid = 0L;
            String exe = lpCmd.getExe();
            String args = lpCmd.getArgs();
            String userLocation = lpCmd.getLocation();
            Vector env = lpCmd.getEnvironment();
            Vector agents = lpCmd.getAgents();
            String[] envArray = new String[env.size()];
            int i = 0;
            while (i < env.size()) {
                envArray[i] = ((RAString)env.elementAt(i)).getData();
                ++i;
            }
            String realExe = this._config.resolveExecutableName(exe);
            TPTPLoggerImpl.log(this, 3, "Launch executable = " + realExe);
            String[] sysEnv = PlatformUtility.getEnvironment();
            String[] acUserEnv = this._config.resolveExecutableEnvironment(exe, envArray);
            String[] newEnv = PlatformUtility.mergeEnvironment(sysEnv, acUserEnv);
            int i2 = 0;
            while (i2 < newEnv.length) {
                TPTPLoggerImpl.log(this, 3, "Launch environment[" + i2 + "] = " + newEnv[i2]);
                ++i2;
            }
            String location = userLocation == null || userLocation.equals("") ? this._config.resolveExecutableWorkingDir(exe) : userLocation;
            TPTPLoggerImpl.log(this, 3, "Launch location = " + location);
            String newArgs = this.isJava(realExe) ? this._config.resolveExecutableArguments(exe, "-Dconsole.encoding=UTF-8 " + args) : this._config.resolveExecutableArguments(exe, args);
            TPTPLoggerImpl.log(this, 3, "Launch arguments = " + newArgs);
            pid = System.getProperty("os.name").startsWith("Windows") ? PlatformUtility.launchProcess("\"" + realExe + "\" " + newArgs, newEnv, location) : PlatformUtility.launchProcess(String.valueOf(realExe) + " " + newArgs, newEnv, location);
            if (pid > 0L) {
                ProcessProxy process = this._node.getProcess(pid);
                if (process == null) {
                    process = new ProcessProxy(pid);
                    process.addProcessListener(this);
                    process.setProcess(PlatformUtility.getProcess(pid));
                    process.setAttacheClient(source);
                    this._node.addProcess(process);
                }
                int i3 = 0;
                while (i3 < agents.size()) {
                    String agentName = ((RAString)agents.elementAt(i3)).getData();
                    AgentProxy agent = process.getAgent(agentName);
                    if (agent == null) {
                        TPTPLoggerImpl.log(this, 2, "Adding agent interest: " + agentName);
                        agent = new AgentProxy(agentName);
                        agent.addAgentListener(this);
                        agent.setProcess(process);
                        process.addAgent(agent);
                        agent.setAttachedClient(source);
                    }
                    ++i3;
                }
                if (lpCmd.getConsoleIP() == 0L && lpCmd.getConsolePort() == 0L) {
                    ConsoleInfoCommand ciCmd = new ConsoleInfoCommand(process.getPid(), process.getProcess().getInputStream(), process.getProcess().getErrorStream(), process.getProcess().getOutputStream());
                    ciCmd.setContext(command.getContext());
                    this.sendCommand(source, ciCmd);
                } else {
                    byte[] addr_bytes = new byte[4];
                    addr_bytes[3] = (byte)(lpCmd.getConsoleIP() >> 24 & 0xFFL);
                    addr_bytes[2] = (byte)(lpCmd.getConsoleIP() >> 16 & 0xFFL);
                    addr_bytes[1] = (byte)(lpCmd.getConsoleIP() >> 8 & 0xFFL);
                    addr_bytes[0] = (byte)(lpCmd.getConsoleIP() >> 0 & 0xFFL);
                    TPTPLoggerImpl.log(3, "Console: " + addr_bytes[0] + "." + addr_bytes[1] + "." + addr_bytes[2] + "." + addr_bytes[3] + ":" + lpCmd.getConsolePort());
                    try {
                        InetAddress addr = InetAddress.getByAddress(addr_bytes);
                        Socket sock = new Socket(addr, (int)lpCmd.getConsolePort());
                        WorkerThread stdout = new WorkerThread(process.getPid(), "stdout", sock.getOutputStream(), process.getProcess().getInputStream());
                        WorkerThread stderr = new WorkerThread(process.getPid(), "stderr", sock.getOutputStream(), process.getProcess().getErrorStream());
                        WorkerThread stdin = new WorkerThread(process.getPid(), "stdin", process.getProcess().getOutputStream(), sock.getInputStream());
                        stdout.start();
                        stderr.start();
                        stdin.start();
                    }
                    catch (UnknownHostException unknownHostException) {
                        TPTPLoggerImpl.log(0, "Cannot resolve host address: " + addr_bytes[0] + "." + addr_bytes[1] + "." + addr_bytes[2] + "." + addr_bytes[3]);
                    }
                    catch (IOException iOException) {
                        TPTPLoggerImpl.log(0, "Cannot create socket to host: " + addr_bytes[0] + "." + addr_bytes[1] + "." + addr_bytes[2] + "." + addr_bytes[3]);
                    }
                }
                ProcessLaunchedCommand plCmd = new ProcessLaunchedCommand();
                plCmd.setContext(command.getContext());
                plCmd.setExe(exe);
                plCmd.setArgs(args);
                plCmd.setEnvironment(newEnv);
                plCmd.setProcessId(pid);
                this.sendCommand(source, plCmd);
            } else {
                TPTPLoggerImpl.log(this, 0, "Failed to launch process");
            }
        }
    }

    private void handleManagedFileCommand(String source, String destination, CommandElement command) {
        ManageFileCommand mfCmd = (ManageFileCommand)command;
        int op = (int)mfCmd.getOperation();
        switch (op) {
            case 1: {
                TPTPLoggerImpl.log(this, 3, "Recieved managed file GET command: " + mfCmd.getFilename());
                this.sendFileServerPort(source, destination, command);
                break;
            }
            case 2: {
                TPTPLoggerImpl.log(this, 3, "Recieved managed file PUT command" + mfCmd.getFilename());
                this.sendFileServerPort(source, destination, command);
                break;
            }
            case 3: {
                TPTPLoggerImpl.log(this, 3, "Recieved managed file DELETE command" + mfCmd.getFilename());
                String fileName = mfCmd.getFilename();
                File file = new File(fileName);
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryProcessList(String source, String destination, CommandElement command, boolean isRequeued) {
        RegisteredProcessListCommand processListCommand = null;
        TPTPLoggerImpl.log(this, 2, "Trying to retrieve the process list");
        ProcessProxy[] processes = this._node.getProcesses();
        if (processes.length == 0) {
            if (isRequeued) {
                TPTPLoggerImpl.log(this, 1, "Cannot find any process");
                processListCommand = new RegisteredProcessListCommand(new long[0]);
                processListCommand.setContext(command.getContext());
                TPTPLoggerImpl.log(this, 2, "Returning empty process list to client");
                this.sendCommand(source, processListCommand);
                return;
            }
            TPTPLoggerImpl.log(this, 2, "Cannot find any process, requeueing message");
            Object object = this._requeueLock;
            synchronized (object) {
                try {
                    this._requeueLock.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.requeueCommand(source, destination, command);
            return;
        }
        long[] pids = new long[processes.length];
        int i = 0;
        while (i < processes.length) {
            pids[i] = processes[i].getPid();
            TPTPLoggerImpl.log(this, 3, "Adding process " + pids[i]);
            ++i;
        }
        processListCommand = new RegisteredProcessListCommand(pids);
        processListCommand.setContext(command.getContext());
        TPTPLoggerImpl.log(this, 2, "Returning process list to client");
        this.sendCommand(source, processListCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryAgentList(String source, String destination, CommandElement command, boolean isRequeued) {
        QueryAgentListCommand qcmd = (QueryAgentListCommand)command;
        ActiveAgentListCommand agentListCommand = null;
        Vector<RAString> agentList = new Vector<RAString>();
        long pid = qcmd.getProcessId();
        TPTPLoggerImpl.log(this, 2, "Trying to retrieve the agent list for process: " + pid);
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null) {
            Enumeration agents = process.getAgents();
            if (agents.hasMoreElements()) {
                while (agents.hasMoreElements()) {
                    AgentProxy agent = (AgentProxy)agents.nextElement();
                    agentList.addElement(new RAString(agent.getName()));
                }
                agentListCommand = new ActiveAgentListCommand(process.getName(), agentList);
                agentListCommand.setContext(command.getContext());
                agentListCommand.setProcessId(pid);
                TPTPLoggerImpl.log(this, 2, "Returning agent list to client");
                this.sendCommand(source, agentListCommand);
            } else {
                if (isRequeued) {
                    TPTPLoggerImpl.log(this, 1, "Cannot find any agent");
                    return;
                }
                TPTPLoggerImpl.log(this, 2, "Cannot find any agent in process " + pid + ", requeueing message");
                Object object = this._requeueLock;
                synchronized (object) {
                    try {
                        this._requeueLock.wait(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.requeueCommand(source, destination, command);
                return;
            }
        }
    }

    private void handleQueryAgentDetails(String source, String destination, CommandElement command) {
        AgentProxy agent;
        QueryAgentDetailsCommand qadCmd = (QueryAgentDetailsCommand)command;
        long pid = qadCmd.getProcessId();
        String agentName = qadCmd.getAgentName();
        TPTPLoggerImpl.log(this, 2, "Trying to query details for agent: " + agentName + " in process " + pid);
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null) {
            AgentDetailsCommand adCmd = new AgentDetailsCommand();
            adCmd.setContext(command.getContext());
            adCmd.setProcessId(pid);
            adCmd.setAgentName(agent.getName());
            adCmd.setAgentType(agent.getType());
            adCmd.setAgentUUID(agent.getUuid());
            TPTPLoggerImpl.log(this, 2, "Returning details: agent=" + agent.getName() + ", type=" + agent.getType() + ", UUID=" + agent.getUuid());
            this.sendCommand(source, adCmd);
        }
    }

    private void handleQueryAgentState(String source, String destination, CommandElement command) {
        AgentProxy agent;
        AgentQueryStateCommand qcmd = (AgentQueryStateCommand)command;
        long pid = qcmd.getProcessId();
        String agentName = qcmd.getAgentName();
        TPTPLoggerImpl.log(this, 2, "Trying to query state for agent: " + agentName + " in process " + pid);
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null) {
            if (agent.isAttached()) {
                AgentAttachedCommand reply = new AgentAttachedCommand();
                reply.setContext(command.getContext());
                reply.setAgentName(agentName);
                reply.setProcessId(pid);
                this.sendCommand(source, reply);
                TPTPLoggerImpl.log(this, 2, "Agent (" + agentName + ") is currently attached");
            } else {
                AgentDetachedCommand reply = new AgentDetachedCommand();
                reply.setContext(command.getContext());
                reply.setAgentName(agentName);
                reply.setProcessId(pid);
                this.sendCommand(source, reply);
                TPTPLoggerImpl.log(this, 2, "Agent (" + agentName + ") is currently detached");
            }
        }
    }

    private void handleRegisterAgentNotification(String source, String destination, CommandElement command) {
        AgentProxy agent;
        RegisterAgentInterestCommand rCmd = (RegisterAgentInterestCommand)command;
        long pid = rCmd.getProcessId();
        String agentName = rCmd.getAgentName();
        TPTPLoggerImpl.log(this, 2, "Trying to register agent notification for agent " + agentName + " in process " + pid);
        ProcessProxy process = this._node.getProcess(pid);
        if (process == null) {
            process = new ProcessProxy(pid);
            process.addProcessListener(this);
            this._node.addProcess(process);
        }
        if ((agent = process.getAgent(agentName)) == null) {
            agent = new AgentProxy(agentName);
            agent.addAgentListener(this);
            agent.setProcess(process);
            process.addAgent(agent);
        } else {
            AgentActiveCommand aaCmd = new AgentActiveCommand();
            aaCmd.setContext(command.getContext());
            aaCmd.setProcessId(pid);
            aaCmd.setAgentName(agentName);
            aaCmd.setAgentType(agent.getType());
            aaCmd.setAgentUUID(agent.getUuid());
            TPTPLoggerImpl.log(this, 3, "Notifying interested client that agent is active: " + agentName);
            this.sendCommand(source, aaCmd);
        }
        agent.setAttachedClient(source);
        agent.setActive(true);
    }

    private void handleStartMonitoringAgent(String source, String destination, CommandElement command) {
        StartMonitoringRemoteAgentCommand rCmd = (StartMonitoringRemoteAgentCommand)command;
        long pid = rCmd.getProcessId();
        long host = rCmd.getIP();
        long port = rCmd.getPort();
        String agentName = rCmd.getAgentName();
        TPTPLoggerImpl.log(this, 2, "Starting to monitor agent: " + agentName + " in process: " + pid);
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null) {
            AgentProxy agent = process.getAgent(agentName);
            if (agent != null && agent.isAttached()) {
                String attachedDataConnection = agent.getAttachedDataConnection();
                Connection shmDataConnection = null;
                if (attachedDataConnection == null) {
                    String shmName = new String("rabuffer" + this._numShmBuffers++);
                    shmDataConnection = ConnectionFactoryImpl.createSharedMemoryConnection(shmName, true);
                    attachedDataConnection = shmDataConnection.getConnectionId();
                    TPTPLoggerImpl.log(this, 3, "Shared memory connection " + attachedDataConnection + " is created for agent " + agentName + " in process " + pid);
                    agent.setAttachedDataConnection(attachedDataConnection);
                } else {
                    shmDataConnection = ConnectionFactoryImpl.getConnection(attachedDataConnection);
                    TPTPLoggerImpl.log(this, 3, "Shared memory connection " + attachedDataConnection + " already exists for agent " + agentName + " in process " + pid);
                }
                if (port <= 0L) {
                    Connection directConnection = ConnectionFactoryImpl.getConnection("TPTP_DIRECT_DATA_CONNECTION:" + -port);
                    if (directConnection != null) {
                        directConnection.setInputStream(shmDataConnection.getInputStream());
                    }
                } else {
                    byte[] addr_bytes = new byte[4];
                    addr_bytes[3] = (byte)(host >> 24);
                    addr_bytes[2] = (byte)(host >> 16);
                    addr_bytes[1] = (byte)(host >> 8);
                    addr_bytes[0] = (byte)(host >> 0);
                    TPTPLoggerImpl.log(3, "Data channel: " + addr_bytes[0] + "." + addr_bytes[1] + "." + addr_bytes[2] + "." + addr_bytes[3] + ":" + port);
                    try {
                        InetAddress addr = InetAddress.getByAddress(addr_bytes);
                        Socket sock = new Socket(addr, (int)rCmd.getPort());
                        WorkerThread dataChannel = new WorkerThread(process.getPid(), "data channel", sock.getOutputStream(), shmDataConnection.getInputStream());
                        dataChannel.start();
                    }
                    catch (UnknownHostException unknownHostException) {
                        TPTPLoggerImpl.log(0, "Cannot resolve host address: " + addr_bytes[0] + "." + addr_bytes[1] + "." + addr_bytes[2] + "." + addr_bytes[3]);
                    }
                    catch (IOException iOException) {
                        TPTPLoggerImpl.log(0, "Cannot create socket to host: " + addr_bytes[0] + "." + addr_bytes[1] + "." + addr_bytes[2] + "." + addr_bytes[3]);
                    }
                }
                StartMonitoringLocalAgentCommand reply = new StartMonitoringLocalAgentCommand();
                reply.setContext(command.getContext());
                reply.setProcessId(pid);
                reply.setAgentName(agentName);
                reply.setFile(shmDataConnection.getConnectionName());
                String agentControlConnection = agent.getAttachedControlConnection();
                if (agentControlConnection != null) {
                    this.sendCommand(agentControlConnection, reply);
                    TPTPLoggerImpl.log(this, 2, "Start monitoring request sent to agent: " + agentName);
                }
                agent.setMonitoring(true);
            } else {
                TPTPLoggerImpl.log(this, 1, "Cannot find an attached agent: " + agentName + " in process " + pid);
            }
        } else {
            TPTPLoggerImpl.log(this, 1, "Cannot find process: " + pid);
        }
    }

    private void handleStopMonitoringAgent(String source, String destination, CommandElement command) {
        AgentProxy agent;
        StopMonitorCommand stopCmd = (StopMonitorCommand)command;
        long pid = stopCmd.getProcessId();
        String agentName = stopCmd.getAgentName();
        TPTPLoggerImpl.log(this, 2, "Stopping to monitor agent: " + agentName + " in process: " + pid);
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null && (agent = process.getAgent(agentName)) != null) {
            String attachedControlStream = agent.getAttachedControlConnection();
            if (attachedControlStream != null) {
                this.sendCommand(attachedControlStream, stopCmd);
                TPTPLoggerImpl.log(this, 2, "Stop monitoring request sent to agent: " + agentName);
            }
            agent.setMonitoring(false);
        }
    }

    private void incommingCommand(String source, String destination, CommandElement command, boolean isRequeued) {
        switch ((int)command.getTag()) {
            case 49: {
                this.handleAgentScopingInformation(source, destination, command);
                break;
            }
            case 1: {
                TPTPLoggerImpl.log(this, 0, "Command is not supported: RA_AUTHENTICATE");
                break;
            }
            case 16: {
                this.handleLaunchProcess(source, destination, command);
                break;
            }
            case 27: {
                this.handleKillProcess(source, destination, command);
                break;
            }
            case 24: {
                this.handleStopMonitoringAgent(source, destination, command);
                break;
            }
            case 22: 
            case 23: {
                this.handleStartMonitoringAgent(source, destination, command);
                break;
            }
            case 20: {
                this.handleAttachToAgent(source, destination, command, isRequeued);
                break;
            }
            case 21: {
                this.handleDetachFromAgent(source, destination, command);
                break;
            }
            case 17: {
                this.handleQueryProcessList(source, destination, command, isRequeued);
                break;
            }
            case 18: {
                this.handleQueryAgentList(source, destination, command, isRequeued);
                break;
            }
            case 28: {
                this.handleQueryAgentDetails(source, destination, command);
                break;
            }
            case 25: 
            case 26: 
            case 29: {
                this.handleCustomCommand(source, destination, command);
                break;
            }
            case 98: 
            case 99: 
            case 102: {
                TPTPLoggerImpl.log(this, 0, "Command is not supported: RA_CONTROLLER_REQUEST_MONITOR");
                break;
            }
            case 37: {
                this.handleErrorString(source, destination, command);
                break;
            }
            case 97: 
            case 101: {
                TPTPLoggerImpl.log(this, 0, "Command is not supported: RA_AGENT_REQUEST_MONITOR");
                break;
            }
            case 19: {
                this.handleRegisterAgentNotification(source, destination, command);
                break;
            }
            case 30: {
                this.handleGetPropertyList(source, destination, command);
                break;
            }
            case 31: {
                this.handleManagedFileCommand(source, destination, command);
                break;
            }
            case 43: {
                this.handleQueryAgentState(source, destination, command);
                break;
            }
            case 35: {
                this.handleAgentActive(source, destination, command);
                break;
            }
            case 36: {
                this.handleAgentInactive(source, destination, command);
                break;
            }
            case 255: {
                ShutdownThread sThread = new ShutdownThread();
                sThread.start();
            }
        }
    }

    private void incommingMessage(TPTPMessage tptpMessage) {
        Message message = (Message)tptpMessage.getPayload();
        if (!(message instanceof AcknowledgementMessage)) {
            if (message instanceof ControlMessage) {
                int commandCount = ((ControlMessage)message).getCommandCount();
                int i = 0;
                while (i < commandCount) {
                    this.incommingCommand(tptpMessage.getSource(), tptpMessage.getDestination(), ((ControlMessage)message).getCommand(i), tptpMessage.isRequeued());
                    ++i;
                }
            } else {
                TPTPLoggerImpl.log(this, 0, "Message type is not recognized");
            }
        }
    }

    public void interrupt() {
        if (this._mmThread != null) {
            this._mmThread.interrupt();
        }
        this._stop = true;
    }

    private boolean isJava(String exe) {
        if (exe.endsWith(String.valueOf(File.separatorChar) + "java" + PlatformObject.exeExt)) {
            return true;
        }
        return exe.endsWith(String.valueOf(File.separatorChar) + "javaw" + PlatformObject.exeExt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExited(long pid) {
        ProcessProxy process = this._node.getProcess(pid);
        if (process != null) {
            ProcessProxy processProxy = process;
            synchronized (processProxy) {
                if (process.isActive()) {
                    Enumeration agents = process.getAgents();
                    while (agents.hasMoreElements()) {
                        AgentProxy agent = (AgentProxy)agents.nextElement();
                        if (agent == null) continue;
                        String client = agent.getAttachedClient();
                        agent.setActive(false);
                        if (client == null) continue;
                        ProcessExitedCommand peCmd = new ProcessExitedCommand();
                        peCmd.setContext(0L);
                        peCmd.setProcessId(pid);
                        this.sendCommand(client, peCmd);
                    }
                    process.removeAllAgents();
                }
                process.setActive(false);
            }
            this._node.removeProcess(process);
        }
        TPTPLoggerImpl.log(this, 3, "Process " + pid + " terminated");
    }

    public void processLaunched(long pid) {
        TPTPLoggerImpl.log(this, 3, "Process " + pid + " launched");
    }

    private void requeueCommand(String source, String destination, CommandElement command) {
        ControlMessage message = new ControlMessage();
        message.appendCommand(command);
        this.requeueMessage(source, destination, message);
    }

    private void requeueMessage(String source, String destination, ControlMessage message) {
        TPTPMessageImpl tptpMessage = new TPTPMessageImpl();
        tptpMessage.setSource(source);
        tptpMessage.setDestination(destination);
        tptpMessage.setPayload(message);
        tptpMessage.setRequeued(true);
        try {
            this._inputQueue.putItem(tptpMessage);
        }
        catch (QueueFullException queueFullException) {
            TPTPLoggerImpl.log(this, 0, "Error occurred when re-queueing message");
        }
    }

    public void run() {
        if (this._config == null) {
            TPTPLoggerImpl.log(this, 0, "Missing Agent Controller configuration");
            return;
        }
        if (this._inputQueue != null) {
            this._mmThread = new MemoryManagerThread();
            this._mmThread.start();
            while (!this._stop) {
                Object obj = null;
                obj = this._inputQueue.getItem();
                if (obj == null) {
                    return;
                }
                if (!(obj instanceof TPTPMessage)) continue;
                this.incommingMessage((TPTPMessage)obj);
            }
        }
    }

    private void sendAgentActiveCommand(CommandElement command, long pid, AgentProxy agent) {
        AgentActiveCommand aaCmd = new AgentActiveCommand();
        aaCmd.setContext(command.getContext());
        aaCmd.setProcessId(pid);
        aaCmd.setAgentName(agent.getName());
        aaCmd.setAgentType(agent.getType());
        aaCmd.setAgentUUID(agent.getUuid());
        TPTPLoggerImpl.log(this, 3, "Notifying attached client that agent is active: " + agent.getName());
        this.sendCommand(agent.getAttachedClient(), aaCmd);
    }

    private void sendCommand(String destination, CommandElement command) {
        ControlMessage cmsg = new ControlMessage();
        cmsg.appendCommand(command);
        this.sendMessage(destination, cmsg);
    }

    private void sendFileServerPort(String source, String destination, CommandElement command) {
        ResourceLocation replyCommand = new ResourceLocation();
        int fsPort = this._config.getFileServerPort();
        TPTPLoggerImpl.log(this, 2, "Trying to send the file server port");
        replyCommand.setContext(command.getContext());
        replyCommand.setPort(fsPort);
        replyCommand.setJobKey("dummy");
        this.sendCommand(source, replyCommand);
        TPTPLoggerImpl.log(this, 2, "File server port " + fsPort + " sent");
    }

    private void sendMessage(String destination, Message message) {
        if (this._outputQueue != null) {
            TPTPMessageImpl tptpMessage = new TPTPMessageImpl();
            tptpMessage.setDestination(destination);
            tptpMessage.setPayload(message);
            try {
                this._outputQueue.putItem(tptpMessage);
            }
            catch (QueueFullException e) {
                e.printStackTrace();
            }
        }
    }

    public void setConfiguration(Configuration config) {
        this._config = config;
    }

    public void setInputQueue(Queue q) {
        this._inputQueue = q;
    }

    public void setOutputQueue(Queue q) {
        this._outputQueue = q;
    }

    class MemoryManagerThread
    extends Thread {
        private double _stopThreshold = 0.85;
        private long _sleep = 5000L;
        private boolean _done = false;
        private long _maxMem = Long.MAX_VALUE;

        public MemoryManagerThread() {
            this.setName("IAC Memory Manager");
        }

        private void detachAllAgents() {
            boolean isRecovered = false;
            String client = null;
            long pid = 0L;
            String agentName = null;
            ProcessProxy[] processes = HyadesMessageProcessorImpl.this._node.getProcesses();
            if (processes != null) {
                int i = 0;
                while (i < processes.length) {
                    ProcessProxy process = processes[i];
                    Enumeration agents = process.getAgents();
                    if (agents != null && agents.hasMoreElements()) {
                        isRecovered = true;
                        while (agents.hasMoreElements()) {
                            AgentProxy agent = (AgentProxy)agents.nextElement();
                            client = agent.getAttachedClient();
                            pid = process.getPid();
                            agentName = agent.getName();
                            DetachFromAgentCommand command = new DetachFromAgentCommand();
                            command.setAgentName(agentName);
                            command.setProcessId(pid);
                            command.setContext(0L);
                            HyadesMessageProcessorImpl.this.handleDetachFromAgent("", "", command);
                        }
                    }
                    ++i;
                }
                if (isRecovered && client != null && pid != 0L && agentName != null) {
                    ErrorCommand error = new ErrorCommand();
                    error.setContext(0L);
                    error.setProcessId(pid);
                    error.setAgentName(agentName);
                    error.setErrorId(ACStrings.ERROR_OUT_OF_MEMORY_ID);
                    error.setErrorString(String.valueOf(ACStrings.ERROR_OUT_OF_MEMORY_DETACH) + " " + ACStrings.ERROR_OUT_OF_MEMORY_RESOLUTION);
                    HyadesMessageProcessorImpl.this.sendCommand(client, error);
                }
            }
        }

        private long getFreeMem() {
            long mem = Runtime.getRuntime().freeMemory();
            return mem;
        }

        private long getMaxMem() {
            long mem = Runtime.getRuntime().maxMemory();
            return mem;
        }

        private long getTotalMem() {
            long mem = Runtime.getRuntime().totalMemory();
            return mem;
        }

        public void interrupt() {
            this._done = true;
        }

        public void run() {
            long shm = ExecutionPlugin.getInstance().getInt(ACStrings.PREF_SHARED_MEMORY_SIZE) * 1024 * 1024;
            this._maxMem = this.getMaxMem();
            TPTPLoggerImpl.log(this, 3, "JVM max memory = " + this._maxMem);
            TPTPLoggerImpl.log(this, 3, "Shared memory buffer size = " + this._maxMem);
            while (!this._done) {
                long freeMem = this.getFreeMem();
                long totalMem = this.getTotalMem();
                long maxMem = this.getMaxMem();
                long usedMem = totalMem - freeMem;
                double perUsed = (double)(usedMem + shm) / (double)maxMem;
                TPTPLoggerImpl.log(this, 3, "JVM memory usage (used/total/max) = " + usedMem + "/" + totalMem + "/" + maxMem + " (" + (int)(perUsed * 100.0) + "%)");
                if (perUsed > this._stopThreshold) {
                    TPTPLoggerImpl.log(this, 1, "Approaching JVM maximum heap memory threshold. Detaching all agents");
                    this.detachAllAgents();
                }
                try {
                    MemoryManagerThread.sleep(this._sleep);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            this.setName("IAC Shutdown");
        }

        public void run() {
            AgentController ac = AgentControllerFactoryImpl.getAgentController();
            ac.triggered();
            ac.stop();
        }
    }

    class WorkerThread
    extends Thread {
        private InputStream _inputStream;
        private OutputStream _outputStream;

        public WorkerThread(long pid, String name, OutputStream out, InputStream in) {
            this.setName("Process Worker - " + name + ": " + pid);
            this._inputStream = in;
            this._outputStream = out;
        }

        public void run() {
            byte[] buffer = new byte[BufferConstant.TPTP_CONSOLE_BUFFER_SIZE];
            int byteRead = 0;
            do {
                try {
                    byteRead = this._inputStream.read(buffer, 0, buffer.length);
                    if (byteRead <= 0) continue;
                    this._outputStream.write(buffer, 0, byteRead);
                    this._outputStream.flush();
                }
                catch (IOException iOException) {
                    return;
                }
            } while (byteRead > 0);
        }
    }
}

