/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.agentcontroller.config.PlatformObject;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Agent;
import org.eclipse.tptp.platform.agentcontroller.internal.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Application;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Option;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Parameter;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Variable;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AbstractConfigurationImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.EclipseUtility;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileConfigurationImpl
extends AbstractConfigurationImpl {
    private static FileConfigurationImpl _instance = null;
    private long DEFAULT_DATA_CHANNEL_SIZE = 0x800000L;
    private DocumentBuilder _docBuilder = null;
    private Vector _loadedConfig = new Vector();
    private String _exechome = null;
    private String _raserverhome = null;

    public static FileConfigurationImpl getInstance() {
        if (_instance == null) {
            _instance = new FileConfigurationImpl();
        }
        return _instance;
    }

    private FileConfigurationImpl() {
        try {
            this._docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        this._exechome = EclipseUtility.getBundleInstallLocation("org.eclipse.hyades.execution");
        this._raserverhome = String.valueOf(this._exechome) + File.separator + "iac-runtime";
        TPTPLoggerImpl.log(3, "IAC installation path = " + this._raserverhome);
        this.initializeGlobalVariables();
        this.load();
    }

    private void initializeGlobalVariables() {
        AgentControllerEnvironment acEnv = new AgentControllerEnvironment();
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        String libenv = os.equals("win32") ? "PATH" : (os.equals("aix") ? "LIBPATH" : (os.equals("hpux") ? "SHLIB_PATH" : "LD_LIBRARY_PATH"));
        acEnv.addVariable(new Variable(libenv, EclipseUtility.getBundleInstallLocation("org.eclipse.hyades.execution." + os + "." + arch), "prepend"));
        String swtDllPath = EclipseUtility.getBundleStoreDir("org.eclipse.swt");
        if (swtDllPath != null) {
            acEnv.addVariable(new Variable(libenv, swtDllPath, "append"));
        }
        acEnv.addVariable(new Variable("CLASSPATH", EclipseUtility.getBundleClasspath("org.eclipse.core.runtime"), "append"));
        acEnv.addVariable(new Variable("CLASSPATH", EclipseUtility.getBundleClasspath("org.eclipse.equinox.common"), "append"));
        acEnv.addVariable(new Variable("CLASSPATH", EclipseUtility.getBundleClasspath("org.eclipse.osgi"), "append"));
        this.addConfiguration(acEnv);
        ExecutionPlugin.getInstance().setString("RASERVER_HOME", this._raserverhome);
        ExecutionPlugin.getInstance().setString("ECLIPSEROOT", EclipseUtility.getEclipseRoot());
        ExecutionPlugin.getInstance().setString("PLUGINS_HOME", String.valueOf(this._raserverhome) + File.separator + "extensions");
        String apacheCommonsLoggingClasspath = EclipseUtility.getBundleClasspath("org.apache.commons_logging");
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_APACHE_COMMONS_LOGGING", apacheCommonsLoggingClasspath);
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_APACHE_JAKARTA_COMMONS_LOGGING", apacheCommonsLoggingClasspath);
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_CORE_COMMANDS", EclipseUtility.getBundleClasspath("org.eclipse.core.commands"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_CORE_RUNTIME", EclipseUtility.getBundleClasspath("org.eclipse.core.runtime"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_EMF_COMMON", EclipseUtility.getBundleClasspath("org.eclipse.emf.common"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_EMF_ECORE", EclipseUtility.getBundleClasspath("org.eclipse.emf.ecore"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_EMF_ECORE_XMI", EclipseUtility.getBundleClasspath("org.eclipse.emf.ecore.xmi"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_EQUINOX_COMMON", EclipseUtility.getBundleClasspath("org.eclipse.equinox.common"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_JFACE", EclipseUtility.getBundleClasspath("org.eclipse.jface"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_OSGI", EclipseUtility.getBundleClasspath("org.eclipse.osgi"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_ECLIPSE_SWT", EclipseUtility.getBundleClasspath("org.eclipse.swt"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_ORG_JUNIT", EclipseUtility.getBundleClasspath("org.junit"));
        ExecutionPlugin.getInstance().setString("CLASSPATH_COM_IBM_ICU", EclipseUtility.getBundleClasspath("com.ibm.icu"));
        String lib_extension = "";
        if (os.equals("win32") && arch.equals("x86")) {
            lib_extension = ".dll";
        } else if (os.equals("linux") && arch.equals("x86")) {
            lib_extension = ".so";
        } else if (os.equals("solaris") && arch.equals("sparc")) {
            lib_extension = ".so";
        } else {
            TPTPLoggerImpl.log(0, "Platform " + os + " with architecture " + arch + " is not supported by probekit.  You could get an error message indicating piAgentExtension can't be loaded");
        }
        ExecutionPlugin.getInstance().setString("LIB_EXTENSION", lib_extension);
        ExecutionPlugin.getInstance().setString("PROBEKIT_PLUGIN", EclipseUtility.getBundleInstallLocation("org.eclipse.hyades.probekit"));
        ExecutionPlugin.getInstance().setString("ECLIPSE_OS", os);
        ExecutionPlugin.getInstance().setString("ECLIPSE_ARCH", arch);
    }

    private void load() {
        File[] pluginDirs;
        File pluginBase;
        File mainConfig = new File(String.valueOf(this._raserverhome) + File.separator + "config" + File.separator + "serviceconfig.xml");
        if (mainConfig.exists() && mainConfig.isFile()) {
            Document mainDoc = this.parseFile(mainConfig.getAbsolutePath());
            if (mainDoc == null) {
                ExecutionPlugin.getInstance().setBoolean(ACStrings.PREF_ENABLED, false);
                ExecutionPlugin.getInstance().setErrorOccurred(true);
                return;
            }
            this.populateConfiguration(mainDoc);
        }
        if ((pluginBase = new File(String.valueOf(this._raserverhome) + File.separator + "extensions")).exists() && pluginBase.isDirectory() && (pluginDirs = pluginBase.listFiles()) != null) {
            int i = 0;
            while (i < pluginDirs.length) {
                this.loadPluginConfig(pluginDirs[i].getName());
                ++i;
            }
        }
    }

    private void loadPluginConfig(String pluginName) {
        TPTPLoggerImpl.log(this, 3, "Trying to load plugin (" + pluginName + ")");
        if (this._loadedConfig.contains(pluginName)) {
            TPTPLoggerImpl.log(this, 3, "Plugin (" + pluginName + ") already loaded");
        } else {
            File pluginConfigDir = new File(String.valueOf(this._raserverhome) + File.separator + "extensions" + File.separator + pluginName);
            if (pluginConfigDir.isDirectory()) {
                AgentControllerEnvironment acEnv = new AgentControllerEnvironment();
                String pluginCP = EclipseUtility.getBundleClasspath(pluginName);
                String pluginCPAlias = new String("CLASSPATH_" + pluginName).toUpperCase().replace('.', '_');
                if (pluginCP != null && pluginCPAlias != null) {
                    ExecutionPlugin.getInstance().setString(pluginCPAlias, pluginCP);
                }
                String pluginPath = EclipseUtility.getBundleInstallLocation(pluginName);
                String pluginPathAlias = new String("PATH_" + pluginName).toUpperCase().replace('.', '_');
                if (pluginPath != null && pluginPathAlias != null) {
                    ExecutionPlugin.getInstance().setString(pluginPathAlias, pluginPath);
                }
                this.addConfiguration(acEnv);
                String pluginVersion = EclipseUtility.getBundleVersion(pluginName);
                Option verOption = new Option();
                verOption.setName(pluginName);
                verOption.setType("version");
                if (pluginVersion == null) {
                    verOption.setValue("0.0.0");
                } else {
                    verOption.setValue(pluginVersion);
                }
                this.addConfiguration(verOption);
                File configFile = new File(pluginConfigDir, "config" + File.separator + "pluginconfig.xml");
                if (configFile.exists()) {
                    Document pluginDoc = this.parseFile(configFile.getAbsolutePath());
                    this.populateConfiguration(pluginDoc);
                }
                TPTPLoggerImpl.log(this, 3, "Plugin (" + pluginName + ") loaded");
                this._loadedConfig.add(pluginName);
            } else {
                TPTPLoggerImpl.log(this, 1, "Plugin path (" + pluginConfigDir.getAbsolutePath() + ") is not a directory");
            }
        }
    }

    private Document parseFile(String path) {
        Document doc = null;
        if (this._docBuilder != null) {
            try {
                doc = this._docBuilder.parse(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return doc;
    }

    private void populateConfiguration(Document doc) {
        Element rootElement = doc.getDocumentElement();
        String rootTag = rootElement.getTagName();
        if (rootTag.equals("AgentControllerConfiguration") || rootTag.equals("PluginConfiguration")) {
            NodeList childs;
            if (rootTag.equals("AgentControllerConfiguration")) {
                String filePort = rootElement.getAttribute("filePort");
                try {
                    this.setFileServerPort(Integer.parseInt(filePort));
                }
                catch (Exception exception) {
                    this.setFileServerPort(10005);
                }
            } else if (rootTag.equals("PluginConfiguration")) {
                String requires = rootElement.getAttribute("requires");
                StringTokenizer strtok = new StringTokenizer(requires, ", ");
                while (strtok.hasMoreTokens()) {
                    String require = strtok.nextToken();
                    TPTPLoggerImpl.log(this, 3, "This plugin depends on plugin: " + require);
                    this.loadPluginConfig(require);
                }
            }
            if ((childs = rootElement.getChildNodes()) != null) {
                int i = 0;
                while (i < childs.getLength()) {
                    Node item = childs.item(i);
                    if (item instanceof Element) {
                        String name;
                        Element element = (Element)item;
                        String tag = element.getTagName();
                        if (tag.equals("AgentControllerEnvironment")) {
                            NodeList acEnvChilds = element.getChildNodes();
                            if (acEnvChilds != null) {
                                AgentControllerEnvironment acEnv = new AgentControllerEnvironment();
                                int j = 0;
                                while (j < acEnvChilds.getLength()) {
                                    Element acEnvElement;
                                    String acEnvTag;
                                    Node acEnvItem = acEnvChilds.item(j);
                                    if (acEnvItem instanceof Element && (acEnvTag = (acEnvElement = (Element)acEnvItem).getTagName()).equals("Variable")) {
                                        String oldValue;
                                        String name2 = acEnvElement.getAttribute("name");
                                        String value = acEnvElement.getAttribute("value");
                                        String position = acEnvElement.getAttribute("position");
                                        if (name2.equals(PlatformObject.libEnv) || name2.equals("PATH") || name2.equals("CLASSPATH")) {
                                            value = value.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                                        }
                                        String newValue = oldValue = ExecutionPlugin.getInstance().getString(name2);
                                        if (position.equals("append")) {
                                            newValue = new String(String.valueOf(oldValue) + File.pathSeparatorChar + value);
                                        } else if (position.equals("prepend")) {
                                            newValue = new String(String.valueOf(value) + File.pathSeparatorChar + oldValue);
                                        } else if (position.equals("replace")) {
                                            newValue = new String(value);
                                        }
                                        ExecutionPlugin.getInstance().setString(name2, newValue);
                                        acEnv.addVariable(new Variable(name2, value, position));
                                    }
                                    ++j;
                                }
                                this.addConfiguration(acEnv);
                            }
                        } else if (tag.equals("Application")) {
                            name = element.getAttribute("executable");
                            String path = element.getAttribute("path");
                            String location = element.getAttribute("location");
                            Application app = new Application();
                            app = new Application(name, path, location);
                            NodeList appChilds = element.getChildNodes();
                            if (appChilds != null) {
                                int j = 0;
                                while (j < appChilds.getLength()) {
                                    Node appItem = appChilds.item(j);
                                    if (appItem instanceof Element) {
                                        Element appElement = (Element)appItem;
                                        String appTag = appElement.getTagName();
                                        if (appTag.equals("Variable")) {
                                            Variable appVar = new Variable();
                                            String varName = appElement.getAttribute("name");
                                            String varValue = appElement.getAttribute("value");
                                            String varPosition = appElement.getAttribute("position");
                                            if (varName.equals(PlatformObject.libEnv) || varName.equals("PATH") || varName.equals("CLASSPATH")) {
                                                varValue = varValue.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                                            }
                                            appVar.setName(varName);
                                            appVar.setValue(varValue);
                                            appVar.setPosition(varPosition);
                                            app.addVariable(appVar);
                                        } else if (appTag.equals("Parameter")) {
                                            Parameter appParam = new Parameter();
                                            appParam.setValue(appElement.getAttribute("value"));
                                            appParam.setPosition(appElement.getAttribute("position"));
                                            app.addParameter(appParam);
                                        }
                                    }
                                    ++j;
                                }
                            }
                            this.addConfiguration(app);
                        } else if (!tag.equals("Hosts")) {
                            String type;
                            if (tag.equals("Option")) {
                                name = element.getAttribute("name");
                                type = element.getAttribute("type");
                                String value = element.getAttribute("value");
                                Option option = new Option();
                                option.setName(name);
                                option.setType(type);
                                option.setValue(value);
                                this.addConfiguration(option);
                            } else if (tag.equals("Agent")) {
                                name = element.getAttribute("name");
                                type = element.getAttribute("type");
                                String client = element.getAttribute("client");
                                String dataChannelSize = element.getAttribute("dataChannelSize");
                                Agent agent = new Agent();
                                agent.setName(name);
                                agent.setType(type);
                                agent.setClient(client);
                                agent.setExtends(element.getAttribute("extends").toLowerCase().equals("true"));
                                long actualSize = this.DEFAULT_DATA_CHANNEL_SIZE;
                                long multiplier = 1L;
                                if (dataChannelSize != null && !dataChannelSize.equals("")) {
                                    char unit = dataChannelSize.charAt(dataChannelSize.length() - 1);
                                    if (unit == 'k' || unit == 'K') {
                                        String temp = dataChannelSize.substring(0, dataChannelSize.length() - 1);
                                        try {
                                            actualSize = Long.parseLong(temp);
                                            multiplier = 1024L;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            TPTPLoggerImpl.log(this, 1, "Error parsing shared memory channel size: " + dataChannelSize);
                                        }
                                    } else if (unit == 'm' || unit == 'M') {
                                        String temp = dataChannelSize.substring(0, dataChannelSize.length() - 1);
                                        try {
                                            actualSize = Long.parseLong(temp);
                                            multiplier = 0x100000L;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            TPTPLoggerImpl.log(this, 1, "Error parsing shared memory channel size: " + dataChannelSize);
                                        }
                                    } else if (unit == 'g' || unit == 'G') {
                                        String temp = dataChannelSize.substring(0, dataChannelSize.length() - 1);
                                        try {
                                            actualSize = Long.parseLong(temp);
                                            multiplier = 0x40000000L;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            TPTPLoggerImpl.log(this, 1, "Error parsing shared memory channel size: " + dataChannelSize);
                                        }
                                    } else {
                                        try {
                                            actualSize = Long.parseLong(dataChannelSize);
                                            multiplier = 1L;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            TPTPLoggerImpl.log(this, 1, "Error parsing shared memory channel size: " + dataChannelSize);
                                        }
                                    }
                                }
                                agent.setDataChannelSize(actualSize * multiplier);
                                TPTPLoggerImpl.log(this, 3, "Agent: " + agent.getName() + " shared memory channel size set to: " + actualSize * multiplier + " bytes");
                                NodeList agentChilds = element.getChildNodes();
                                if (agentChilds != null) {
                                    int j = 0;
                                    while (j < agentChilds.getLength()) {
                                        Element agentElement;
                                        String agentTag;
                                        Node agentItem = agentChilds.item(j);
                                        if (agentItem instanceof Element && (agentTag = (agentElement = (Element)agentItem).getTagName()).equals("Option")) {
                                            Option agentOption = new Option();
                                            agentOption.setName(agentElement.getAttribute("name"));
                                            agentOption.setValue(ExecutionPlugin.getInstance().resolveVariable(agentElement.getAttribute("value")));
                                            agentOption.setType(agentElement.getAttribute("type"));
                                            agent.addOption(agentOption);
                                        }
                                        ++j;
                                    }
                                }
                                this.addConfiguration(agent);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

