/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.File;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.AgentController;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Agent;
import org.eclipse.tptp.platform.agentcontroller.internal.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Application;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Option;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Parameter;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Variable;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConfigurationImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.EclipseUtility;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.PlatformUtility;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ExecutionPlugin
extends AbstractUIPlugin {
    public static String PLUGIN_ID = "org.eclipse.hyades.execution";
    public static String AC_CONFIG_EXTENTION_POINT = "acConfig";
    private static int APPLICATION = 0;
    private static int BUNDLE_CLASSPATH = 1;
    private static int BUNDLE_PATH = 2;
    private static int JAVA_PROPERTY = 3;
    private static int SYSTEM_ENVIRONMENT = 4;
    private static int NUM_ALIASES = 5;
    private static String[] _aliases = new String[NUM_ALIASES];
    private static String ALIAS_RELATIVE_PATH = "./";
    private static String ALIAS_END = ")";
    private static ExecutionPlugin _instance;
    private IPreferenceStore _preferenceStore;
    private boolean _errorOccurred = false;

    static {
        ExecutionPlugin._aliases[ExecutionPlugin.APPLICATION] = "$A(";
        ExecutionPlugin._aliases[ExecutionPlugin.BUNDLE_CLASSPATH] = "$C(";
        ExecutionPlugin._aliases[ExecutionPlugin.BUNDLE_PATH] = "$P(";
        ExecutionPlugin._aliases[ExecutionPlugin.JAVA_PROPERTY] = "$J(";
        ExecutionPlugin._aliases[ExecutionPlugin.SYSTEM_ENVIRONMENT] = "$E(";
    }

    public ExecutionPlugin() {
        _instance = this;
        this._preferenceStore = this.getPreferenceStore();
        this.initialize();
    }

    public ExecutionPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        _instance = this;
        this._preferenceStore = this.getPreferenceStore();
        this.initialize();
    }

    public boolean getBoolean(String name) {
        return this._preferenceStore.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this._preferenceStore.getDefaultBoolean(name);
    }

    public int getDefaultInt(String name) {
        return this._preferenceStore.getDefaultInt(name);
    }

    public String getDefaultString(String name) {
        return this._preferenceStore.getDefaultString(name);
    }

    public static ExecutionPlugin getInstance() {
        return _instance;
    }

    public int getInt(String name) {
        return this._preferenceStore.getInt(name);
    }

    public String getString(String name) {
        return this._preferenceStore.getString(name);
    }

    private void initialize() {
        AgentController agentController = AgentControllerFactoryImpl.getAgentController();
        if (this.getBoolean(ACStrings.PREF_ENABLED)) {
            agentController.setSocketEnabled(this.getBoolean(ACStrings.PREF_SOCKET_ENABLED));
            agentController.setPort(this.getInt(ACStrings.PREF_SOCKET_PORT));
            TPTPLoggerImpl.setEnabled(this.getBoolean(ACStrings.PREF_LOGGING_ENABLED));
            TPTPLoggerImpl.setLoggingLevel(this.getInt(ACStrings.PREF_LOGGING_LEVEL));
            agentController.setAutoStart(this.getBoolean(ACStrings.PREF_AUTO_START));
            if (this.getBoolean(ACStrings.PREF_AUTO_START)) {
                agentController.start();
            }
        }
    }

    public boolean isErrorOccurred() {
        return this._errorOccurred;
    }

    private void processConfigurationElement(IConfigurationElement config) {
        String configName = config.getName();
        String namespace = config.getNamespace();
        if (configName.equals("AgentControllerEnvironment")) {
            AgentControllerEnvironment env = new AgentControllerEnvironment();
            IConfigurationElement[] variables = config.getChildren("Variable");
            int j = 0;
            while (j < variables.length) {
                IConfigurationElement variable = variables[j];
                String name = variable.getAttribute("name");
                String value = this.resolveAlias(variable.getAttribute("value"));
                if (value.startsWith(ALIAS_RELATIVE_PATH)) {
                    value = this.resolveBundleRelativePath(value, namespace);
                }
                String position = variable.getAttribute("position");
                Variable var = new Variable(name, value, position);
                env.addVariable(var);
                ++j;
            }
            ConfigurationImpl.getInstance().addConfiguration(env);
        } else if (configName.equals("Application")) {
            String executable = config.getAttribute("executable");
            String path = this.resolveAlias(config.getAttribute("path"));
            String location = this.resolveAlias(config.getAttribute("location"));
            String extend = config.getAttribute("extends");
            String os = config.getAttribute("os");
            String arch = config.getAttribute("arch");
            if (os != null && os.length() != 0 && !os.equals(Platform.getOS())) {
                return;
            }
            if (arch != null && arch.length() != 0 && !arch.equals(Platform.getOSArch())) {
                return;
            }
            if (path.startsWith(ALIAS_RELATIVE_PATH)) {
                path = this.resolveBundleRelativePath(path, namespace);
            }
            if (location.startsWith(ALIAS_RELATIVE_PATH)) {
                location = this.resolveBundleRelativePath(location, namespace);
            }
            Application app = new Application(executable, path, location);
            if (extend != null) {
                app.setExtends(extend.toLowerCase().equals("true"));
            }
            IConfigurationElement[] parameters = config.getChildren("Parameter");
            int j = 0;
            while (j < parameters.length) {
                IConfigurationElement parameter = parameters[j];
                String value = this.resolveAlias(parameter.getAttribute("value"));
                if (value.startsWith(ALIAS_RELATIVE_PATH)) {
                    value = this.resolveBundleRelativePath(value, namespace);
                }
                String position = parameter.getAttribute("position");
                app.addParameter(new Parameter(value, position));
                ++j;
            }
            IConfigurationElement[] variables = config.getChildren("Variable");
            int j2 = 0;
            while (j2 < variables.length) {
                IConfigurationElement variable = variables[j2];
                String name = variable.getAttribute("name");
                String value = this.resolveAlias(variable.getAttribute("value"));
                if (value.startsWith(ALIAS_RELATIVE_PATH)) {
                    value = this.resolveBundleRelativePath(value, namespace);
                }
                String position = variable.getAttribute("position");
                app.addVariable(new Variable(name, value, position));
                ++j2;
            }
            ConfigurationImpl.getInstance().addConfiguration(app);
        } else if (configName.equals("Option")) {
            String name = config.getAttribute("name");
            String type = config.getAttribute("type");
            String value = this.resolveAlias(config.getAttribute("value"));
            if (value.startsWith(ALIAS_RELATIVE_PATH)) {
                value = this.resolveBundleRelativePath(value, namespace);
            }
            ConfigurationImpl.getInstance().addConfiguration(new Option(name, type, value));
        } else if (configName.equals("Agent")) {
            String name = config.getAttribute("name");
            String type = config.getAttribute("type");
            String dataChannelSize = config.getAttribute("dataChannelSize");
            String logFile = this.resolveAlias(config.getAttribute("logFile"));
            if (logFile.startsWith(ALIAS_RELATIVE_PATH)) {
                logFile = this.resolveBundleRelativePath(logFile, namespace);
            }
            String client = config.getAttribute("client");
            String extend = config.getAttribute("extends");
            Agent agent = new Agent();
            agent.setName(name);
            if (type != null) {
                agent.setType(type);
            }
            if (dataChannelSize != null) {
                long size = 0L;
                long multiplier = 1L;
                if ((dataChannelSize = dataChannelSize.toUpperCase()).endsWith("M")) {
                    multiplier = 0x100000L;
                    dataChannelSize = dataChannelSize.substring(0, dataChannelSize.length() - 1);
                } else if (dataChannelSize.endsWith("K")) {
                    multiplier = 1024L;
                    dataChannelSize = dataChannelSize.substring(0, dataChannelSize.length() - 1);
                }
                try {
                    size = Long.parseLong(dataChannelSize);
                    agent.setDataChannelSize(size * multiplier);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (logFile != null) {
                agent.setLogFile("logFile");
            }
            if (client != null) {
                agent.setClient(client);
            }
            if (extend != null) {
                agent.setExtends(extend.toLowerCase().equals("true"));
            }
            IConfigurationElement[] options = config.getChildren("Option");
            int j = 0;
            while (j < options.length) {
                IConfigurationElement option = options[j];
                String name_2 = option.getAttribute("name");
                String type_2 = option.getAttribute("type");
                String value_2 = this.resolveAlias(option.getAttribute("value"));
                if (value_2.startsWith(ALIAS_RELATIVE_PATH)) {
                    value_2 = this.resolveBundleRelativePath(value_2, namespace);
                }
                agent.addOption(new Option(name_2, type_2, value_2));
                ++j;
            }
            ConfigurationImpl.getInstance().addConfiguration(agent);
        }
    }

    public String resolveAlias(String oldString) {
        boolean done = false;
        if (oldString == null) {
            return new String("");
        }
        String newString = new String(oldString);
        do {
            int startIndex = -1;
            int aliasInUse = -1;
            int i = 0;
            while (i < NUM_ALIASES) {
                if (newString.indexOf(_aliases[i], 0) >= 0) {
                    startIndex = newString.indexOf(_aliases[i], 0);
                    aliasInUse = i;
                    break;
                }
                ++i;
            }
            if (startIndex >= 0) {
                int endIndex = newString.indexOf(ALIAS_END, startIndex);
                if (endIndex > 0) {
                    StringBuffer strbuf = new StringBuffer();
                    String aliasName = newString.substring(startIndex + _aliases[aliasInUse].length(), endIndex);
                    String aliasValue = null;
                    if (aliasName != null && aliasName.length() > 0) {
                        if (aliasInUse == APPLICATION) {
                            aliasValue = ConfigurationImpl.getInstance().resolveExecutableName(aliasName);
                        } else if (aliasInUse == BUNDLE_CLASSPATH) {
                            aliasValue = EclipseUtility.getBundleClasspath(aliasName);
                        } else if (aliasInUse == BUNDLE_PATH) {
                            aliasValue = EclipseUtility.getBundleInstallLocation(aliasName);
                        } else if (aliasInUse == JAVA_PROPERTY) {
                            aliasValue = System.getProperty(aliasName);
                        } else if (aliasInUse == SYSTEM_ENVIRONMENT) {
                            aliasValue = PlatformUtility.getEnvironment(aliasName);
                        }
                    }
                    strbuf.append(newString.substring(0, startIndex));
                    if (aliasValue != null) {
                        strbuf.append(aliasValue);
                    }
                    if (endIndex + ALIAS_END.length() < newString.length()) {
                        strbuf.append(newString.substring(endIndex + ALIAS_END.length()));
                    }
                    newString = strbuf.toString();
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        return newString;
    }

    private String resolveBundleRelativePath(String relativePath, String bundleName) {
        String newPath = relativePath;
        String bundlePath = EclipseUtility.getBundleInstallLocation(bundleName);
        if (bundlePath != null) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(bundlePath);
            strbuf.append(File.separator);
            if (newPath.length() > ALIAS_RELATIVE_PATH.length()) {
                strbuf.append(newPath.substring(ALIAS_RELATIVE_PATH.length()));
            }
            newPath = strbuf.toString();
        }
        return newPath;
    }

    public String resolveVariable(String str) {
        String result = str;
        boolean done = false;
        int start = 0;
        int end = result.length() - 1;
        while (!done) {
            start = result.indexOf(37, 0);
            if (start != -1) {
                end = start + 1;
                if (end < result.length()) {
                    if ((end = result.indexOf(37, end)) != -1) {
                        if (end - start > 1) {
                            String alias = result.substring(start + 1, end);
                            String value = this.getString(alias);
                            if (value != null) {
                                StringBuffer strbuf = new StringBuffer();
                                strbuf.append(result.substring(0, start));
                                strbuf.append(value);
                                strbuf.append(result.substring(end + 1));
                                result = strbuf.toString();
                            }
                            if ((end = (start = end + 1) + 1) < result.length()) continue;
                            done = true;
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        TPTPLoggerImpl.log((Object)this, 3, "Resolved alias (" + str + ") to (" + result + ")");
        return result;
    }

    public void setBoolean(String name, boolean value) {
        this._preferenceStore.setValue(name, value);
        if (name.equals(ACStrings.PREF_AUTO_START)) {
            AgentControllerFactoryImpl.getAgentController().setAutoStart(value);
        } else if (name.equals(ACStrings.PREF_ENABLED)) {
            AgentControllerFactoryImpl.getAgentController().setEnabled(value);
        } else if (name.equals(ACStrings.PREF_LOGGING_ENABLED)) {
            TPTPLoggerImpl.setEnabled(value);
        } else if (name.equals(ACStrings.PREF_SOCKET_ENABLED)) {
            AgentControllerFactoryImpl.getAgentController().setSocketEnabled(value);
        }
    }

    protected void setErrorOccurred(boolean error) {
        this._errorOccurred = error;
    }

    public void setInt(String name, int value) {
        this._preferenceStore.setValue(name, value);
        if (name.equals(ACStrings.PREF_LOGGING_LEVEL) && value < 4) {
            TPTPLoggerImpl.setLoggingLevel(value);
        }
        if (name.equals(ACStrings.PREF_SOCKET_PORT) && value < 65536) {
            AgentControllerFactoryImpl.getAgentController().setPort(value);
        }
    }

    public void setString(String name, String value) {
        this._preferenceStore.setValue(name, value);
        if (name.equals(ACStrings.PREF_LOGGING_DIRECTORY)) {
            TPTPLoggerImpl.setLoggingDirectory(value);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, AC_CONFIG_EXTENTION_POINT);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement config = elements[i];
                this.processConfigurationElement(config);
                ++i;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

