/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.File;
import java.util.Dictionary;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class EclipseUtility {
    private static boolean _isRunning = false;

    static {
        try {
            Class.forName("org.eclipse.core.runtime.Platform");
            _isRunning = Platform.isRunning();
            if (_isRunning) {
                TPTPLoggerImpl.log(3, "Eclipse Platform is running");
            } else {
                TPTPLoggerImpl.log(3, "Eclipse Platform is not running");
            }
        }
        catch (Exception exception) {
            TPTPLoggerImpl.log(3, "Eclipse Platform is not running");
        }
    }

    public static String getBaseDataClasspath(BaseData baseData) {
        StringBuffer strbuf = new StringBuffer();
        BundleFile bundleFile = baseData.getBundleFile();
        if (bundleFile != null) {
            File file = bundleFile.getBaseFile();
            if (file.exists() && file.isFile()) {
                String path = file.getAbsolutePath();
                strbuf.append(path);
                if (!path.endsWith(File.pathSeparator)) {
                    strbuf.append(File.pathSeparator);
                }
            } else if (file.exists() && file.isDirectory()) {
                String[] cp = null;
                try {
                    cp = baseData.getClassPath();
                }
                catch (BundleException bundleException) {}
                if (cp != null) {
                    int i = 0;
                    while (i < cp.length) {
                        strbuf.append(String.valueOf(file.getAbsolutePath()) + File.separator + cp[i] + File.pathSeparator);
                        ++i;
                    }
                } else {
                    strbuf.append(String.valueOf(file.getAbsolutePath()) + File.pathSeparator);
                }
            } else {
                TPTPLoggerImpl.log(1, "Cannot resolve the classpath for plugin: " + baseData.getSymbolicName());
            }
        }
        if (strbuf.length() > 0) {
            return strbuf.toString();
        }
        return new String("");
    }

    public static String getBaseDataStoreDir(BaseData baseData) {
        StringBuffer strbuf = new StringBuffer();
        if (baseData != null) {
            StorageHook[] storageHooks = baseData.getStorageHooks();
            int i = 0;
            while (storageHooks != null && i < storageHooks.length) {
                BaseStorageHook baseStorageHook;
                if (storageHooks[i] instanceof BaseStorageHook && (baseStorageHook = (BaseStorageHook)storageHooks[i]) != null) {
                    try {
                        File bundleStore = baseStorageHook.getBundleStore();
                        strbuf.append(EclipseUtility.getPathDirectories(bundleStore));
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                ++i;
            }
        }
        if (strbuf.length() > 0) {
            return strbuf.toString();
        }
        return new String("");
    }

    public static Bundle getBundle(String bundleName) {
        if (bundleName != null) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                TPTPLoggerImpl.log(1, "Cannot resolve Bundle for: " + bundleName);
            }
            return bundle;
        }
        return null;
    }

    public static String getBundleClasspath(Bundle bundle) {
        String bundlePath;
        BundleData bundleData;
        StringBuffer strbuf = new StringBuffer();
        if (bundle != null && bundle instanceof BundleHost) {
            BundleHost bundleHost = (BundleHost)bundle;
            BundleData bundleData2 = bundleHost.getBundleData();
            if (bundleData2 != null && bundleData2 instanceof BaseData) {
                BaseData baseData = (BaseData)bundleData2;
                strbuf.append(EclipseUtility.getBaseDataClasspath(baseData));
                if (strbuf.charAt(strbuf.length() - 1) != File.pathSeparatorChar) {
                    strbuf.append(File.pathSeparator);
                }
            }
            Bundle[] fragments = EclipseUtility.getFragments(bundle);
            int i = 0;
            while (fragments != null && i < fragments.length) {
                strbuf.append(EclipseUtility.getBundleClasspath(fragments[i]));
                if (strbuf.charAt(strbuf.length() - 1) != File.pathSeparatorChar) {
                    strbuf.append(File.pathSeparator);
                }
                ++i;
            }
        } else if (bundle != null && bundle instanceof BundleFragment && (bundleData = ((BundleFragment)bundle).getBundleData()) != null && bundleData instanceof BaseData) {
            BaseData baseData = (BaseData)bundleData;
            strbuf.append(EclipseUtility.getBaseDataClasspath(baseData));
            if (strbuf.charAt(strbuf.length() - 1) != File.pathSeparatorChar) {
                strbuf.append(File.pathSeparator);
            }
        }
        if (bundle != null && (bundlePath = EclipseUtility.getBundleInstallLocation(bundle)) != null) {
            strbuf.append(String.valueOf(bundlePath) + File.separator + "bin");
            if (strbuf.charAt(strbuf.length() - 1) != File.pathSeparatorChar) {
                strbuf.append(File.pathSeparator);
            }
        }
        if (strbuf.length() > 0) {
            return strbuf.toString();
        }
        return new String("");
    }

    public static String getBundleClasspath(String bundleName) {
        return EclipseUtility.getBundleClasspath(EclipseUtility.getBundle(bundleName));
    }

    public static String[] getBundleDependencies(Bundle bundle) {
        StringTokenizer strtok;
        int count;
        Vector<String> depends = new Vector<String>();
        String dependString = EclipseUtility.getBundleDependenciesAsString(bundle);
        String[] returnType = new String[]{};
        if (dependString.length() > 0 && (count = (strtok = new StringTokenizer(dependString, ",")).countTokens()) > 0) {
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (token.indexOf(59) > 0) {
                    token = token.substring(0, token.indexOf(59) - 1);
                }
                if (Platform.getBundle((String)token) == null) continue;
                depends.addElement(token);
            }
        }
        return depends.toArray(returnType);
    }

    public static String getBundleDependenciesAsString(Bundle bundle) {
        BundleData bundleData = null;
        StringBuffer strbuf = new StringBuffer();
        if (bundle != null && bundle instanceof BundleHost) {
            BundleHost bundleHost = (BundleHost)bundle;
            bundleData = bundleHost.getBundleData();
        } else if (bundle != null && bundle instanceof BundleFragment) {
            bundleData = ((BundleFragment)bundle).getBundleData();
        }
        if (bundleData != null) {
            try {
                Dictionary dictionary = bundleData.getManifest();
                if (dictionary != null) {
                    strbuf.append((String)dictionary.get("Require-Bundle"));
                }
            }
            catch (BundleException bundleException) {}
        }
        Bundle[] fragments = EclipseUtility.getFragments(bundle);
        int i = 0;
        while (fragments != null && i < fragments.length) {
            strbuf.append("," + EclipseUtility.getBundleDependenciesAsString(fragments[i]));
            ++i;
        }
        if (strbuf.length() > 0) {
            return strbuf.toString();
        }
        return new String("");
    }

    public static String[] getBundleDependencies(String bundleName) {
        return EclipseUtility.getBundleDependencies(EclipseUtility.getBundle(bundleName));
    }

    public static BundleFile getBundleFile(Bundle bundle) {
        if (bundle != null && bundle instanceof BaseData) {
            return ((BaseData)bundle).getBundleFile();
        }
        if (bundle != null && bundle instanceof BundleHost) {
            BundleData bundleData = ((BundleHost)bundle).getBundleData();
            if (bundleData != null && bundleData instanceof BaseData) {
                return ((BaseData)bundleData).getBundleFile();
            }
            return null;
        }
        if (bundle != null && bundle instanceof BundleFragment) {
            BundleData bundleData = ((BundleFragment)bundle).getBundleData();
            if (bundleData != null && bundleData instanceof BaseData) {
                return ((BaseData)bundleData).getBundleFile();
            }
            return null;
        }
        return null;
    }

    public static BundleFile getBundleFile(String bundleName) {
        return EclipseUtility.getBundleFile(EclipseUtility.getBundle(bundleName));
    }

    public static String getBundleInstallLocation(Bundle bundle) {
        String path = null;
        if (bundle != null) {
            File file;
            BundleFile bundleFile = EclipseUtility.getBundleFile(bundle);
            if (bundleFile != null && (file = bundleFile.getBaseFile()).exists() && file.isDirectory()) {
                path = file.getAbsolutePath();
            }
            if (path == null) {
                TPTPLoggerImpl.log(1, "Cannot resolve the path for plugin: " + bundle.getSymbolicName());
            }
            return path;
        }
        return new String("");
    }

    public static String getBundleInstallLocation(String bundleName) {
        return EclipseUtility.getBundleInstallLocation(EclipseUtility.getBundle(bundleName));
    }

    public static String getBundleStoreDir(Bundle bundle) {
        BundleFragment bundleFragment;
        BundleData bundleData;
        StringBuffer strbuf = new StringBuffer();
        if (bundle != null && bundle instanceof BundleHost) {
            BundleHost bundleHost = (BundleHost)bundle;
            BundleData bundleData2 = bundleHost.getBundleData();
            if (bundleData2 != null && bundleData2 instanceof BaseData) {
                strbuf.append(EclipseUtility.getBaseDataStoreDir((BaseData)bundleData2));
            }
            Bundle[] fragments = EclipseUtility.getFragments(bundle);
            int i = 0;
            while (i < fragments.length) {
                strbuf.append(EclipseUtility.getBundleStoreDir(fragments[i]));
                ++i;
            }
        } else if (bundle != null && bundle instanceof BundleFragment && (bundleData = (bundleFragment = (BundleFragment)bundle).getBundleData()) != null && bundleData instanceof BaseData) {
            strbuf.append(EclipseUtility.getBaseDataStoreDir((BaseData)bundleData));
        }
        if (strbuf.length() > 0) {
            return strbuf.toString();
        }
        return new String("");
    }

    public static String getBundleStoreDir(String bundleName) {
        return EclipseUtility.getBundleStoreDir(EclipseUtility.getBundle(bundleName));
    }

    public static String getBundleVersion(Bundle bundle) {
        if (bundle != null) {
            if (bundle instanceof BundleHost) {
                BundleData bundleData = ((BundleHost)bundle).getBundleData();
                if (bundleData != null && bundleData instanceof BaseData) {
                    BaseData baseData = (BaseData)bundleData;
                    int verMajor = baseData.getVersion().getMajor();
                    int verMinor = baseData.getVersion().getMinor();
                    int verMicro = baseData.getVersion().getMicro();
                    return new String(String.valueOf(verMajor) + "." + verMinor + "." + verMicro);
                }
                return new String("0.0.0");
            }
            return new String("0.0.0");
        }
        return new String("0.0.0");
    }

    public static String getBundleVersion(String bundleName) {
        return EclipseUtility.getBundleVersion(EclipseUtility.getBundle(bundleName));
    }

    public static String getEclipseRoot() {
        File f = new File(Platform.getInstallLocation().getURL().getPath());
        return f.getAbsolutePath();
    }

    public static Bundle[] getFragments(Bundle bundle) {
        return Platform.getFragments((Bundle)bundle);
    }

    public static Bundle[] getFragments(String bundleName) {
        Bundle bundle = EclipseUtility.getBundle(bundleName);
        if (bundle != null) {
            return EclipseUtility.getFragments(bundle);
        }
        return null;
    }

    private static String getPathDirectories(File dir) {
        StringBuffer strbuf = new StringBuffer();
        if (dir.isDirectory()) {
            boolean isContainFiles = false;
            File[] files = dir.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                if (files[i].isFile()) {
                    isContainFiles = true;
                } else if (files[i].isDirectory()) {
                    strbuf.append(EclipseUtility.getPathDirectories(files[i]));
                }
                ++i;
            }
            if (isContainFiles) {
                strbuf.append(String.valueOf(dir.getAbsolutePath()) + File.pathSeparator);
            }
        }
        if (strbuf.length() > 0) {
            return strbuf.toString();
        }
        return new String("");
    }
}

