/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.conformance;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.ws.internal.conformance.IJavaBeanProperty;
import org.eclipse.jst.ws.internal.conformance.JavaBeanProperty;

public class JDTResolver {
    private IJavaProject javaProject_;
    private IProgressMonitor monitor_;
    private static String[] wrapperTypes_ = new String[]{"java.lang.Character", "java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private static String[] primitiveTypes_ = new String[]{"char", "boolean", "byte", "short", "int", "long", "float", "double"};
    private static String[] jaxrpcTypes_ = new String[]{"boolean", "byte", "short", "int", "long", "float", "double", "java.lang.String", "java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.util.Date", "java.util.Calendar", "java.math.BigInteger", "java.math.BigDecimal", "java.net.URI", "javax.xml.namespace.QName"};

    public JDTResolver(IProject project, IProgressMonitor monitor) {
        this.javaProject_ = JavaCore.create((IProject)project);
        this.monitor_ = monitor;
    }

    public boolean isInterface(IType jdtType) throws JavaModelException {
        return jdtType.isInterface();
    }

    public boolean isAbstract(IType jdtType) throws JavaModelException {
        return Flags.isAbstract((int)jdtType.getFlags());
    }

    public boolean isConstructable(IType jdtType) throws JavaModelException {
        IMethod[] methods = jdtType.getMethods();
        int numberOfConstructors = 0;
        int m = 0;
        while (m < methods.length) {
            if (methods[m].isConstructor()) {
                ++numberOfConstructors;
                if (methods[m].getNumberOfParameters() == 0 && Flags.isPublic((int)methods[m].getFlags())) {
                    return true;
                }
            }
            ++m;
        }
        return numberOfConstructors == 0;
    }

    public boolean isStandardType(String typeName) {
        return typeName.startsWith("java.") || typeName.startsWith("javax.");
    }

    public boolean isPrimitiveType(String typeName) {
        int i = 0;
        while (i < primitiveTypes_.length) {
            if (primitiveTypes_[i].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isWrapperType(String typeName) {
        int i = 0;
        while (i < wrapperTypes_.length) {
            if (wrapperTypes_[i].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isJAXRPCStandardType(String typeName) {
        int i = 0;
        while (i < jaxrpcTypes_.length) {
            if (jaxrpcTypes_[i].equals(typeName)) {
                return true;
            }
            ++i;
        }
        if (this.isWrapperType(typeName) && !"java.lang.Character".equals(typeName)) {
            return true;
        }
        return this.isPrimitiveType(typeName) && !"char".equals(typeName);
    }

    public IField[] getPublicFields(IType jdtType, IType[] jdtSuperClasses) throws JavaModelException {
        LinkedList fieldsList = new LinkedList();
        this.harvestPublicFields(jdtType, fieldsList);
        if (jdtSuperClasses != null) {
            int t = 0;
            while (t < jdtSuperClasses.length) {
                this.harvestPublicFields(jdtSuperClasses[t], fieldsList);
                ++t;
            }
        }
        return fieldsList.toArray(new IField[0]);
    }

    public IMethod[] getPublicMethods(IType jdtType, IType[] jdtSuperClasses) throws JavaModelException {
        LinkedList methodsList = new LinkedList();
        this.harvestPublicMethods(jdtType, methodsList);
        if (jdtSuperClasses != null) {
            int t = 0;
            while (t < jdtSuperClasses.length) {
                this.harvestPublicMethods(jdtSuperClasses[t], methodsList);
                ++t;
            }
        }
        return methodsList.toArray(new IMethod[0]);
    }

    public IJavaBeanProperty[] getPublicProperties(IType jdtType, IType[] jdtSuperClasses) throws JavaModelException {
        IMethod[] methods = this.getPublicMethods(jdtType, jdtSuperClasses);
        HashMap<String, JavaBeanProperty> properties = new HashMap<String, JavaBeanProperty>();
        int m = 0;
        while (m < methods.length) {
            JavaBeanProperty property;
            String name = this.getGetterName(methods[m]);
            if (name != null) {
                property = (JavaBeanProperty)properties.get(name);
                if (property == null) {
                    property = new JavaBeanProperty();
                    property.setName(name);
                    properties.put(name, property);
                }
                property.setGetter(methods[m]);
            } else {
                name = this.getSetterName(methods[m]);
                if (name != null) {
                    property = (JavaBeanProperty)properties.get(name);
                    if (property == null) {
                        property = new JavaBeanProperty();
                        property.setName(name);
                        properties.put(name, property);
                    }
                    property.setSetter(methods[m]);
                }
            }
            ++m;
        }
        return properties.values().toArray(new JavaBeanProperty[0]);
    }

    public IType getFieldType(IField jdtField) throws JavaModelException {
        IJavaElement elem = jdtField.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String signature = jdtField.getTypeSignature();
        String typeName = this.getTypeNameFromSignature(signature);
        return this.findType(typeName, ancestor);
    }

    public String getFieldTypeName(IField jdtField) throws JavaModelException {
        IJavaElement elem = jdtField.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String signature = jdtField.getTypeSignature();
        String typeName = this.getTypeNameFromSignature(signature);
        return this.resolveType(typeName, ancestor);
    }

    public IType getPropertyType(IJavaBeanProperty javaBeanProperty) throws JavaModelException {
        IType[] parameters;
        IMethod method = javaBeanProperty.getGetter();
        if (method != null) {
            return this.getReturnType(method);
        }
        method = javaBeanProperty.getSetter();
        if (method != null && (parameters = this.getParameterTypes(method)).length > 0) {
            return parameters[parameters.length - 1];
        }
        return null;
    }

    public String getPropertyTypeName(IJavaBeanProperty javaBeanProperty) throws JavaModelException {
        String[] parameterTypeNames;
        IMethod method = javaBeanProperty.getGetter();
        if (method != null) {
            return this.getReturnTypeName(method);
        }
        method = javaBeanProperty.getSetter();
        if (method != null && (parameterTypeNames = this.getParameterTypeNames(method)).length > 0) {
            return parameterTypeNames[0];
        }
        return null;
    }

    public IType getReturnType(IMethod jdtMethod) throws JavaModelException {
        IJavaElement elem = jdtMethod.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String signature = jdtMethod.getReturnType();
        String typeName = this.getTypeNameFromSignature(signature);
        return this.findType(typeName, ancestor);
    }

    public String getReturnTypeName(IMethod jdtMethod) throws JavaModelException {
        IJavaElement elem = jdtMethod.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String signature = jdtMethod.getReturnType();
        String typeName = this.getTypeNameFromSignature(signature);
        return this.resolveType(typeName, ancestor);
    }

    public IType[] getParameterTypes(IMethod jdtMethod) throws JavaModelException {
        IJavaElement elem = jdtMethod.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String[] signatures = jdtMethod.getParameterTypes();
        IType[] types = new IType[signatures.length];
        int s = 0;
        while (s < signatures.length) {
            String typeName = this.getTypeNameFromSignature(signatures[s]);
            types[s] = this.findType(typeName, ancestor);
            ++s;
        }
        return types;
    }

    public String[] getParameterTypeNames(IMethod jdtMethod) throws JavaModelException {
        IJavaElement elem = jdtMethod.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String[] signatures = jdtMethod.getParameterTypes();
        String[] typeNames = new String[signatures.length];
        int s = 0;
        while (s < signatures.length) {
            String typeName = this.getTypeNameFromSignature(signatures[s]);
            typeNames[s] = this.resolveType(typeName, ancestor);
            ++s;
        }
        return typeNames;
    }

    public IType[] getExceptionTypes(IMethod jdtMethod) throws JavaModelException {
        IJavaElement elem = jdtMethod.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String[] signatures = jdtMethod.getExceptionTypes();
        IType[] types = new IType[signatures.length];
        int s = 0;
        while (s < signatures.length) {
            String typeName = this.getTypeNameFromSignature(signatures[s]);
            types[s] = this.findType(typeName, ancestor);
            ++s;
        }
        return types;
    }

    public String[] getExceptionTypeNames(IMethod jdtMethod) throws JavaModelException {
        IJavaElement elem = jdtMethod.getAncestor(7);
        IType ancestor = elem instanceof IType ? (IType)elem : null;
        String[] signatures = jdtMethod.getExceptionTypes();
        String[] typeNames = new String[signatures.length];
        int s = 0;
        while (s < signatures.length) {
            String typeName = this.getTypeNameFromSignature(signatures[s]);
            typeNames[s] = this.resolveType(typeName, ancestor);
            ++s;
        }
        return typeNames;
    }

    public IType[] getSuperClasses(IType jdtType) throws JavaModelException {
        return this.getSuperClasses(jdtType, "java.lang.Object");
    }

    public IType[] getSuperClasses(IType jdtType, String stopClassName) throws JavaModelException {
        ITypeHierarchy hierarchy = jdtType.newSupertypeHierarchy(this.monitor_);
        IType[] allSuperClasses = hierarchy.getAllSuperclasses(jdtType);
        LinkedList<IType> superClasses = new LinkedList<IType>();
        int i = 0;
        while (i < allSuperClasses.length) {
            if (allSuperClasses[i].getFullyQualifiedName().equals(stopClassName)) break;
            superClasses.add(allSuperClasses[i]);
            ++i;
        }
        return superClasses.toArray(new IType[0]);
    }

    public String getTypeNameFromSignature(String signature) {
        String packageName = Signature.getSignatureQualifier((String)signature);
        String baseName = Signature.getSignatureSimpleName((String)signature);
        String typeName = String.valueOf(packageName.trim().equals("") ? "" : String.valueOf(packageName) + ".") + baseName;
        return typeName;
    }

    public String resolveType(String typeName, IType ancestor) throws JavaModelException {
        String[][] matches;
        if (ancestor != null && (matches = ancestor.resolveType(typeName)) != null && matches.length > 0) {
            StringBuffer qname = new StringBuffer();
            int n = matches[0].length;
            int j = 0;
            while (j < n - 1) {
                qname.append(matches[0][j]).append(".");
                ++j;
            }
            if (n >= 0) {
                qname.append(matches[0][n - 1]);
            }
            return qname.toString();
        }
        return typeName;
    }

    public IType findType(String typeName, IType ancestor) throws JavaModelException {
        String[][] matches;
        IType type = this.javaProject_.findType(typeName);
        if (type == null && ancestor != null && (matches = ancestor.resolveType(typeName)) != null) {
            int i = 0;
            while (type == null && i < matches.length) {
                StringBuffer qname = new StringBuffer();
                int n = matches[i].length;
                int j = 0;
                while (j < n - 1) {
                    qname.append(matches[i][j]).append(".");
                    ++j;
                }
                if (n >= 0) {
                    qname.append(matches[i][n - 1]);
                }
                type = this.javaProject_.findType(qname.toString());
                ++i;
            }
        }
        return type;
    }

    public void harvestPublicMethods(IType jdtType, List list) throws JavaModelException {
        IMethod[] methods = jdtType.getMethods();
        int m = 0;
        while (m < methods.length) {
            if (!methods[m].isConstructor() && Flags.isPublic((int)methods[m].getFlags())) {
                list.add(methods[m]);
            }
            ++m;
        }
    }

    public void harvestPublicFields(IType jdtType, List list) throws JavaModelException {
        IField[] fields = jdtType.getFields();
        int f = 0;
        while (f < fields.length) {
            if (Flags.isPublic((int)fields[f].getFlags())) {
                list.add(fields[f]);
            }
            ++f;
        }
    }

    public String getGetterName(IMethod method) {
        try {
            String signature;
            String returnTypeName;
            String methodName = method.getElementName();
            if (methodName.startsWith("get") && methodName.length() > 3) {
                String signature2 = method.getSignature();
                String returnTypeName2 = Signature.getReturnType((String)signature2);
                if (returnTypeName2 != null && returnTypeName2 != "V") {
                    String indexTypeName;
                    String[] parameterSignatures = method.getParameterTypes();
                    if (parameterSignatures.length == 0) {
                        return String.valueOf(methodName.substring(3, 4).toLowerCase()) + methodName.substring(4);
                    }
                    if (parameterSignatures.length == 1 && (indexTypeName = this.getTypeNameFromSignature(parameterSignatures[0])).equals("int")) {
                        return String.valueOf(methodName.substring(3, 4).toLowerCase()) + methodName.substring(4);
                    }
                }
            } else if (methodName.startsWith("is") && methodName.length() > 2 && "Z".equals(returnTypeName = Signature.getReturnType((String)(signature = method.getSignature()))) && method.getParameterTypes().length == 0) {
                return String.valueOf(methodName.substring(2, 3).toLowerCase()) + methodName.substring(3);
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    public String getSetterName(IMethod method) {
        try {
            String signature;
            String returnTypeName;
            String methodName = method.getElementName();
            if (methodName.startsWith("set") && methodName.length() > 3 && "V".equals(returnTypeName = Signature.getReturnType((String)(signature = method.getSignature())))) {
                String[] parameterSignatures = method.getParameterTypes();
                if (parameterSignatures.length == 1) {
                    return String.valueOf(methodName.substring(3, 4).toLowerCase()) + methodName.substring(4);
                }
                if (parameterSignatures.length == 2 && "I".equals(parameterSignatures[0])) {
                    return String.valueOf(methodName.substring(3, 4).toLowerCase()) + methodName.substring(4);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }
}

