/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.taglib.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class BodyContentType
extends AbstractEnumerator {
    public static final int TAGDEPENDENT = 0;
    public static final int JSP = 1;
    public static final int EMPTY = 2;
    public static final int SCRIPTLESS = 3;
    public static final BodyContentType TAGDEPENDENT_LITERAL = new BodyContentType(0, "tagdependent", "tagdependent");
    public static final BodyContentType JSP_LITERAL = new BodyContentType(1, "JSP", "JSP");
    public static final BodyContentType EMPTY_LITERAL = new BodyContentType(2, "empty", "empty");
    public static final BodyContentType SCRIPTLESS_LITERAL = new BodyContentType(3, "scriptless", "scriptless");
    private static final BodyContentType[] VALUES_ARRAY = new BodyContentType[]{TAGDEPENDENT_LITERAL, JSP_LITERAL, EMPTY_LITERAL, SCRIPTLESS_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static BodyContentType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BodyContentType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static BodyContentType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BodyContentType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BodyContentType get(int value) {
        switch (value) {
            case 0: {
                return TAGDEPENDENT_LITERAL;
            }
            case 1: {
                return JSP_LITERAL;
            }
            case 2: {
                return EMPTY_LITERAL;
            }
            case 3: {
                return SCRIPTLESS_LITERAL;
            }
        }
        return null;
    }

    private BodyContentType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

