/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;

public abstract class AbstractEJBValidationRuleFactory {
    protected HashMap _ruleList = null;

    public void release(IValidationRule rule) {
        if (rule == null) {
            return;
        }
        rule.reset();
    }

    protected Iterator addDependentRuleToRuleList() {
        Iterator iterator = this._ruleList.values().iterator();
        while (iterator.hasNext()) {
            IValidationRule rule = (IValidationRule)iterator.next();
            Object[] ids = rule.getDependsOn();
            if (ids == null) continue;
            for (int i = 0; i < ids.length; ++i) {
                IValidationRule dRule = (IValidationRule)this._ruleList.get(ids[i]);
                if (dRule == null) continue;
                dRule.addDependent(rule);
            }
        }
        return iterator;
    }

    protected void logAllDependentRules() {
        Logger logger = this.getMsgLogger();
        if (logger.isLoggingLevel(Level.FINEST)) {
            Iterator iterator = this._ruleList.values().iterator();
            Iterator depIterator = null;
            while (iterator.hasNext()) {
                IValidationRule rule = (IValidationRule)iterator.next();
                Set dependents = rule.getDependents();
                StringBuffer buffer = new StringBuffer();
                buffer.append("list of dependents for rule:");
                buffer.append(rule.getClass().getName());
                buffer.append("\n");
                if (dependents != null) {
                    for (IValidationRule dRule : dependents) {
                        buffer.append("\t");
                        buffer.append(dRule.getClass().getName());
                        buffer.append("\n");
                    }
                }
                buffer.append("\n");
                logger.write(Level.FINEST, buffer.toString());
            }
        }
    }

    protected abstract Logger getMsgLogger();

    protected EJBJar getEJBJar(IEJBValidationContext vc) {
        return (EJBJar)vc.loadModel("EJB_MODEL");
    }

    public IValidationRule getRule(IEJBValidationContext vc, Object ruleId) {
        Object rule = this._ruleList.get(ruleId);
        if (rule == null) {
            Logger logger = vc.getMsgLogger();
            if (logger != null && logger.isLoggingLevel(Level.FINE)) {
                logger.write(Level.FINE, "Cannot load rule from ruleId: " + ruleId);
            }
            return null;
        }
        return (IValidationRule)rule;
    }
}

