/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.List;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateEJB;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AValidateKeyClass
extends AValidateEJB {
    public Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        return ((Entity)parent).getPrimaryKey();
    }

    public final List[] getMethodsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    public final List[] getFieldsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    protected boolean isValid(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedList) throws InvalidInputException {
        return super.isValid(vc, bean, clazz, method, methodsExtendedList) && !ValidationRuleUtility.isJavaLangObjectMethod(bean, method);
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        vc.terminateIfCancelled();
        this.validateLegalRMIType(vc, bean, clazz);
        if (ValidationRuleUtility.isUnnamedPackage(clazz.getJavaPackage())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2041", 4, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public final void validateLegalRMIType(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        vc.terminateIfCancelled();
        ValidationRuleUtility.isValidType(clazz);
        if (!ValidationRuleUtility.isLegalRMI_IIOPType(bean, clazz)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2019", 4, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        Method equalsMethod;
        Method hashCodeMethod = ValidationRuleUtility.getMethodExtended(clazz, "hashCode", new JavaHelpers[0]);
        if (hashCodeMethod == null || ValidationRuleUtility.isJavaLangObjectMethod(bean, hashCodeMethod)) {
            String[] msgParm = new String[]{clazz.getQualifiedName(), "hashCode()"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2001", 2, bean, clazz, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        if ((equalsMethod = ValidationRuleUtility.getMethodExtended(clazz, "equals", new JavaHelpers[]{ValidationRuleUtility.getType("java.lang.Object", bean)})) == null || ValidationRuleUtility.isJavaLangObjectMethod(bean, equalsMethod)) {
            String[] msgParm = new String[]{clazz.getQualifiedName(), "equals(java.lang.Object)"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2001", 2, bean, clazz, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
    }
}

