/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Set;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateBean;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AValidateEntityBean
extends AValidateBean {
    protected static final String JAVAX_EJB_ENTITYBEAN = "javax.ejb.EntityBean";
    protected static final String SETENTITYCONTEXT = "setEntityContext";
    protected static final String UNSETENTITYCONTEXT = "unsetEntityContext";
    protected static final String EJBLOAD = "ejbLoad";
    protected static final String EJBSTORE = "ejbStore";
    protected static final String JAVAX_EJB_ENTITYCONTEXT = "javax.ejb.EntityContext";
    private boolean hasValidConstructor = false;
    private boolean hasAConstructor = false;
    private boolean hasSetEntityContext = false;
    private boolean hasUnsetEntityContext = false;
    private boolean hasEjbActivate = false;
    private boolean hasEjbPassivate = false;
    private boolean hasEjbRemove = false;
    private boolean hasEjbLoad = false;
    private boolean hasEjbStore = false;

    public Method getMatchingHomeFindMethodExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return null;
        }
        if (bean == null) {
            return null;
        }
        return ValidationRuleUtility.getMethodExtended(bean.getHomeInterface(), method, "find");
    }

    protected String getParentName() {
        return JAVAX_EJB_ENTITYBEAN;
    }

    public boolean isFrameworkMethod(String name) {
        if (name == null) {
            return false;
        }
        if (super.isFrameworkMethod(name)) {
            return true;
        }
        if (name.equals(EJBLOAD)) {
            return true;
        }
        if (name.equals(EJBSTORE)) {
            return true;
        }
        if (name.equals(SETENTITYCONTEXT)) {
            return true;
        }
        return name.equals(UNSETENTITYCONTEXT);
    }

    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        String name = ejbMethod.getName();
        if (name.equals("ejbCreate")) {
            this.validateEjbCreateMethod(vc, bean, clazz, ejbMethod);
        } else if (name.equals("ejbPostCreate")) {
            this.validateEjbPostCreateMethod(vc, bean, clazz, ejbMethod);
        } else if (name.equals("finalize")) {
            this.validateFinalize(vc, bean, clazz, ejbMethod);
        } else if (name.startsWith("ejbFind")) {
            this.validateEjbFindMethod(vc, bean, clazz, ejbMethod);
        } else if (this.isBusinessMethod(vc, bean, clazz, ejbMethod)) {
            this.validateBusinessMethod(vc, bean, clazz, ejbMethod);
        } else {
            this.validateHelperMethod(vc, bean, clazz, ejbMethod);
        }
        vc.terminateIfCancelled();
    }

    protected void primValidateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        String name = ejbMethod.getName();
        if (!this.hasSetEntityContext && name.equals(SETENTITYCONTEXT)) {
            JavaParameter[] params = ejbMethod.listParametersWithoutReturn();
            if (params.length == 1 && ValidationRuleUtility.isAssignableFrom(params[0].getJavaType(), ValidationRuleUtility.getType(JAVAX_EJB_ENTITYCONTEXT, bean))) {
                this.hasSetEntityContext = true;
            }
        } else if (!this.hasUnsetEntityContext && name.equals(UNSETENTITYCONTEXT)) {
            if (ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasUnsetEntityContext = true;
            }
        } else if (!this.hasEjbActivate && name.equals("ejbActivate")) {
            if (ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasEjbActivate = true;
            }
        } else if (!this.hasEjbPassivate && name.equals("ejbPassivate")) {
            if (ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasEjbPassivate = true;
            }
        } else if (!this.hasEjbRemove && name.equals("ejbRemove")) {
            if (ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasEjbRemove = true;
            }
        } else if (!this.hasEjbLoad && name.equals(EJBLOAD)) {
            if (ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasEjbLoad = true;
            }
        } else if (!this.hasEjbStore && name.equals(EJBSTORE)) {
            if (ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasEjbStore = true;
            }
        } else if (!this.hasValidConstructor && ejbMethod.isConstructor()) {
            this.hasAConstructor = true;
            if (ValidationRuleUtility.isPublic(ejbMethod) && ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasValidConstructor = true;
            }
        }
        vc.terminateIfCancelled();
    }

    public void validateBusinessMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        IMessage message;
        vc.terminateIfCancelled();
        super.validateBusinessMethod(vc, bean, clazz, method);
        if (!ValidationRuleUtility.isPublic(method)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2408.bus", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2410.bus", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2409.bus", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateLegalRMIMethodWithoutExceptions(vc, bean, clazz, method);
        this.validateBusinessMethodNoRemoteException(vc, bean, clazz, method);
    }

    protected void validateBusinessMethodNoRemoteException(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        this.validateNoRemoteException(vc, bean, clazz, method, "CHKJ2400.bus");
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        super.validateClass(vc, bean, clazz);
        this.verifyFieldExists(vc, bean, clazz);
    }

    public void validateEjbCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        IMessage message;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2408.ejbCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2410.ejbCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2409.ejbCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (ValidationRuleUtility.usesUnknownPrimaryKey(bean)) {
            this.validateLegalRMIMethodArguments(vc, bean, clazz, method);
        } else {
            this.validateLegalRMIMethodWithoutExceptions(vc, bean, clazz, method);
        }
        this.validateEjbCreateMethod_keyDep(vc, bean, clazz, method);
        this.validateNoRemoteException(vc, bean, clazz, method, "CHKJ2400.ejbCreate");
        Method ejbPostCreateMethod = ValidationRuleUtility.getMethodExtended(clazz, "ejbPostCreate", method.listParametersWithoutReturn());
        if (ejbPostCreateMethod == null) {
            IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2002", 2, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message2);
        }
        this.validateEjbCreateMethod_homeDep(vc, bean, clazz, method);
    }

    public void validateEjbCreateMethod_keyDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaHelpers primaryKey = null;
        primaryKey = ValidationRuleUtility.usesUnknownPrimaryKey(bean) ? ValidationRuleUtility.getType("java.lang.Object", bean) : ((Entity)bean).getPrimaryKey();
        vc.terminateIfCancelled();
        JavaHelpers parmType = method.getReturnType();
        if (!ValidationRuleUtility.isAssignableFrom(parmType, primaryKey)) {
            String keyName = primaryKey == null ? "<primary-key>" : primaryKey.getJavaName();
            String[] msgParm = new String[]{keyName};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2406", 2, bean, clazz, method, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateEjbFindMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
    }

    public void validateEjbFindMethod_homeDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        JavaClass home = bean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, home);
        String methodName = "f" + method.getName().substring(4);
        Method homeMethod = ValidationRuleUtility.getMethodExtended(home, method, methodName);
        if (homeMethod == null) {
            return;
        }
        Set exceptions = ValidationRuleUtility.getNotSubsetExceptions(bean, method, homeMethod);
        if (exceptions.size() > 0) {
            for (JavaClass exc : exceptions) {
                String[] msgParm = new String[]{exc.getQualifiedName(), home.getQualifiedName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2420", 1, bean, clazz, method, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateEjbPostCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        String returnTypeName;
        IMessage message;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2408.ejbPostCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2410.ejbPostCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2409.ejbPostCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        vc.terminateIfCancelled();
        JavaHelpers parmType = method.getReturnType();
        String string = returnTypeName = parmType == null ? "" : parmType.getQualifiedName();
        if (!returnTypeName.equals("void")) {
            IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2418", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message2);
        }
        this.validateNoRemoteException(vc, bean, clazz, method, "CHKJ2400.ejbPostCreate");
        Method ejbCreateMethod = ValidationRuleUtility.getMethodExtended(clazz, "ejbCreate", method.listParametersWithoutReturn());
        if (ejbCreateMethod == null) {
            IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2028", 2, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message3);
        }
        this.validateEjbPostCreateMethod_homeDep(vc, bean, clazz, method);
    }

    public void validateEjbPostCreateMethod_homeDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaClass homeIntf = bean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, homeIntf);
        Method createMethod = this.getMatchingHomeCreateMethodExtended(vc, bean, clazz, method);
        if (createMethod == null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2029", 2, bean, clazz, method, new String[]{homeIntf.getName()}, (IValidationRule)this);
            vc.addMessage(message);
            return;
        }
        Set exceptions = ValidationRuleUtility.getNotSubsetExceptions(bean, method, createMethod);
        if (exceptions.size() > 0) {
            for (JavaClass exc : exceptions) {
                String[] msgParm = new String[]{exc.getQualifiedName(), homeIntf.getQualifiedName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2420", 1, bean, clazz, method, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    protected void validateFinalize(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        if (method == null) {
            return;
        }
        if (method.listParametersWithoutReturn().length == 0) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2007", 2, bean, clazz, method, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        IMessage message;
        String[] modelObjectName = new String[]{clazz.getQualifiedName()};
        if (!this.hasValidConstructor && this.hasAConstructor) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2006", 1, bean, clazz, modelObjectName, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasSetEntityContext) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2033", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasUnsetEntityContext) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2034", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasEjbActivate) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2035", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasEjbPassivate) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2036", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasEjbRemove) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2037", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasEjbLoad) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2038", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasEjbStore) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2039", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public abstract void verifyFieldExists(IEJBValidationContext var1, EnterpriseBean var2, JavaClass var3) throws InvalidInputException;

    public void preValidate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        super.preValidate(vc, targetParent, target);
        this.hasValidConstructor = false;
        this.hasAConstructor = false;
        this.hasSetEntityContext = false;
        this.hasUnsetEntityContext = false;
        this.hasEjbActivate = false;
        this.hasEjbPassivate = false;
        this.hasEjbRemove = false;
        this.hasEjbLoad = false;
        this.hasEjbStore = false;
    }
}

