/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.jca.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.model.translator.connector.ConnectorTranslator;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.ConnectorResource;
import org.eclipse.wst.common.internal.emf.resource.J2EESchemaUtility;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class ConnectorResourceImpl
extends XMLResourceImpl
implements ConnectorResource {
    public static final String CLASS_NAME = ConnectorResourceImpl.class.getName();

    public ConnectorResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public ConnectorResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public Connector getConnector() {
        return (Connector)this.getRootObject();
    }

    public Translator getRootTranslator() {
        return ConnectorTranslator.INSTANCE;
    }

    public int getType() {
        return 5;
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/dtd/connector_1_0.dtd";
    }

    public String getJ2EE_Alt_1_2_SystemID() {
        return "http://java.sun.com/dtd/connector_1.0.dtd";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/connector_1_0.dtd";
    }

    public String getJ2EE_Alt_1_3_SystemID() {
        return "http://java.sun.com/dtd/connector_1.0.dtd";
    }

    public String getDoctype() {
        int j2eeVersionId = this.getJ2EEVersionID();
        if (j2eeVersionId == 12) {
            return "connector";
        }
        if (j2eeVersionId == 13) {
            return "connector";
        }
        return null;
    }

    public void setModuleVersionID(int moduleVersionId) {
        this.primSetVersionID(moduleVersionId);
        if (moduleVersionId == 15) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 10) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
        } else {
            this.primSetDoctypeValues(null, null);
            this.unrecognizedModuleVersionID(CLASS_NAME, "setModuleVersionID", moduleVersionId);
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int j2eeVersionId) {
        if (j2eeVersionId == 50) {
            this.primSetDoctypeValues(null, null);
            this.primSetVersionID(15);
        } else if (j2eeVersionId == 14) {
            this.primSetDoctypeValues(null, null);
            this.primSetVersionID(15);
        } else if (j2eeVersionId == 13) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
            this.primSetVersionID(10);
        } else if (j2eeVersionId == 12) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            this.primSetVersionID(10);
        } else {
            this.setModuleVersionID(this.getDefaultModuleVersionID());
            this.unrecognizedJ2EEVersionID(CLASS_NAME, "setJ2EEVersionID", j2eeVersionId);
        }
        this.syncVersionOfRootObject();
    }

    public int getJ2EEVersionID() {
        int moduleVersionId = this.getModuleVersionID();
        if (moduleVersionId == 10) {
            return 13;
        }
        if (moduleVersionId == 15) {
            return 14;
        }
        this.unrecognizedModuleVersionID(CLASS_NAME, "getJ2EEVersionID", moduleVersionId);
        return 14;
    }

    protected int getDefaultVersionID() {
        return this.getDefaultModuleVersionID();
    }

    protected int getDefaultModuleVersionID() {
        return 15;
    }

    protected void syncVersionOfRootObject() {
        Connector conn = this.getConnector();
        if (conn == null) {
            return;
        }
        String version = conn.getSpecVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            conn.setSpecVersion(newVersion);
        }
    }

    protected byte[] getElementBytes() {
        return J2EESchemaUtility.RAR_BYTES;
    }

    protected byte[] getVersionBytes() {
        return J2EESchemaUtility.VERSION_1_5_BYTES;
    }

    protected byte[] getSchemaLocationBytes() {
        return J2EESchemaUtility.RAR_1_5_BYTES;
    }

    public int lookupModuleVersionId(String schemaName) {
        if (schemaName == null) {
            return -1;
        }
        if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            return 15;
        }
        return -1;
    }

    public int lookupModuleVersionId(String publicId, String systemId) {
        if (publicId == null || systemId == null) {
            return -1;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && (systemId.equals("http://java.sun.com/dtd/connector_1_0.dtd") || systemId.equals("http://java.sun.com/dtd/connector_1.0.dtd"))) {
            return 10;
        }
        return -1;
    }

    public int parseModuleVersionId(String versionString) {
        if (versionString == null) {
            return -1;
        }
        if (versionString.equals("1.0")) {
            return 10;
        }
        if (versionString.equals("1.5")) {
            return 15;
        }
        return -1;
    }
}

