/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.servertarget;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.servertarget.J2EEProjectServerTargetOp;
import org.eclipse.jst.j2ee.project.datamodel.properties.IJ2EEProjectServerTargetDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ResourceManager;

public class J2EEProjectServerTargetDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEProjectServerTargetDataModelProperties {
    private static final String DEFAULT_TARGET_ID = "org.eclipse.jst.server.core.runtimeType";

    public void init() {
        this.model.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", this.getDefaultServerTargetID());
        super.init();
    }

    public IDataModelOperation getDefaultOperation() {
        return new J2EEProjectServerTargetOp(this.model);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME");
        propertyNames.add("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        propertyNames.add("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID");
        propertyNames.add("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID");
        propertyNames.add("IJ2EEProjectServerTargetDataModelProperties.UPDATE_MODULES");
        return propertyNames;
    }

    public IProject getProject() {
        String name = (String)this.getProperty("IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME");
        if (name != null && name.length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        return null;
    }

    public IRuntime getRuntimeTarget() {
        String serverTargetId = (String)this.getProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        return ResourceManager.getInstance().getRuntime(serverTargetId);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID")) {
            return this.getDefaultServerTargetID();
        }
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID")) {
            return this.getDefaultVersionID();
        }
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.UPDATE_MODULES")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Integer getDefaultVersionID() {
        return new Integer(14);
    }

    private Object getDefaultServerTargetID() {
        List targets = this.getValidServerTargets();
        if (!targets.isEmpty()) {
            IRuntime target = null;
            int i = targets.size() - 1;
            while (i < targets.size() && i >= 0) {
                target = (IRuntime)targets.get(i);
                if (DEFAULT_TARGET_ID.equals(target.getId())) {
                    return target.getId();
                }
                --i;
            }
            if (target != null) {
                return target.getId();
            }
        }
        return null;
    }

    public String computeTypeId() {
        int type = -1;
        if (this.getDataModel().isPropertySet("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID")) {
            type = this.getIntProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID");
        }
        return this.computeTypeId(type);
    }

    private String computeTypeId(int deploymentDescriptorType) {
        switch (deploymentDescriptorType) {
            case 2: {
                return "j2ee.ear";
            }
            case 1: {
                return "j2ee.appclient";
            }
            case 3: {
                return "j2ee.ejb";
            }
            case 4: {
                return "j2ee.web";
            }
            case 5: {
                return "j2ee.connector";
            }
        }
        return null;
    }

    public String computeVersionId() {
        int version = -1;
        if (this.getDataModel().isPropertySet("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID")) {
            version = this.getIntProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID");
        }
        return this.computeVersionId(version);
    }

    private String computeVersionId(int version) {
        switch (version) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return null;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID")) {
            return this.getValidServerTargetDescriptors();
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    private DataModelPropertyDescriptor[] getValidServerTargetDescriptors() {
        List targets = this.getValidServerTargets();
        DataModelPropertyDescriptor[] descriptors = null;
        if (!targets.isEmpty()) {
            int serverTargetListSize = targets.size();
            descriptors = new DataModelPropertyDescriptor[serverTargetListSize];
            int i = 0;
            while (i < targets.size()) {
                IRuntime runtime = (IRuntime)targets.get(i);
                descriptors[i] = new DataModelPropertyDescriptor(runtime.getId(), runtime.getName());
                ++i;
            }
        } else {
            descriptors = new DataModelPropertyDescriptor[]{};
        }
        return descriptors;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID")) {
            IRuntime target = this.getServerTargetByID(this.getStringProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID"));
            if (target == null) {
                this.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", null);
            }
            this.model.notifyPropertyChange("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", 4);
        } else if ("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID".equals(propertyName)) {
            this.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", propertyValue);
        }
        return true;
    }

    private IRuntime getServerTargetByID(String id) {
        List targets = this.getValidServerTargets();
        int i = 0;
        while (i < targets.size()) {
            IRuntime target = (IRuntime)targets.get(i);
            if (id.equals(target.getId())) {
                return target;
            }
            ++i;
        }
        return null;
    }

    private List getValidServerTargets() {
        List validServerTargets = null;
        validServerTargets = J2EEProjectServerTargetDataModelProvider.getServerTargets("", "");
        if (validServerTargets != null && validServerTargets.isEmpty()) {
            validServerTargets = null;
        }
        if (validServerTargets == null) {
            return Collections.EMPTY_LIST;
        }
        return validServerTargets;
    }

    public static List getServerTargets(String type, String version) {
        List<IRuntime> targets = Arrays.asList(ServerUtil.getRuntimes((String)type, (String)version));
        return targets;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID")) {
            return this.validateServerTarget();
        }
        return super.validate(propertyName);
    }

    private IStatus validateServerTarget() {
        List targets = this.getValidServerTargets();
        if (targets.isEmpty()) {
            return J2EEPlugin.newErrorStatus(J2EECreationResourceHandler.ServerTargetDataModel_UI_7, null);
        }
        IRuntime target = this.getRuntimeTarget();
        if (target == null) {
            return J2EEPlugin.newErrorStatus(J2EECreationResourceHandler.ServerTargetDataModel_UI_8, null);
        }
        if (!targets.contains(target)) {
            return J2EEPlugin.newErrorStatus(J2EECreationResourceHandler.ServerTargetDataModel_UI_9, null);
        }
        return OK_STATUS;
    }
}

