/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.model.translator.common;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.resource.TranslatorPath;

public class JavaClassTranslator
extends Translator {
    public JavaClassTranslator(String domNameAndPath, EStructuralFeature aFeature) {
        super(domNameAndPath, aFeature);
    }

    public JavaClassTranslator(String domNameAndPath, EStructuralFeature aFeature, TranslatorPath path) {
        super(domNameAndPath, aFeature, path);
    }

    public JavaClassTranslator(String domNameAndPath, EStructuralFeature aFeature, TranslatorPath[] paths) {
        super(domNameAndPath, aFeature, paths);
    }

    public JavaClassTranslator(String domNameAndPath, EStructuralFeature aFeature, int style) {
        super(domNameAndPath, aFeature, style);
    }

    public Object convertStringToValue(String nodeName, String readAheadName, String value, Notifier owner) {
        Object result = null;
        if (value != null) {
            result = this.convertStringToValue(value, (EObject)owner);
        }
        return result;
    }

    public Object convertStringToValue(String strValue, EObject owner) {
        if (strValue != null) {
            ResourceSet rs;
            Resource ownerRes;
            String qualifiedName = this.removePreceedingAndTrailingPeriods(strValue.trim());
            if (owner != null && (ownerRes = owner.eResource()) != null && (rs = ownerRes.getResourceSet()) != null) {
                JavaHelpers javaClass = null;
                try {
                    javaClass = JavaRefFactory.eINSTANCE.reflectType(qualifiedName, rs);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (javaClass != null) {
                    return javaClass;
                }
            }
            return JavaRefFactory.eINSTANCE.createClassRef(qualifiedName);
        }
        return null;
    }

    private String removePreceedingAndTrailingPeriods(String qualifiedName) {
        int qualifiedNameEnd;
        int endIndex;
        int startIndex;
        char[] characters = qualifiedName.toCharArray();
        for (startIndex = 0; startIndex < characters.length && characters[startIndex] == '.'; ++startIndex) {
        }
        for (endIndex = qualifiedNameEnd = qualifiedName.length() - 1; endIndex > -1 && characters[endIndex] == '.'; --endIndex) {
            if (startIndex != 0 || endIndex != qualifiedNameEnd) continue;
            return qualifiedName;
        }
        return qualifiedName.substring(startIndex, endIndex + 1);
    }

    public String convertValueToString(Object value, EObject owner) {
        if (value != null) {
            return ((JavaClass)value).getQualifiedName();
        }
        return null;
    }
}

