/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.jca.archive.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.jca.archive.operations.ConnectorComponentNestedJARLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ConnectorComponentLoadStrategyImpl
extends ComponentLoadStrategyImpl {
    private int dotJavaLength = ".java".length();
    private List alreadyIndexed = new ArrayList();
    private Map classesMap;
    private IFile knownDD;
    public static String[] knownLibExtensions = new String[]{".jar", ".zip", ".so", ".o", ".sl", ".dll"};

    public ConnectorComponentLoadStrategyImpl(IVirtualComponent vComponent) {
        super(vComponent);
        this.knownDD = vComponent.getRootFolder().getFile("META-INF/ra.xml").getUnderlyingFile();
    }

    public List getFiles() {
        this.addNestedJARsFromSourceRoots();
        this.aggregateSourceFiles();
        return this.filesHolder.getFiles();
    }

    private void addNestedJARsFromSourceRoots() {
        IPackageFragmentRoot[] sourceRoots = J2EEProjectUtilities.getSourceContainers(this.vComponent.getProject());
        int i = 0;
        while (i < sourceRoots.length) {
            try {
                File aFile = this.getNestedJar(sourceRoots[i]);
                if (aFile != null) {
                    this.filesHolder.addFile(aFile);
                }
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError(e);
            }
            ++i;
        }
    }

    private File getNestedJar(IPackageFragmentRoot sourceRoot) throws JavaModelException {
        IPath outputPath = sourceRoot.getRawClasspathEntry().getOutputLocation();
        if (outputPath == null) {
            IProject project = this.vComponent.getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    outputPath = javaProject.getOutputLocation();
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError(e);
            }
            if (outputPath == null) {
                return null;
            }
        }
        IFolder javaOutputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath);
        this.indexClassesForOutputFolder(javaOutputFolder);
        IContainer sourceContainer = (IContainer)sourceRoot.getResource();
        int sourceContainerSegmentCount = sourceContainer.getProjectRelativePath().segmentCount();
        boolean isModuleRoot = this.knownDD.getProjectRelativePath().toString().startsWith(sourceContainer.getProjectRelativePath().toString());
        ArrayList iFiles = new ArrayList();
        boolean foundJava = this.gatherFilesForJAR(iFiles, sourceContainer, isModuleRoot, false, sourceContainerSegmentCount);
        if (!isModuleRoot || foundJava) {
            int i = 0;
            while (i < iFiles.size()) {
                this.filesHolder.removeIFile((IFile)iFiles.get(i));
                ++i;
            }
            File nestedArchive = this.createNestedArchive(iFiles, sourceContainer, javaOutputFolder);
            return nestedArchive;
        }
        return null;
    }

    private boolean gatherFilesForJAR(List iFiles, IContainer current, boolean isModuleRoot, boolean foundJava, int sourceContainerSegmentCount) {
        IResource[] members;
        try {
            members = current.members();
        }
        catch (CoreException core) {
            throw new ArchiveRuntimeException((Exception)((Object)core));
        }
        int i = 0;
        while (i < members.length) {
            IResource res = members[i];
            if (res.getType() == 2) {
                foundJava = this.gatherFilesForJAR(iFiles, (IContainer)((IFolder)res), isModuleRoot, foundJava, sourceContainerSegmentCount) || foundJava;
            } else {
                IFile srcFile = (IFile)res;
                if (this.belongsInNestedJAR(srcFile, isModuleRoot)) {
                    if (ConnectorComponentLoadStrategyImpl.isJava(srcFile)) {
                        if (this.exportSource) {
                            iFiles.add(srcFile);
                        }
                        String className = srcFile.getProjectRelativePath().removeFirstSegments(sourceContainerSegmentCount).toString();
                        List classes = this.retrieveClasses(className = className.substring(0, className.length() - this.dotJavaLength));
                        if (classes != null) {
                            Iterator iterator = classes.iterator();
                            while (iterator.hasNext()) {
                                IFile clazz = (IFile)iterator.next();
                                iFiles.add(clazz);
                            }
                        }
                    } else {
                        iFiles.add(srcFile);
                    }
                    if (isModuleRoot) {
                        foundJava = foundJava || ConnectorComponentLoadStrategyImpl.isJava(srcFile) || ConnectorComponentLoadStrategyImpl.isClass(srcFile);
                    }
                }
            }
            ++i;
        }
        return foundJava;
    }

    private File createNestedArchive(List files, IContainer sourceContainer, IFolder javaOutputFolder) {
        ConnectorComponentNestedJARLoadStrategyImpl loader = new ConnectorComponentNestedJARLoadStrategyImpl(files, sourceContainer, javaOutputFolder);
        ArchiveOptions options = ((Archive)this.getContainer()).getOptions().cloneWith(loader);
        String uri = this.computeUniqueArchiveURI((IResource)sourceContainer);
        try {
            return this.getArchiveFactory().primOpenArchive(options, uri);
        }
        catch (OpenFailureException ex) {
            throw new ArchiveRuntimeException(ex);
        }
    }

    private String computeUniqueArchiveURI(IResource resource) {
        int increment = 0;
        String name = resource.getName();
        StringBuffer sb = null;
        do {
            sb = new StringBuffer(name.length() + 5);
            sb.append('_');
            sb.append(name);
            if (increment > 0) {
                sb.append(increment);
            }
            sb.append(".jar");
            ++increment;
        } while (this.filesHolder.contains(sb.toString()));
        return sb.toString();
    }

    private boolean belongsInNestedJAR(IFile iFile, boolean isModuleRoot) {
        if (isModuleRoot && this.isDeploymentDescriptor(iFile)) {
            return false;
        }
        int i = 0;
        while (i < knownLibExtensions.length) {
            if (ConnectorComponentLoadStrategyImpl.hasExtension(iFile, knownLibExtensions[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean shouldInclude(String uri) {
        return !ConnectorComponentLoadStrategyImpl.hasExtension(uri, ".class") && !ConnectorComponentLoadStrategyImpl.hasExtension(uri, ".java");
    }

    private void indexClassesForOutputFolder(IFolder javaOutputFolder) {
        if (javaOutputFolder == null || this.alreadyIndexed.contains(javaOutputFolder)) {
            return;
        }
        this.alreadyIndexed.add(javaOutputFolder);
        int segmentCount = javaOutputFolder.getProjectRelativePath().segmentCount();
        this.indexClasses((IResource)javaOutputFolder, segmentCount);
    }

    private void indexClasses(IResource resource, int javaOutputSegmentCount) {
        switch (resource.getType()) {
            case 1: {
                this.indexClass((IFile)resource, javaOutputSegmentCount);
                break;
            }
            case 2: {
                try {
                    IResource[] members = ((IFolder)resource).members();
                    int i = 0;
                    while (i < members.length) {
                        this.indexClasses(members[i], javaOutputSegmentCount);
                        ++i;
                    }
                    break;
                }
                catch (CoreException e) {
                    Logger.getLogger().logError(e);
                }
            }
        }
    }

    private void indexClass(IFile iFile, int javaOutputSegmentCount) {
        if (!ConnectorComponentLoadStrategyImpl.isClass(iFile)) {
            return;
        }
        if (this.classesMap == null) {
            this.classesMap = new HashMap();
        }
        String name = iFile.getName();
        IPath relPath = iFile.getProjectRelativePath().removeFirstSegments(javaOutputSegmentCount);
        String key = relPath.toString();
        key = name.indexOf(36) != -1 ? key.substring(0, key.indexOf(36)) : key.substring(0, key.indexOf(46));
        ArrayList<IFile> inners = (ArrayList<IFile>)this.classesMap.get(key);
        if (inners == null) {
            inners = new ArrayList<IFile>(1);
            this.classesMap.put(key, inners);
        }
        inners.add(iFile);
    }

    public List retrieveClasses(String key) {
        if (this.classesMap == null) {
            return null;
        }
        return (List)this.classesMap.get(key);
    }

    public static boolean isJava(IFile iFile) {
        return ConnectorComponentLoadStrategyImpl.hasExtension(iFile, ".java");
    }

    public static boolean isClass(IFile iFile) {
        return ConnectorComponentLoadStrategyImpl.hasExtension(iFile, ".class");
    }

    private static boolean hasExtension(IFile iFile, String ext) {
        String name = iFile.getName();
        return ConnectorComponentLoadStrategyImpl.hasExtension(name, ext);
    }

    private static boolean hasExtension(String name, String ext) {
        int offset = ext.length();
        return name.regionMatches(true, name.length() - offset, ext, 0, offset);
    }

    private boolean isDeploymentDescriptor(IFile iFile) {
        return this.knownDD.equals((Object)iFile);
    }
}

