/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.datamodel.properties.IEarComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.earcreation.EarComponentCreationFacetOperation;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.DoNotUseMeThisWillBeDeletedPost15;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;

public class EarComponentCreationDataModelProvider
extends J2EEComponentCreationDataModelProvider
implements IEarComponentCreationDataModelProperties,
DoNotUseMeThisWillBeDeletedPost15 {
    public IDataModelOperation getDefaultOperation() {
        return new EarComponentCreationFacetOperation(this.model);
    }

    protected Integer getDefaultComponentVersion() {
        int highestJ2EEPref = J2EEPlugin.getDefault().getJ2EEPreferences().getHighestJ2EEVersionID();
        switch (highestJ2EEPref) {
            case 14: {
                return new Integer(14);
            }
            case 13: {
                return new Integer(13);
            }
            case 12: {
                return new Integer(12);
            }
        }
        return new Integer(14);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IEarComponentCreationDataModel.J2EE_PROJECTS_LIST");
        propertyNames.add("IEarComponentCreationDataModel.JAVA_PROJECT_LIST");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEComponentCreationDataModelProperties.DD_FOLDER")) {
            return "/META_INF";
        }
        if (propertyName.equals("IJ2EEComponentCreationDataModelProperties.UI_SHOW_EAR_SECTION")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEarComponentCreationDataModel.J2EE_PROJECTS_LIST")) {
            return Collections.EMPTY_LIST;
        }
        if (propertyName.equals("IEarComponentCreationDataModel.JAVA_PROJECT_LIST")) {
            return Collections.EMPTY_LIST;
        }
        if (propertyName.equals("IComponentCreationDataModelProperties.NESTED_EAR_COMPONENT_CREATION_DM")) {
            return this.model;
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("IComponentCreationDataModelProperties.COMPONENT_VERSION")) {
            Integer propertyValue = (Integer)this.getProperty(propertyName);
            String description = null;
            switch (propertyValue) {
                case 12: {
                    description = "1.2";
                    break;
                }
                case 13: {
                    description = "1.3";
                    break;
                }
                default: {
                    description = "1.4";
                }
            }
            return new DataModelPropertyDescriptor(propertyValue, description);
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidComponentVersionDescriptors() {
        int highestJ2EEPref = J2EEPlugin.getDefault().getJ2EEPreferences().getHighestJ2EEVersionID();
        DataModelPropertyDescriptor[] descriptors = null;
        switch (highestJ2EEPref) {
            case 12: {
                descriptors = new DataModelPropertyDescriptor[]{new DataModelPropertyDescriptor(new Integer(12), "1.2")};
                break;
            }
            case 13: {
                descriptors = new DataModelPropertyDescriptor[]{new DataModelPropertyDescriptor(new Integer(12), "1.2"), new DataModelPropertyDescriptor(new Integer(13), "1.3")};
                break;
            }
            default: {
                descriptors = new DataModelPropertyDescriptor[]{new DataModelPropertyDescriptor(new Integer(12), "1.2"), new DataModelPropertyDescriptor(new Integer(13), "1.3"), new DataModelPropertyDescriptor(new Integer(14), "1.4")};
            }
        }
        return descriptors;
    }

    protected int convertModuleVersionToJ2EEVersion(int moduleVersion) {
        return moduleVersion;
    }

    protected EClass getComponentType() {
        return CommonarchiveFactoryImpl.getPackage().getEARFile();
    }

    protected String getComponentExtension() {
        return ".ear";
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IComponentCreationDataModelProperties.PROJECT_NAME")) {
            IRuntimeType type;
            String typeId;
            IRuntime runtime;
            IProject project;
            String projectName;
            IStatus stat = super.validate(propertyName);
            if (stat.isOK() && (projectName = this.getDataModel().getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME")) != null && projectName.length() != 0 && (project = ProjectUtilities.getProject(projectName)) != null && (runtime = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget()) != null && (typeId = (type = runtime.getRuntimeType()).getId()).startsWith("org.eclipse.jst.server.tomcat")) {
                String msg = EARCreationResourceHandler.SERVER_TARGET_NOT_SUPPORT_EAR;
                return WTPCommonPlugin.createErrorStatus(msg);
            }
        } else if (propertyName.equals("IEarComponentCreationDataModel.J2EE_PROJECTS_LIST")) {
            return this.validateTargetComponentVersion((List)this.model.getProperty("IEarComponentCreationDataModel.J2EE_PROJECTS_LIST"));
        }
        return super.validate(propertyName);
    }

    private IStatus validateTargetComponentVersion(List list) {
        Integer version = (Integer)this.model.getProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION");
        int earVersion = version;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IProject handle = (IProject)iter.next();
            IVirtualComponent comp = ComponentCore.createComponent((IProject)handle.getProject());
            int compVersion = J2EEVersionUtil.convertVersionStringToInt(comp);
            if (earVersion >= compVersion) continue;
            String errorStatus = "The Module specification level of " + handle.getName() + ", is incompatible with the containing EAR version";
            return J2EEPlugin.newErrorStatus(errorStatus, null);
        }
        return OK_STATUS;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean returnValue = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IComponentCreationDataModelProperties.COMPONENT_NAME")) {
            this.setProperty("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME", this.getDataModel().getStringProperty("IComponentCreationDataModelProperties.COMPONENT_NAME"));
        } else if (propertyName.equals("IComponentCreationDataModelProperties.NESTED_EAR_COMPONENT_CREATION_DM")) {
            throw new RuntimeException();
        }
        return returnValue;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        return super.getValidPropertyDescriptors(propertyName);
    }

    protected boolean isCreatingEarComponent() {
        return true;
    }

    protected IProject getEARProject() {
        String earProjname = (String)this.model.getProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
        IDataModel earDM = (IDataModel)this.model.getProperty("IComponentCreationDataModelProperties.NESTED_EAR_COMPONENT_CREATION_DM");
        earDM.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", earProjname);
        if (earProjname != null && !earProjname.equals("") && this.validate("IComponentCreationDataModelProperties.COMPONENT_NAME").isOK()) {
            return ProjectUtilities.getProject(earProjname);
        }
        return null;
    }

    protected String getJ2EEProjectType() {
        return "jst.ear";
    }
}

