/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.internal.J2EEMultiStatus;
import org.eclipse.jst.j2ee.internal.J2EESpecificationConstants;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class J2EEStatus
implements J2EESpecificationConstants {
    public static final int COMPLETED_OK = 0;
    public static final int NOT_NEEDED = 1;
    public static final int NOT_POSSIBLE = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final J2EEStatus OK_STATUS = new J2EEStatus(0, "");
    private static final J2EEStatus[] EmptyStatusArray = new J2EEStatus[0];
    private int severity;
    private String message;
    private XMLResource resource;
    private EObject targetObject;

    public J2EEStatus() {
    }

    public J2EEStatus(int aSeverity, String aMessage) {
        this(aSeverity, (EObject)null, aMessage);
    }

    public J2EEStatus(int aSeverity, XMLResource xmlResource) {
        this(aSeverity, xmlResource, null);
    }

    public J2EEStatus(int aSeverity, EObject anObject) {
        this(aSeverity, anObject, null);
    }

    public J2EEStatus(int aSeverity, XMLResource xmlResource, String aMessage) {
        this.severity = aSeverity;
        this.resource = xmlResource;
        this.message = aMessage;
    }

    public J2EEStatus(int aSeverity, EObject anObject, String aMessage) {
        this.severity = aSeverity;
        this.targetObject = anObject;
        this.message = aMessage;
    }

    public String format(String aPattern, String arg1) {
        return MessageFormat.format(aPattern, arg1);
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = this.createDefaultMessage();
        }
        return this.message;
    }

    public String getMessageForDisplay() {
        return this.getSeverityText() + " " + this.getMessage();
    }

    protected String getSeverityText() {
        switch (this.severity) {
            case 4: {
                return ERROR_TEXT;
            }
            case 3: {
                return WARNING_TEXT;
            }
            case 1: 
            case 2: {
                return INFO_TEXT;
            }
        }
        return "";
    }

    private String createDefaultMessage() {
        String objDesc;
        if (this.getResource() != null) {
            objDesc = this.getResource().getURI().toString();
        } else if (this.getTargetObject() != null && this.getTargetObject() instanceof ENamedElement) {
            objDesc = ((ENamedElement)this.getTargetObject()).getName();
        } else {
            return null;
        }
        switch (this.getSeverity()) {
            case 0: {
                return this.format(DEFAULT_COMPLETED_STATUS_MSG, objDesc);
            }
            case 1: {
                return this.format(DEFAULT_NOT_NEEDED_STATUS_MSG, objDesc);
            }
            case 2: {
                return this.format(DEFAULT_NOT_POSSIBLE_STATUS_MSG, objDesc);
            }
            case 4: {
                return this.format(DEFAULT_ERROR_STATUS_MSG, objDesc);
            }
        }
        return null;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isOK() {
        return this.severity == 0 || this.severity == 1;
    }

    public boolean isError() {
        return this.severity == 4;
    }

    public boolean isWarning() {
        return this.severity == 3;
    }

    public boolean isNotNeeded() {
        return this.severity == 1;
    }

    public boolean isNotPossible() {
        return this.severity == 2;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public J2EEStatus[] getChildren() {
        return EmptyStatusArray;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public XMLResource getResource() {
        return this.resource;
    }

    public EObject getTargetObject() {
        return this.targetObject;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MigrationStatus ");
        if (this.severity == 0) {
            buf.append("Completed OK");
        } else if (this.severity == 4) {
            buf.append("ERROR");
        } else if (this.severity == 3) {
            buf.append("WARNING");
        } else if (this.severity == 1) {
            buf.append("Not Needed");
        } else if (this.severity == 2) {
            buf.append("Not Possible");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(' ');
        buf.append(this.message);
        return buf.toString();
    }

    public J2EEStatus append(J2EEStatus aStatus) {
        if (aStatus == null) {
            return this;
        }
        J2EEMultiStatus multi = new J2EEMultiStatus();
        multi.merge(this);
        multi.merge(aStatus);
        return multi;
    }
}

