/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.internal.impl.CompatibilityDescriptionGroupImpl;
import org.eclipse.jst.j2ee.common.internal.util.CommonUtil;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.Interceptors;
import org.eclipse.jst.j2ee.ejb.Relationships;
import org.eclipse.jst.j2ee.ejb.internal.impl.EnterpriseBeanImpl;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;

public class EJBJarImpl
extends CompatibilityDescriptionGroupImpl
implements EJBJar {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = EJBJarImpl.class.getName();
    protected static final String EJB_CLIENT_JAR_EDEFAULT = null;
    protected String ejbClientJar = EJB_CLIENT_JAR_EDEFAULT;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected AssemblyDescriptor assemblyDescriptor = null;
    protected EList enterpriseBeans = null;
    protected Relationships relationshipList = null;
    protected static final boolean METADATA_COMPLETE_EDEFAULT = false;
    protected boolean metadataComplete = false;
    protected boolean metadataCompleteESet = false;
    protected Interceptors interceptors = null;
    private boolean _J2EEVersionIDStored = false;
    private int _storedJ2EEVersionID;

    protected EClass eStaticClass() {
        return EjbPackage.Literals.EJB_JAR;
    }

    public boolean containsContainerManagedBeans() {
        for (EnterpriseBean ejb : this.getEnterpriseBeans()) {
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity()) continue;
            return true;
        }
        return false;
    }

    public boolean containsSecurityRole(String name) {
        AssemblyDescriptor ad = this.getAssemblyDescriptor();
        return ad != null && ad.getSecurityRoleNamed(name) != null;
    }

    public List getBeanManagedBeans() {
        EList allBeans = this.getEnterpriseBeans();
        int size = allBeans.size();
        ArrayList<EnterpriseBean> beans = new ArrayList<EnterpriseBean>(size);
        for (int i = 0; i < size; ++i) {
            EnterpriseBean ejb = (EnterpriseBean)allBeans.get(i);
            if (!ejb.isBeanManagedEntity()) continue;
            beans.add(ejb);
        }
        return beans;
    }

    public List getContainerManagedBeans() {
        ArrayList<EnterpriseBean> cmps = new ArrayList<EnterpriseBean>(this.getEnterpriseBeans().size());
        for (EnterpriseBean ejb : this.getEnterpriseBeans()) {
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity()) continue;
            cmps.add(ejb);
        }
        return cmps;
    }

    public List getEJB11ContainerManagedBeans() {
        ArrayList<EnterpriseBean> cmps = new ArrayList<EnterpriseBean>(this.getEnterpriseBeans().size());
        for (EnterpriseBean ejb : this.getEnterpriseBeans()) {
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity() || ejb.getVersionID() > 11) continue;
            cmps.add(ejb);
        }
        return cmps;
    }

    public List getEJB20ContainerManagedBeans() {
        ArrayList<EnterpriseBean> cmps = new ArrayList<EnterpriseBean>(this.getEnterpriseBeans().size());
        for (EnterpriseBean ejb : this.getEnterpriseBeans()) {
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity() || ejb.getVersionID() < 20) continue;
            cmps.add(ejb);
        }
        return cmps;
    }

    public List getMessageDrivenBeans() {
        EList ejbs = this.getEnterpriseBeans();
        int size = ejbs.size();
        ArrayList<EnterpriseBean> mdbs = new ArrayList<EnterpriseBean>(size);
        for (int i = 0; i < size; ++i) {
            EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
            if (!ejb.isMessageDriven()) continue;
            mdbs.add(ejb);
        }
        return mdbs;
    }

    public List getEjbRelations() {
        return this.getRelationshipList() == null ? null : this.getRelationshipList().getEjbRelations();
    }

    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref) {
        String link = ref.getLink();
        if (link == null) {
            return null;
        }
        return this.getEnterpriseBeanNamed(link);
    }

    public EnterpriseBean getEnterpriseBeanNamed(String ejbName) {
        if (ejbName == null) {
            return null;
        }
        EList beans = this.getEnterpriseBeans();
        for (int i = 0; i < beans.size(); ++i) {
            EnterpriseBean bean = (EnterpriseBean)beans.get(i);
            if (!ejbName.equals(bean.getName())) continue;
            return bean;
        }
        return null;
    }

    public List getEnterpriseBeansWithReference(JavaClass aJavaClass) {
        EList beans = this.getEnterpriseBeans();
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        EnterpriseBean bean = null;
        for (int i = 0; i < beans.size(); ++i) {
            bean = (EnterpriseBean)beans.get(i);
            if (!bean.hasJavaReference(aJavaClass)) continue;
            result.add(bean);
        }
        return result;
    }

    public EnterpriseBean getEnterpriseBeanWithReference(JavaClass aJavaClass) {
        EList beans = this.getEnterpriseBeans();
        EnterpriseBean bean = null;
        for (int i = 0; i < beans.size(); ++i) {
            bean = (EnterpriseBean)beans.get(i);
            if (!bean.hasJavaReference(aJavaClass)) continue;
            return bean;
        }
        return null;
    }

    public List getSessionBeans() {
        EList allBeans = this.getEnterpriseBeans();
        int size = allBeans.size();
        ArrayList<EnterpriseBean> beans = new ArrayList<EnterpriseBean>(size);
        for (int i = 0; i < size; ++i) {
            EnterpriseBean ejb = (EnterpriseBean)allBeans.get(i);
            if (!ejb.isSession()) continue;
            beans.add(ejb);
        }
        return beans;
    }

    public boolean isVersion1_1Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        EJBResource ejbRes = (EJBResource)this.eResource();
        return ejbRes.isEJB1_1();
    }

    public boolean isVersion2_0Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        EJBResource ejbRes = (EJBResource)this.eResource();
        return ejbRes.isEJB2_0();
    }

    public void renameSecurityRole(String existingRoleName, String newRoleName) {
        AssemblyDescriptor ad = this.getAssemblyDescriptor();
        if (ad != null) {
            ad.renameSecurityRole(existingRoleName, newRoleName);
        }
        EList ejbs = this.getEnterpriseBeans();
        for (int i = 0; i < ejbs.size(); ++i) {
            EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
            ejb.reSyncSecurityRoleRef(existingRoleName, newRoleName);
        }
    }

    public void setDisplayName(String newDisplayName) {
        super.setDisplayName(newDisplayName);
    }

    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    public void setEjbClientJar(String newEjbClientJar) {
        String oldEjbClientJar = this.ejbClientJar;
        this.ejbClientJar = newEjbClientJar;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldEjbClientJar, (Object)this.ejbClientJar));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionID() throws IllegalStateException {
        J2EEVersionResource ejbRes = (J2EEVersionResource)((Object)this.eResource());
        if (ejbRes == null) {
            if (this.version == null) {
                throw new IllegalStateException();
            }
            if (this.version.equals("3.0")) {
                return 30;
            }
            if (this.version.equals("2.1")) {
                return 21;
            }
            if (this.version.equals("2.0")) {
                return 20;
            }
            if (this.version.equals("1.1")) {
                return 11;
            }
            if (this.version.equals("1.0")) {
                return 10;
            }
            throw new IllegalStateException();
        }
        return ejbRes.getModuleVersionID();
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldVersion, (Object)this.version));
        }
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    public NotificationChain basicSetAssemblyDescriptor(AssemblyDescriptor newAssemblyDescriptor, NotificationChain msgs) {
        AssemblyDescriptor oldAssemblyDescriptor = this.assemblyDescriptor;
        this.assemblyDescriptor = newAssemblyDescriptor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldAssemblyDescriptor, (Object)newAssemblyDescriptor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor newAssemblyDescriptor) {
        if (newAssemblyDescriptor != this.assemblyDescriptor) {
            NotificationChain msgs = null;
            if (this.assemblyDescriptor != null) {
                msgs = ((InternalEObject)((Object)this.assemblyDescriptor)).eInverseRemove(this, 2, AssemblyDescriptor.class, msgs);
            }
            if (newAssemblyDescriptor != null) {
                msgs = ((InternalEObject)((Object)newAssemblyDescriptor)).eInverseAdd(this, 2, AssemblyDescriptor.class, msgs);
            }
            if ((msgs = this.basicSetAssemblyDescriptor(newAssemblyDescriptor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newAssemblyDescriptor, (Object)newAssemblyDescriptor));
        }
    }

    public EList getEnterpriseBeans() {
        if (this.enterpriseBeans == null) {
            this.enterpriseBeans = new EObjectContainmentWithInverseEList.Unsettable(EnterpriseBean.class, this, 10, 23);
        }
        return this.enterpriseBeans;
    }

    public void unsetEnterpriseBeans() {
        if (this.enterpriseBeans != null) {
            ((InternalEList.Unsettable)this.enterpriseBeans).unset();
        }
    }

    public boolean isSetEnterpriseBeans() {
        return this.enterpriseBeans != null && ((InternalEList.Unsettable)this.enterpriseBeans).isSet();
    }

    public Relationships getRelationshipList() {
        return this.relationshipList;
    }

    public NotificationChain basicSetRelationshipList(Relationships newRelationshipList, NotificationChain msgs) {
        Relationships oldRelationshipList = this.relationshipList;
        this.relationshipList = newRelationshipList;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldRelationshipList, (Object)newRelationshipList);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setRelationshipList(Relationships newRelationshipList) {
        if (newRelationshipList != this.relationshipList) {
            NotificationChain msgs = null;
            if (this.relationshipList != null) {
                msgs = ((InternalEObject)((Object)this.relationshipList)).eInverseRemove(this, 1, Relationships.class, msgs);
            }
            if (newRelationshipList != null) {
                msgs = ((InternalEObject)((Object)newRelationshipList)).eInverseAdd(this, 1, Relationships.class, msgs);
            }
            if ((msgs = this.basicSetRelationshipList(newRelationshipList, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newRelationshipList, (Object)newRelationshipList));
        }
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean newMetadataComplete) {
        boolean oldMetadataComplete = this.metadataComplete;
        this.metadataComplete = newMetadataComplete;
        boolean oldMetadataCompleteESet = this.metadataCompleteESet;
        this.metadataCompleteESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 12, oldMetadataComplete, this.metadataComplete, !oldMetadataCompleteESet));
        }
    }

    public void unsetMetadataComplete() {
        boolean oldMetadataComplete = this.metadataComplete;
        boolean oldMetadataCompleteESet = this.metadataCompleteESet;
        this.metadataComplete = false;
        this.metadataCompleteESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 12, oldMetadataComplete, false, oldMetadataCompleteESet));
        }
    }

    public boolean isSetMetadataComplete() {
        return this.metadataCompleteESet;
    }

    public Interceptors getInterceptors() {
        return this.interceptors;
    }

    public NotificationChain basicSetInterceptors(Interceptors newInterceptors, NotificationChain msgs) {
        Interceptors oldInterceptors = this.interceptors;
        this.interceptors = newInterceptors;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldInterceptors, (Object)newInterceptors);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setInterceptors(Interceptors newInterceptors) {
        if (newInterceptors != this.interceptors) {
            NotificationChain msgs = null;
            if (this.interceptors != null) {
                msgs = ((InternalEObject)((Object)this.interceptors)).eInverseRemove(this, -14, null, msgs);
            }
            if (newInterceptors != null) {
                msgs = ((InternalEObject)((Object)newInterceptors)).eInverseAdd(this, -14, null, msgs);
            }
            if ((msgs = this.basicSetInterceptors(newInterceptors, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newInterceptors, (Object)newInterceptors));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                if (this.assemblyDescriptor != null) {
                    msgs = ((InternalEObject)((Object)this.assemblyDescriptor)).eInverseRemove(this, -10, null, msgs);
                }
                return this.basicSetAssemblyDescriptor((AssemblyDescriptor)((Object)otherEnd), msgs);
            }
            case 10: {
                return ((InternalEList)this.getEnterpriseBeans()).basicAdd(otherEnd, msgs);
            }
            case 11: {
                if (this.relationshipList != null) {
                    msgs = ((InternalEObject)((Object)this.relationshipList)).eInverseRemove(this, -12, null, msgs);
                }
                return this.basicSetRelationshipList((Relationships)((Object)otherEnd), msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return this.basicSetAssemblyDescriptor(null, msgs);
            }
            case 10: {
                return ((InternalEList)this.getEnterpriseBeans()).basicRemove(otherEnd, msgs);
            }
            case 11: {
                return this.basicSetRelationshipList(null, msgs);
            }
            case 13: {
                return this.basicSetInterceptors(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getEjbClientJar();
            }
            case 8: {
                return this.getVersion();
            }
            case 9: {
                return this.getAssemblyDescriptor();
            }
            case 10: {
                return this.getEnterpriseBeans();
            }
            case 11: {
                return this.getRelationshipList();
            }
            case 12: {
                return this.isMetadataComplete() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.getInterceptors();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setEjbClientJar((String)newValue);
                return;
            }
            case 8: {
                this.setVersion((String)newValue);
                return;
            }
            case 9: {
                this.setAssemblyDescriptor((AssemblyDescriptor)newValue);
                return;
            }
            case 10: {
                this.getEnterpriseBeans().clear();
                this.getEnterpriseBeans().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setRelationshipList((Relationships)newValue);
                return;
            }
            case 12: {
                this.setMetadataComplete((Boolean)newValue);
                return;
            }
            case 13: {
                this.setInterceptors((Interceptors)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setEjbClientJar(EJB_CLIENT_JAR_EDEFAULT);
                return;
            }
            case 8: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 9: {
                this.setAssemblyDescriptor(null);
                return;
            }
            case 10: {
                this.unsetEnterpriseBeans();
                return;
            }
            case 11: {
                this.setRelationshipList(null);
                return;
            }
            case 12: {
                this.unsetMetadataComplete();
                return;
            }
            case 13: {
                this.setInterceptors(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return EJB_CLIENT_JAR_EDEFAULT == null ? this.ejbClientJar != null : !EJB_CLIENT_JAR_EDEFAULT.equals(this.ejbClientJar);
            }
            case 8: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 9: {
                return this.assemblyDescriptor != null;
            }
            case 10: {
                return this.isSetEnterpriseBeans();
            }
            case 11: {
                return this.relationshipList != null;
            }
            case 12: {
                return this.isSetMetadataComplete();
            }
            case 13: {
                return this.interceptors != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer("\n\nEJB Jar deployment descriptor   [ ");
        result.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())).append(" ]\n\n");
        result.append("  *Resource           [ " + this.eResource() + " ]\n");
        result.append("  Version             [ " + this.version + " ]\n");
        try {
            result.append("  Version ID          [ " + this.getVersionID() + " ]\n");
        }
        catch (IllegalStateException e) {
            result.append("  Version ID          [ ERROR: cannot be calculated - IllegalStateException ]\n");
        }
        result.append("  Metadata Complete   [ ");
        if (this.metadataCompleteESet) {
            result.append(this.metadataComplete);
        } else {
            result.append("<unset>");
        }
        result.append(" ]\n");
        result.append("  EJB Client JAR      [ " + this.ejbClientJar + " ]\n");
        EList l = this.getEnterpriseBeans();
        if (l != null) {
            result.append("\n  EJB Module contains [ " + l.size() + " ] EJBs\n");
            for (EnterpriseBean b : l) {
                if (b != null) {
                    result.append(b);
                    continue;
                }
                result.append("  Bean                 [ " + b + " ]\n");
            }
        } else {
            result.append("\n  EJB Module contains no EJBs\n");
        }
        result.append("\n");
        return result.toString();
    }

    public EJBRelationshipRole getRelationshipRole(String aRoleName, ContainerManagedEntity sourceCMP) {
        if (aRoleName == null || sourceCMP == null) {
            return null;
        }
        EJBRelationshipRole role = null;
        if (this.getRelationshipList() != null) {
            EList relations = this.getRelationshipList().getEjbRelations();
            int size = relations.size();
            EJBRelation rel = null;
            for (int i = 0; i < size; ++i) {
                rel = (EJBRelation)relations.get(i);
                role = rel.getRelationshipRole(aRoleName);
                if (role == null || role.getSourceEntity() != sourceCMP) continue;
                return role;
            }
        }
        return null;
    }

    public EJBRelation getEJBRelation(String aRelationName) {
        Relationships relList = this.getRelationshipList();
        if (relList != null) {
            EList rels = relList.getEjbRelations();
            int size = rels.size();
            EJBRelation rel = null;
            for (int i = 0; i < size; ++i) {
                rel = (EJBRelation)rels.get(i);
                if (rel == null || !aRelationName.equals(rel.getName())) continue;
                return rel;
            }
        }
        return null;
    }

    public List getEJBRelationsForSource(ContainerManagedEntity cmp) {
        Relationships relList = this.getRelationshipList();
        ArrayList<EJBRelation> result = null;
        if (relList != null) {
            EList rels = relList.getEjbRelations();
            int size = rels.size();
            EJBRelation rel = null;
            block0: for (int i = 0; i < size; ++i) {
                rel = (EJBRelation)rels.get(i);
                if (rel == null) continue;
                EList roles = rel.getRelationshipRoles();
                for (int j = 0; j < roles.size(); ++j) {
                    EJBRelationshipRole role = (EJBRelationshipRole)roles.get(j);
                    if (role.getSourceEntity() != cmp) continue;
                    if (result == null) {
                        result = new ArrayList<EJBRelation>();
                    }
                    result.add(rel);
                    continue block0;
                }
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public List getEJBRelationshipRolesForType(ContainerManagedEntity cmp) {
        Relationships relList = this.getRelationshipList();
        ArrayList<EJBRelationshipRole> result = null;
        if (relList != null) {
            EList rels = relList.getEjbRelations();
            int size = rels.size();
            EJBRelation rel = null;
            block0: for (int i = 0; i < size; ++i) {
                rel = (EJBRelation)rels.get(i);
                if (rel == null) continue;
                EList roles = rel.getRelationshipRoles();
                for (int j = 0; j < roles.size(); ++j) {
                    EJBRelationshipRole role = (EJBRelationshipRole)roles.get(j);
                    if (!cmp.equals(role.getTypeEntity())) continue;
                    if (result == null) {
                        result = new ArrayList<EJBRelationshipRole>();
                    }
                    result.add(role);
                    continue block0;
                }
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public void storeJ2EEVersionID() throws IllegalStateException {
        String methodName = "storeJ2EEVersionID";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this._J2EEVersionIDStored) {
            logger.logp(Level.FINER, className, methodName, "RETURN J2EE version ID value already stored [ {0} ]", this._storedJ2EEVersionID);
            return;
        }
        J2EEVersionResource res = (J2EEVersionResource)((Object)this.eResource());
        if (res == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing IllegalStateException as resource is null");
            throw new IllegalStateException("XMLResource is null");
        }
        EList l = this.getEnterpriseBeans();
        if (l != null) {
            for (EnterpriseBeanImpl b : l) {
                if (b == null) continue;
                b.storeVersionID(res);
            }
        }
        this._storedJ2EEVersionID = res.getJ2EEVersionID();
        this._J2EEVersionIDStored = true;
        logger.logp(Level.FINER, className, methodName, "RETURN Stored [ {0} ]", this._storedJ2EEVersionID);
    }

    public int getJ2EEVersionID() throws IllegalStateException {
        if (!this._J2EEVersionIDStored) {
            this.storeJ2EEVersionID();
        }
        return this._storedJ2EEVersionID;
    }
}

