/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntryImpl;

public class ClasspathUtil {
    public static void processManifest(String inPath, List rtClasspath, Set processedPaths) {
        ArrayList paths = ClasspathUtil.getManifestPaths(inPath);
        for (int i = 0; i < paths.size(); ++i) {
            RuntimeClasspathEntry entry = (RuntimeClasspathEntry)paths.get(i);
            if (processedPaths.contains(entry)) continue;
            processedPaths.add(entry);
            rtClasspath.add(entry);
            ClasspathUtil.processManifest(entry.getAbsolutePath(), rtClasspath, processedPaths);
        }
    }

    protected static RuntimeClasspathEntry createRuntimeClasspathEntry(String absolutePath, String manifestValue) {
        RuntimeClasspathEntryImpl entry = new RuntimeClasspathEntryImpl();
        entry.setAbsolutePath(absolutePath);
        entry.setManifestValue(manifestValue);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ArrayList getManifestPaths(String path) {
        ArrayList manifestPaths = new ArrayList();
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                File manifestFile = new File(path + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
                if (manifestFile.exists()) {
                    FileInputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(manifestFile);
                        Manifest manifest = new Manifest(inputStream);
                        manifestPaths = ClasspathUtil.getManifestClassPaths(manifest, f.getParent());
                    }
                    catch (IOException e) {
                    }
                    finally {
                        if (null != inputStream) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException ex) {
                                Logger.getLogger().logError(ex);
                            }
                        }
                    }
                }
            } else {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(f);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null) {
                        manifestPaths = ClasspathUtil.getManifestClassPaths(manifest, f.getParent());
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        return manifestPaths;
    }

    protected static ArrayList getManifestClassPaths(Manifest manifest, String archivePath) {
        ArrayList<RuntimeClasspathEntry> pathList = new ArrayList<RuntimeClasspathEntry>();
        Attributes main = manifest.getMainAttributes();
        String classPath = main.getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String path = archivePath + File.separator + token;
                if (!new File(path = ClasspathUtil.normalizePath(path)).exists()) continue;
                pathList.add(ClasspathUtil.createRuntimeClasspathEntry(path, token));
            }
        }
        return pathList;
    }

    public static String normalizePath(String path) {
        File f = new File(path);
        try {
            f = f.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f.getPath();
    }
}

