/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.logging.Level;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;
import org.eclipse.jst.j2ee.internal.xml.J2EEXmlDtDEntityResolver;
import org.eclipse.jst.j2ee.jca.Connector;

public class RarImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return RarImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
            J2EEXmlDtDEntityResolver.registerDtD("http://java.sun.com/dtd/connector_1_0.dtd", "connector_1_0.dtd");
        }
        return discriminator;
    }

    public RARFile getRARFile() {
        return (RARFile)this.getArchive();
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    public void loadDeploymentDescriptor() throws Exception {
        Connector connector2 = (Connector)this.primLoadDeploymentDescriptor();
        this.versionCheck(connector2);
        this.getRARFile().setDeploymentDescriptor(connector2);
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        protected static final String className = Discriminator.class.getName();

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.RAR;
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached RAR value [ {0} ]", Boolean.toString(canImport));
                return canImport;
            }
            boolean canImport = anArchive.containsFile("META-INF/ra.xml");
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN RAR [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new RarImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.RAR_File, "META-INF/ra.xml");
        }

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createRARFile();
        }
    }
}

